<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Dry Clean Locker | Home </title>

    <link href="<?php echo e(asset ('css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('font-awesome/css/font-awesome.css')); ?>" rel="stylesheet">

    <!-- FooTable -->
    <link href="<?php echo e(asset ('css/plugins/footable/footable.core.css')); ?>" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="<?php echo e(asset ('css/sweetalert.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset ('css/animate.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('css/style.css')); ?>" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>
<body>
    <div id="wrapper">

        <!-- Side Navbar -->
        <?php echo $__env->make('navbar_static_side', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <!-- Top Navbar -->
                <?php echo $__env->make('navbar_static_top', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Locations</strong></h2>
                    <a href="add_employee.php">
                        <button type="button" class="btn btn-default btn-sm">
                            <span class="glyphicon glyphicon-plus"></span> Add Location
                        </button>
                    </a>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>SNo</th>
                                            <th>Shortcode</th>
                                            <th>Description</th>
                                            <th>Address Line 1</th>
                                            <th>Address Line 2</th>
                                            <th>City</th>
                                            <th>Country</th>
                                            <!--<th>Password</th>-->
                                            <th>Region</th>
                                            <th>Postcode</th>
                                            <th>Access Notes</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="employee_list">
                                       <!-- Dynamically appending Employees List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">

            <!-- Footer -->
            <?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete Employee</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the Employee?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deleteEmployee()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->



    <!-- Mainly scripts -->
    <script src="<?php echo e(asset ('js/jquery-3.1.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/metisMenu/jquery.metisMenu.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/slimscroll/jquery.slimscroll.min.js')); ?>"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo e(asset ('js/inspinia.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/pace/pace.min.js')); ?>"></script>

    <!-- Sweet alert -->
    <script src="<?php echo e(asset ('js/plugins/sweetalert/sweetalert.min.js')); ?>"></script>

    <!-- FooTable -->
    <script src="<?php echo e(asset ('js/plugins/footable/footable.all.min.js')); ?>"></script>

    <!-- Page-Level Scripts -->
    <script>
        var delete_employee;

        $(document).ready(function() 
        {
            $("#side4").addClass("activeSM");
            $("#side4 a").css("color","#224ea6");

            viewEmployees();

            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "Please add Employees.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("add_employee.php");
                });
            });

            //Delete Row
            $('#swal_btn2').click(function(){
                swal({
                    title: "Employee Deleted!",
                    text: "",
                    type: "success",
                    confirmButtonColor: "#DD6B55",
                });
            });

            //Active Row
            $('#swal_btn3').click(function(){
                swal({
                     title: "Activated/Deactivated",
                    text: "Employee Activated/Deactivated Successfully.",
                    type: "success",
                    confirmButtonColor: "#003399",
                });
            });
        });

        function viewEmployees()
        {
            var $list = $("#employee_list");
            $list.empty();
            $.ajax({
                url: "/kos_apis/view_all_employee.php",
                type: "GET",
                success: function(data)
                {   
                    var count = 1;
                    var dat = jQuery.parseJSON(data);
                    if ( dat.status == "success")
                    {
                        $.each(dat.Data, function(index,obj) 
                        {
                            if( obj.emp_active == '0')
                            {
                                var status = '<span id="'+obj.emp_username+'" onclick ="statusChange(this.id);" class="label label-danger">Inactive</span>';
                            }
                            else
                            {
                                var status = '<span id="'+obj.emp_username+'" onclick ="statusChange(this.id);" class="label label-primary">Active</span>';
                            }
                            $list.append('<tr>'+
                                            '<td><strong>'+count+'</strong></td>'+
                                            '<td>'+obj.emp_fname+'</td>'+
                                            '<td>'+obj.emp_lname+'</td>'+
                                            '<td>'+obj.emp_username+'</td>'+
                                            '<td>'+obj.emp_phone+'</td>'+
                                            '<td>'+obj.emp_email+'</td>'+
                                            '<td>'+obj.emp_emailSMS+'</td>'+
                                            '<td>'+obj.emp_role+'</td>'+
                                            '<td>'+status+'</td>'+
                                            '<td>'+
                                                '<div class="btn-group">'+
                                                    '<button id="'+obj.emp_username+'" onclick ="saveEmployee(this.id);" class="btn-white btn btn-xs">Edit</button>'+
                                                    '<button id="'+obj.emp_username+'" onclick ="deleteEmployeeModal(this.id);" class="btn-white btn btn-xs">Delete</button>'+
                                                '</div>'+
                                            '</td>'+
                                        '</tr>');
                            count++;
                        });
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }

        function deleteEmployeeModal(id)
        {
            $('#deleteModal').modal('show');
            delete_employee = id;
        }


        function deleteEmployee()
        {
            $('#deleteModal').modal('hide');

            var emp_id = delete_employee;
            $.ajax({            
                url: "/kos_apis/delete_employee.php",
                type: "get",
                data: {"emp_username": emp_id},
                success: function(result)
                {
                    var data = jQuery.parseJSON(result);
                    if(data.status == "success")
                    {
                        swal_btn2.click();
                        viewEmployees();
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });
        }

        function saveEmployee(id)
        {
            var emp_id = id;
            localStorage.setItem("emp_id",emp_id);
            window.location.href = "update_employee.php";
            
        }

        function statusChange(id)
        {
            var emp_id = id;
            $.ajax({            
                url: "/kos_apis/active_employee.php",
                type: "get",
                data: {"emp_username": emp_id},
                success: function(result)
                {
                    var data = jQuery.parseJSON(result);
                    if(data.status == "success")
                    {
                        swal_btn3.click();
                        viewEmployees();
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });        
        }
    </script>
</body>
</html>
