<!DOCTYPE html>
<html>
<head>
    <title>Dry Clean Locker | Add an Employee</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link href="{{ asset ('css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset ('font-awesome/css/font-awesome.css') }}" rel="stylesheet">

    <!-- FooTable -->
    <link href="{{ asset ('css/plugins/footable/footable.core.css') }}" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="{{ asset ('css/sweetalert.css') }}" rel="stylesheet">

    <!-- Ladda style -->
    <link href="{{ asset ('css/ladda-themeless.min.css')}}" rel="stylesheet">

    <link href="{{ asset ('css/animate.css') }}" rel="stylesheet">
    <link href="{{ asset ('css/style.css') }}" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>

<body>
    <div id="wrapper">
        @include('navbar_static_side')
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                @include('navbar_static_top')
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Add an Employee</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="{{ url('view_employees')}}">Employees</a>
                        </li>
                        <li class="active">
                            <strong>Add an Employee</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="add_employee_form">
                                    <div class="form-group">
                                        <label>First Name</label>
                                        <input type="text" id="fname" name="fname" placeholder="Enter First Name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Last Name</label>
                                        <input type="text" id="lname" name="lname" placeholder="Enter Last Name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Email</label>
                                        <input type="email" id="email" name="email" placeholder="Enter Email" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Country</label>
                                        <select class="form-control" id="country" name="country" required="">
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Mobile#</label>
                                        <input type="number" id="mobile_no" name="mobile_no"  onkeypress="return event.charCode == 43 || event.charCode >= 48 && event.charCode <= 57" placeholder="Enter Mobile#" class="form-control" required>
                                    </div>              
                                     <div class="form-group">
                                        <label>Password</label>
                                        <input type="password" id="password" name="password" placeholder="Enter Password" class="form-control" required>
                                    </div>

                                    <div class="form-group">
                                        <label>Confirm Password</label>
                                        <input type="password" id="con_password" name="con_password" placeholder="Re-Type Password" class="form-control" required>
                                    </div>      
                                    <div class="form-group">
                                        <label>Gender</label><br>
                                        <input type="radio" name="gender" value="Male" checked> Male
                                        <input type="radio" name="gender" value="Female"> Female
                                    </div>     
                                    <div class="form-group">
                                        <label>Role</label>
                                        <select class="form-control" id="role" name="role" required="">
                                            <option value="select" selected>Select Role</option>
                                            <option value="Admin">Admin</option>
                                            <option value="Employee">Employee</option>
                                            <option value="Driver">Driver</option>
                                        </select>
                                    </div> 
                                                                
                                    <div>
                                        <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added Employee -->
                                        <button id="swal_btn" type="button" style="display:none"></button>
                                        <!-- Employee not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none"></button>
                                    </div>
                                </form>
                                <a href="{{url('view_employees')}}">
                                    <button style="background-color: #5cb85c;color: white;margin-left: 70px;margin-top: -50px;" class="btn btn-sm btn-primary m-t-n-xs" data-style="zoom-in">Cancel</button>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('footer')
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="{{ asset ('js/jquery-3.1.1.min.js')}}"></script>
    <script src="{{ asset ('js/bootstrap.min.js')}}"></script>
    <script src="{{ asset ('js/plugins/metisMenu/jquery.metisMenu.js')}}"></script>
    <script src="{{ asset ('js/plugins/slimscroll/jquery.slimscroll.min.js')}}"></script>

    <!-- Custom and plugin javascript -->
    <script src="{{ asset ('js/inspinia.js')}}"></script>
    <script src="{{ asset ('js/plugins/pace/pace.min.js')}}"></script>

    <script src="{{ asset ('js/plugins/jquery-ui/jquery-ui.min.js')}}"></script>

    <!-- Sweet alert -->
    <script src="{{ asset ('js/plugins/sweetalert/sweetalert.min.js')}}"></script>

    <!-- Jquery Validate -->
    <script src="{{ asset ('js/plugins/validate/jquery.validate.min.js')}}"></script>

    <!-- Ladda -->
    <script src="{{ asset ('js/plugins/ladda/spin.min.js')}}"></script>
    <script src="{{ asset ('js/plugins/ladda/ladda.min.js')}}"></script>
    <script src="{{ asset ('js/plugins/ladda/ladda.jquery.min.js')}}"></script>

    <script>
    var errorMessage;
    $(document).ready(function()
    {
        $("#side6").addClass("activeSM");
        $("#side6 a").css("color","#224ea6");

        viewCountries();

        //Custom validator for contains at least one lower-case letter
        $.validator.addMethod("atLeastOneLowercaseLetter", function (value, element) {
            return this.optional(element) || /[a-z]+/.test(value);
        }, "Must have at least one lowercase letter");
         
        /**
         * Custom validator for contains at least one upper-case letter.
         */
        $.validator.addMethod("atLeastOneUppercaseLetter", function (value, element) {
            return this.optional(element) || /[A-Z]+/.test(value);
        }, "Must have at least one uppercase letter");
         
        /**
         * Custom validator for contains at least one number.
         */
        $.validator.addMethod("atLeastOneNumber", function (value, element) {
            return this.optional(element) || /[0-9]+/.test(value);
        }, "Must have at least one number");
         
        /**
         * Custom validator for contains at least one symbol.
         */
        $.validator.addMethod("atLeastOneSymbol", function (value, element) {
            return this.optional(element) || /[!@#$%^&*()]+/.test(value);
        }, "Must have at least one symbol");


        $("#add_employee_form").validate({
            rules: 
            {
                fname: {
                    required: true
                },
                lname: {
                    required: true
                },
                email: {
                    required: true
                },
                mobile_no: {
                    required: true
                },                
                password: {
                    required: true,
                    atLeastOneLowercaseLetter: true,
                    atLeastOneUppercaseLetter: true,
                    atLeastOneNumber: true,
                    atLeastOneSymbol: true,
                    minlength: 7,
                },
                con_password: {
                    required: true,
                    equalTo: "#password",
                },
                gender: {
                    required: true
                },                
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );
                var swal_btn = document.getElementById("swal_btn");

                var fname = $('#fname').val();
                var lname = $('#lname').val();
                var email = $('#email').val();
                var country = $('#country').val();
                var mobile_no = $('#mobile_no').val();
                var password = $('#password').val();
                var gender = $('input[name=gender]:checked').val();
                var type = $('#role').val();

                if( type == "select" )
                {
                    alert('Please select a Role');
                    l.ladda('stop');
                }
                else if( country == "select")
                {
                    alert('Please select a Country');
                    l.ladda('stop');
                }
                else
                {
                    var formData = new FormData();
                    formData.append("FirstName", fname);
                    formData.append("LastName", lname);
                    formData.append("EmailAddress", email);
                    formData.append("CountryID", country);
                    formData.append("MobileNumber", mobile_no);
                    formData.append("Password", password);
                    formData.append("Sex", gender);
                    formData.append("Type", type);
                        
                    $.ajax
                    ({
                        type:'POST',
                        url:" /DCL/api/EmployeeSignup",
                        data: formData,
                        contentType: false,
                        cache: false,
                        processData:false,
                        success: function(data)
                        {
                            if( data.status == "success")
                            {
                                l.ladda('stop');
                                swal_btn.click();
                            }
                            else if( data.status == "failed" )
                            {
                                l.ladda('stop');
                                errorMessage = data.error;
                                swal_btn2.click();
                            }
                        },
                        error: function(data) 
                        {
                            alert("error");
                        }           

                    }); 
                }               
                return false; // extra insurance preventing the default form action
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Employee added successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#566b8a",
                closeOnConfirm: false
            }, function () {
                window.location.assign("{{ url('view_employees')}}");
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: errorMessage,
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
    });

    function viewCountries()
    {
        var $list = $("#country");
        $list.empty();
        $.ajax({
            url: "/DCL/api/CountryView",
            type: "Post",
            success: function(data)
            {   
                if ( data.status == "success")
                {
                    $list.append('<option value="select">Choose a Country</option>');

                    $.each(data.data, function(index,obj) 
                    {                       
                        $list.append('<option value="'+obj.Name+'">'+obj.Name+'</option>');
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }
</script>

</body>
</html>
