<!DOCTYPE html>
<html>
<head>
    <title>Dry Clean Locker | Home </title>

    <link href="<?php echo e(asset ('css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('font-awesome/css/font-awesome.css')); ?>" rel="stylesheet">

    <!-- FooTable -->
    <link href="<?php echo e(asset ('css/plugins/footable/footable.core.css')); ?>" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="<?php echo e(asset ('css/sweetalert.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset ('css/animate.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('css/style.css')); ?>" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>

<body>
    <div id="wrapper">
        <?php echo $__env->make('navbar_static_side', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php echo $__env->make('navbar_static_top', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Add Customer</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="accessories.php">Customers</a>
                        </li>
                        <li class="active">
                            <strong>Add Customer</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="add_accessory_form">
                                    <div class="form-group">
                                        <label>Email</label>
                                        <input type="email" id="email" name="email" placeholder="Enter Email" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Password</label>
                                        <input type="password" id="password" name="password" placeholder="Enter Password" class="form-control" required>
                                    </div>

                                    <div class="form-group">
                                        <label>Confirm Password</label>
                                        <input type="password" id="con_password" name="con_password" placeholder="Re-Type Password" class="form-control" required>
                                    </div>


                                   
                                    <div>
                                        <button style="background-color: #003399;border-color: #224ea6;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added Accessory -->
                                        <button id="swal_btn" type="button" style="display:none">
                                        <!-- Accessory not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <script>
    $(document).ready(function()
    {
        $("#side2").addClass("activeSM");
        $("#side2 a").css("color","#224ea6");
        
       $("#add_accessory_form").validate({
            rules: 
            {
                name: {
                   required: true
                },
                quantity: {
                   required: true,
                   number: true
                },
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );
                var swal_btn = document.getElementById("swal_btn");

                var name = $('#name').val();
                var added_to_vehicle = $('#added_to_vehicle').val();
                var quantity = $('#quantity').val();

                var formData = new FormData();
                formData.append("acc_name", name);
                formData.append("vehicle_type", added_to_vehicle);
                formData.append("acc_pieces", quantity);
                    
                $.ajax
                ({
                    type:'POST',
                    url:"/kos_apis/add_accessory.php",
                    data: formData,
                    contentType: false,
                    cache: false,
                    processData:false,
                    success: function(data)
                    {
                        var dat = jQuery.parseJSON(data);
                        if( dat.status == "success" )
                        {
                            l.ladda('stop');
                            swal_btn.click();
                        }
                        else if( dat.status == "failed" )
                        {
                            l.ladda('stop');
                            swal_btn2.click();
                        }
                    },
                    error: function(data) 
                    {
                        alert("error");
                    }           

                });                
                return false; // extra insurance preventing the default form action
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Added Successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
                closeOnConfirm: false
            }, function () {
                window.location.assign("accessories.php");
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: "Accessory not Added.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
    });
</script>

</body>
</html>
