<!DOCTYPE html>
<html>
<head>
    <title>Anahita Joon | Edit a Season </title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link href="{{ asset ('css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset ('font-awesome/css/font-awesome.css') }}" rel="stylesheet">

    <!-- FooTable -->
    <link href="{{ asset ('css/plugins/footable/footable.core.css') }}" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="{{ asset ('css/sweetalert.css') }}" rel="stylesheet">

    <!-- Ladda style -->
    <link href="{{ asset ('css/ladda-themeless.min.css')}}" rel="stylesheet">

    <link href="{{ asset ('css/animate.css') }}" rel="stylesheet">
    <link href="{{ asset ('css/style.css') }}" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
<script>
    if (!localStorage.Session)
    {
        window.stop();
        window.location.replace("login");
    }
    </script>
</head>

<body>
    <div id="wrapper">
        @include('navbar_static_side')
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                @include('navbar_static_top')
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Edit an Item</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="{{ url('view_season')}}">Seasons</a>
                        </li>
                        <li class="active">
                            <strong>Edit an Season</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="edit_item_form">
                                    <div class="form-group">
                                       <img id="picture" src="" width="50" />
                                    </div>                                    
                                    <div class="form-group">
                                        <label>Upload Picture</label>
                                        <input type="file" id="photo" name="photo" class="form-control">
                                    </div>                                    
                                    
                                    <div class="form-group">
                                        <label>The Season</label>
                                        <textarea rows="5" id="description" name="description" placeholder="Enter the Season" class="form-control" required></textarea>
                                    </div>                                 
                                    <div class="form-group">
                                        <label>The Persona</label>
                                        <textarea id="description2" rows="5" name="description2" placeholder="Enter the Persona" class="form-control" required></textarea>
                                    </div>
                                  
                                     
                                    <div>
                                        <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Edit</span><span class="ladda-spinner"></span>
                                        </button>

                                        <!-- Successfully Added Item -->
                                        <button id="swal_btn" type="button" style="display:none"></button>
                                        <!-- Item not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none"></button>
                                    </div>
                                </form>
                                <a href="{{url('view_season')}}">
                                    <button style="background-color: #5cb85c;color: white;margin-left: 70px;margin-top: -50px;" class="btn btn-sm btn-primary m-t-n-xs" data-style="zoom-in">Cancel</button>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('footer')
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <script>
    var errorMessage;
    $(document).ready(function()
    {
        $("#side5").addClass("activeSM");
        $("#side5 a").css("color","#224ea6");

      
        viewItems();

        //Custom validator for contains at least one lower-case letter
        $.validator.addMethod("setTwoNumberDecimal", function (value, element) 
        {
            var check = value.split(".");
            //console.log(check.length);
            if( check.length == 2)
            {
                if(check[1].length == 2)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
            else
            {
                return false;
            }
        }, "You must include a Price with two decimal places i.e 1.01");
        
       $("#edit_item_form").validate({
            rules: 
            {
                description: {
                    required: true
                },
                description2: {
                    required: true
                }
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );
                var swal_btn = document.getElementById("swal_btn");
		var season_id = localStorage.season_id;
                var photo= document.getElementById('photo').files[0];               
		var description2 = $('#description2').val();
                var description = $('#description').val();
                   

                    var formData = new FormData();
                    formData.append("season_id", season_id);
                    if(photo)
                    {
                        formData.append("photo", photo);
                    }                   
                   
                    formData.append("description2", description2);
                    formData.append("description", description);
                   
                                      
                    $.ajax
                    ({
                        type:'POST',
                        url:"/joon/api/EditSeason",
                        data: formData,
                        contentType: false,
                        cache: false,
                        processData:false,
                        success: function(data)
                        {
                            if( data.status == "success" )
                            {
                                l.ladda('stop');
                                swal_btn.click();
                            }
                            else if( data.status == "failed" )
                            {
                                l.ladda('stop');
                                errorMessage = data.error;
                                swal_btn2.click();
                            }
                        },
                        error: function(data) 
                        {
                            alert("error");
                        }           
                    });
                               
                return false; // extra insurance preventing the default form action
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Season edited successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
                closeOnConfirm: false
            }, function () {
                window.location.assign("{{ url('view_season')}}");
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: errorMessage,
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
    });

    

    function viewItems()
    {
        var season_id = localStorage.season_id;
        $.ajax({
            url: "/joon/api/SeasonView",
            type: "POST",
            data: { "season_id" : season_id },
            success: function(data)
            {   
                if ( data.status == "success")
                {
                    $.each(data.data, function(index,obj) 
                    {
                        
                        $("#picture").attr("src","/joon/public/"+obj.image);
                        $('#description').val(obj.description);
			$('#description2').val(obj.description2);
                        
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }
</script>

</body>
</html>
