<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title> Maktabti | Books Information </title>

    <link href="{{ asset ('css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset ('font-awesome/css/font-awesome.css') }}" rel="stylesheet">

    <!-- FooTable -->
    <link href="{{ asset ('css/plugins/footable/footable.core.css') }}" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="{{ asset ('css/sweetalert.css') }}" rel="stylesheet">
    
    <!-- Ladda style -->
    <link href="{{ asset ('css/ladda-themeless.min.css')}}" rel="stylesheet">
    <link href="{{ asset ('css/animate.css') }}" rel="stylesheet">
    <link href="{{ asset ('css/style.css') }}" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
        .image-upload > input[type="file"]
	{
	    display: none;
	}
	
	.image-upload #add_book_image
	{
	    width: 80px;
	    cursor: pointer;
	}
    </style>
</head>
<body>
    <div id="wrapper">

        <!-- Side Navbar -->
        @include('navbar_static_side') 

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <!-- Top Navbar -->
                @include('navbar_static_top') 
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Edit Book</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="{{ url('view_books')}}">Books</a>
                        </li>
                        <li class="active">
                            <strong>Book Information</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
        <div class="row">
          <div class="col-lg-8">
            <div class="ibox ">
              <div class="ibox-content">
                <form id="regForm" style="display: block" >
                  <h1>Book Information:</h1> <br>
                  <!-- One "tab" for each step in the form: -->

                   <label>Edit Book Name (English)</label>
                   <input type="text" id="name_english" name="name_english" placeholder="Enter category name" class="form-control" required>
                   <br>

                   <label>Edit  Book Name (Arabic)</label>
                   <input type="text" id="name_arabic" name="name_arabic" placeholder="Enter category name" class="form-control" required>
                   <br>
                   
                   <label>Change Book Cover Photo</label>
                   <input type="file" id="photo" name="photo" class="form-control"  onchange="readURL(this);">
                   <img id="image_view" style="width: 150px" src="#" alt="your image" />
                   <a onclick="viewBookModal()"><strong style="color: skyblue;"> View Book Images</strong></a>
                   <br>
                   
                   <label>Edit Book Category</label>                                
                   <select class="form-control" id="category_list" name="category_list">
                   </select>
                   <br> 
                   
                   <label>Edit Description (English)</label>
                   <textarea rows="5" id="description_english" name="description_english" placeholder="Enter Description" class="form-control" required></textarea>
                   <br>

                   <label>Edit Description (Arabic)</label>
                   <textarea rows="5" id="description_arabic" name="description_arabic" placeholder="Enter Description" class="form-control" required></textarea>
                   <br>
                   
                   <label>Edit Unit Price</label>
                   <input type="text" id="price" name="price" placeholder="Enter category name" class="form-control" required>
                   <br>

                   <label>In Stock</label>
                   <input type="text" id="quantity_avail" name="quantity_avail" placeholder="Enter category name" class="form-control" required>
                   <br>

                    <div>
                            <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                 <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                            </button>
                        </div>

              </form>
            </div>
          </div>
        </div>
      </div>
    </div>

           

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <button id="swal_btn2" type="button" style="display:none"></button>
            <button id="swal_btn3" type="button" style="display:none"></button>

            <!-- Footer -->
            @include('footer')

        </div>
    </div>

    <!-- Modal -->
	  <div class="modal fade" id="myBookModal" role="dialog">
	    <div class="modal-dialog">
	    
	      <!-- Modal content-->
	      <div class="modal-content">
	        <div class="modal-header">
	          <button type="button" class="close" data-dismiss="modal">&times;</button>
	          <h4 class="modal-title">Book Images</h4>
	        </div>
	        <div class="modal-body">	        
			<form id="regForm2" style="display: block">
				<h1>Book Images:</h1> <br>
				<!-- One tab for each step in the form: -->
				
				<div class="row" id="book_pages_list">              
					<!-- Appending Book Pages Dynamically -->	                      	
				</div>
				<br>
				<div class="tab image-upload">
					<label for="photo_pages">
						<img id="add_book_image" src="img/plus_icon.png" width="100" alt="your image" />
					</label>
					<input type="file" id="photo_pages" name="photo_pages" class="form-control" onchange="readURL2(this);" required>
				</div>	
				<br>
				<br>
				<div>
					<button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo2 btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
					<span class="ladda-label">Add more book images</span><span class="ladda-spinner"></span>
					</button>	
				</div>
			</form>     
	        </div>
	        <div class="modal-footer">
	          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
	        </div>
	      </div>
	      
	    </div>
	  </div>
    <!-- Modal Close -->


    <!-- Mainly scripts -->
    <script src="{{ asset ('js/jquery-3.1.1.min.js') }}"></script>
    <script src="{{ asset ('js/bootstrap.min.js') }}"></script>
    <script src="{{ asset ('js/plugins/metisMenu/jquery.metisMenu.js') }}"></script>
    <script src="{{ asset ('js/plugins/slimscroll/jquery.slimscroll.min.js') }}"></script>

    <!-- Custom and plugin javascript -->
    <script src="{{ asset ('js/inspinia.js') }}"></script>
    <script src="{{ asset ('js/plugins/pace/pace.min.js') }}"></script>

    <!-- Sweet alert -->
    <script src="{{ asset ('js/plugins/sweetalert/sweetalert.min.js') }}"></script>

    	<!-- Jquery Validate -->
	<script src="js/plugins/validate/jquery.validate.min.js"></script>
	
	<!-- Ladda -->
	<script src="js/plugins/ladda/spin.min.js"></script>
	<script src="js/plugins/ladda/ladda.min.js"></script>
	<script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <!-- Page-Level Scripts -->
    <script>
    	var book_images_array;
    	var bkid;
    	var errorMessage ;
        $(document).ready(function() 
        {
            viewCategories();
            viewBook(0);
            
            $("#side1").addClass("activeSM");
            $("#side1 a").css("color","#224ea6");
            
            
	$("#regForm").validate({
	      rules: 
	      {
	        name_english: {
	          required: true,
	        },
	        name_arabic: {
	          required: true,
	        },
	        description_english: {
	          required: true
	        },  
	        description_arabic: {
	          required: true
	        }, 
	        price: {
	          required: true
	        }, 
	        quantity_avail: {
	          required: true
	        },  
	      },
	      messages: 
	      {
	      },
	      submitHandler: function(form) 
	      {
	        var l = $( '.ladda-button-demo' ).ladda();
	        l.ladda( 'start' );
	
	        var photo= document.getElementById('photo').files[0];
	        var name_english = $('#name_english').val();
	        var name_arabic = $('#name_arabic').val();
	        var description_english = $('#description_english').val();
	        var description_arabic = $('#description_arabic').val();
	        var price = $('#price').val();
	        var quantity_avail = $('#quantity_avail').val();
	        var law_category = $('#category_list').val();
	        
	        if( law_category == "select" )
                {
                    alert('Please select any Category');
                    l.ladda('stop');
                }
                else
                {	
		        var formData = new FormData();
		        
		        if(photo)
			{
				formData.append("photo", photo);
			}
			formData.append("book_id", bkid);
		        formData.append("name_english", name_english);
		        formData.append("name_arabic", name_arabic);
		        formData.append("description_english", description_english);
		        formData.append("description_arabic", description_arabic);
		        formData.append("price", price);
		        formData.append("quantity_avail", quantity_avail);
		        formData.append("law_category", law_category);
		
		
		        $.ajax
		        ({
		          type:'POST',
		          url:"https://maktabty.org/Maktabti/api/ItemEdit",
		          data: formData,
		          contentType: false,
		          cache: false,
		          processData:false,
		          success: function(data)
		          {
		            if( data.status == "success")
		            {
		               l.ladda('stop');               
		               swal_btn.click();
		            }
		            else if( data.status == "failed" )
		            {
		              l.ladda('stop');
		              errorMessage = data.error;
		              swal_btn2.click();
		            }
		          },
		          error: function(data) 
		          {
		            alert("error");
		          }           
		
		        });      
	      }          
              return false; // extra insurance preventing the default form action
            }
          });

     $("#regForm2").validate({
      rules: 
      {
        photo_pages: {
          required: true
        },
      },
      messages: 
      {
      },
      submitHandler: function(form) 
      {
        var l = $( '.ladda-button-demo2' ).ladda();
        l.ladda( 'start' );

        var photo= document.getElementById('photo_pages').files[0];

        var formData = new FormData();
        formData.append("book_id", bkid);
        formData.append("photo", photo);


        $.ajax
        ({
          type:'POST',
          url:"https://maktabty.org/Maktabti/api/BooksImages",
          data: formData,
          contentType: false,
          cache: false,
          processData:false,
          success: function(data)
          {
            if( data.status == "success")
            {
              l.ladda('stop');
              $('#add_book_image').attr('src', 'img/plus_icon.png');
              viewBook(1);
            }
            else if( data.status == "failed" )
            {
              l.ladda('stop');
              errorMessage = data.error;
              swal_btn3.click();
            }
          },
          error: function(data) 
          {
            alert("error");
          }           

        });                
              return false; // extra insurance preventing the default form action
            }
          });



            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "EDITED",
                    text: "Your Book details have been edited successfully",
                    type: "success",
                    confirmButtonColor: "#a5dc86",                    
                closeOnConfirm: false
            }, function () {
                window.location.assign("{{ url('view_books')}}");
                });
            });
            
            //Book Image Deleted
            $('#swal_btn3').click(function(){
                swal({
                     title: "Operation Unsuccessful",
                    text: errorMessage ,
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
            
             //Book Image Deleted
            $('#swal_btn2').click(function(){
                swal({
                     title: "Deleted",
                    text: "Book Image has been deleted",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });
	
	function viewBookModal()
    	{
    		var $list = $('#book_pages_list');
    		$list.empty();
    		
    		
    			$.each(book_images_array, function(index,obj) 
                   	{
    			 	$list.append('<div class="col-md-4 col-sm-3 col-xs-6" style="padding: 10px 10px 0px 10px;">'+       			 				
    			 				'<label style="position: fixed;margin-left:5px;margin-top: 2px;">'+
                            					'<i class="fa fa-trash" id="'+obj.bk_im_id+'" onclick ="deleteImage(this.id);" style="font-size:20px;color:red"></i>'+
                            				'</label>'+ 		
							'<img src="https://maktabty.org/Maktabti/public/'+obj.image+'" style="width:100%; height:100px">'+
						'</div>');
			});
    			$('#myBookModal').modal('show');
    		
    		
    	}
    	
    	function deleteImage(id)
	{
	    $.ajax({
	            url: "https://maktabty.org/Maktabti/api/BooksImagesDelete",
	            type: "POST",
	            data: { "img_id" : id },
	            success: function(data)
	            {   
	                if ( data.status == "success")
	                {
	                	swal_btn2.click();
	                	viewBook(1);
	                }
	                else
	                {
	                    alert("Book not Deleted");
	                }
	            },
	            error: function(data)
	            {
	            }           
	        });
	}

        function viewBook(id)
    {
        bkid = localStorage.bkid;
       // alert (bkid);
        $.ajax({
            url: "https://maktabty.org/Maktabti/api/ItemView",
            type: "POST",
            data: {"book_id" : bkid},
            success: function(data)
            {   
                var count = 1;
                //var dat = jQuery.parseJSON(data);
                if ( data.status == "success")
                {
                    $.each(data.data, function(index,obj) 
                    {
                        $('#name_english').val(obj.name_english);
                        $('#name_arabic').val(obj.name_arabic);
                        $('#description_english').val(obj.description_english);
                        $('#description_arabic').val(obj.description_arabic);
                        $('#price').val(obj.price);
                        $('#quantity_avail').val(obj.quantity_avail);
                        $('#category_list').val(obj.law_category);
                        $("#image_view").attr("src","https://maktabty.org/Maktabti/public/"+obj.cover_photo);
                        book_images_array = obj.images;            
                    });                    
                    if( id == 1)
                    {
                    	viewBookModal();
                    }
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function viewCategories()
    {
        var $list = $("#category_list");
        $list.empty();
        $.ajax({
            url: "https://maktabty.org/Maktabti/api/CategoryView",
            type: "POST",
            success: function(data)
            {   
                if ( data.status == "success")
                {
                    $list.append('<option value="select">Choose a Category</option>');
                    $.each(data.data, function(index,obj) 
                    {
                        $list.append('<option value="'+obj.category_name+'">'+obj.category_name+'</option>');
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }
    
	function readURL(input) 
	{
		if (input.files && input.files[0]) 
		{
			var reader = new FileReader();
			
			reader.onload = function (e) {
			$('#image_view')
			.attr('src', e.target.result);
			};
			reader.readAsDataURL(input.files[0]);
		}
	}
	
	function readURL2(input)
	{
		if (input.files && input.files[0])
		{
			var reader = new FileReader();
			
			reader.onload = function (e) {
			$('#add_book_image')
			.attr('src', e.target.result);
			};
			
			reader.readAsDataURL(input.files[0]);
		}
	}
        
    </script>
</body>
</html>
