<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Maktabti | Book's Information </title>

    <link href="{{ asset ('css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset ('font-awesome/css/font-awesome.css') }}" rel="stylesheet">

    <!-- FooTable -->
    <link href="{{ asset ('css/plugins/footable/footable.core.css') }}" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="{{ asset ('css/sweetalert.css') }}" rel="stylesheet">

    <link href="{{ asset ('css/animate.css') }}" rel="stylesheet">
    <link href="{{ asset ('css/style.css') }}" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>
<body>
    <div id="wrapper">

        <!-- Side Navbar -->
        @include('navbar_static_side') 

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <!-- Top Navbar -->
                @include('navbar_static_top') 
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Edit Book</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="{{ url('view_books')}}">Books</a>
                        </li>
                        <li class="active">
                            <strong>Book Information</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
        <div class="row">
          <div class="col-lg-8">
            <div class="ibox ">
              <div class="ibox-content">
                <form id="regForm" style="display: block" >
                  <h1>Book Information:</h1> <br>
                  <!-- One "tab" for each step in the form: -->
                
                    <label>Category List</label>                                
                    <select class="form-control" id="category_list" name="category_list" required="">
                   </select>
                   <br>

                   <label>Upload Cover Photo</label>
                   <input type="file" id="photo" name="photo" class="form-control"  onchange="readURL(this);" required>
                   <img id="image_view" style="width: 150px" src="#" alt="your image" />
                   <br>

                   <label>Book Name (English)</label>
                   <input type="text" id="name_english" name="name_english" placeholder="Enter category name" class="form-control" required>
                   <br>

                   <label>Book Name (Arabic)</label>
                   <input type="text" id="name_arabic" name="name_arabic" placeholder="Enter category name" class="form-control" required>
                   <br>

                   <label>Unit Price</label>
                   <input type="text" id="price" name="price" placeholder="Enter category name" class="form-control" required>
                   <br>

                   <label>In Stock</label>
                   <input type="text" id="quantity_avail" name="quantity_avail" placeholder="Enter category name" class="form-control" required>
                   <br>

                   <label>Description (English)</label>
                   <textarea rows="5" id="description_english" name="description_english" placeholder="Enter Description" class="form-control" required></textarea>
                   <br>

                   <label>Description (Arabic)</label>
                   <textarea rows="5" id="description_arabic" name="description_arabic" placeholder="Enter Description" class="form-control" required></textarea>
                   <br>

                    <div>
                            <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                 <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                            </button>
                        </div>

              </form>

              <form id="regForm2" style="display: none">
                  <h1>Book Images:</h1> <br>
                  <!-- One "tab" for each step in the form: -->
                
                    <div class="tab" >Books Images: <br>
                  <label>Upload Cover Photo</label>
                  <input type="file" id="photo" name="photo" class="form-control" required>
                </div>

<br>
<br>
                <div>
                            <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                 <span class="ladda-label">Add Picture</span><span class="ladda-spinner"></span>
                            </button>

                           <!--  <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                 <span class="ladda-label">Save</span><span class="ladda-spinner"></span>
                            </button>  -->

                        </div>

              </form>
              

                



            </div>
          </div>
        </div>
      </div>
    </div>

           

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>

            <!-- Footer -->
            @include('footer')

        </div>
    </div>

    
    <!-- Modal Close -->


    <!-- Mainly scripts -->
    <script src="{{ asset ('js/jquery-3.1.1.min.js') }}"></script>
    <script src="{{ asset ('js/bootstrap.min.js') }}"></script>
    <script src="{{ asset ('js/plugins/metisMenu/jquery.metisMenu.js') }}"></script>
    <script src="{{ asset ('js/plugins/slimscroll/jquery.slimscroll.min.js') }}"></script>

    <!-- Custom and plugin javascript -->
    <script src="{{ asset ('js/inspinia.js') }}"></script>
    <script src="{{ asset ('js/plugins/pace/pace.min.js') }}"></script>

    <!-- Sweet alert -->
    <script src="{{ asset ('js/plugins/sweetalert/sweetalert.min.js') }}"></script>

    <!-- FooTable -->
    <script src="{{ asset ('js/plugins/footable/footable.all.min.js') }}"></script>

    <!-- Page-Level Scripts -->
    <script>
        $(document).ready(function() 
        {
            viewCategories();
            viewBook();
            
            $("#side1").addClass("activeSM");
            $("#side1 a").css("color","#224ea6");


            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "No Detail Found",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("{{url('view_orders')}}");
                });
            });
        });


        function viewBook()
    {
        var bkid = localStorage.bkid;
        alert (bkid);
        $.ajax({
            url: "https://maktabty.org/Maktabti/api/ItemView",
            type: "POST",
            data: {"book_id" : bkid},
            success: function(data)
            {   
                var count = 1;
                //var dat = jQuery.parseJSON(data);
                if ( data.status == "success")
                {
                    $.each(data.data, function(index,obj) 
                    {
                        $('#name_english').val(obj.name_english);
                        $('#name_arabic').val(obj.name_arabic);
                        $('#description_english').val(obj.description_english);
                        $('#description_arabic').val(obj.description_arabic);
                        $('#price').val(obj.price);
                        $('#quantity_avail').val(obj.quantity_avail);
                        $('#category_list').val(obj.law_category);
                        $("#image_view").attr("src","http://www.tecjaunt.com/Maktabti/public/"+obj.cover_photo);
                        
                        
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function viewCategories()
    {
        var $list = $("#category_list");
        $list.empty();
        $.ajax({
            url: "https://maktabty.org/Maktabti/api/CategoryView",
            type: "POST",
            success: function(data)
            {   
                if ( data.status == "success")
                {
                    $list.append('<option value="select">Choose a Category</option>');
                    $.each(data.data, function(index,obj) 
                    {
                        $list.append('<option value="'+obj.category_name+'">'+obj.category_name+'</option>');
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }
        
        
    </script>
</body>
</html>
