<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Maktabti | Order Details </title>

    <link href="{{ asset ('css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset ('font-awesome/css/font-awesome.css') }}" rel="stylesheet">

    <!-- FooTable -->
    <link href="{{ asset ('css/plugins/footable/footable.core.css') }}" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="{{ asset ('css/sweetalert.css') }}" rel="stylesheet">

    <link href="{{ asset ('css/animate.css') }}" rel="stylesheet">
    <link href="{{ asset ('css/style.css') }}" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>
<body>
    <div id="wrapper">

        <!-- Side Navbar -->
        @include('navbar_static_side') 

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <!-- Top Navbar -->
                @include('navbar_static_top') 
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Order Details</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="{{ url('view_orders')}}">Orders</a>
                        </li>
                        <li class="active">
                            <strong>Order Details</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce" style="padding-bottom: 0px">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Item List</th>
                                            <th>Quantity</th>
                                            <th>Unit Price</th>
                                            <th>Total Price</th>
                                        </tr>
                                    </thead>
                                    <tbody id="order_details_list">
                                       <!-- Dynamically appending order_details_list -->
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

           

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>

            <!-- Footer -->
            @include('footer')

        </div>
    </div>

    
    <!-- Modal Close -->


    <!-- Mainly scripts -->
    <script src="{{ asset ('js/jquery-3.1.1.min.js') }}"></script>
    <script src="{{ asset ('js/bootstrap.min.js') }}"></script>
    <script src="{{ asset ('js/plugins/metisMenu/jquery.metisMenu.js') }}"></script>
    <script src="{{ asset ('js/plugins/slimscroll/jquery.slimscroll.min.js') }}"></script>

    <!-- Custom and plugin javascript -->
    <script src="{{ asset ('js/inspinia.js') }}"></script>
    <script src="{{ asset ('js/plugins/pace/pace.min.js') }}"></script>

    <!-- Sweet alert -->
    <script src="{{ asset ('js/plugins/sweetalert/sweetalert.min.js') }}"></script>

    <!-- FooTable -->
    <script src="{{ asset ('js/plugins/footable/footable.all.min.js') }}"></script>

    <!-- Page-Level Scripts -->
    <script>
        $(document).ready(function() 
        {
            $("#side2").addClass("activeSM");
            $("#side2 a").css("color","#224ea6");

            viewOrderDetails();

            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "No Detail Found",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("{{url('view_orders')}}");
                });
            });
        });

        function viewOrderDetails()
        {
            var order_details_id = localStorage.order_details_id;
           // alert (order_details_id);
            var $list = $("#order_details_list");
            $list.empty();
            $.ajax({
                url: "https://maktabty.org/Maktabti/api/ViewOrder",
                type: "POST",
                data: {"order_id" : order_details_id },
                success: function(data)
                {   
                    var count = 1;
                    var netTotal=0;
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {               
                            var order_total = parseFloat(obj.order_total);

                            $.each(obj.items, function(index1,obj1) 
                            {
                               //var test= obj1.name_english;
                               //alert (test);
                                

                               // var unit_price = obj1.ItemTotalCost / obj1.Quantity;

                               var price_fixed = parseFloat(obj1.price);
                               var new_price_fixed = price_fixed.toFixed(2);
                               var qu = parseFloat(obj1.quantity);
                                //var qu = obj1.quantity
                               var t_price = new_price_fixed * qu;
                              var t_price2 = parseFloat(obj1.price);
                              netTotal = netTotal + t_price;
                             // netTotal = netTotal + new_price_fixed;
                               //alert (t_price2);
                                $list.append('<tr>'+
                                                '<td><strong>'+count+'</strong></td>'+
                                                '<td>'+obj1.name_english+'</td>'+
                                                '<td>'+obj1.quantity+'</td>'+
                                               // '<td>€'+obj1.price.toFixed(2)+'</td>'+
                                                '<td>€'+new_price_fixed+'</td>'+
                                               '<td>€'+t_price+'</td>'+
                                            '</tr>');
                                count++;
                            });
                        });
                        if( count == 1)
                        {
                            swal_btn.click();
                        }
                        else
                        {
                            $list.append('<tr>'+
                                                '<td></td>'+
                                                '<td></td>'+
                                                '<td></td>'+
                                                '<td><strong>Net Total:</strong></td>'+
                                                '<td><strong>€'+netTotal+'</strong></td>'+
                                            '</tr>');
                        }
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }

        function addCleanerNote()
        {
            var order_details_id = localStorage.order_details_id;
            var cleaner_note_value = $('#cleaner_note').val();

            if( cleaner_note_value )
            {
                $.ajax({            
                    url: "/DCL/api/CleanerNote",
                    type: "POST",
                    data: { "OrderID": order_details_id , "cleaner_note" : cleaner_note_value },
                    success: function(data)
                    {
                        if( data.status == "success" )
                        {
                            $('#cleaner_note_modal').modal('hide');
                            viewOrderDetails();
                        }
                        else if ( data.status == "failed" )
                        {
                            alert("failed");
                        }
                    },
                    error: function(data) 
                    {
                    }           
                });
            }
            else
            {
                alert("Cleaner note is empty. Please enter some text to Add Note.");
            }
        }
    </script>
</body>
</html>
