<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Customer Deal Details</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">

    <style type="text/css">
    .activeSM
    {
        background-color: white !important; /* #38283c !important;*/
    }
    .span_email
    {
        color:#224EA6;
        border: solid 2px #224EA6;
        margin: 0px 10px 10px 0px;
        display: inline-block;
        padding: 5px;
        cursor: pointer;
    }
    </style>
    <script>
    if (!localStorage.customer_login_deal)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>
<body>
    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Deal Details</strong></h2>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <!-- Deal Div -->
            <div id="deal_details_show" class="wrapper wrapper-content animated fadeInRight ecommerce" style="display: none;">
                <div class="row">
                    <div class="col-md-6 col-sm-12 col-xs-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <p style="color:red"> *Only pending deals under the phone# entered will display. </p>
                                <h2 style="color:#1c84c6"><strong>Please verify and click if it is your deal?</strong></h2>
                                <div class="ibox" id="deal_div" style="border: 4px solid lightgray;border-radius: 5px;">
                                    <div class="ibox-content table-responsive">
                                        <div class="row">
                                            <div class="col-md-6 col-sm-6 col-xs-6"> 
                                                <p><b>Vehicle Type:</b></p>
                                                <p><b>Term:</b></p>
                                                <p><b>Price:</b></p>
                                                <p><b>Refundable Deposit:</b></p>
                                            </div>
                                            
                                            <div class="col-md-6 col-sm-6 col-xs-6"> 
                                                <p id="vehicle_type"></p>
                                                <p id="vehicle_term"></p>
                                                <p id="vehicle_price"></p>
                                                <p id="vehicle_deposit"></p>
                                            </div>
                                            
                                            
                                            <!--
                                            <div class="col-md-6 col-sm-6 col-xs-12"> 
                                                <img id="driving_license_front" width="100" style="margin-top: 5px">
                                                <img id="driving_license_back" width="100" style="margin-top: 5px">
                                            </div>
                                            -->
                                        </div>
                                    </div>
                                </div>
                                <a href="javascript:login_show();">
                                    <button style="background-color: #003399;border-color: #003399;color: white; width: 100%;height:60px; margin-bottom:10px;font-size:30px" class="btn btn-sm btn-success m-t-n-xs" type="submit">This is My Deal </button>
                                </a>
                                <button id="modal_button" style="background-color: white;border-color: #003399;color: #003399; width: 100%;height:60px;font-size:30px" class="btn btn-sm btn-primary m-t-n-xs" type="submit" data-toggle="modal" data-target="#wrongDeal" data-style="zoom-in">This is Not My Deal </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>  

            <!-- Signin/Signup Div -->
            <div id="login_show" class="wrapper wrapper-content animated fadeInRight ecommerce" style="display: none;">
                <div class="row">
                    <div class="col-md-6 col-sm-12 col-xs-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <div class="imgcontainer">              
                                    <a href="javascript:deal_details_show();">                     
                                        <img src="img/back-arrow.png" width="50"><br>
                                    </a> 
                                </div><br>
                                
                                <form id="customer_verification" style="display:block">
                                    <div class="form-group">
                                        <label for="uname"><b>Please Enter Your Email</b></label>
                                        <input class="form-control" type="email" placeholder="Enter your email" id="email" name="email" style="margin-bottom:20px" required>
                                        <span id="gmail" class="span_email" onclick="getSpanEmail(this.id)">@gmail.com</span>
                                        <span id="aol" class="span_email" onclick="getSpanEmail(this.id)">@aol.com</span>
                                        <span id="hotmail" class="span_email" onclick="getSpanEmail(this.id)">@hotmail.com</span>
                                        <span id="outlook" class="span_email" onclick="getSpanEmail(this.id)">@outlook.com</span>
                                        <span id="yahoo" class="span_email" onclick="getSpanEmail(this.id)">@yahoo.com</span>
                                    </div>                                      
                                    <div style="margin-top: 40px">
                                        <button style="background-color: #003399;border-color: #224ea6;color: white; width: 100%; font-size:15px" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">NEXT</span><span class="ladda-spinner"></span>
                                        </button>
                                    </div>
                                </form>
                                
                                <form id="customer_login" style="display:none">
                                    <div class="form-group">
                                        <center>
                                            <label id="already_email"></label>
                                        </center>
                                    </div>
                                    <div class="form-group">
                                        <label for="psw"><b>Password</b></label>
                                        <input class="form-control" type="password" placeholder="Enter your password" id="password" name="password" required>
                                        <label style="float: right;color: #003399;"><small>Forgot Password?</small></label>
                                    </div>                                      
                                    <div style="margin-top: 40px">
                                        <button style="background-color: #003399;border-color: #224ea6;color: white; width: 100%; font-size:15px" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Login</span><span class="ladda-spinner"></span>
                                        </button>
                                    </div>
                                </form>
                                
                                <!--<a href="signup.html">
                                    <button style="margin-top: 10px; background-color: white;border-color: #224ea6;color: #003399; width: 100%; font-size:15px" class="btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                        New Here ? Register Here
                                    </button>
                                </a>-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Customer Login Success -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Customer not Login -->
            <button id="swal_btn2" type="button" style="display:none"></button>
            <!-- Verify Customer -->
            <button id="swal_btn3" type="button" style="display:none"></button>

            <?php
                include 'footer.php';
            ?>
        </div>
    </div>

    <!-- Wrong Deal Modal -->
    <div class="modal fade" id="wrongDeal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">We Apologize!</h4>
                </div>
                <div class="modal-body">
                    <p>Dear Customer,</p>
                    <p>Sorry for this inconvenience,</p>
                    <p>Please go to speak with the SalesMan</p>
                    <p>Thank you.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" style="background-color: blue; color: white" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->

    <!-- Customer Identification Modal -->
    <div class="modal fade" id="customerModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Verification</h4>
                </div>
                <div class="modal-body">
                    <h2><strong>Are you <font id="customername"></font>?</strong></h2>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white"  onclick="customerConfirm()">YES</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" onclick="customernotConfirm()">NO</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->

    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
    
    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>
    
    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>
    
    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>
     <script src="js/plugins/validate/additional-methods.min.js"></script>
    
    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>
    
    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>
    
    <!-- Page-Level Scripts -->
    <script>
        var errorText;
        var customer_exist;
        var customer_name;
        var customer_email;
        var showdeal = 1;
        var already_email;
    
        $(document).ready(function() 
        {
            $('#modal_button').click(function()
            {
                setTimeout("logout();",5000);
            });
            
            viewDealStatus();
            
            $("#customer_verification").validate({
                rules: 
                {
                    email: {
                       required: true
                    },
                },
                messages: 
                {
                },
                submitHandler: function(form) 
                {
                    var l = $( '.ladda-button-demo' ).ladda();
                    l.ladda( 'start' );
    
                    var email = $('#email').val();
                    already_email = email;
    
                    $.ajax
                    ({
                        type:'GET',
                        url:"/Panama/BigApp/BigAppLar/apis/api/VerifyEmail",
                        data: { email : email },
                        success: function(data)
                        {                        
                            if( data.status == "success" )
                            {
                                l.ladda('stop');
                                localStorage.Customer_Email = email;
                                window.location.href = "signup.php";
                            }
                            else if( data.status == "failed" )
                            {
                                l.ladda('stop');
                                
                                if( data.error == "Email Already Exits" )
                                {
                                    $('#customer_verification').css('display','none');
                                    $('#customer_login').css('display','block');
                                    $('#already_email').html(already_email);
                                }
                            }
                        },
                        error: function(data) 
                        {
                            l.ladda('stop');
                            alert("error");
                        }           
                    });                
                    return false; // extra insurance preventing the default form action
                }
            });
    
            $("#customer_login").validate({
                rules: 
                {
                    email: {
                       required: true
                    },
                    password: {
                        required: true,
                    },
                },
                messages: 
                {
                },
                submitHandler: function(form) 
                {
                    var l = $( '.ladda-button-demo' ).ladda();
                    l.ladda( 'start' );
    
                    var email = $('#email').val();
                    var password = $('#password').val();
    
                    var formData = new FormData();
                    formData.append("email", email);
                    formData.append("password", password);
    
                    $.ajax
                    ({
                        type:'POST',
                        url:"../kos_apis/customer_login.php",
                        data: formData,
                        contentType: false,
                        cache: false,
                        processData:false,
                        success: function(data)
                        {                        
                            var dat = jQuery.parseJSON(data);
                            if( dat.status == "success" )
                            {
                                l.ladda('stop');
                                localStorage.setItem("customer_data",data);
                                window.location.assign("signup.php");
                            }
                            else if( dat.status == "failed" )
                            {
                                l.ladda('stop');
                                alert(dat.error);
                                swal_btn2.click();
                            }
                        },
                        error: function(data) 
                        {
                            alert("error");
                        }           
                    });                
                    return false; // extra insurance preventing the default form action
                }
            });
    
            //Error
            $('#swal_btn2').click(function(){
                swal({
                    title: "Email/Password is incorrect",
                    text: errorText,
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });
        
        function getSpanEmail(id)
        {
            var arr=["gmail","aol","hotmail","outlook","yahoo"];
            var multipleIDS="";
            var count=0;
            
            $.each(arr, function(index,val) 
            {
                if( id != val)
                {
                    if(count == 0)
                    {
                        multipleIDS = multipleIDS + "#" + val;
                        count++;
                    }
                    else
                    {
                        multipleIDS = multipleIDS + ",#" + val;
                    }
                }
            });
            
            var temp  = $('#email').val();
            var temp2 = temp.split("@");
            $('#email').val(temp2[0] + "@" + id + ".com");
            $('#'+id).css({
                "color": "white",
                "background-color": "#224EA6",
            });
            
            
            $(multipleIDS).css({
                "color": "#224EA6",
                "background-color": "white",
            });
        }
        
        function viewDealStatus()
        {
            $.ajax
            ({
                type:'GET',
                url:"/Panama/BigApp/BigAppLar/apis/api/ViewSettingsStatus",
                success: function(data)
                {                        
                    if( data.status == "success" )
                    {
                        $.each(data.data, function(index,obj) 
                        {
                            if( obj.type == "showdeal")
                            {
                                showdeal = obj.status;
                            }
                        });
                        
                        if(showdeal)
                        {
                            $('#deal_details_show').css('display','block');
                            viewDealDetails();
                        }
                        else
                        {
                            $('.imgcontainer').css('display','none');
                            login_show();
                        }
                    }
                },
                error: function(data) 
                {
                    alert("error");
                }           
            });   
        }
    
        function viewDealDetails()
        {
            var deal_details = jQuery.parseJSON(localStorage.deal_details);
    
            $.each(deal_details.order_details, function(index,obj) 
            {
                $('#vehicle_type').html(obj.vehicle_type);
                $('#vehicle_term').html(obj.term);
                $('#vehicle_price').html( "$"+obj.price);
                $('#vehicle_deposit').html( "$"+obj.deposit_amount);
                //$('#driving_license_front').attr( "src","/kos_apis/"+obj.driv_license_front);
                //$('#driving_license_back').attr( "src","/kos_apis/"+obj.driv_license_back);
            });  
    
            customer_exist = deal_details.customer_details;
    
            if(customer_exist)
            {
                $.each(deal_details.customer_details, function(index,obj) 
                {
                    customer_name = obj.fname +" "+ obj.lname;
                    customer_email = obj.customer_email;
                });  
            }    
        }
    
        function deal_details_show()
        {
            $('#deal_details_show').css('display','block');
            $('#login_show').css('display','none');
        }
        
        function login_show()
        {
            if(showdeal)
            {
                if( customer_exist == null )
                {
                    $('#deal_details_show').css('display','none');
                    $('#login_show').css('display','block');
                }
                else
                {
                    $('#customername').html(customer_name);
                    $('#customerModal').modal('show');
                }
            }
            else
            {
                $('#deal_details_show').css('display','none');
                $('#login_show').css('display','block');
            }
        }
        
        function customerConfirm()
        {
            $('#customerModal').modal('hide');
            $('#email').val(customer_email);
            $('#deal_details_show').css('display','none');
            $('#login_show').css('display','block');
        }
        
        function customernotConfirm()
        {
            $('#customerModal').modal('hide');
            $('#deal_details_show').css('display','none');
            $('#login_show').css('display','block');
        }
    
    </script>
</body>
</html>
