<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Parents Details</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
    /*if (!localStorage.customer_login_deal)
    {
        window.stop();
        window.location.replace("index.php");
    }*/
    </script>
</head>

<body>

    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <!--<?php
                include 'navbar_static_top.php';
                ?>-->
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>PARENT'S OR GUARDIAN'S ADDITIONAL INDEMNIFICATION</Strong></h2>
                    <p>(Must be completed for the participants under the age of <strong><font id="participantage"></font></strong>)</p>
                    <ol class="breadcrumb">
                        <li>
                            Deal Details
                        </li>
                        <li class="active">
                            <strong>Parent's/Guardian's Details</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <h1><strong>Minor Info</strong></h1>
                                <div class="form-group">
                                    <label>First Name</label>
                                    <input type="text" id="fname" name="fname" class="form-control" disabled>
                                </div>
                                <div class="form-group">
                                    <label>Last Name</label>
                                    <input type="text" id="lname" name="lname" class="form-control" disabled>
                                </div>           
                                <div class="form-group">
                                    <label>Mobile</label>
                                    <input type="number" id="mobile" name="mobile" class="form-control" disabled>
                                </div> 
                                <div class="form-group">
                                    <label>Email</label>
                                    <input type="email" id="email" name="email" class="form-control" disabled>
                                </div>
                            </div>
                            <div class="ibox-content">
                                <form id="parent_guardian_form">
                                    <h1><strong>Parent's/Guardian's Info</strong></h1>
                                    <div class="form-group">
                                        <label>First Name</label>
                                        <input type="text" id="fnamep" name="fnamep" placeholder="Enter first name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Last Name</label>
                                        <input type="text" id="lnamep" name="lnamep" placeholder="Enter last name" class="form-control" required>
                                    </div>                                   
                                    <div class="form-group">
                                        <label>Email</label>
                                        <input type="email" id="emailp" name="emailp" placeholder="Enter email" class="form-control">
                                    </div>
                                    <div class="form-group">
                                        <label>Phone No#</label>
                                        <input type="number" id="phonep" name="phonep" placeholder="Enter phone number" class="form-control">
                                    </div> 
                                    <div class="form-group">
                                        <label>Date of birth</label>
                                        <div class="row">
                                            <div class="col-xs-12 col-sm-4">
                                                <input class="dobMDY" type="text" id="dob_month" name="dob_month" class="form-control" placeholder="Month" onchange="CalculateAge();" required>
                                            </div>
                                            <div class="col-xs-12 col-sm-4">
                                                <input class="dobMDY" type="text" id="dob_day" name="dob_day" class="form-control" placeholder="Day" onchange="CalculateAge();" required>
                                            </div>
                                            <div class="col-xs-12 col-sm-4">
                                                <input class="dobMDY" type="text" id="dob_year" name="dob_year" class="form-control" placeholder="Year" onchange="CalculateAge();" required>
                                            </div>
                                        </div>
                                    </div> 
                                    <div class="form-group">
                                        <label>Your Age is:</label>
                                        <input type="text" id="agep" name="agep" placeholder="Enter your Age" class="form-control" required disabled>
                                    </div>   
                                    <div class="form-group">
                                        <label>State</label>
                                        <input type="text" id="statep" name="statep" placeholder="Enter state" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Driving License#</label>
                                        <input type="text" id="license_nop" name="license_nop" placeholder="Enter driving license#" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>
                                            <input type="checkbox" id="checkp" name="checkp" required>
                                        I certify that the above information is accurate.</label>
                                    </div> 
                                    <div>
                                        <button style="background-color: #5cb85c;border-color: #5cb85c;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">DONE</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Edited Customer -->
                                        <button id="swal_btn3" type="button" style="display:none">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <?php
                include 'footer.php';
            ?>
        </div>
    </div>

<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

<!-- Jquery Validate -->
<script src="js/plugins/validate/jquery.validate.min.js"></script>
 <script src="js/plugins/validate/additional-methods.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- Ladda -->
<script src="js/plugins/ladda/spin.min.js"></script>
<script src="js/plugins/ladda/ladda.min.js"></script>
<script src="js/plugins/ladda/ladda.jquery.min.js"></script>

<script>
    var errorText;
    var agefixed;
    var ageyear;
    var customerEMAIL;
    var customerDealId;

    $(document).ready(function()
    {
        viewAgeSetup();
        readURL();

        //Add Customer
        $("#parent_guardian_form").validate({
            rules: 
            {
                fnamep: {
                   required: true
                },
                lnamep: {
                    required: true,
                },
                emailp: {
                    required: true,
                    email: true
                },
                phonep: {
                    required: true,
                },  
                dob_month: {
                    required: true,
                    number: true,
                    maxlength: 2,
                },
                dob_day: {
                    required: true,
                    number: true,
                    maxlength: 2,
                },
                dob_year: {
                    required: true,
                    number: true,
                    maxlength: 4,
                },
                license_nop: {
                    required: true,
                },
                agep: {
                    required: true,
                    number: true,
                },                    
                statep: {
                    required: true,
                },
                checkp: {
                    required: true,
                }
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );

                var fname = $('#fnamep').val();
                var lname = $('#lnamep').val();
                var email = $('#emailp').val();
                var phone = $('#phonep').val();
                var dob_day = $('#dob_day').val();
                var dob_month = $('#dob_month').val();
                var dob_year = $('#dob_year').val();
                var dob = dob_month + "-" + dob_day + "-" + dob_year;
                var age = $('#agep').val();
                var license_no = $('#license_nop').val();
                var state = $('#statep').val();
                
                localStorage.customerDealEmail = email;

                var formData = new FormData();
                formData.append("customer_email",customerEMAIL);
                formData.append("guardian_fname", fname);
                formData.append("guardian_lname", lname);
                formData.append("guardian_phone", phone);
                formData.append("guardian_email", email);
                formData.append("guardian_state", state);
                formData.append("guardian_dob", dob);
                formData.append("guardian_age", age);
                formData.append("guardian_dl_no", license_no);

                if ( ageyear < agefixed )
                {
                    alert(" You are " + age + " old, you must be at least " + agefixed + " years old or elder than " + agefixed + " years to be a Parent/Guardian.");
                    l.ladda('stop');
                }
                else
                {
                    $.ajax
                    ({
                        type:'POST',
                        url:"../kos_apis/customer_guardian.php",
                        data: formData,
                        contentType: false,
                        cache: false,
                        processData:false,
                        success: function(data)
                        {                        
                            var dat = jQuery.parseJSON(data);
                            if( dat.status == "success" )
                            {
                                $.ajax
                                ({
                                    type:'POST',
                                    url:"../kos_apis/updatedeal_status.php",
                                    data: {"deal_id": customerDealId , "verification_status" : "unverified" },
                                    success: function(data)
                                    {
                                        l.ladda('stop');
                                        window.location.assign("rental_agreement.php");
                                    },
                                    error: function(data) 
                                    {
                                        alert("error");
                                    }           
                                });
                            }
                            else if( dat.status == "failed" )
                            {
                                l.ladda('stop');
                                errorText = dat.error;
                                swal_btn2.click();
                            }
                        },
                        error: function(data) 
                        {
                            alert("error");
                        }           
                    });            
                }
                return false; // extra insurance preventing the default form action
                
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Added Successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                title: "Operation Unsuccessfull!",
                text: errorText,
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });

        $('#swal_btn3').click(function(){
            swal({
                title: "Edited Successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
            });
        });
    });
    
    function CalculateAge()
    {
    	var month = $("#dob_month").val();
    	var day = $("#dob_day").val();
    	var year = $("#dob_year").val();
    	
        $.ajax({
                url: '../kos_apis/calculate_age.php',
        		type: 'post',
        		data: {"month":month,"day":day,"year":year},
        		success: function (response)
        		{
        			var dat = jQuery.parseJSON(response);
        			
                    if( dat.status == "success" )
                    {
                        $('#agep').val(dat.data);
                        var temp = dat.data.substr(0, 2);
                        ageyear = parseInt(temp);
                    }
                    else if( dat.status == "failed" )
                    {
                    }
        		}
        	});
    }
    
    function readURL()
    {
        var url = window.location.href;
        
        var temp = url.split('?');
        var temp2 = temp[1].split('=');
        var customer_email = temp2[1];
        customerEMAIL = customer_email;
        
        $.ajax({
            url: "../kos_apis/viewcustomer.php",
            type: "GET",
            data: { "customer_email" : customer_email }, 
            success: function(data)
            {   
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    $.each(dat.customer_details, function(index,obj) 
                    {
                        customerDealId = obj.cust_deal ;
                        $('#fname').val(obj.fname);
                        $('#lname').val(obj.lname);
                        $('#email').val(obj.customer_email);
                        $('#mobile').val(obj.customer_phone);
                    });
                }
            },
            error: function(data)
            {
            }           
        });  
    }
    
    function viewAgeSetup()
    {
        $.ajax({
            url: "../kos_apis/view_age.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    $('#participantage').html(dat.age);
                    agefixed = parseInt(dat.age);
                }
            },
            error: function(data)
            {
            }           
        });        
    }

</script>

</body>
</html>
