<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Anahita Joon | Seasons </title>

    <link href="<?php echo e(asset ('css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('font-awesome/css/font-awesome.css')); ?>" rel="stylesheet">

    <!-- FooTable -->
    <link href="<?php echo e(asset ('css/plugins/footable/footable.core.css')); ?>" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="<?php echo e(asset ('css/sweetalert.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset ('css/animate.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('css/style.css')); ?>" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
<script>
    if (!localStorage.Session)
    {
        window.stop();
        window.location.replace("login");
    }
    </script>
</head>
<body>
    <div id="wrapper">

        <!-- Side Navbar -->
        <?php echo $__env->make('navbar_static_side5', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <!-- Top Navbar -->
                <?php echo $__env->make('navbar_static_top', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 
            </div>
           <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Seasons</strong></h2>
                    <!-- <a href="<?php echo e(url('add_item')); ?>">
                        <button type="button" class="btn btn-default btn-sm">
                            <span class="glyphicon glyphicon-plus"></span> Add a Season
                        </button>
                    </a> -->
                </div>
                <div class="col-lg-2">

                </div>
            </div> 

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Image</th>
                                            <th>The Season</th>
                                            <th>The Persona</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="item_list">
                                       <!-- Dynamically appending Employees List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>

            <!-- Footer -->
            <?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete a Seasom</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete an Item?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deleteItem()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->



    <!-- Mainly scripts -->
    <script src="<?php echo e(asset ('js/jquery-3.1.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/metisMenu/jquery.metisMenu.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/slimscroll/jquery.slimscroll.min.js')); ?>"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo e(asset ('js/inspinia.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/pace/pace.min.js')); ?>"></script>

    <!-- Sweet alert -->
    <script src="<?php echo e(asset ('js/plugins/sweetalert/sweetalert.min.js')); ?>"></script>

    <!-- FooTable -->
    <script src="<?php echo e(asset ('js/plugins/footable/footable.all.min.js')); ?>"></script>

    <!-- Page-Level Scripts -->
    <script>
        var delete_customer;
        var customer_data;

        $(document).ready(function() 
        {
            $("#side7").addClass("activeSM");
            $("#side7 a").css("color","#224ea6");

            $('.search-panel .dropdown-menu').find('a').click(function(e) {
                e.preventDefault();
                var param = $(this).attr("href").replace("#","");
                var concept = $(this).text();
                $('.search-panel span#search_concept').text(concept);
                $('.input-group #search_param').val(param);
            });

            viewCustomer();

            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "Please add Customer.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("<?php echo e(url('add_customer')); ?>");
                });
            });

            //Delete Row
            $('#swal_btn2').click(function(){
                swal({
                    title: "Customer Deleted!",
                    text: "",
                    type: "success",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });

        function viewCustomer()
        {
            var $list = $("#item_list");
            $list.empty();
            $.ajax({
                url: "/joon/api/SeasonView",
                type: "POST",
                
                success: function(data)
                {   
                    var count = 1;
                    customer_data = data;

                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {
                                $list.append('<tr>'+
                                                '<td><strong>'+obj.season_id+'</strong></td>'+
                                                '<td><img width="150" src="/joon/public/'+obj.image+'"/></td>'+
                                                '<td>'+obj.description+'</td>'+
                                                '<td>'+obj.description2+'</td>'+
                                                
                                                '<td>'+
                                                    '<div class="btn-group">'+
                                                        '<button id="'+obj.season_id+'" onclick ="saveCustomer(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+

                                                         '</div>'+
                                                '</td>'+
                                            '</tr>');
                                count++;
                            
                        });
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }

        function deleteCustomerModal(id)
        {
            $('#deleteModal').modal('show');
            delete_customer = id;
        }


        function deleteCustomer()
        {
            $('#deleteModal').modal('hide');

            var customer_email = delete_customer;
            $.ajax({            
                url: "/DCL/api/PersonDelete",
                type: "POST",
                data: {"EmailAddress": customer_email},
                success: function(data)
                {
                   // var data = jQuery.parseJSON(result);
                    if(data.status == "success")
                    {
                        swal_btn2.click();
                        viewCustomer();
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });
        }

        function saveCustomer(id)
        {
            var season_id= id;
//alert (season_id);
            localStorage.setItem("season_id",season_id);
            window.location.href = "<?php echo e(url('edit_season')); ?>";
        }

        function searchFilter()
        {
            var search_option = $('#search_concept').html();
            if(search_option == "All")
            {
                $('#search_box').val("All");
            }
            var search_value = $('#search_box').val();

            if( search_option != "Filter by" && search_value )
            {
                var $list = $("#customer_list");
                $list.empty();

                var count = 1;

                if( search_option == "Last Name" )
                {
                    $.each(customer_data.data, function(index,obj) 
                    {
                        if( obj.progress && search_value == obj.LastName )
                        {
                            $list.append('<tr>'+
                                            '<td><strong>'+count+'</strong></td>'+
                                            '<td>'+obj.FirstName+'</td>'+
                                            '<td style="color: #566b8a;font-weight: bolder;">'+obj.LastName+'</td>'+
                                            '<td>'+obj.EmailAddress+'</td>'+
                                            '<td>'+obj.CountryID+'</td>'+
                                            '<td>'+obj.MobileNumber+'</td>'+
                                            '<td>'+obj.Sex+'</td>'+
                                            '<td>'+
                                                '<div class="btn-group">'+
                                                    '<button id="'+obj.EmailAddress+'" onclick ="saveCustomer(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+

                                                    '<button id="'+obj.EmailAddress+'" onclick ="deleteCustomerModal(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/delete_icon.png" /></button>'+

                                                    '<button id="'+obj.EmailAddress+'" onclick ="changePassword(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/reset_password.png" /></button>'+
                                                '</div>'+
                                            '</td>'+
                                        '</tr>');
                            count++;
                        }
                    });
                    if( count == 1)
                    {
                        $list.append('<tr><td colspan="5"><h2>No record found.</h2></td></tr>');
                        $('#search_box').val("");
                    }
                }
                else if( search_option == "Email" )
                {
                    $.each(customer_data.data, function(index,obj) 
                    {
                        if( obj.progress && search_value == obj.EmailAddress )
                        {
                            $list.append('<tr>'+
                                            '<td><strong>'+count+'</strong></td>'+
                                            '<td>'+obj.FirstName+'</td>'+
                                            '<td>'+obj.LastName+'</td>'+
                                            '<td style="color: #566b8a;font-weight: bolder;">'+obj.EmailAddress+'</td>'+
                                            '<td>'+obj.CountryID+'</td>'+
                                            '<td>'+obj.MobileNumber+'</td>'+
                                            '<td>'+obj.Sex+'</td>'+
                                            '<td>'+
                                                '<div class="btn-group">'+
                                                    '<button id="'+obj.EmailAddress+'" onclick ="saveCustomer(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+

                                                    '<button id="'+obj.EmailAddress+'" onclick ="deleteCustomerModal(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/delete_icon.png" /></button>'+

                                                    '<button id="'+obj.EmailAddress+'" onclick ="changePassword(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/reset_password.png" /></button>'+
                                                '</div>'+
                                            '</td>'+
                                        '</tr>');
                            count++;
                        }
                    });
                    if( count == 1)
                    {
                        $list.append('<tr><td colspan="5"><h2>No record found.</h2></td></tr>');
                        $('#search_box').val("");
                    }
                }
                else
                {
                    $.each(customer_data.data, function(index,obj) 
                    {
                        if( obj.progress )
                        {
                            $list.append('<tr>'+
                                            '<td><strong>'+count+'</strong></td>'+
                                            '<td>'+obj.FirstName+'</td>'+
                                            '<td>'+obj.LastName+'</td>'+
                                            '<td>'+obj.EmailAddress+'</td>'+
                                            '<td>'+obj.CountryID+'</td>'+
                                            '<td>'+obj.MobileNumber+'</td>'+
                                            '<td>'+obj.Sex+'</td>'+
                                            '<td>'+
                                                '<div class="btn-group">'+
                                                    '<button id="'+obj.EmailAddress+'" onclick ="saveCustomer(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/edit_icon.png" /></button>'+

                                                    '<button id="'+obj.EmailAddress+'" onclick ="deleteCustomerModal(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/delete_icon.png" /></button>'+

                                                    '<button id="'+obj.EmailAddress+'" onclick ="changePassword(this.id);" class="btn-white btn btn-xs"><img alt="image" width="20" src="img/reset_password.png" /></button>'+
                                                '</div>'+
                                            '</td>'+
                                        '</tr>');
                            count++;
                        }
                    });
                }
            }
            else
            {
                alert("Please select filter and enter search parameter");
            }
        }
    </script>
</body>
</html>
