<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Vehicle</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>
<body>
    <div id="wrapper">
        <?php
            include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                    include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Edit All Vehicles</strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="vehicles.php">Vehicles</a>
                        </li>
                        <li class="active">
                            <strong>Edit All Vehicles</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-8">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>SNo</th>
                                            <th>Vehicle</th>
                                            <th>Category</th>
                                        </tr>
                                    </thead>
                                    <tbody id="vehicle_list">
                                        <!-- Dynamically appending Vehicles List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none"></button>

            <?php
                include 'footer.php';
            ?>
        </div>
    </div>

<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- FooTable -->
<script src="js/plugins/footable/footable.all.min.js"></script>

<!-- Page-Level Scripts -->
 <script>
    var delete_vehicle;
    var total_count;
    var objData;
    
    $(document).ready(function() 
    {
        $("#side4").addClass("activeSM");
        $("#side4 a").css("color","#224ea6");

        viewVehicles();
        
        //Empty List
        $('#swal_btn').click(function(){
            swal({
                 title: "List is Empty!",
                text: "Please add Vehicles.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
                closeOnConfirm: false
            }, function () {
                window.location.assign("add_vehicle.php");
            });
        });

        //Delete Row
        $('#swal_btn2').click(function(){
            swal({
                title: "Vehicle Deleted!",
                text: "",
                type: "success",
                confirmButtonColor: "#DD6B55",
            });
        });

        //Active Row
        $('#swal_btn3').click(function(){
            swal({
                 title: "Activated/Deactivated",
                text: "Vehicle Activated/Deactivated Successfully.",
                type: "success",
                confirmButtonColor: "#003399",
            });
        });
    });

    function viewVehicles()
    {
        total_count=1;
        var $list = $("#vehicle_list");
        $list.empty();
        
        $.ajax
        ({
            url: "kos_apis/view_all_vehicles.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                
                if ( dat.status == "success")
                {
                    objData = dat.Data;
                    
                    $.each(dat.Data, function(index,obj) 
                    {
                        $list.append('<tr>'+
                                        '<td><strong>'+count+'</strong></td>'+
                                        '<td style="width:20%"><input type="text" value="'+obj.vehicleNo+'" id="scooter_number'+index+'" name="scooter_number" placeholder="Enter scooter #" class="form-control"></td>'+
                                        '<td>'+
                                            '<div class="form-control" id="type_of_scooter'+total_count+'">'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>');
                        count++;
                        total_count++;
                    });
                }
                else
                {
                    swal_btn.click();
                }
                viewVehicleType();
            },
            error: function(data)
            {
            }           
        });        
    }
    
    function viewVehicleType()
    {
        $.ajax({
            url: "kos_apis/view_vehicle_types.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    for( var i=1 ; i < total_count ; i++ )
                    {
                        var $list = $("#type_of_scooter"+i);
                        $list.empty();
                        
                        $.each(dat.types, function(index,obj) 
                        {
                            if ( obj.active == "0")
                            {
                                //Do Nothing
                            }
                            else
                            {
                                var temptest = objData[i-1]['vehicle_id'];
                                if( objData[i-1]['vehicle_type'] == obj.type_name )
                                {
                                    vehicle_type = '<button class="btn-white btn btn-xs removing_class'+i+'"  id="'+temptest+'_'+i+'_'+index+'" onclick ="editAllvehicles(this.id);"  style="background-color:#224ea6;color:white">'+obj.type_name+'</button>';
                                }
                                else
                                {
                                    vehicle_type = '<button class="btn-white btn btn-xs removing_class'+i+'" id="'+temptest+'_'+i+'_'+index+'" onclick ="editAllvehicles(this.id);">'+obj.type_name+'</button>';
                                }
                                $list.append(vehicle_type);
                            }
                        });
                    }
                }
                else
                {
                    $list.append('<p>No category added.</p>');
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function editAllvehicles(id)
    {
        var temp = id.split('_');
        
        $('.removing_class'+temp[1]).css({
                                    "background-color": "white",
                                    "color"     : "#797b7d"
                                });
        
        $('#'+id).css({
                        "background-color": "#224ea6",
                        "color"     : "white"
                    });
        
        var vehicle_id = temp[0];
        
        var scooter_number = $('#scooter_number'+(parseInt(temp[1])-1)).val();
        var vehicle_type   = $('#'+id).html();
        
        var formData = new FormData();
        formData.append("vehicle_id", vehicle_id);
        formData.append("vehicleNo", scooter_number);
        formData.append("vehicle_tagNo", "tag_number");
        formData.append("vehicle_vinNo", "vin_number");                
        formData.append("vehicle_policeNo", "police_number");
        formData.append("vehicle_medallionNo", "medallion_number");
        formData.append("vehicle_make", "make");
        formData.append("vehicle_model", "model");
        formData.append("vehicle_year", "year");
        formData.append("vehicle_size", "size");
        formData.append("vehicle_cost", "cost");
        formData.append("vehicle_minforsale", "min_for_sale");
        formData.append("vehicle_minforrent", "min_for_rent");
        formData.append("vehicle_mileage", "mileage");
        formData.append("vehicle_sold", "sold");
        formData.append("vehicle_info", "Vehicle_info");
        formData.append("vehicle_type", vehicle_type);
        
        $.ajax({            
            type:'POST',
            url:"kos_apis/edit_vehicle.php",
            data: formData,
            contentType: false,
            cache: false,
            processData:false,
            success: function(result)
            {
                var data = jQuery.parseJSON(result);
                if(data.status == "success")
                {
                    //alert("edited");
                    //viewVehicles();
                }
                else if (data.status == "failed")
                {
                    l.ladda( 'stop' );
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });        
    }
</script>
</body>
</html>