<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\http\Request;
use Illuminate\http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Input;
use Hash;


use DB;


class CountryController extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
	
    public function getName (Request $request)
    { 
	return response()->json(['status'=>'success']); 
      
    }
	
	
	
	
	public function CountryEdit (Request $request)
    { 
			if(isset($request['CountryID']) && !empty($request['CountryID']) AND isset($request['Name']) && !empty($request['Name']) AND isset($request['PhoneCode']) && !empty($request['PhoneCode']) AND isset($request['CurrencyCode']) && !empty($request['CurrencyCode']) AND isset($request['CurrencySymbol']) && !empty($request['CurrencySymbol'])) 
			{
				$CountryID=$request['CountryID'];
                $Name=$request['Name'];
				$PhoneCode=$request['PhoneCode'];
				$CurrencyCode=$request['CurrencyCode'];
				$CurrencySymbol=$request['CurrencySymbol'];
				
							 
					$users = DB::select('select * from country where CountryID = ?', [$CountryID]);
					if($users)
					{
						try 
						{ 
							$user_new = DB::update('update country SET Name = ? , PhoneCode = ? , CurrencyCode = ?, CurrencySymbol = ? where CountryID = ?', [$Name,$PhoneCode,$CurrencyCode,$CurrencySymbol,$CountryID]);
							if ( $user_new)                             
							{
								return response()->json(['status'=>'success']);
							}
							else 
							{
								return response()->json(['status'=>'failed','error'=>'Country Already Exist']);
							}
						
						}
						
						catch(\Illuminate\Database\QueryException $ex)
						{ 		
							return response()->json(['status'=>'failed','error'=>'Country Already Exist']);
						}
						
										  
						//return response()->json(['status'=>'success','data'=>$users ]);
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'Wrong Country Id']);
					}
				 
				 
				 
				
				
			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }

public function CountryView (Request $request)
    {

		if(isset($request['CountryID']) && !empty($request['CountryID'])) 
			{
				$CountryID=$request['CountryID'];
				$DeletedFlag =0;
			$users = DB::select('select * from country where DeletedFlag = ? AND CountryID = ?', [$DeletedFlag , $CountryID]);
				if($users)
				{
					return response()->json(['status'=>'success','data'=>$users]);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'No Information Found']);
				}
			
		}
		else 
		{
			
			$DeletedFlag =0;
			$users = DB::select('select * from country where DeletedFlag = ? ', [$DeletedFlag]);
				
				if($users)
				{
					return response()->json(['status'=>'success','data'=>$users]);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'No Information Found']);
				}
			
		}
        
    }
	
	
	public function CountryDelete(Request $request)
    {
		if(isset($request['CountryID']) && !empty($request['CountryID'])) 
			{
				$CountryID=$request['CountryID'];
			
			
			$users = DB::select('select * from country where CountryID = ?', [$CountryID]);
			
				if($users)
				{
					try 
					{ 
						$DeletedFlag  =1;
						$user_new = DB::update('update country SET DeletedFlag= ?   where CountryID = ?', [$DeletedFlag,$CountryID]);
						if ( $user_new)
						{
							return response()->json(['status'=>'success']);
						}
						else 
						{
							return response()->json(['status'=>'failed','error'=>'Sql Error']);
						}
					
					}
					
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						return response()->json(['status'=>'failed','error'=>'Sql Error']);
					}
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Wrong Item Id']);
				}
			
		}
		else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			
		}
        
    }

}

