<!DOCTYPE html>
<html>
<head>
    <title>Dry Clean Locker | Add a Country </title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link href="{{ asset ('css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset ('font-awesome/css/font-awesome.css') }}" rel="stylesheet">

    <!-- FooTable -->
    <link href="{{ asset ('css/plugins/footable/footable.core.css') }}" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="{{ asset ('css/sweetalert.css') }}" rel="stylesheet">

    <!-- Ladda style -->
    <link href="{{ asset ('css/ladda-themeless.min.css')}}" rel="stylesheet">

    <link href="{{ asset ('css/animate.css') }}" rel="stylesheet">
    <link href="{{ asset ('css/style.css') }}" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>

<body>
    <div id="wrapper">
        @include('navbar_static_side')
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                @include('navbar_static_top')
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Add a Country</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="{{ url('view_country')}}">Countries</a>
                        </li>
                        <li class="active">
                            <strong>Add a Country</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="add_country_form">
                                    <div class="form-group">
                                        <label>Country</label>
                                        <select class="form-control" id="country" name="country" required="">
                                            <option value="Afghanistan">Afghanistan</option>
                                            <option value="Albania">Albania</option>
                                            <option value="Algeria">Algeria</option>
                                            <option value="American Samoa">American Samoa</option>
                                            <option value="Andorra">Andorra</option>
                                            <option value="Angola">Angola</option>
                                            <option value="Anguilla">Anguilla</option>
                                            <option value="Antartica">Antarctica</option>
                                            <option value="Antigua and Barbuda">Antigua and Barbuda</option>
                                            <option value="Argentina">Argentina</option>
                                            <option value="Armenia">Armenia</option>
                                            <option value="Aruba">Aruba</option>
                                            <option value="Australia">Australia</option>
                                            <option value="Austria">Austria</option>
                                            <option value="Azerbaijan">Azerbaijan</option>
                                            <option value="Bahamas">Bahamas</option>
                                            <option value="Bahrain">Bahrain</option>
                                            <option value="Bangladesh">Bangladesh</option>
                                            <option value="Barbados">Barbados</option>
                                            <option value="Belarus">Belarus</option>
                                            <option value="Belgium">Belgium</option>
                                            <option value="Belize">Belize</option>
                                            <option value="Benin">Benin</option>
                                            <option value="Bermuda">Bermuda</option>
                                            <option value="Bhutan">Bhutan</option>
                                            <option value="Bolivia">Bolivia</option>
                                            <option value="Bosnia and Herzegowina">Bosnia and Herzegowina</option>
                                            <option value="Botswana">Botswana</option>
                                            <option value="Bouvet Island">Bouvet Island</option>
                                            <option value="Brazil">Brazil</option>
                                            <option value="British Indian Ocean Territory">British Indian Ocean Territory</option>
                                            <option value="Brunei Darussalam">Brunei Darussalam</option>
                                            <option value="Bulgaria">Bulgaria</option>
                                            <option value="Burkina Faso">Burkina Faso</option>
                                            <option value="Burundi">Burundi</option>
                                            <option value="Cambodia">Cambodia</option>
                                            <option value="Cameroon">Cameroon</option>
                                            <option value="Canada">Canada</option>
                                            <option value="Cape Verde">Cape Verde</option>
                                            <option value="Cayman Islands">Cayman Islands</option>
                                            <option value="Central African Republic">Central African Republic</option>
                                            <option value="Chad">Chad</option>
                                            <option value="Chile">Chile</option>
                                            <option value="China">China</option>
                                            <option value="Christmas Island">Christmas Island</option>
                                            <option value="Cocos Islands">Cocos (Keeling) Islands</option>
                                            <option value="Colombia">Colombia</option>
                                            <option value="Comoros">Comoros</option>
                                            <option value="Congo">Congo</option>
                                            <option value="Congo">Congo, the Democratic Republic of the</option>
                                            <option value="Cook Islands">Cook Islands</option>
                                            <option value="Costa Rica">Costa Rica</option>
                                            <option value="Cota D'Ivoire">Cote d'Ivoire</option>
                                            <option value="Croatia">Croatia (Hrvatska)</option>
                                            <option value="Cuba">Cuba</option>
                                            <option value="Cyprus">Cyprus</option>
                                            <option value="Czech Republic">Czech Republic</option>
                                            <option value="Denmark">Denmark</option>
                                            <option value="Djibouti">Djibouti</option>
                                            <option value="Dominica">Dominica</option>
                                            <option value="Dominican Republic">Dominican Republic</option>
                                            <option value="East Timor">East Timor</option>
                                            <option value="Ecuador">Ecuador</option>
                                            <option value="Egypt">Egypt</option>
                                            <option value="El Salvador">El Salvador</option>
                                            <option value="Equatorial Guinea">Equatorial Guinea</option>
                                            <option value="Eritrea">Eritrea</option>
                                            <option value="Estonia">Estonia</option>
                                            <option value="Ethiopia">Ethiopia</option>
                                            <option value="Falkland Islands">Falkland Islands (Malvinas)</option>
                                            <option value="Faroe Islands">Faroe Islands</option>
                                            <option value="Fiji">Fiji</option>
                                            <option value="Finland">Finland</option>
                                            <option value="France">France</option>
                                            <option value="France Metropolitan">France, Metropolitan</option>
                                            <option value="French Guiana">French Guiana</option>
                                            <option value="French Polynesia">French Polynesia</option>
                                            <option value="French Southern Territories">French Southern Territories</option>
                                            <option value="Gabon">Gabon</option>
                                            <option value="Gambia">Gambia</option>
                                            <option value="Georgia">Georgia</option>
                                            <option value="Germany">Germany</option>
                                            <option value="Ghana">Ghana</option>
                                            <option value="Gibraltar">Gibraltar</option>
                                            <option value="Greece">Greece</option>
                                            <option value="Greenland">Greenland</option>
                                            <option value="Grenada">Grenada</option>
                                            <option value="Guadeloupe">Guadeloupe</option>
                                            <option value="Guam">Guam</option>
                                            <option value="Guatemala">Guatemala</option>
                                            <option value="Guinea">Guinea</option>
                                            <option value="Guinea-Bissau">Guinea-Bissau</option>
                                            <option value="Guyana">Guyana</option>
                                            <option value="Haiti">Haiti</option>
                                            <option value="Heard and McDonald Islands">Heard and Mc Donald Islands</option>
                                            <option value="Holy See">Holy See (Vatican City State)</option>
                                            <option value="Honduras">Honduras</option>
                                            <option value="Hong Kong">Hong Kong</option>
                                            <option value="Hungary">Hungary</option>
                                            <option value="Iceland">Iceland</option>
                                            <option value="India">India</option>
                                            <option value="Indonesia">Indonesia</option>
                                            <option value="Iran">Iran (Islamic Republic of)</option>
                                            <option value="Iraq">Iraq</option>
                                            <option value="Ireland">Ireland</option>
                                            <option value="Israel">Israel</option>
                                            <option value="Italy">Italy</option>
                                            <option value="Jamaica">Jamaica</option>
                                            <option value="Japan">Japan</option>
                                            <option value="Jordan">Jordan</option>
                                            <option value="Kazakhstan">Kazakhstan</option>
                                            <option value="Kenya">Kenya</option>
                                            <option value="Kiribati">Kiribati</option>
                                            <option value="Democratic People's Republic of Korea">Korea, Democratic People's Republic of</option>
                                            <option value="Korea">Korea, Republic of</option>
                                            <option value="Kuwait">Kuwait</option>
                                            <option value="Kyrgyzstan">Kyrgyzstan</option>
                                            <option value="Lao">Lao People's Democratic Republic</option>
                                            <option value="Latvia">Latvia</option>
                                            <option value="Lebanon">Lebanon</option>
                                            <option value="Lesotho">Lesotho</option>
                                            <option value="Liberia">Liberia</option>
                                            <option value="Libyan Arab Jamahiriya">Libyan Arab Jamahiriya</option>
                                            <option value="Liechtenstein">Liechtenstein</option>
                                            <option value="Lithuania">Lithuania</option>
                                            <option value="Luxembourg">Luxembourg</option>
                                            <option value="Macau">Macau</option>
                                            <option value="Macedonia">Macedonia, The Former Yugoslav Republic of</option>
                                            <option value="Madagascar">Madagascar</option>
                                            <option value="Malawi">Malawi</option>
                                            <option value="Malaysia">Malaysia</option>
                                            <option value="Maldives">Maldives</option>
                                            <option value="Mali">Mali</option>
                                            <option value="Malta">Malta</option>
                                            <option value="Marshall Islands">Marshall Islands</option>
                                            <option value="Martinique">Martinique</option>
                                            <option value="Mauritania">Mauritania</option>
                                            <option value="Mauritius">Mauritius</option>
                                            <option value="Mayotte">Mayotte</option>
                                            <option value="Mexico">Mexico</option>
                                            <option value="Micronesia">Micronesia, Federated States of</option>
                                            <option value="Moldova">Moldova, Republic of</option>
                                            <option value="Monaco">Monaco</option>
                                            <option value="Mongolia">Mongolia</option>
                                            <option value="Montserrat">Montserrat</option>
                                            <option value="Morocco">Morocco</option>
                                            <option value="Mozambique">Mozambique</option>
                                            <option value="Myanmar">Myanmar</option>
                                            <option value="Namibia">Namibia</option>
                                            <option value="Nauru">Nauru</option>
                                            <option value="Nepal">Nepal</option>
                                            <option value="Netherlands">Netherlands</option>
                                            <option value="Netherlands Antilles">Netherlands Antilles</option>
                                            <option value="New Caledonia">New Caledonia</option>
                                            <option value="New Zealand">New Zealand</option>
                                            <option value="Nicaragua">Nicaragua</option>
                                            <option value="Niger">Niger</option>
                                            <option value="Nigeria">Nigeria</option>
                                            <option value="Niue">Niue</option>
                                            <option value="Norfolk Island">Norfolk Island</option>
                                            <option value="Northern Mariana Islands">Northern Mariana Islands</option>
                                            <option value="Norway">Norway</option>
                                            <option value="Oman">Oman</option>
                                            <option value="Pakistan">Pakistan</option>
                                            <option value="Palau">Palau</option>
                                            <option value="Panama">Panama</option>
                                            <option value="Papua New Guinea">Papua New Guinea</option>
                                            <option value="Paraguay">Paraguay</option>
                                            <option value="Peru">Peru</option>
                                            <option value="Philippines">Philippines</option>
                                            <option value="Pitcairn">Pitcairn</option>
                                            <option value="Poland">Poland</option>
                                            <option value="Portugal">Portugal</option>
                                            <option value="Puerto Rico">Puerto Rico</option>
                                            <option value="Qatar">Qatar</option>
                                            <option value="Reunion">Reunion</option>
                                            <option value="Romania">Romania</option>
                                            <option value="Russia">Russian Federation</option>
                                            <option value="Rwanda">Rwanda</option>
                                            <option value="Saint Kitts and Nevis">Saint Kitts and Nevis</option> 
                                            <option value="Saint LUCIA">Saint LUCIA</option>
                                            <option value="Saint Vincent">Saint Vincent and the Grenadines</option>
                                            <option value="Samoa">Samoa</option>
                                            <option value="San Marino">San Marino</option>
                                            <option value="Sao Tome and Principe">Sao Tome and Principe</option> 
                                            <option value="Saudi Arabia">Saudi Arabia</option>
                                            <option value="Senegal">Senegal</option>
                                            <option value="Seychelles">Seychelles</option>
                                            <option value="Sierra">Sierra Leone</option>
                                            <option value="Singapore" selected>Singapore</option>
                                            <option value="Slovakia">Slovakia (Slovak Republic)</option>
                                            <option value="Slovenia">Slovenia</option>
                                            <option value="Solomon Islands">Solomon Islands</option>
                                            <option value="Somalia">Somalia</option>
                                            <option value="South Africa">South Africa</option>
                                            <option value="South Georgia">South Georgia and the South Sandwich Islands</option>
                                            <option value="Span">Spain</option>
                                            <option value="SriLanka">Sri Lanka</option>
                                            <option value="St. Helena">St. Helena</option>
                                            <option value="St. Pierre and Miguelon">St. Pierre and Miquelon</option>
                                            <option value="Sudan">Sudan</option>
                                            <option value="Suriname">Suriname</option>
                                            <option value="Svalbard">Svalbard and Jan Mayen Islands</option>
                                            <option value="Swaziland">Swaziland</option>
                                            <option value="Sweden">Sweden</option>
                                            <option value="Switzerland">Switzerland</option>
                                            <option value="Syria">Syrian Arab Republic</option>
                                            <option value="Taiwan">Taiwan, Province of China</option>
                                            <option value="Tajikistan">Tajikistan</option>
                                            <option value="Tanzania">Tanzania, United Republic of</option>
                                            <option value="Thailand">Thailand</option>
                                            <option value="Togo">Togo</option>
                                            <option value="Tokelau">Tokelau</option>
                                            <option value="Tonga">Tonga</option>
                                            <option value="Trinidad and Tobago">Trinidad and Tobago</option>
                                            <option value="Tunisia">Tunisia</option>
                                            <option value="Turkey">Turkey</option>
                                            <option value="Turkmenistan">Turkmenistan</option>
                                            <option value="Turks and Caicos">Turks and Caicos Islands</option>
                                            <option value="Tuvalu">Tuvalu</option>
                                            <option value="Uganda">Uganda</option>
                                            <option value="Ukraine">Ukraine</option>
                                            <option value="United Arab Emirates">United Arab Emirates</option>
                                            <option value="United Kingdom" selected>United Kingdom</option>
                                            <option value="United States">United States of America</option>
                                            <option value="United States Minor Outlying Islands">United States Minor Outlying Islands</option>
                                            <option value="Uruguay">Uruguay</option>
                                            <option value="Uzbekistan">Uzbekistan</option>
                                            <option value="Vanuatu">Vanuatu</option>
                                            <option value="Venezuela">Venezuela</option>
                                            <option value="Vietnam">Viet Nam</option>
                                            <option value="Virgin Islands (British)">Virgin Islands (British)</option>
                                            <option value="Virgin Islands (U.S)">Virgin Islands (U.S.)</option>
                                            <option value="Wallis and Futana Islands">Wallis and Futuna Islands</option>
                                            <option value="Western Sahara">Western Sahara</option>
                                            <option value="Yemen">Yemen</option>
                                            <option value="Yugoslavia">Yugoslavia</option>
                                            <option value="Zambia">Zambia</option>
                                            <option value="Zimbabwe">Zimbabwe</option>              
                                        </select>
                                    </div>                                   
                                    <div class="form-group">
                                        <label>Phone Code</label>
                                        <input type="text" id="phone_code" name="phone_code" placeholder="Enter Phone Code" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Currency Code</label>
                                        <select class="form-control" id="currency_code" name="currency_code" required="">
                                            <option value="USD">USD</option>
                                            <option value="EUR">EUR</option>
                                            <option value="GBP" selected="">GBP</option>
                                            <option value="DZD">DZD</option> 
                                            <option value="ARP">ARP</option>
                                            <option value="AUD">AUD</option>
                                            <option value="ATS">ATS</option>
                                            <option value="BSD">BSD</option>
                                            <option value="BBD">BBD</option>
                                            <option value="BEF">BEF</option>
                                            <option value="BMD">BMD</option>
                                            <option value="BRR">BRR</option>
                                            <option value="BGL">BGL</option>
                                            <option value="CAD">CAD</option>
                                            <option value="CLP">CLP</option>
                                            <option value="CNY">CNY</option>
                                            <option value="CYP">CYP</option>
                                            <option value="CSK">CSK</option>
                                            <option value="DKK">DKK</option>
                                            <option value="NLG">NLG</option>
                                            <option value="XCD">XCD</option>
                                            <option value="EGP">EGP</option>
                                            <option value="FJD">FJD</option>
                                            <option value="FIM">FIM</option>
                                            <option value="FRF">FRF</option>
                                            <option value="DEM">DEM</option>
                                            <option value="XAU">XAU</option>
                                            <option value="GRD">GRD</option>
                                            <option value="HKD">HKD</option>
                                            <option value="HUF">HUF</option>
                                            <option value="ISK">ISK</option>
                                            <option value="INR">INR</option>
                                            <option value="IDR">IDR</option>
                                            <option value="IEP">IEP</option>
                                            <option value="ILS">ILS</option>
                                            <option value="ITL">ITL</option>
                                            <option value="JMD">JMD</option>
                                            <option value="JPY">JPY</option>
                                            <option value="JOD">JOD</option>
                                            <option value="KRW">KRW</option>
                                            <option value="LBP">LBP</option>
                                            <option value="LUF">LUF</option>
                                            <option value="MYR">MYR</option>
                                            <option value="MXP">MXP</option>
                                            <option value="NLG">NLG</option>
                                            <option value="NZD">NZD</option>
                                            <option value="NOK">NOK</option>
                                            <option value="PKR">PKR</option>
                                            <option value="XPD">XPD</option>
                                            <option value="PHP">PHP</option>
                                            <option value="XPT">XPT</option>
                                            <option value="PLZ">PLZ</option>
                                            <option value="PTE">PTE</option>
                                            <option value="ROL">ROL</option>
                                            <option value="RUR">RUR</option>
                                            <option value="SAR">SAR</option>
                                            <option value="XAG">XAG</option>
                                            <option value="SGD">SGD</option>
                                            <option value="SKK">SKK</option>
                                            <option value="ZAR">ZAR</option>
                                            <option value="KRW">KRW</option>
                                            <option value="ESP">ESP</option>
                                            <option value="XDR">XDR</option>
                                            <option value="SDD">SDD</option>
                                            <option value="SEK">SEK</option>
                                            <option value="CHF">CHF</option>
                                            <option value="TWD">TWD</option>
                                            <option value="THB">THB</option>
                                            <option value="TTD">TTD</option>
                                            <option value="TRL">TRL</option>
                                            <option value="VEB">VEB</option>
                                            <option value="ZMK">ZMK</option>
                                            <option value="EUR">EUR</option>
                                            <option value="XCD">XCD</option>
                                            <option value="XDR">XDR</option>
                                            <option value="XAG">XAG</option>
                                            <option value="XAU">XAU</option>
                                            <option value="XPD">XPD</option>
                                            <option value="XPT">XPT</option>
                                            <option value="AED">&#8360;</option>
                                        </select>
                                    </div>                                   
                                    <div class="form-group">
                                        <label>Currency Symbol</label>
                                        <select class="form-control" id="currency_symbol" name="currency_symbol" required="">
                                            <option value="AED">&#1583;&#1573;</option>
                                            <option value="AFN">&#65;&#102;</option>
                                            <option value="ALL">&#76;&#101;&#107;</option>
                                            <option value="AMD"></option>
                                            <option value="ANG">&#402;</option>
                                            <option value="AOA">&#75;&#122;</option>
                                            <option value="ARS">&#36;</option>
                                            <option value="AUD">&#36;</option>
                                            <option value="AWG">&#402;</option>
                                            <option value="AZN">&#1084;&#1072;&#1085;</option>
                                            <option value="BAM">&#75;&#77;</option>
                                            <option value="BBD">&#36;</option>
                                            <option value="BDT">&#2547;</option>
                                            <option value="BGN">&#1083;&#1074;</option>
                                            <option value="BHD">&#1583;.&#1576;</option>
                                            <option value="BIF">&#70;&#66;&#117;</option>
                                            <option value="BMD">&#36;</option>
                                            <option value="BND">&#36;</option>
                                            <option value="BOB">&#36;&#98;</option>
                                            <option value="BRL">&#82;&#36;</option>
                                            <option value="BSD">&#36;</option>
                                            <option value="BTN">&#78;&#117;&#46;</option>
                                            <option value="BWP">&#80;</option>
                                            <option value="BYR">&#112;&#46;</option>
                                            <option value="BZD">&#66;&#90;&#36;</option>
                                            <option value="CAD">&#36;</option>
                                            <option value="CDF">&#70;&#67;</option>
                                            <option value="CHF">&#67;&#72;&#70;</option>
                                            <option value="CLF"></option>
                                            <option value="CLP">&#36;</option>
                                            <option value="CNY">&#165;</option>
                                            <option value="COP">&#36;</option>
                                            <option value="CRC">&#8353;</option>
                                            <option value="CUP">&#8396;</option>
                                            <option value="CVE">&#36;</option>
                                            <option value="CZK">&#75;&#269;</option>
                                            <option value="DJF">&#70;&#100;&#106;</option>
                                            <option value="DKK">&#107;&#114;</option>
                                            <option value="DOP">&#82;&#68;&#36;</option>
                                            <option value="DZD">&#1583;&#1580;</option>
                                            <option value="EGP">&#163;</option>
                                            <option value="ETB">&#66;&#114;</option>
                                            <option value="EUR">&#8364;</option>
                                            <option value="FJD">&#36;</option>
                                            <option value="FKP">&#163;</option>
                                            <option value="GBP" selected="">&#163;</option>
                                            <option value="GEL">&#4314;</option>
                                            <option value="GHS">&#162;</option>
                                            <option value="GIP">&#163;</option>
                                            <option value="GMD">&#68;</option>
                                            <option value="GNF">&#70;&#71;</option>
                                            <option value="GTQ">&#81;</option>
                                            <option value="GYD">&#36;</option>
                                            <option value="HKD">&#36;</option>
                                            <option value="HNL">&#76;</option>
                                            <option value="HRK">&#107;&#110;</option>
                                            <option value="HTG">&#71;</option>
                                            <option value="HUF">&#70;&#116;</option>
                                            <option value="IDR">&#82;&#112;</option>
                                            <option value="ILS">&#8362;</option>
                                            <option value="INR">&#8377;</option>
                                            <option value="IQD">&#1593;&#1583;</option>
                                            <option value="IRR">&#65020;</option>
                                            <option value="ISK">&#107;&#114;</option>
                                            <option value="JEP">&#163;</option>
                                            <option value="JMD">&#74;&#36;</option>
                                            <option value="JOD">&#74;&#68;</option>
                                            <option value="JPY">&#165;</option>
                                            <option value="KES">&#75;&#83;&#104;</option>
                                            <option value="KGS">&#1083;&#1074;</option>
                                            <option value="KHR">&#6107;</option>
                                            <option value="KMF">&#67;&#70;</option>
                                            <option value="KPW">&#8361;</option>
                                            <option value="KRW">&#8361;</option>
                                            <option value="KWD">&#1583;.&#1603;</option>
                                            <option value="KYD">&#36;</option>
                                            <option value="KZT">&#1083;&#1074;</option>
                                            <option value="LAK">&#8365;</option>
                                            <option value="LBP">&#163;</option>
                                            <option value="LKR">&#8360;</option>
                                            <option value="LRD">&#36;</option>
                                            <option value="LSL">&#76;</option>
                                            <option value="LTL">&#76;&#116;</option>
                                            <option value="LVL">&#76;&#115;</option>
                                            <option value="LYD">&#1604;.&#1583;</option>
                                            <option value="MAD">&#1583;.&#1605;</option>
                                            <option value="MDL">&#76;</option>
                                            <option value="MGA">&#65;&#114;</option>
                                            <option value="MKD">&#1076;&#1077;&#1085;</option>
                                            <option value="MMK">&#75;</option>
                                            <option value="MNT">&#8366;</option>
                                            <option value="MOP">&#77;&#79;&#80;&#36;</option>
                                            <option value="MRO">&#85;&#77;</option>
                                            <option value="MUR">&#8360;</option>
                                            <option value="MVR">&#1923;</option>
                                            <option value="MWK">&#77;&#75;</option>
                                            <option value="MXN">&#36;</option>
                                            <option value="MYR">&#82;&#77;</option>
                                            <option value="MZN">&#77;&#84;</option>
                                            <option value="NAD">&#36;</option>
                                            <option value="NGN">&#8358;</option>
                                            <option value="NIO">&#67;&#36;</option>
                                            <option value="NOK">&#107;&#114;</option>
                                            <option value="NPR">&#8360;</option>
                                            <option value="NZD">&#36;</option>
                                            <option value="OMR">&#65020;</option>
                                            <option value="PAB">&#66;&#47;&#46;</option>
                                            <option value="PEN">&#83;&#47;&#46;</option>
                                            <option value="PGK">&#75;</option>
                                            <option value="PHP">&#8369;</option>
                                            <option value="PKR">&#8360;</option>
                                            <option value="PLN">&#122;&#322;</option>
                                            <option value="PYG">&#71;&#115;</option>
                                            <option value="QAR">&#65020;</option>
                                            <option value="RON">&#108;&#101;&#105;</option>
                                            <option value="RSD">&#1044;&#1080;&#1085;&#46;</option>
                                            <option value="RUB">&#1088;&#1091;&#1073;</option>
                                            <option value="RWF">&#1585;&#1587;</option>
                                            <option value="SAR">&#65020;</option>
                                            <option value="SBD">&#36;</option>
                                            <option value="SCR">&#8360;</option>
                                            <option value="SDG">&#163;</option>
                                            <option value="SEK">&#107;&#114;</option>
                                            <option value="SGD">&#36;</option>
                                            <option value="SHP">&#163;</option>
                                            <option value="SLL">&#76;&#101;</option>
                                            <option value="SOS">&#83;</option>
                                            <option value="SRD">&#36;</option>
                                            <option value="STD">&#68;&#98;</option>
                                            <option value="SVC">&#36;</option>
                                            <option value="SYP">&#163;</option>
                                            <option value="SZL">&#76;</option>
                                            <option value="THB">&#3647;</option>
                                            <option value="TJS">&#84;&#74;&#83;</option>
                                            <option value="TMT">&#109;</option>
                                            <option value="TND">&#1583;.&#1578;</option>
                                            <option value="TOP">&#84;&#36;</option>
                                            <option value="TRY">&#8356;</option>
                                            <option value="TTD">&#36;</option>
                                            <option value="TWD">&#78;&#84;&#36;</option>
                                            <option value="TZS"></option>
                                            <option value="UAH">&#8372;</option>
                                            <option value="UGX">&#85;&#83;&#104;</option>
                                            <option value="USD">&#36;</option>
                                            <option value="UYU">&#36;&#85;</option>
                                            <option value="UZS">&#1083;&#1074;</option>
                                            <option value="VEF">&#66;&#115;</option>
                                            <option value="VND">&#8363;</option>
                                            <option value="VUV">&#86;&#84;</option>
                                            <option value="WST">&#87;&#83;&#36;</option>
                                            <option value="XAF">&#70;&#67;&#70;&#65;</option>
                                            <option value="XCD">&#36;</option>
                                            <option value="XDR"></option>
                                            <option value="XOF"></option>
                                            <option value="XPF">&#70;</option>
                                            <option value="YER">&#65020;</option>
                                            <option value="ZAR">&#82;</option>
                                            <option value="ZMK">&#90;&#75;</option>
                                            <option value="ZWL">&#90;&#36;</option>                                           
                                        </select>
                                    </div>                                    
                                   
                                    <div>
                                        <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>

                                        <!-- Successfully Added Country -->
                                        <button id="swal_btn" type="button" style="display:none"></button>
                                        <!-- Country not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none"></button>
                                    </div>
                                </form>
                                <a href="{{url('view_country')}}">
                                    <button style="background-color: #5cb85c;color: white;margin-left: 70px;margin-top: -50px;" class="btn btn-sm btn-primary m-t-n-xs" data-style="zoom-in">Cancel</button>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('footer')
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <script>
    var errorMessage;
    $(document).ready(function()
    {
        $("#side8").addClass("activeSM");
        $("#side8 a").css("color","#224ea6");

        
        $("#add_country_form").validate({
            rules: 
            {
                country: {
                    required: true
                },
                phone_code: {
                    required: true,
                },
                currency_code: {
                    required: true,
                },
                currency_symbol: {
                    required: true,
                },
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );
                var swal_btn = document.getElementById("swal_btn");

                var country = $('#country').val();
                var phone_code = $('#phone_code').val();
                var currency_code = $('#currency_code').val();
                var currency_symbol = $('#currency_symbol').val();

                var formData = new FormData();
                formData.append("Name", country);
                formData.append("PhoneCode", phone_code);
                formData.append("CurrencyCode", currency_code);
                formData.append("CurrencySymbol", currency_symbol);
                                    
                $.ajax
                ({
                    type:'POST',
                    url:"/DCL/api/AddCountry",
                    data: formData,
                    contentType: false,
                    cache: false,
                    processData:false,
                    success: function(data)
                    {
                        if( data.status == "success" )
                        {
                            l.ladda('stop');
                            swal_btn.click();
                        }
                        else if( data.status == "failed" )
                        {
                            l.ladda('stop');
                            errorMessage = data.error;
                            swal_btn2.click();
                        }
                    },
                    error: function(data) 
                    {
                        alert("error");
                    }           

                });                
                return false; // extra insurance preventing the default form action
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Country added successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
                closeOnConfirm: false
            }, function () {
                window.location.assign("{{ url('view_country')}}");
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: errorMessage,
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
    });
</script>

</body>
</html>
