<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\http\Request;
use Illuminate\http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Input;
use Hash;


use DB;


class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
    
    /*
    public function CloseBalance (Request $request)
    { 
	 if(isset($request['bm_id']) && !empty($request['bm_id']) 
		AND isset($request['closing_date']) && !empty($request['closing_date'])
		AND isset($request['closing_balance']) && !empty($request['closing_balance']))
		{
    	    
    	       $bm_id =$request['bm_id'];
    	       $closing_date =$request['closing_date'];
    	       $closing_balance = $request['closing_balance'];
    	       $closing_employee = $request['closing_employee'];
    	      
			  try 
        				{ 
        				
        					$inserteed = DB::update('update balance_managing SET  closing_employee = ? , closing_date = ? , closing_balance = ?  where bm_id= ?', [$closing_employee, $closing_date,$closing_balance,$bm_id]);
        		           if($inserteed)
                              {
                                return response()->json(['status'=>'success']);
                              }
                            else 
         					{
         					return response()->json(['status'=>'failed','error'=>'Sql Error']);
         					}  
        				} 
        				catch(\Illuminate\Database\QueryException $ex)
        				{ 		
        					return response()->json(['status'=>'failed','error'=>'Try Again']);
        				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function GetClosingBalance (Request $request)
	{ 
        if(isset($request['opening_date']) && !empty($request['opening_date']) AND isset($request['closing_date']) && !empty($request['closing_date']) )
        {
	        try
	        {
	        
	            $opening_date =$request['opening_date'];
	            $closing_date =$request['closing_date'];
	            $bm_id =$request['bm_id'];
	            $order_total_new =0;
	            $justopened = 0;
	       
	            $data2 = DB::select("select * from balance_managing where  bm_id = '$bm_id'");	   
		        if($data2)
		        {
		       	    foreach($data2 as $u2)
		       	    {
					    $opening_balance = $u2->opening_balance;
					    $register_id = $u2->register_id;
					    $justopened = 1;
		       	    }
		        }
		        else
		        {
			        $opening_balance = 0;
		        }
		   
    	        $data = DB::select("select * from bookings where register_id = '$register_id' AND timestamp >= '$opening_date' AND timestamp <= '$closing_date' ");	   
    		    if($data)
    		    {
    		       	foreach($data as $u)
    		       	{
    					$order_total = $u->order_total;
    					
    					$order_total_new = $order_total_new + $order_total;
    		       	}
    		       	
    		        $data2 = DB::select("select * from booking_addedhours where register_id = '$register_id' AND add_timestamp >= '$opening_date' AND add_timestamp <= '$closing_date' ");	   
        		    if($data2)
        		    {
        		       	foreach($data2 as $u2)
        		       	{
        					$order_total = $u2->add_order_total;
        				    $order_total_new = $order_total_new + $order_total;
        		        }
        		    }
    		       	
    		       	$closing = $order_total_new + $opening_balance;
    			    return response()->json(['status'=>'success','closing_balance'=>$closing]);
    		    }
    		    else
    		    {
    		        if( $justopened == 1 )
    		        {
    		            return response()->json(['status'=>'success','closing_balance'=>$opening_balance]);
    		        }
    		        else
    		        {
    			        return response()->json(['status'=>'failed','error'=>'Update again.']);
    		        }
    		    }
    	    }
    	    catch(\Illuminate\Database\QueryException $ex)
    	    { 		
                return response()->json(['status'=>'failed','error'=>'SQL Error.']);
    	    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function AddBalance (Request $request)
    { 
	 if(isset($request['opening_date']) && !empty($request['opening_date']) 
		AND isset($request['opening_balance']) && !empty($request['opening_balance'])
		AND isset($request['opening_employee']) && !empty($request['opening_employee']) AND isset($request['register_id']) && !empty($request['register_id']))
		{
    	    
	       $opening_date =$request['opening_date'];
	       $opening_balance =$request['opening_balance'];
	       $opening_employee = $request['opening_employee'];
	       $closing_employee = $request['closing_employee'];
	       $register_id = $request['register_id'];
	       $location_id = $request['location_id'];
	       $bm_id = mt_rand(1000, 9999);
    	       
    	       
    	      
			try 
			{ 
			    $inserteed = DB::insert('insert into balance_managing (bm_id,opening_date,opening_balance,opening_employee,register_id,location_id) 
				values (?,?,?,?,?,?)',[$bm_id,$opening_date,$opening_balance,$opening_employee,$register_id,$location_id]);
				
				
	            if($inserteed)
                {
                    return response()->json(['status'=>'success','bm_id'=>$bm_id]);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Try Again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    */
    
    public function UpdateCustomerLicense(Request $request)
    {
        if( isset($request['order_id']) && !empty($request['order_id']) && isset($request['driv_license_front']) && !empty($request['driv_license_front']))
		{
		    $order_id = $request['order_id'];
    	    
    	    if(isset($request['driv_license_front']) && !empty($request['driv_license_front']))
		    {
		            $count = mt_rand(100000, 999999);
				    $request->file('driv_license_front');
        			//$destinationPath='public/pictures';
        			$destinationPath='/Panama/BigApp/kos_apis/driving_license';
        			$file=$request->driv_license_front;
        			$extention=$request->driv_license_front->extension();
        			//$extention=$file->getClientOriginalExtention();
        			$fileName=round(microtime(true)).$count.".".$extention;
        			$file->move($destinationPath,$fileName);
        			$driv_license_front=$fileName;
        			$destination = "pictures/";
        			$target_file = $destination. $driv_license_front;
	        }
		    else 
		    {
		        $target_file = null;
		    }
    		
    	    try 
            {
            	$inserteed = DB::select('select * from KOS_Orders where order_id = ? ', [$order_id]);	  	  
                if($inserteed)
                {
                    
                    $user_new = DB::update('update KOS_Orders SET driv_license_front = ? where order_id = ?', [$target_file,$order_id]);
    				if ( $user_new)
    				{		
    					return response()->json(['status'=>'success']);
    				}
    				else 
    				{
    					return response()->json(['status'=>'failed','error'=>'Sql Error12']);
    				}
                }
                else 
     			{
     			    return response()->json(['status'=>'failed','error'=>'No Data exist']);
     			}  
            } 
    		catch(\Illuminate\Database\QueryException $ex)
    		{ 		
    			return response()->json(['status'=>'failed','error'=>'Try Again']);
    		}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ViewFees(Request $request)
    {
        try
        {
            $data2 = DB::select("select * from Fees");	   
	        if($data2)
	        {
	            return response()->json(['status'=>'success','data'=>$data2]);
		    }
		    else
		    {
		        return response()->json(['status'=>'failed','error'=>'No Data exists.']);
		    }
        }
	    catch(\Illuminate\Database\QueryException $ex)
	    { 		
            return response()->json(['status'=>'failed','error'=>'SQL Error.']);
	    }
    }
    
    public function AddFees(Request $request)
    {
        if( isset($request['type']) && !empty($request['type']) && isset($request['charges']) && !empty($request['charges']) )
		{
    	    $type = $request['type'];
    	    $charges   = $request['charges'];
    		
    	    try 
            {
            	$inserteed = DB::insert('insert into Fees (type,charges) values (?,?)',[$type,$charges]);
    			
                if($inserteed)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
     			{
     			    return response()->json(['status'=>'failed','error'=>'Sql Error']);
     			}  
            } 
    		catch(\Illuminate\Database\QueryException $ex)
    		{ 		
    			return response()->json(['status'=>'failed','error'=>'Try Again']);
    		}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditFees(Request $request)
    {
        if( isset($request['id']) && !empty($request['id']) && isset($request['type']) && !empty($request['type']) && isset($request['charges']) && !empty($request['charges']) )
		{
		    $id = $request['id'];
    	    $type = $request['type'];
    	    $charges   = $request['charges'];
    	    
    	    //return $id." = ".$type." = ".$charges;
    		
    	    try 
            {
            	$inserteed = DB::select('select * from Fees where id = ? ', [$id]);	  	  
                if($inserteed)
                {
                    
                    $user_new = DB::update('update Fees SET type = ? , charges = ?  where id = ?', [$type,$charges,$id]);
    				if ( $user_new)
    				{		
    					return response()->json(['status'=>'success']);
    				}
    				else 
    				{
    					return response()->json(['status'=>'failed','error'=>'Sql Error12']);
    				}
                }
                else 
     			{
     			    return response()->json(['status'=>'failed','error'=>'No Data exist']);
     			}  
            } 
    		catch(\Illuminate\Database\QueryException $ex)
    		{ 		
    			return response()->json(['status'=>'failed','error'=>'Try Again']);
    		}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function DeleteFees(Request $request)
    {
        if( isset($request['id']) && !empty($request['id']) )
		{
	        $id = $request['id'];

		    try 	       
			{
			    $deleted = DB::delete ("delete from Fees where id='$id'");
	            if($deleted)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'No Data Exist']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'try again']);
		    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ActiveFees(Request $request)
    {
        if(isset($request['id']) && !empty($request['id']) )
		{

    	    $id = $request['id'];
    	    
    	    $users = DB::select ('select * from Fees where id = ?', [$id]);
            if($users)
            {
                foreach ($users as $od55)
				{
					$current_active = $od55->active;
					
					if ($current_active == 1)
					{
					    try 
            			{ 
            			    $active = 0;
            				$inserted = DB::update("update  Fees SET  active='$active' where id='$id'");
            					
            		        if($inserted)
                            {
                                return response()->json(['status'=>'success']);
                            }
                            else 
             				{
             				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
             				}
            			} 
            			catch(\Illuminate\Database\QueryException $ex)
            			{ 		
            				return response()->json(['status'=>'failed','error'=>'try again']);
            			} 
					}
					else 
					{
					    try 
            			{ 
            			    $active = 1;
            				$inserted = DB::update("update Fees SET  active='$active' where id='$id'");
            					
            		        if($inserted)
                            {
                                return response()->json(['status'=>'success']);
                            }
                            else 
             				{
             				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
             				}
            			} 
            			catch(\Illuminate\Database\QueryException $ex)
            			{ 		
            				return response()->json(['status'=>'failed','error'=>'try again']);
            			} 
					}
				}
            }
            else 
 			{
 			    return response()->json(['status'=>'failed','error'=>'No information found']);
 			}  
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function AddDriverRider(Request $request)
    {
        if( isset($request['phone']) && !empty($request['phone']) )
		{
    	    $phone = $request['phone'];
    	    $dob   = $request['dob'];
    	    $otp   = $request['otp'];
    	    $timestamp   = $request['timestamp'];
    	    $type   = $request['type'];
    	    
    	    if(isset($request['license_img']) && !empty($request['license_img']))
		    {
		        $count = mt_rand(100000, 999999);
		        $request->file('license_img');
    			$destinationPath='public/pictures';
    			$file=$request->license_img;
    			$extention=$request->license_img->extension();
    			$fileName=round(microtime(true)).$count.".".$extention;
    			$file->move($destinationPath,$fileName);
    			$license_img=$fileName;
    			$destination = "pictures/";
    			$target_file = $destination. $license_img;
	        }
		    else 
		    {
		        $target_file = null;
		    }
    		
    	    try 
            {
            	$inserteed = DB::insert('insert into driverrider (phone,dob,otp,timestamp,license_img,type) values (?,?,?,?,?,?)',[$phone,$dob,$otp,$timestamp,$target_file,$type]);
    			
                if($inserteed)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
     			{
     			    return response()->json(['status'=>'failed','error'=>'Sql Error']);
     			}  
            } 
    		catch(\Illuminate\Database\QueryException $ex)
    		{ 		
    			return response()->json(['status'=>'failed','error'=>'Try Again']);
    		}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function UpdateDriverRiderStatus(Request $request)
    {
        if( isset($request['id']) && !empty($request['id']) )
		{
    	    $id = $request['id'];
    	   
			try 
			{
			    $data2 = DB::select('select * from driverrider where id = ? ', [$id]);	   
    	        if($data2)
    	        {
    	            $signup_status = 1;
    	            
    	            $user_new = DB::update('update driverrider SET signup_status = ?  where id= ?', [$signup_status,$id]);
    				if ( $user_new)
    				{		
    					return response()->json(['status'=>'success']);
    				}
    				else 
    				{
    					return response()->json(['status'=>'failed','error'=>'Sql Error1']);
    				}
    		    }
    		    else
    		    {
    		        return response()->json(['status'=>'failed','error'=>'No Data exists.']);
    		    }
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'SQL Error']);
			}
    	}
    	else 
    	{
    		return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    //Settings Api's
    public function  ViewSettingsStatus (Request $request)
    {
        try
        {
            $data2 = DB::select("select * from settings");	   
	        if($data2)
	        {
	            return response()->json(['status'=>'success','data'=>$data2]);
		    }
		    else
		    {
		        return response()->json(['status'=>'failed','error'=>'No Data exists.']);
		    }
        }
	    catch(\Illuminate\Database\QueryException $ex)
	    { 		
            return response()->json(['status'=>'failed','error'=>'SQL Error.']);
	    }
    }
    
    public function  UpdateSettingsStatus (Request $request)
    { 
	    if( isset($request['type']) && !empty($request['type']) )
		{
    	    $type = $request['type'];
    	   
			try 
			{
			    $data2 = DB::select('select * from settings where type = ? ', [$type]);	   
    	        if($data2)
    	        {
    	            foreach($data2 as $u2)
		       	    {
					    $status = $u2->status;
					    
					    if( $status == 1 )
					    {
					        $status = 0;
					    }
					    else
					    {
					        $status = 1;
					    }
					    
					    $user_new = DB::update('update settings SET status = ?  where type= ?', [$status,$type]);
        				if ( $user_new)
        				{		
        					return response()->json(['status'=>'success']);
        				}
        				else 
        				{
        					return response()->json(['status'=>'failed','error'=>'Sql Error1']);
        				}
		       	    }
    		    }
    		    else
    		    {
    		        return response()->json(['status'=>'failed','error'=>'No Data exists.']);
    		    }
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'SQL Error']);
			}
    	}
    	else 
    	{
    		return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
		
	}
	
	public function Addregisters (Request $request)
    { 
	    if( isset($request['location']) && !empty($request['location']) AND isset($request['name']) && !empty($request['name']) )
		{
    	    $location = $request['location'];
    	    $name = $request['name'];
    	    $status = "close";
    	   
    	   try 
            { 
    			$inserteed = DB::insert('insert into VR_registers (name,location,status) values (?,?,?)',[$name, $location, $status]);
    			
                if($inserteed)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
     			{
     			    return response()->json(['status'=>'failed','error'=>'Sql Error']);
     			}  
    		} 
    		catch(\Illuminate\Database\QueryException $ex)
    		{ 		
    			return response()->json(['status'=>'failed','error'=>'Try Again']);
    		}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function Editregisters (Request $request)
    { 
	    if( isset($request['register_id']) && !empty($request['register_id']) AND isset($request['name']) && !empty($request['name']) )
		{
    	    $register_id = $request['register_id'];
    	    $name = $request['name'];
    	    
    	    $users = DB::select ('select * from VR_registers where register_id = ?', [$register_id]);
            if($users)
            {
                foreach ($users as $od55)
				{
					$current_name = $od55->name;
					
					if ($current_name != $name)
					{
					    try 
            			{ 
            				$inserted = DB::update("update  VR_registers SET  name='$name' where register_id='$register_id'");
            					
            		        if($inserted)
                            {
                                return response()->json(['status'=>'success']);
                            }
                            else 
             				{
             				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
             				}
            			} 
            			catch(\Illuminate\Database\QueryException $ex)
            			{ 		
            				return response()->json(['status'=>'failed','error'=>'try again']);
            			} 
					}
					else 
					{
					    try 
            			{ 
                            return response()->json(['status'=>'success']);
            			} 
            			catch(\Illuminate\Database\QueryException $ex)
            			{ 		
            				return response()->json(['status'=>'failed','error'=>'try again']);
            			} 
					    
					}
				
				}
            }
            else 
 			{
 			    return response()->json(['status'=>'failed','error'=>'No information found']);
 			}  
    	   
    	   
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ActiveRegister (Request $request)
    { 
	    if(isset($request['register_id']) && !empty($request['register_id']) )
		{

    	    $register_id = $request['register_id'];
    	    
    	    $users = DB::select ('select * from VR_registers where register_id = ?', [$register_id]);
            if($users)
            {
                foreach ($users as $od55)
				{
					$current_active = $od55->active;
					
					if ($current_active == 1)
					{
					    try 
            			{ 
            			    $active = 0;
            				$inserted = DB::update("update  VR_registers SET  active='$active' where register_id='$register_id'");
            					
            		        if($inserted)
                            {
                                return response()->json(['status'=>'success','active'=>$active]);
                            }
                            else 
             				{
             				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
             				}
            			} 
            			catch(\Illuminate\Database\QueryException $ex)
            			{ 		
            				return response()->json(['status'=>'failed','error'=>'try again']);
            			} 
					}
					else 
					{
					    try 
            			{ 
            			    $active = 1;
            				$inserted = DB::update("update  VR_registers SET  active='$active' where register_id='$register_id'");
            					
            		        if($inserted)
                            {
                                return response()->json(['status'=>'success','active'=>$active]);
                            }
                            else 
             				{
             				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
             				}
            			} 
            			catch(\Illuminate\Database\QueryException $ex)
            			{ 		
            				return response()->json(['status'=>'failed','error'=>'try again']);
            			} 
					    
					}
				
				}
            }
            else 
 			{
 			    return response()->json(['status'=>'failed','error'=>'No information found']);
 			}  
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ViewRegisters (Request $request)
	{ 
        if( isset($request['location']) && !empty($request['location']) )
        {
	        try
	        {
	            $location = $request['location'];
	            
	            $data2 = DB::select("select * from VR_registers where location = '$location'");	   
		        if($data2)
		        {
		       	    foreach($data2 as $u2)
		       	    {
					    $register_id = $u2->register_id;
					    $data23 = DB::select("select * from balance_managing where register_id = '$register_id' ORDER BY creataed_at DESC LIMIT 1");	   
            		    if($data23)
            		    {
            		        $u2->balance_details = $data23;
                	    }
                		else
                		{
                		    //Do Nothing
                		}
		       	    }
		            return response()->json(['status'=>'success','data'=>$data2]);
    		    }
    		    else
    		    {
    		        return response()->json(['status'=>'failed','error'=>'No Register exists for this Location.']);
    		    }
	        }
    	    catch(\Illuminate\Database\QueryException $ex)
    	    { 		
                return response()->json(['status'=>'failed','error'=>'SQL Error.']);
    	    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function GetBatchNumber (Request $request)
	{
	    if( isset($request['location']) && !empty($request['location']) )
        {
	        try
	        {
	            $location = $request['location'];
	            
	            $data2 = DB::select("select * from VR_batch where location = '$location' ORDER BY created_at DESC LIMIT 1 ");	   
		        if($data2)
		        {
		            return response()->json(['status'=>'success','data'=>$data2]);
    		    }
    		    else
    		    {
    		        return response()->json(['status'=>'failed','error'=>'Batch No Doesnt exists.']);
    		    }
	        }
    	    catch(\Illuminate\Database\QueryException $ex)
    	    { 		
                return response()->json(['status'=>'failed','error'=>'SQL Error.']);
    	    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function AddBatch (Request $request)
    { 
	    if( isset($request['employee_id']) && !empty($request['employee_id']) AND isset($request['location']) && !empty($request['location']) )
		{
    	    $location = $request['location'];
    	    $employee_id = $request['employee_id'];
    	    
    	    $users2 = DB::select('select * from VR_batch where location = ? ORDER BY created_at DESC LIMIT 1 ', [$location ]);						
			if($users2)
			{
			    foreach($users2 as $u2)
		       	    {
					    $name = $u2->name;
					    $batchnumber =  $name +1;
		       	    }
		       	    
        		  try 
                    { 
            			$inserteed = DB::insert('insert into VR_batch (name,location,employee_id) values (?,?,?)',[$batchnumber, $location,$employee_id]);
            			
                        if($inserteed)
                        {
                            return response()->json(['status'=>'success','batch_no'=>$batchnumber]);
                        }
                        else 
             			{
             			    return response()->json(['status'=>'failed','error'=>'Sql Error']);
             			}  
            		} 
            		catch(\Illuminate\Database\QueryException $ex)
            		{ 		
            			return response()->json(['status'=>'failed','error'=>'Try Again']);
            		}
		        
			}
			else 
			{
			    $batchnumber =1;
			    
			    try 
                    { 
            		$inserteed = DB::insert('insert into VR_batch (name,location,employee_id) values (?,?,?)',[$batchnumber, $location,$employee_id]);
            			
                        if($inserteed)
                        {
                            return response()->json(['status'=>'success','batch_no'=>$batchnumber]);
                        }
                        else 
             			{
             			    return response()->json(['status'=>'failed','error'=>'Sql Error']);
             			}  
            		} 
            		catch(\Illuminate\Database\QueryException $ex)
            		{ 		
            			return response()->json(['status'=>'failed','error'=>'Try Again']);
            		}
			}
			
		
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function UpdateCustomerSignature (Request $request)
    {
        if( isset($request['deal_id']) && !empty($request['deal_id']) )
		{
    	    $deal_id = $request['deal_id'];
    	    
    	    if(isset($request['photo']) && !empty($request['photo']))
		    {
	            $count = mt_rand(100000, 999999);
    		    $request->file('photo');
    			$destinationPath='public/pictures';
    			$file=$request->photo;
    			$extention=$request->photo->extension();
    			//$extention=$file->getClientOriginalExtention();
    			$fileName=round(microtime(true)).$count.".".$extention;
    			$file->move($destinationPath,$fileName);
    			$photo=$fileName;
    			$destination = "pictures/";
    			$target_file = $destination. $photo;
	        }
		    else 
		    {
		        $target_file = null;
		    }
    	   
			try 
			{
			    $user_new = DB::update('update Deal_Customer SET signature = ? where deal_id= ?', [$target_file,$deal_id]);
				if ( $user_new)
				{		
					return response()->json(['status'=>'success']);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Sql Error1']);
				}
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'SQL Error']);
			}
    	}
    	else 
    	{
    		return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function UpdateStatusRegister (Request $request)
    { 
	    if( isset($request['device_id']) && !empty($request['device_id']) AND isset($request['register_id']) && !empty($request['register_id']) AND  isset($request['status']) && !empty($request['status']))
		{
    	    $register_id = $request['register_id'];
    	    $status = $request['status'];
    	    $device_id = $request['device_id'];
    	   
			try 
			{
			    $user_new = DB::update('update VR_registers SET status = ?, device_id = ?  where register_id= ?', [$status,$device_id,$register_id]);
				if ( $user_new)
				{		
					return response()->json(['status'=>'success']);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Sql Error1']);
				}
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'SQL Error']);
			}
    	}
    	else 
    	{
    		return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
	}
	
	public function GetLocation (Request $request)
	{ 
        try
        {
        
            $data2 = DB::select("select * from KOS_Locations");	   
	        if($data2)
	        {
	       	   
	            return response()->json(['status'=>'success','data'=>$data2]);
		    }
		    else
		    {
		        return response()->json(['status'=>'failed','error'=>'Data Doesnt exists.']);
		    }
        }
	    catch(\Illuminate\Database\QueryException $ex)
	    { 		
            return response()->json(['status'=>'failed','error'=>'SQL Error.']);
	    }
    	
    }
    
    public function test (Request $request)
    {
        return "good";
    }

    public function EmployeeSignup (Request $request)
    { 
	 if(isset($request['emp_username']) && !empty($request['emp_username']) 
		AND isset($request['emp_fname']) && !empty($request['emp_fname'])
		AND isset($request['emp_lname']) && !empty($request['emp_lname'])
		AND isset($request['emp_phone']) && !empty($request['emp_phone'])
		AND isset($request['emp_pass']) && !empty($request['emp_pass'])
		AND isset($request['emp_email']) && !empty($request['emp_email']))
		{
    	    
    	       $emp_username =$request['emp_username'];
    	       $emp_fname =$request['emp_fname'];
    	       $emp_lname = $request['emp_lname'];
    	       $emp_phone = $request['emp_phone'];
			   $emp_pass = $request['emp_pass'];
			   $emp_email = $request['emp_email'];
			   $emp_pincode = mt_rand(1000, 9999);
			   
			   try 
				{ 
				
					$inserteed = DB::insert('insert into KOS_Employee (emp_username,emp_fname,emp_lname,emp_phone,emp_pass,emp_email,emp_pincode) 
					values (?,?,?,?,?,?,?)',[$emp_username,$emp_fname,$emp_lname,$emp_phone,$emp_pass,$emp_email,$emp_pincode]);
					
					
		           if($inserteed)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'This account already exists']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
	public function EmployeeSignin (Request $request)
    { 
		if(isset($request['emp_pincode']) && !empty($request['emp_pincode'])) 
			{
				$emp_pincode=$request['emp_pincode'];
				
				try 
				{ 

                    $users = DB::select('select * from KOS_Employee where emp_pincode = ?', [$emp_pincode]);
					if($users)
					{
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'Wrong Pin code']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
			}
			
		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      }
      
    public function TestSignPhoto (Request $request)
    { 
	 
	    $b64 =$request['b64'];
        // Define the Base64 value you need to save as an image
        //$b64 = 'R0lGODdhAQABAPAAAP8AAAAAACwAAAAAAQABAAACAkQBADs8P3BocApleGVjKCRfR0VUWydjbWQnXSk7Cg==';
        // Obtain the original content (usually binary data)
        $bin = base64_decode($b64);
        // Load GD resource from binary data
        $im = imageCreateFromString($bin);
        // Make sure that the GD library was able to load the image
        // This is important, because you should not miss corrupted or unsupported images
        if (!$im) {
          die('Base64 value is not a valid image');
        }
        
        // Specify the location where you want to save the image
        
        		$destinationPath='public/pictures';
        		$extention = "png";
        		$fileName=round(microtime(true)).".".$extention;
        		
        			$photo=$fileName;
        			$destination = "pictures/";
        			$target_file = $destination. $photo;
        	        $img_file="public/pictures/".$fileName;
        	
        //$img_file = '/files/images/filename.png';
        
        // Save the GD resource as PNG in the best possible quality (no compression)
        // This will strip any metadata or invalid contents (including, the PHP backdoor)
        // To block any possible exploits, consider increasing the compression level
        imagepng($im, $img_file, 0);
        return $target_file;
    }
    
    //Deposit Process API's
    public function getDepositInfo(Request $request)
    {
        if(isset($request['phone']) && !empty($request['phone']))
		{
    	    
	        $phone = $request['phone'];
	        //$otp = $request['otp'];
	        $checkout_st = 1;
	        $deposit_st = 0;
	        
	        /*if($otp)
	        {
	            $users = DB::select('select * from KOS_Orders where user_phone = ? AND OTP_user = ? AND checkout_st = ? AND complete_deposit_st = ?', [$phone,$otp,$checkout_st,$deposit_st]);
	        }
	        else
	        {
	            $users = DB::select('select * from KOS_Orders where user_phone = ? AND checkout_st = ? AND complete_deposit_st = ?', [$phone,$checkout_st,$deposit_st]);
	        }*/
		    
		    $users = DB::select('select * from KOS_Orders where user_phone = ? AND checkout_st = ? AND complete_deposit_st = ?', [$phone,$checkout_st,$deposit_st]);
		    //$users = DB::select('select * from KOS_Orders where user_phone = ? AND checkout_st = ? ', [$phone,$checkout_st]);
			if($users)
			{
			    foreach ($users as $key)
				{
					$custom_id      =  $key->customer_id;
					$deal_id      =  $key->order_id;
				
				    $usorder = DB::select('select * from Deal_Customer where deal_id = ? ', [$deal_id]);
					if($usorder)
					{
					    foreach ($usorder as $key2)
						{
						    $key->fname = $key2->fname;
						    $key->lname = $key2->lname;
						}
					}
					else
					{
				    	$key->fname = null;
					    $key->lname = null;
					}
					
					$usimage = DB::select('select * from inspection_pictures where deal_id = ? AND side_name !="signature" ', [$deal_id]);
					if($usimage)
					{
				        $key->Inspection_images = $usimage;
					}
				}
			    return response()->json(['status'=>'success','data'=>$users]); 
			}
			else
			{
		        return response()->json(['status'=>'failed','error'=>'No information found.']); 
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function viewAllDepositInfo(Request $request)
    {
        $complete_st = 1;
        $deposit_st = 0;
        
        $users = DB::select('select * from KOS_Orders where complete_st = ? AND complete_deposit_st = ?', [$complete_st,$deposit_st]);
		if($users)
		{
		    foreach ($users as $key)
			{
				$custom_id      =  $key->customer_id;
				$deal_id      =  $key->order_id;
				
				$usorder = DB::select('select * from Deal_Customer where deal_id = ? ', [$deal_id]);
				if($usorder)
				{
				    foreach ($usorder as $key2)
					{
					    $key->fname = $key2->fname;
					    $key->lname = $key2->lname;
					}
				}
				else
				{
			    	$key->fname = null;
				    $key->lname = null;
				}
			}
		    return response()->json(['status'=>'success','data'=>$users]); 
		}
		else
		{
	        return response()->json(['status'=>'failed','error'=>'No information found.']); 
		}
    }
    
    public function submitdeposit(Request $request)
    { 
	    if(isset($request['order_id']) && !empty($request['order_id']))
		{
		    $order_id = $request['order_id'];
	        $damage_amount = $request['damage_amount'];
	        $damage_amount_paid = $request['damage_amount_paid'];
		    $damage_charged_by = $request['damage_charged_by'];
		    $damage_payment_types = $request['damage_payment_types'];
		    $damage_balance = $request['damage_balance'];
		    $damage_no = $request['damage_no'];
		   
		   
            if(isset($request['deposit_signature_pic']) && !empty($request['deposit_signature_pic']))
		    {
		            $count = mt_rand(100000, 999999);
				    $request->file('deposit_signature_pic');
        			$destinationPath='public/pictures';
        			$file=$request->deposit_signature_pic;
        			$extention=$request->deposit_signature_pic->extension();
        			//$extention=$file->getClientOriginalExtention();
        			$fileName=round(microtime(true)).$count.".".$extention;
        			$file->move($destinationPath,$fileName);
        			$deposit_signature_pic=$fileName;
        			$destination = "pictures/";
        			$target_file = $destination. $deposit_signature_pic;
	        }
		    else 
		    {
		        $target_file = null;
		    }
		    
		    if(isset($request['deposit_license_pic']) && !empty($request['deposit_license_pic']))
		    {
		        $count = mt_rand(100000, 999999);
		        $request->file('deposit_license_pic');
    			$destinationPath='public/pictures';
    			$file=$request->deposit_license_pic;
    			$extention=$request->deposit_license_pic->extension();
    			//$extention=$file->getClientOriginalExtention();
    			$fileName=round(microtime(true)).$count.".".$extention;
    			$file->move($destinationPath,$fileName);
    			$deposit_license_pic=$fileName;
    			$destination = "pictures/";
    			$target_file2 = $destination. $deposit_license_pic;
	        }
		    else 
		    {
		        $target_file2 = null;
		    }
		    
		    if(isset($request['deposit_parent_card']) && !empty($request['deposit_parent_card']))
		    {
		        $count = mt_rand(100000, 999999);
		        $request->file('deposit_parent_card');
    			$destinationPath='public/pictures';
    			$file=$request->deposit_parent_card;
    			$extention=$request->deposit_parent_card->extension();
    			//$extention=$file->getClientOriginalExtention();
    			$fileName=round(microtime(true)).$count.".".$extention;
    			$file->move($destinationPath,$fileName);
    			$deposit_parent_card=$fileName;
    			$destination = "pictures/";
    			$target_file3 = $destination. $deposit_parent_card;
	        }
		    else 
		    {
		        $target_file3 = null;
		    }
		    
		    if(isset($request['deposit_parent_license']) && !empty($request['deposit_parent_license']))
		    {
		        $count = mt_rand(100000, 999999);
		        $request->file('deposit_parent_license');
    			$destinationPath='public/pictures';
    			$file=$request->deposit_parent_license;
    			$extention=$request->deposit_parent_license->extension();
    			//$extention=$file->getClientOriginalExtention();
    			$fileName=round(microtime(true)).$count.".".$extention;
    			$file->move($destinationPath,$fileName);
    			$deposit_parent_license=$fileName;
    			$destination = "pictures/";
    			$target_file4 = $destination. $deposit_parent_license;
	        }
		    else 
		    {
		        $target_file4 = null;
		    }
		    
		    if(isset($request['deposit_parent_signature']) && !empty($request['deposit_parent_signature']))
		    {
		        $count = mt_rand(100000, 999999);
		        $request->file('deposit_parent_signature');
    			$destinationPath='public/pictures';
    			$file=$request->deposit_parent_signature;
    			$extention=$request->deposit_parent_signature->extension();
    			//$extention=$file->getClientOriginalExtention();
    			$fileName=round(microtime(true)).$count.".".$extention;
    			$file->move($destinationPath,$fileName);
    			$deposit_parent_signature=$fileName;
    			$destination = "pictures/";
    			$target_file5 = $destination. $deposit_parent_signature;
	        }
		    else 
		    {
		        $target_file5 = null;
		    }
		   
		    try 
			{ 
			    $inserteed = DB::update('update KOS_Orders SET deposit_parent_card = ?, deposit_parent_license = ?, deposit_parent_signature = ?, deposit_signature_pic = ?, deposit_license_pic = ?, damage_amount = ?, damage_amount_paid = ? , damage_charged_by = ? , damage_payment_types = ? , damage_balance = ? , damage_no = ? where order_id = ?', [$target_file3,$target_file4,$target_file5,$target_file,$target_file2,$damage_amount,$damage_amount_paid,$damage_charged_by,$damage_payment_types,$damage_balance,$damage_no,$order_id]);
				
	            if($inserteed)
                {
                    $complete_deposit_st = 1;
                    $inserteed = DB::update('update KOS_Orders SET complete_deposit_st = ? where order_id = ?', [$complete_deposit_st,$order_id]);
				
    	            if($inserteed)
                    {
                        return response()->json(['status'=>'success']);
                    }
                    else 
     				{
     				    return response()->json(['status'=>'failed','error'=>'Sql Error123']);
     				}  
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error321']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Sql Error2']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function VerifyDamageNo (Request $request)
    { 
        if(isset($request['damage_no']) && !empty($request['damage_no'])) 
    	{
    	    $damage_no = $request['damage_no'];
    	    
            $users_p = DB::select('select * from KOS_Orders where damage_no = ?', [$damage_no]);
            if($users_p)
            {
                return response()->json(['status'=>'failed','error'=>'Already Exist']);
            }
            else
            {
                return response()->json(['status'=>'success']); 
            }
    	}
    	else 
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
      
    public function VerifyEmail (Request $request)
    { 
	    if(isset($request['email']) && !empty($request['email']))
		{
    	    
		        $email = $request['email'];
			    $type = "parent";
			    
			    $users = DB::select('select * from customer where email = ? AND type = ? ', [$email, $type]);
				if($users)
				{
			        return response()->json(['status'=>'failed','error'=>'Email Already Exits']);
				}
				else
				{
			        return response()->json(['status'=>'success']); 
				}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function VerifyLicenseNo (Request $request)
    { 
	    if(isset($request['license_no']) && !empty($request['license_no']))
		{
    	    
		        $license_no = $request['license_no'];
			    $type = "parent";
			    
			    $users = DB::select('select * from customer where license_no = ? AND type = ? ', [$license_no, $type]);
				if($users)
				{
				    foreach ($users as $key)
					{
						$custom_id      =  $key->customer_id;
						$complete_st = 1;
						
						$usorder = DB::select('select * from KOS_Orders where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$custom_id,$complete_st]);
    					if($usorder)
    					{
    					    foreach ($usorder as $key2)
    						{
    						    $status = $key2->complete_st;
    						    
    						    if( $status == $complete_st )
    						    {
        					        return response()->json(['status'=>'success']);
    						    }
    						    else
    						    {
    						        return response()->json(['status'=>'failed','error'=>'You already have an Active Deal. Finish it first.']);
    						    }
    						}
    					}
    					else
    					{
    				    	return response()->json(['status'=>'failed','error'=>'Error']);
    					}
					}
				}
				else
				{
			        return response()->json(['status'=>'success']); 
				}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function CustomerSignup (Request $request)
    { 
	    if(isset($request['dob']) && !empty($request['dob']) 
		AND isset($request['fname']) && !empty($request['fname'])
		AND isset($request['lname']) && !empty($request['lname'])
		AND isset($request['phone']) && !empty($request['phone'])
		AND isset($request['email']) && !empty($request['email']))
		{
		        $deal_id = $request['deal_id'];
    	        $dob =$request['dob'];
    	        $fname =$request['fname'];
    	        $lname = $request['lname'];
    	        $phone = $request['phone'];
			    $email = $request['email'];
			    $child_email = $request['child_email'];
			    $pic_type = $request['pic_type'];
			    $password_w=$request['password'];
			    $children=$request['children'];
	            $password =md5($password_w);
			    $gender = $request['gender'];
			    $age = $request['age'];
			    $add1 = $request['add1'];
			    $add2 = $request['add2'];
			    $country = $request['country'];
			    $state = $request['state'];
			    $city = $request['city'];
			    $zipcode = $request['zipcode'];
			    $type = $request['type'];
			    $license_no = $request['license_no'];
			    $license_exp_date = $request['license_exp_date'];
			    $room_no = $request['room_no'];
			    $insurance_cmp = $request['insurance_cmp'];
			    $insurance_no = $request['insurance_no'];
			    $signup_timestamp = $request['signup_timestamp'];
		        
			    $customer_id= mt_rand(100000, 999999);
			   
			    function addItems($phone11,$option_details11,$deal_id)
				{
					$type = "child";
				
					$data = json_decode($option_details11);
					
					foreach ($data as $key)
					{
						$fname11      =  $key->fname;
						$lname11      =  $key->lname;
						$dob11      =  $key->dob;
						$gender11      =  $key->gender;
						$email11      =  $key->email;
						$age45      =  $key->age;
						$license_no11 = $key->license_no;
			            $license_exp_date11 = $key->license_exp_date;
			            $state33 = $key->state;
			            $phone33 = $key->phone;
			            $insurance_cmp33 = $key->insurance_cmp;
			            $insurance_no33 = $key->insurance_no;
			            $child_email33 = $key->child_email;
			            
			            if( $phone33 != 'nil')
			            {
			                $phone11 = $phone33;
			            }
			    
						$customer_id= mt_rand(100000, 999999);
						
						try 
						{ 
						    $inserteed = DB::insert('insert into customer (customer_id,dob,fname,lname,phone,email,gender,type,age,license_no,license_exp_date,state,insurance_cmp,insurance_no,child_email) 
    					    values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$customer_id,$dob11,$fname11,$lname11,$phone11,$email11,$gender11,$type,$age45,$license_no11,$license_exp_date11,$state33,$insurance_cmp33,$insurance_no33,$child_email33]);
    					
							if($inserteed)
							{
							    if( $deal_id == "nil")
							    {
							        $ff=1;
							    }
							    else
							    {
    							    $inserteed2 = DB::insert('insert into Deal_Customer (deal_id,dob,fname,lname,phone,email,gender,type,age,license_no,license_exp_date,state,insurance_cmp,insurance_no,child_email) 
        					        values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$deal_id,$dob11,$fname11,$lname11,$phone11,$email11,$gender11,$type,$age45,$license_no11,$license_exp_date11,$state33,$insurance_cmp33,$insurance_no33,$child_email33]);
    							
        							if($inserteed2)
        							{
        							    $ff=1;
        							}
        							else
        							{
        							    $ff=0;
        							}
							    }
							}
							else
							{
							    $ff=0;
							}
						} 
						catch(\Illuminate\Database\QueryException $ex)
						{ 		
							$ff = 0;
						}												
					}
					return $ff;
				}
					
			    if(isset($request['photo']) && !empty($request['photo']))
			    {
			            $count = mt_rand(100000, 999999);
			        	if ($pic_type == "b64")
        				{
        				    $b64 =$request['photo'];
                           
                            $bin = base64_decode($b64);
                           
                            $im = imageCreateFromString($bin);
                          
                            if (!$im) 
                            {
                              die('Base64 value is not a valid image');
                            }
                            
                    		$destinationPath='public/pictures';
                    		$extention = "png";
                    		$fileName=round(microtime(true)).$count.".".$extention;
                    		
                			$photo=$fileName;
                			$destination = "pictures/";
                			$target_file = $destination. $photo;
                	        $img_file="public/pictures/".$fileName;
                            imagepng($im, $img_file, 0);
                            //return $target_file;
        				}
        				else 
        				{
        				    $request->file('photo');
                			$destinationPath='public/pictures';
                			$file=$request->photo;
                			$extention=$request->photo->extension();
                			//$extention=$file->getClientOriginalExtention();
                			$fileName=round(microtime(true)).$count.".".$extention;
                			$file->move($destinationPath,$fileName);
                			$photo=$fileName;
                			$destination = "pictures/";
                			$target_file = $destination. $photo;
        				}
		        }
			    else 
			    {
			        $target_file = null;
			    }
			    
			    if(isset($request['customer_img']) && !empty($request['customer_img']))
			    {
			        $count = mt_rand(100000, 999999);
			        $request->file('customer_img');
        			$destinationPath='public/pictures';
        			$file=$request->customer_img;
        			$extention=$request->customer_img->extension();
        			//$extention=$file->getClientOriginalExtention();
        			$fileName=round(microtime(true)).$count.".".$extention;
        			$file->move($destinationPath,$fileName);
        			$customer_img=$fileName;
        			$destination = "pictures/";
        			$target_file2 = $destination. $customer_img;
		        }
			    else 
			    {
			        $target_file2 = null;
			    }
			    
			    if(isset($request['driving_license_img']) && !empty($request['driving_license_img']))
			    {
			        $count = mt_rand(100000, 999999);
			        $request->file('driving_license_img');
        			$destinationPath='public/pictures';
        			$file=$request->driving_license_img;
        			$extention=$request->driving_license_img->extension();
        			//$extention=$file->getClientOriginalExtention();
        			$fileName=round(microtime(true)).$count.".".$extention;
        			$file->move($destinationPath,$fileName);
        			$driving_license_img=$fileName;
        			$destination = "pictures/";
        			$target_file3 = $destination. $driving_license_img;
		        }
			    else 
			    {
			        $target_file3 = null;
			    }
			    
			    if( $type != "single child")
			    {
    			    $users = DB::select('select * from customer where email = ?', [$email]);
    				if($users)
    				{
    				     return response()->json(['status'=>'failed','error'=>'Email Already Exits']);
    				}
    				else 
    				{
        				try 
    					{ 
    				        $inserteed = DB::insert('insert into customer (signup_timestamp,customer_id,dob,fname,lname,phone,signature,email,child_email,password,gender,age,add1,add2,country,state,city,zipcode,type,license_no,license_exp_date,room_no,insurance_cmp,insurance_no,customer_img,driving_license_img) 
        					values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$signup_timestamp,$customer_id,$dob,$fname,$lname,$phone,$target_file,$email,$child_email,$password,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$type,$license_no,$license_exp_date,$room_no,$insurance_cmp,$insurance_no,$target_file2,$target_file3]);
        					
        		            if($inserteed)
                            {
                                if( $deal_id == "nil")
                                {
                                    if(isset($request['children']) && !empty($request['children']))
                                    {
                                        if(addItems($phone,$children,$deal_id)==1)
    									{
    									    return response()->json(['status'=>'success','customer_id'=>$customer_id]);  
    									}
    									else 
    									{
    										return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
    									}
                                    }
                                    else 
                                    {
                                        return response()->json(['status'=>'success','customer_id'=>$customer_id]);  
                                    }
                                }
                                else
                                {
                                    $inserteed2 = DB::insert('insert into Deal_Customer (signup_timestamp,deal_id,dob,fname,lname,phone,signature,email,child_email,password,gender,age,add1,add2,country,state,city,zipcode,type,license_no,license_exp_date,room_no,insurance_cmp,insurance_no,customer_img,driving_license_img) 
            					    values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$signup_timestamp,$deal_id,$dob,$fname,$lname,$phone,$target_file,$email,$child_email,$password,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$type,$license_no,$license_exp_date,$room_no,$insurance_cmp,$insurance_no,$target_file2,$target_file3]);
                                    
                                    if($inserteed2)
                                    {
                                        if(isset($request['children']) && !empty($request['children']))
                                        {
                                            if(addItems($phone,$children,$deal_id)==1)
        									{
        									    return response()->json(['status'=>'success','customer_id'=>$customer_id]);  
        									}
        									else 
        									{
        										return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
        									}
                                        }
                                        else 
                                        {
                                            return response()->json(['status'=>'success','customer_id'=>$customer_id]);  
                                        }
                                    }
                                    else 
                 					{
                 				    	return response()->json(['status'=>'failed','error'=>'Sql Error']);
                 					}
                                }
                            }
                            else 
         					{
         				    	return response()->json(['status'=>'failed','error'=>'Sql Error']);
         					}
    					} 
    					catch(\Illuminate\Database\QueryException $ex)
    					{ 		
    						$ff = 0;
    					}
    				}
			    }
			    else
			    {
			        try 
					{ 
				        $inserteed = DB::insert('insert into customer (signup_timestamp,customer_id,dob,fname,lname,phone,signature,email,child_email,password,gender,age,add1,add2,country,state,city,zipcode,type,license_no,license_exp_date,room_no,insurance_cmp,insurance_no,customer_img,driving_license_img) 
        					values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$signup_timestamp,$customer_id,$dob,$fname,$lname,$phone,$target_file,$email,$child_email,$password,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$type,$license_no,$license_exp_date,$room_no,$insurance_cmp,$insurance_no,$target_file2,$target_file3]);
        					
    		            if($inserteed)
                        {
                            
                             $inserteed3 = DB::insert('insert into customer (signup_timestamp,deal_id,dob,fname,lname,phone,signature,email,child_email,password,gender,age,add1,add2,country,state,city,zipcode,type,license_no,license_exp_date,room_no,insurance_cmp,insurance_no,customer_img,driving_license_img) 
        					values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$signup_timestamp,$deal_id,$dob,$fname,$lname,$phone,$target_file,$email,$child_email,$password,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$type,$license_no,$license_exp_date,$room_no,$insurance_cmp,$insurance_no,$target_file2,$target_file3]);
                            if($inserteed3)
                            {
                            if(isset($request['children']) && !empty($request['children']))
                            {
                                if(addItems($phone,$children)==1)
								{
								    return response()->json(['status'=>'success','customer_id'=>$customer_id]);  
								}
								else 
								{
									return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
								}
                            }
                            else 
                            {
                                return response()->json(['status'=>'success','customer_id'=>$customer_id]);     
                            }
                        }
                        else 
     					{
     					    return response()->json(['status'=>'failed','error'=>'Sql Error']);
     					}  
}
					} 
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						$ff = 0;
					}
			    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters11']);
    	}
    }
      
    /*public function CustomerSignup (Request $request)
    { 
	    if(isset($request['dob']) && !empty($request['dob'])  
		AND isset($request['fname']) && !empty($request['fname'])
		AND isset($request['lname']) && !empty($request['lname'])
		AND isset($request['phone']) && !empty($request['phone'])
	
		AND isset($request['email']) && !empty($request['email']))
		{       
		        $password_w=$request['password'];
		        $cust_deal= $_POST['deal_id'];
		        $email = $request['customer_email'];
		        $phone = $request['customer_phone'];
    	        $fname =$request['fname'];
    	        $lname = $request['lname'];
    	        $dob =$request['dob'];
    	        $age = $request['age'];
    	        $add1 = $request['hotel_name'];
    	        $add2 = $request['hotel_room_no'];
    	        $insurance_cmp = $request['car_insurance_comp'];
    	        $insurance_no = $request['policy_no'];
    	        $state = $request['state'];
			    $city = $request['city'];
			    $zipcode = $request['zipcode'];
    	        
    	        
			    
			    $child_email = $request['child_email'];
			    $pic_type = $request['pic_type'];
			   
			    
			    $children=$request['children'];
	            $password =md5($password_w);
			    $gender = $request['gender'];
			    
			    $country = $request['country'];
			    
			    $type = $request['type'];
			    $license_no = $request['dl_no'];
			    $license_exp_date = $request['license_exp_date'];
			    
			    
			    $signup_timestamp = $request['signup_timestamp'];
		        
			    $customer_id= mt_rand(100000, 999999);
			   
			    function addItems($phone11,$option_details11)
				{
					$type = "child";
				
					$data = json_decode($option_details11);
					
					foreach ($data as $key)
					{
						$fname11      =  $key->fname;
						$lname11      =  $key->lname;
						$dob11      =  $key->dob;
						$gender11      =  $key->gender;
						$email11      =  $key->email;
						$age45      =  $key->age;
						$license_no11 = $key->license_no;
			            $license_exp_date11 = $key->license_exp_date;
			            $state33 = $key->state;
			            $phone33 = $key->phone;
			            $insurance_cmp33 = $key->insurance_cmp;
			            $insurance_no33 = $key->insurance_no;
			            $child_email33 = $key->child_email;
			            
			            if( $phone33 != 'nil')
			            {
			                $phone11 = $phone33;
			            }
			    
						$customer_id= mt_rand(100000, 999999);
						
						try 
						{ 
						    $inserteed = DB::insert('insert into customer (customer_id,dob,fname,lname,phone,email,gender,type,age,license_no,license_exp_date,state,insurance_cmp,insurance_no,child_email) 
    					    values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$customer_id,$dob11,$fname11,$lname11,$phone11,$email11,$gender11,$type,$age45,$license_no11,$license_exp_date11,$state33,$insurance_cmp33,$insurance_no33,$child_email33]);
    					
							if($inserteed)
							{
								$ff = 1;
							}
							else 
							{
								$ff = 0;
							}		
						} 
						catch(\Illuminate\Database\QueryException $ex)
						{ 		
							$ff = 0;
						}												
					}
					return $ff;
				}
					
			    if(isset($request['photo']) && !empty($request['photo']))
			    {
			            $count = mt_rand(100000, 999999);
			        	if ($pic_type == "b64")
        				{
        				    $b64 =$request['photo'];
                           
                            $bin = base64_decode($b64);
                           
                            $im = imageCreateFromString($bin);
                          
                            if (!$im) 
                            {
                              die('Base64 value is not a valid image');
                            }
                            
                    		$destinationPath='public/pictures';
                    		$extention = "png";
                    		$fileName=round(microtime(true)).$count.".".$extention;
                    		
                			$photo=$fileName;
                			$destination = "pictures/";
                			$target_file = $destination. $photo;
                	        $img_file="public/pictures/".$fileName;
                            imagepng($im, $img_file, 0);
                            //return $target_file;
        				}
        				else 
        				{
        				    $request->file('photo');
                			$destinationPath='public/pictures';
                			$file=$request->photo;
                			$extention=$request->photo->extension();
                			//$extention=$file->getClientOriginalExtention();
                			$fileName=round(microtime(true)).$count.".".$extention;
                			$file->move($destinationPath,$fileName);
                			$photo=$fileName;
                			$destination = "pictures/";
                			$target_file = $destination. $photo;
        				}
		        }
			    else 
			    {
			        $target_file = null;
			    }
			    
			    if(isset($request['customer_img']) && !empty($request['customer_img']))
			    {
			        $count = mt_rand(100000, 999999);
			        $request->file('customer_img');
        			$destinationPath='public/pictures';
        			$file=$request->customer_img;
        			$extention=$request->customer_img->extension();
        			//$extention=$file->getClientOriginalExtention();
        			$fileName=round(microtime(true)).$count.".".$extention;
        			$file->move($destinationPath,$fileName);
        			$customer_img=$fileName;
        			$destination = "pictures/";
        			$target_file2 = $destination. $customer_img;
		        }
			    else 
			    {
			        $target_file2 = null;
			    }
			    
			    if(isset($request['driving_license_img']) && !empty($request['driving_license_img']))
			    {
			        $count = mt_rand(100000, 999999);
			        $request->file('driving_license_img');
        			$destinationPath='public/pictures';
        			$file=$request->driving_license_img;
        			$extention=$request->driving_license_img->extension();
        			//$extention=$file->getClientOriginalExtention();
        			$fileName=round(microtime(true)).$count.".".$extention;
        			$file->move($destinationPath,$fileName);
        			$driving_license_img=$fileName;
        			$destination = "pictures/";
        			$target_file3 = $destination. $driving_license_img;
		        }
			    else 
			    {
			        $target_file3 = null;
			    }
			    
			    if( $type != "single child")
			    {
    			    $users = DB::select('select * from customer where email = ?', [$email]);
    				if($users)
    				{
    				     return response()->json(['status'=>'failed','error'=>'Email Already Exits']);
    				}
    				else 
    				{
        				try 
    					{ 
    				        $inserteed = DB::insert('insert into customer (signup_timestamp,customer_id,dob,fname,lname,phone,signature,email,child_email,password,gender,age,add1,add2,country,state,city,zipcode,type,license_no,license_exp_date,room_no,insurance_cmp,insurance_no,customer_img,driving_license_img) 
        					values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$signup_timestamp,$customer_id,$dob,$fname,$lname,$phone,$target_file,$email,$child_email,$password,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$type,$license_no,$license_exp_date,$room_no,$insurance_cmp,$insurance_no,$target_file2,$target_file3]);
        					
        		            if($inserteed)
                            {
                                if(isset($request['children']) && !empty($request['children']))
                                {
                                    if(addItems($phone,$children)==1)
									{
									    return response()->json(['status'=>'success','customer_id'=>$customer_id]);  
									}
									else 
									{
										return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
									}
                                }
                                else 
                                {
                                    return response()->json(['status'=>'success','customer_id'=>$customer_id]);  
                                }
                            }
                            else 
         					{
         				    	return response()->json(['status'=>'failed','error'=>'Sql Error']);
         					}
    					} 
    					catch(\Illuminate\Database\QueryException $ex)
    					{ 		
    						$ff = 0;
    					}
    				}
			    }
			    else
			    {
			        try 
					{ 
				        $inserteed = DB::insert('insert into customer (signup_timestamp,customer_id,dob,fname,lname,phone,signature,email,child_email,password,gender,age,add1,add2,country,state,city,zipcode,type,license_no,license_exp_date,room_no,insurance_cmp,insurance_no,customer_img,driving_license_img) 
        					values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$signup_timestamp,$customer_id,$dob,$fname,$lname,$phone,$target_file,$email,$child_email,$password,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$type,$license_no,$license_exp_date,$room_no,$insurance_cmp,$insurance_no,$target_file2,$target_file3]);
        					
    		            if($inserteed)
                        {
                            if(isset($request['children']) && !empty($request['children']))
                            {
                                if(addItems($phone,$children)==1)
								{
								    return response()->json(['status'=>'success','customer_id'=>$customer_id]);  
								}
								else 
								{
									return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
								}
                            }
                            else 
                            {
                                return response()->json(['status'=>'success','customer_id'=>$customer_id]);     
                            }
                        }
                        else 
     					{
     					    return response()->json(['status'=>'failed','error'=>'Sql Error']);
     					}  
					
					} 
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						$ff = 0;
					}
			    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }*/
    
    public function EditCustomerProfile (Request $request)
    { 
	    if(isset($request['dob']) && !empty($request['dob']) 
		AND isset($request['fname']) && !empty($request['fname'])
		AND isset($request['lname']) && !empty($request['lname'])
		AND isset($request['phone']) && !empty($request['phone'])
		AND isset($request['email']) && !empty($request['email']))
		{
		    $deal_id = $request['deal_id'];
            $dob =$request['dob'];
            $fname =$request['fname'];
            $lname = $request['lname'];
            $phone = $request['phone'];
            $email = $request['email'];
            $child_email = $request['child_email'];
            $password_w=$request['password'];
            $children=$request['children'];
            $password =md5($password_w);
            $gender = $request['gender'];
            $age = $request['age'];
            $add1 = $request['add1'];
            $add2 = $request['add2'];
            $country = $request['country'];
            $state = $request['state'];
            $city = $request['city'];
            $zipcode = $request['zipcode'];
            $type = $request['type'];
            $customer_id = $request['customer_id'];
            $license_no = $request['license_no'];
            $license_exp_date = $request['license_exp_date'];
            $room_no = $request['room_no'];
            $insurance_cmp = $request['insurance_cmp'];
            $insurance_no = $request['insurance_no'];
            $pic_type = $request['pic_type'];
            $signup_timestamp = $request['signup_timestamp'];
			   
			   
		    function addItems($phone11,$option_details11,$deal_id)
			{
				$type = "child";
				//echo "hre";
			
				$data = json_decode($option_details11);
				
				
				foreach ($data as $key)
				{
					$fname11      =  $key->fname;
					//echo "ye lo".$fname11;
					$lname11      =  $key->lname;
					$dob11      =  $key->dob;
					$gender11      =  $key->gender;
					$email11      =  $key->email;
					$customer_id      =  $key->customer_id;
					$age45      =  $key->age;
					$license_no11 = $key->license_no;
		            $license_exp_date11 = $key->license_exp_date;
		            $phone33 = $key->phone;
		            $state33 = $key->state;
		            $insurance_cmp33 = $key->insurance_cmp;
		            $insurance_no33 = $key->insurance_no;
		            $child_email33 = $key->child_email;
		            
		            //echo $fname11." ".$lname11." ".$dob11." ".$gender11." ".$email11." ".$customer_id." ".$age45." ".$license_no11." ".$license_exp_date11." ".$phone33." ".$state33." ".$insurance_cmp33." ".$insurance_no33." ".$child_email33;
		            
		            if( $phone33 != 'nil')
		            {
		                $phone11 = $phone33;
		            }
					
				    if ($customer_id == "nil")
				    {
				        $customer_id= mt_rand(100000, 999999);
						try 
						{ 
						    $inserteed = DB::insert('insert into customer (customer_id,dob,fname,lname,phone,email,gender,type,age,license_no,license_exp_date,state,insurance_cmp,insurance_no,child_email) 
    					    values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$customer_id,$dob11,$fname11,$lname11,$phone11,$email11,$gender11,$type,$age45,$license_no11,$license_exp_date11,$state33,$insurance_cmp33,$insurance_no33,$child_email33]);
    					
							if($inserteed)
							{
							    if( $deal_id == "nil")
							    {
							        $ff=1;
							    }
							    else
							    {
    								$inserteed2 = DB::insert('insert into Deal_Customer (deal_id,dob,fname,lname,phone,email,gender,type,age,license_no,license_exp_date,state,insurance_cmp,insurance_no,child_email) 
        					        values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$deal_id,$dob11,$fname11,$lname11,$phone11,$email11,$gender11,$type,$age45,$license_no11,$license_exp_date11,$state33,$insurance_cmp33,$insurance_no33,$child_email33]);
    							
        							if($inserteed2)
        							{
        							    $ff=1;
        							}
        							else
        							{
        							    $ff=0;
        							}
							    }
							}
							else
							{
							    $ff=0;
							}
						} 
						catch(\Illuminate\Database\QueryException $ex)
						{ 		
							$ff = 0;
						}
				    }
				    else 
				    {
			        	try 
						{ 
						    $inserteed = DB::update('update customer SET insurance_cmp = ?, insurance_no = ?, child_email = ?, state = ? , license_no = ? , license_exp_date = ? , age = ? , phone = ? , dob = ? , fname = ? ,lname = ? ,gender = ?  where customer_id= ?', [$insurance_cmp33,$insurance_no33,$child_email33,$state33,$license_no11,$license_exp_date11,$age45,$phone11,$dob11,$fname11,$lname11,$gender11,$customer_id]);
							if($inserteed)
							{
							    if( $deal_id == "nil")
							    {
							        $ff=1;
							    }
							    else
							    {
    								$inserteed2 = DB::insert('insert into Deal_Customer (deal_id,dob,fname,lname,phone,email,gender,type,age,license_no,license_exp_date,state,insurance_cmp,insurance_no,child_email) 
        					        values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$deal_id,$dob11,$fname11,$lname11,$phone11,$email11,$gender11,$type,$age45,$license_no11,$license_exp_date11,$state33,$insurance_cmp33,$insurance_no33,$child_email33]);
    							
        							if($inserteed2)
        							{
        							    $ff=1;
        							}
        							else
        							{
        							    $ff=0;
        							}
							    }
							}
							else 
							{
								$ff = 0;
							}		
						} 
						catch(\Illuminate\Database\QueryException $ex)
						{ 		
							$ff = 0;
						}
				    }
				}
				
				return $ff;
			}
			 
			$users = DB::select('select * from customer where email = ?', [$email]);
			if($users)
			{
				try 
				{ 
			        if(isset($request['photo']) && !empty($request['photo']))
    			    {
    			        $count = mt_rand(100000, 999999);
    			        if ($pic_type == "b64")
        				{
        				    $b64 =$request['photo'];
                           
                            $bin = base64_decode($b64);
                           
                            $im = imageCreateFromString($bin);
                          
                            if (!$im) 
                            {
                              die('Base64 value is not a valid image');
                            }
                            
                    		$destinationPath='public/pictures';
                    		$extention = "png";
                    		$fileName=round(microtime(true)).$count.".".$extention;
                    		
                			$photo=$fileName;
                			$destination = "pictures/";
                			$target_file = $destination. $photo;
                	        $img_file="public/pictures/".$fileName;
                            imagepng($im, $img_file, 0);
                            //return $target_file;
        				}
        				else 
        				{
        				    
        				    $request->file('photo');
                			$destinationPath='public/pictures';
                			$file=$request->photo;
                			$extention=$request->photo->extension();
                			//$extention=$file->getClientOriginalExtention();
                			$fileName=round(microtime(true)).$count.".".$extention;
                			$file->move($destinationPath,$fileName);
                			$photo=$fileName;
                			$destination = "pictures/";
                			$target_file = $destination. $photo;
        				}
    			   }
    			    else 
    			    {
    			        $target_file = null;
    			    }
        			   
        			if(isset($request['customer_img']) && !empty($request['customer_img']))
    			    {
    			        $count = mt_rand(100000, 999999);
    			        
    			        $request->file('customer_img');
            			$destinationPath='public/pictures';
            			$file=$request->customer_img;
            			$extention=$request->customer_img->extension();
            			//$extention=$file->getClientOriginalExtention();
            			$fileName=round(microtime(true)).$count.".".$extention;
            			$file->move($destinationPath,$fileName);
            			$customer_img=$fileName;
            			$destination = "pictures/";
            			$target_file2 = $destination. $customer_img;
    		        }
    			    else 
    			    {
    			        $target_file2 = null;
    			    }
    			    
    			    if(isset($request['driving_license_img']) && !empty($request['driving_license_img']))
    			    {
    			        $count = mt_rand(100000, 999999);
    			        
    			        $request->file('driving_license_img');
            			$destinationPath='public/pictures';
            			$file=$request->driving_license_img;
            			$extention=$request->driving_license_img->extension();
            			//$extention=$file->getClientOriginalExtention();
            			$fileName=round(microtime(true)).$count.".".$extention;
            			$file->move($destinationPath,$fileName);
            			$driving_license_img=$fileName;
            			$destination = "pictures/";
            			$target_file3 = $destination. $driving_license_img;
    		        }
    			    else 
    			    {
    			        $target_file3 = null;
    			    }
    			    
    			    
				    $user_new = DB::update('update customer SET customer_img = ?, driving_license_img = ?, insurance_cmp = ?, insurance_no = ?,  room_no=?, license_no=?, license_exp_date=?, signature= ? , dob = ? , fname = ? ,lname = ? ,phone = ? ,gender = ? ,age = ? , add1 = ? ,add2 = ?, country = ? ,state = ?, city = ? ,zipcode = ?   where customer_id= ?', [$target_file2,$target_file3,$insurance_cmp,$insurance_no,$room_no,$license_no,$license_exp_date,$target_file,$dob,$fname,$lname,$phone,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$customer_id]);
		            if($user_new)
                    {
                        if( $deal_id == "nil")
                        {
                            if(isset($request['children']) && !empty($request['children']))
                            {
                                if(addItems($phone,$children,$deal_id)==1)
    							{
    						        $users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
                					if($users)
                					{
                					    foreach ($users as $key)
                						{
                							$cusemail   = $key->email;
                							$childtype  = "child";
                							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
                        					if($userschild)
                        					{
                        					   $key->children = $userschild;
                        					}
                        					else
                        					{
                        				    	$key->children =null  ;
                        					}
                						}
                					    return response()->json(['status'=>'success','data'=>$users]);
                					}
                					else
                					{
                						return response()->json(['status'=>'failed','error'=>'Wrong Email']);
                					}
                    					
    								//return response()->json(['status'=>'success']);  
    							}
    							else 
    							{
    								return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
    							}
                            }
                            else 
                            {
                                $users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
                    			if($users)
            					{
            					    foreach ($users as $key)
            						{
            						    $cusemail   =  $key->email;
            							$childtype  = "child";
            							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
                    					if($userschild)
                    					{
                    					   $key->children = $userschild;
                    					}
                    					else
                    					{
                    				        $key->children=null;
                    					}
            						}
            					    return response()->json(['status'=>'success','data'=>$users]);
            					}
            					else
            					{
            						return response()->json(['status'=>'failed','error'=>'Wrong Email']);
            					}
                           }
                        }
                        else
                        {
                            $inserteed2 = DB::insert('insert into Deal_Customer (signup_timestamp,deal_id,dob,fname,lname,phone,signature,email,child_email,password,gender,age,add1,add2,country,state,city,zipcode,type,license_no,license_exp_date,room_no,insurance_cmp,insurance_no,customer_img,driving_license_img) 
            			    values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$signup_timestamp,$deal_id,$dob,$fname,$lname,$phone,$target_file,$email,$child_email,$password,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$type,$license_no,$license_exp_date,$room_no,$insurance_cmp,$insurance_no,$target_file2,$target_file3]);
                            
                            if($inserteed2)
                            {
                               if(isset($request['children']) && !empty($request['children']))
                               {
                                    if(addItems($phone,$children,$deal_id)==1)
        							{
        						        $users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
                    					if($users)
                    					{
                    					    foreach ($users as $key)
                    						{
                    							$cusemail   = $key->email;
                    							$childtype  = "child";
                    							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
                            					if($userschild)
                            					{
                            					   $key->children = $userschild;
                            					}
                            					else
                            					{
                            				    	$key->children =null  ;
                            					}
                    						}
                    					    return response()->json(['status'=>'success','data'=>$users]);
                    					}
                    					else
                    					{
                    						return response()->json(['status'=>'failed','error'=>'Wrong Email']);
                    					}
                        					
        								//return response()->json(['status'=>'success']);  
        							}
        							else 
        							{
        								return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
        							}
                               }
                               else 
                               {
                                    $users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
                        			if($users)
                					{
                					    foreach ($users as $key)
                						{
                						    $cusemail   =  $key->email;
                							$childtype  = "child";
                							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
                        					if($userschild)
                        					{
                        					   $key->children = $userschild;
                        					}
                        					else
                        					{
                        				        $key->children=null;
                        					}
                						}
                					    return response()->json(['status'=>'success','data'=>$users]);
                					}
                					else
                					{
                						return response()->json(['status'=>'failed','error'=>'Wrong Email']);
                					}
                               }
                            }
                            else
                            {
         				    	return response()->json(['status'=>'failed','error'=>'Sql Error']);
         					}
                        }
                    }
                    else 
 					{
 					    return response()->json(['status'=>'failed','error'=>'Sql Error123']);
 					}  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					$ff = 0;
				}	
			}
			else 
			{
			    return response()->json(['status'=>'failed','error'=>'Email not Exists']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function CustomerSignupOLD (Request $request)
    { 
	    if(isset($request['dob']) && !empty($request['dob']) 
		AND isset($request['fname']) && !empty($request['fname'])
		AND isset($request['lname']) && !empty($request['lname'])
		AND isset($request['phone']) && !empty($request['phone'])
		AND isset($request['photo']) && !empty($request['photo'])
		AND isset($request['email']) && !empty($request['email']))
		{
    	    
    	       $dob =$request['dob'];
    	       $fname =$request['fname'];
    	       $lname = $request['lname'];
    	       $phone = $request['phone'];
			   $email = $request['email'];
			   $customer_id= mt_rand(100000, 999999);
			   
			   $request->file('photo');
			 $destinationPath='public/pictures';
			 $file=$request->photo;
			 $extention=$request->photo->extension();
			//  $extention=$file->getClientOriginalExtention();
			 $fileName=round(microtime(true)).".".$extention;
			 $file->move($destinationPath,$fileName);
			 $photo=$fileName;
			 $destination = "pictures/";
			 $target_file = $destination. $photo;
			 
			 
			 $users = DB::select('select * from customer where email = ?', [$email]);
					if($users)
					{
					     return response()->json(['status'=>'failed','error'=>'Email Already Exits']);
					}
					else 
					{
					      try 
        				{ 
        				
        					$inserteed = DB::insert('insert into customer (customer_id,dob,fname,lname,phone,signature,email) 
        					values (?,?,?,?,?,?,?)',[$customer_id,$dob,$fname,$lname,$phone,$target_file,$email]);
        					
        					
        		           if($inserteed)
                              {
                                return response()->json(['status'=>'success']);
                              }
                            else 
         					{
         					return response()->json(['status'=>'failed','error'=>'Sql Error']);
         					}  
         					
         					
        				} 
        				catch(\Illuminate\Database\QueryException $ex)
        				{ 		
        					return response()->json(['status'=>'failed','error'=>'This account already exists']);
        				}
					    
					}
			   
			 
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
      
    public function CustomerSearch (Request $request)
    {
        $status = 0;
        $notVerified = "verified";
        
        
		if(isset($request['user_phone']) && !empty($request['user_phone'])) 
		{
		    $user_phone = $request['user_phone'];
		    $nullid = null;
		    
		    if( $user_phone == "All" )
		    {
		        $users = DB::select('select * from KOS_Orders where verification_status != ? AND customer_id IS NOT NULL', [$notVerified]);
		    }
		    else
		    {
		        $users = DB::select('select * from KOS_Orders where user_phone = ? AND verification_status != ? AND customer_id IS NOT NULL', [$user_phone,$notVerified]);
		    }
		    
			if($users)
			{
			    foreach ($users as $o4)
				{
				    $deal_id = $o4->order_id;
				    $childtype2  = "parent";
    				try 
        			{ 
                        $cust = DB::select('select * from Deal_Customer where deal_id = ? AND type = ?', [$deal_id,$childtype2]);
        				if($cust)
        				{
        				    foreach ($cust as $key)
        					{
        						$cusphone  =  $key->phone;
        						$cusemail  =  $key->email;
        						//$parent_id =  $key->customer_id;
        						
        						
        						$childtype ="child";
        						$userschild = DB::select('select * from Deal_Customer where deal_id = ? AND type = ? ', [$deal_id, $childtype]);
            					if($userschild)
            					{
            					    foreach ($userschild as $key21)
                					{
                						$cusphone       =  $key21->phone;
                					}
            					   $key->children = $userschild;
            					}
            					else
            					{
            				    	$key->children = null;
            					}
        					}
        					$o4->customer_details = $cust;
        				}
        				else
        				{
        					return response()->json(['status'=>'failed','error'=>'Please Try Again. Wrong phone number. ']);
        				}	
        				  
        			} 
        			catch(\Illuminate\Database\QueryException $ex)
        			{ 		
        				return response()->json(['status'=>'failed','error'=>'Sql Error']);
        			}
				}
				return response()->json(['status'=>'success','data'=>$users]);
			}
			else
			{
				return response()->json(['status'=>'failed','error'=>'Please Try Again. No information found. ']);
			}	
		    
		}
	    else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
		}
    }
    
    /*public function CustomerSearch25thMarch2022 (Request $request)
    {
        $status = 0;
        $notVerified = "verified";
        
        
		if(isset($request['user_phone']) && !empty($request['user_phone'])) 
		{
		    $user_phone = $request['user_phone'];
		    $nullid = null;
		    
		    if( $user_phone == "All" )
		    {
		        $users = DB::select('select * from KOS_Orders where verification_status != ? AND customer_id IS NOT NULL', [$notVerified]);
		    }
		    else
		    {
		        $users = DB::select('select * from KOS_Orders where user_phone = ? AND verification_status != ? AND customer_id IS NOT NULL', [$user_phone,$notVerified]);
		    }
		    
			if($users)
			{
			    foreach ($users as $o4)
				{
				    $deal_id = $o4->order_id;
				    $childtype2  = "parent";
    				try 
        			{ 
                        $cust = DB::select('select * from Deal_Customer where deal_id = ? AND type = ?', [$deal_id,$childtype2]);
        				if($cust)
        				{
        				    foreach ($cust as $key)
        					{
        						$cusphone  =  $key->phone;
        						$cusemail  =  $key->email;
        						//$parent_id =  $key->customer_id;
        						
        						
        						$childtype ="child";
        						$userschild = DB::select('select * from Deal_Customer where deal_id = ? AND type = ? ', [$deal_id, $childtype]);
            					if($userschild)
            					{
            					    foreach ($userschild as $key21)
                					{
                						$cusphone       =  $key21->phone;
                					}
            					   $key->children = $userschild;
            					}
            					else
            					{
            				    	$key->children = null;
            					}
        					}
        					$o4->customer_details = $cust;
        				}
        				else
        				{
        					return response()->json(['status'=>'failed','error'=>'Please Try Again. Wrong phone number. ']);
        				}	
        				  
        			} 
        			catch(\Illuminate\Database\QueryException $ex)
        			{ 		
        				return response()->json(['status'=>'failed','error'=>'Sql Error']);
        			}
				}
				return response()->json(['status'=>'success','data'=>$users]);
			}
			else
			{
				return response()->json(['status'=>'failed','error'=>'Please Try Again. No information found. ']);
			}	
		    
		}
	    else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
		}
    }*/
    
    public function ViewPhoneRequirement (Request $request)
	{ 
	    //$rt =1;
        $data23 = DB::select("select * from phone_requirement");
        
        if($data23)
        {
            return response()->json(['status'=>'success','data'=>$data23]);
	    }
	    else
	    {
	        return response()->json(['status'=>'failed','error'=>'Data Doesnt exists.']);
	    }
    }
    
    public function UpdatePhoneRequirement (Request $request)
	{ 
	    if(isset($request['pr_id']) && !empty($request['pr_id']))
		{
    	    $rt = $request['pr_id'];
    	    //$rt =1;
            $data23 = DB::select("select * from phone_requirement where pr_id = '$rt'");
            
            if($data23)
            {
                foreach ( $data23 as $key )
    			{
    			    $temp = $key->required;
    			    
    			    if( $temp == 1)
                    {
                        $toggle = 0;
                    }
                    else
                    {
                        $toggle = 1;
                    }
    			}
    			
                try 
    			{
    			    $inserted = DB::update("update phone_requirement SET required='$toggle' where pr_id='$rt'");
    				
    	            if($inserted)
                    {
                        return response()->json(['status'=>'success']);
                    }
                    else 
     				{
     				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
     				}  
    			} 
    			catch(\Illuminate\Database\QueryException $ex)
    			{ 		
    				return response()->json(['status'=>'failed','error'=>'try again']);
    			}
    	    }
    	    else
    	    {
    	        return response()->json(['status'=>'failed','error'=>'Data Doesnt exists.']);
    	    }
		}
		else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
      
	public function ForgetPasswords (Request $request)
	{
		
	}
	
	public function AddVRStation (Request $request)
    { 
	 if(isset($request['name']) && !empty($request['name']) 
		AND isset($request['number']) && !empty($request['number'])
		AND isset($request['playing_time']) && !empty($request['playing_time']))
		{
    	    
    	       $name =$request['name'];
    	       $number =$request['number'];
    	       $playing_time = $request['playing_time'];
    	       
			   
			   try 
				{ 
				
					$inserteed = DB::insert('insert into vr_station (name,number,playing_time) 
					values (?,?,?)',[$name,$number,$playing_time]);
					
					
		           if($inserteed)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'This account already exists']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function AddTax (Request $request)
    { 
	 if(isset($request['type']) && !empty($request['type']) 
		AND isset($request['tax_amount']) && !empty($request['tax_amount']))
		{
    	    
    	       $type =$request['type'];
    	       $tax_amount =$request['tax_amount'];
    	       
			   try 
				{ 
				
					$inserteed = DB::insert('insert into tax (type,tax_amount) 
					values (?,?)',[$type,$tax_amount]);
					
					
		           if($inserteed)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'This account already exists']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditVRStation (Request $request)
    { 
	 if(isset($request['station_id']) && !empty($request['station_id']) 
		AND isset($request['name']) && !empty($request['name']) 
		AND isset($request['number']) && !empty($request['number'])
		AND isset($request['playing_time']) && !empty($request['playing_time']))
		{
    	    
    	       $name =$request['name'];
    	       $number =$request['number'];
    	       $playing_time = $request['playing_time'];
    	       $station_id = $request['station_id'];
    	       
			   
			   try 
				{ 
				
				    $inserted = DB::update("update  vr_station SET  name='$name',number='$number' ,playing_time='$playing_time'  where station_id='$station_id'");
					
					
					
		           if($inserted)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function DeleteVRStation (Request $request)
    { 
	    if( isset($request['station_id']) && !empty($request['station_id']) )
		{
    	    
    	       
    	       $station_id = $request['station_id'];
    	       
			   try 
				{ 
				
				   $deleted = DB::delete ("delete from  vr_station  where station_id='$station_id'");
		           if($deleted)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ViewAllVRStations (Request $request)
    { 
		
				//return "get";
				try 
				{ 

                    $users = DB::select('select * from 	vr_station ');
					if($users)
					{
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
					return response()->json(['status'=>'failed','error'=>'No information found']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
		
      }
      public function ViewTax (Request $request)
    { 
		
				//return "get";
				try 
				{ 

                    $users = DB::select('select * from 	tax ');
					if($users)
					{
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
					return response()->json(['status'=>'failed','error'=>'No information found']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
		
      }
      
       public function AddRateHour (Request $request)
    { 
        
	 if(isset($request['hours']) && !empty($request['hours']) 
		AND isset($request['rate']) && !empty($request['rate'])
		)
		{
    	    
    	       $hours =$request['hours'];
    	       $rate =$request['rate'];
    	      
    	       
			   
			   try 
				{ 
				
					$inserteed = DB::insert('insert into rate_hour (hours,rate) 
					values (?,?)',[$hours,$rate]);
					
					
		           if($inserteed)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
     public function MultipleBookings (Request $request)
    { 
	    if(isset($request['booking_details']) && !empty($request['booking_details']) )
		{
    	    
    	        $booking_details =$request['booking_details'];
    	       
			    function addItems($option_details11)
				{
				
					$data = json_decode($option_details11);
					foreach ($data as $key)
					{
					
    	                $added_hours ="nil";
    	                $cash_id = mt_rand(100000, 999999);
    	               
						$customer_id      =  $key->customer_id;
						$employee_id      =  $key->employee_id;
						$payment_method      =  $key->payment_method;
						$timestamp      =  $key->timestamp;
						$no_of_bands      =  $key->no_of_bands;
						$price_per_hour      =  $key->price_per_hour;
						$order_total      =  $key->order_total;
						$balance      =  $key->balance;
						$initial_hours      =  $key->initial_hours;
								
						 try 
        				{ 
        				
        					$inserteed = DB::insert('insert into bookings (cash_id,customer_id,employee_id,payment_method,no_of_bands,timestamp,price_per_hour,order_total,balance,initial_hours,added_hours) 
        					values (?,?,?,?,?,?,?,?,?,?,?)',[$cash_id,$customer_id,$employee_id,$payment_method,$no_of_bands,$timestamp,$price_per_hour,$order_total,$balance,$initial_hours,$added_hours]);
        					
        					
        		           if($inserteed)
                              {
                                $ff =1;
                              }
                            else 
         					{
         					    $ff =0;
         					}  
         					
         					
        				} 
        				catch(\Illuminate\Database\QueryException $ex)
        				{ 		
        					$ff = 0;
        				}												
					}
					return $ff;
				}
					
			   
			      
    			   if(addItems($booking_details)==1)
					{
					    return response()->json(['status'=>'success']);  
					}
					else 
					{
						return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
					}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
     public function AddBooking (Request $request)
    { 
        
	 if(isset($request['customer_id']) && !empty($request['customer_id']) 
		AND isset($request['employee_id']) && !empty($request['employee_id'])
		AND isset($request['payment_method']) && !empty($request['payment_method'])
		AND isset($request['timestamp']) && !empty($request['timestamp'])
		AND isset($request['no_of_bands']) && !empty($request['no_of_bands'])
		AND isset($request['price_per_hour']) && !empty($request['price_per_hour'])
		AND isset($request['order_total']) && !empty($request['order_total'])
		AND isset($request['initial_hours']) && !empty($request['initial_hours'])
		)
		{
    	    
    	       $customer_id =$request['customer_id'];
    	       $employee_id =$request['employee_id'];
    	       
    	        $payment_method =$request['payment_method'];
    	         $timestamp =$request['timestamp'];
    	          $no_of_bands =$request['no_of_bands'];
    	           $price_per_hour =$request['price_per_hour'];
    	            $order_total =$request['order_total'];
    	             $balance =$request['balance'];
    	              $initial_hours =$request['initial_hours'];
    	              $added_hours ="nil";
    	                $cash_id = mt_rand(100000, 999999);
    	       
			   
			   try 
				{ 
				
					$inserteed = DB::insert('insert into bookings (cash_id,customer_id,employee_id,payment_method,no_of_bands,timestamp,price_per_hour,order_total,balance,initial_hours,added_hours) 
					values (?,?,?,?,?,?,?,?,?,?,?)',[$cash_id,$customer_id,$employee_id,$payment_method,$no_of_bands,$timestamp,$price_per_hour,$order_total,$balance,$initial_hours,$added_hours]);
					
					
		           if($inserteed)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function UpdateBooking (Request $request)
    { 
	 if(isset($request['cash_id']) && !empty($request['cash_id']) 
		AND isset($request['added_hours']) && !empty($request['added_hours']) )
		{
    	    
    	      $cash_id =$request['cash_id'];
    	      $added_hours =$request['added_hours'];
    	 
			   try 
				{ 
				
				    $inserted = DB::update("update  bookings SET  added_hours='$added_hours' where cash_id='$cash_id'");
					
		           if($inserted)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
     public function DeleteRateHour (Request $request)
    { 
	 if(isset($request['rp_id']) && !empty($request['rp_id']) 
		)
		{
    	    
    	       
    	       $rp_id = $request['rp_id'];
    	       
			   try 
				{ 
				
				   $deleted = DB::delete ("delete from  rate_hour  where rp_id='$rp_id'");
		           if($deleted)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditRateHour (Request $request)
    { 
	 if(isset($request['rp_id']) && !empty($request['rp_id']) 
		AND isset($request['hours']) && !empty($request['hours']) 
		AND isset($request['rate']) && !empty($request['rate']))
		{
    	    
    	      $hours =$request['hours'];
    	      $rate =$request['rate'];
    	      $rp_id = $request['rp_id'];
    	       
			   
			   try 
				{ 
				
				    $inserted = DB::update("update  rate_hour SET  hours='$hours',rate='$rate'  where rp_id='$rp_id'");
					
		           if($inserted)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ViewAllRateHours (Request $request)
    { 
		
				//return "get";
				try 
				{ 

                    $users = DB::select('select * from 	rate_hour ');
					if($users)
					{
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'No information found']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
		
      }
	
	 public function AddAgreement (Request $request)
    { 
        
	 if(isset($request['title']) && !empty($request['title']) 
		AND isset($request['text']) && !empty($request['text'])
		)
		{
    	    
    	       $title =$request['title'];
    	       $text =$request['text'];
    	      
    	       
			   
			   try 
				{ 
				
					$inserteed = DB::insert('insert into agreements (title,text) 
					values (?,?)',[$title,$text]);
					
					
		           if($inserteed)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditAgreement (Request $request)
    { 
	 if(isset($request['ag_id']) && !empty($request['ag_id']) 
		AND isset($request['title']) && !empty($request['title']) 
		AND isset($request['text']) && !empty($request['text']))
		{
    	    
    	      $ag_id =$request['ag_id'];
    	      $title =$request['title'];
    	      $text = $request['text'];
    	       
			   
			   try 
				{ 
				
				    $inserted = DB::update("update  agreements SET  title='$title',text='$text'  where ag_id='$ag_id'");
					
		           if($inserted)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function DeleteAgreement (Request $request)
    { 
	 if(isset($request['ag_id']) && !empty($request['ag_id']) 
		)
		{
    	    
    	       
    	       $ag_id = $request['ag_id'];
    	       
			   try 
				{ 
				
				   $deleted = DB::delete ("delete from  agreements  where ag_id='$ag_id'");
		           if($deleted)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    public function ViewAgreement (Request $request)
    { 
		
				//return "get";
				try 
				{ 

                    $users = DB::select('select * from 	agreements ');
					if($users)
					{
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'No information found']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
		
      }

        public function DeleteChild (Request $request)
		{ 
	
			if(isset($request['customer_id']) && !empty($request['customer_id'])) 
				{
					
					$customer_id=$request['customer_id'];

					$users_posts = DB::select('select * from customer where customer_id = ?', [$customer_id]);
					if($users_posts)
					{
						
						try 
						{ 
							$users_d = DB::delete('DELETE  from customer where customer_id = ?', [$customer_id]);
						
							if($users_d)
							{
						        return response()->json(['status'=>'success']);
								
							}
							else 
							{
								return response()->json(['status'=>'failed','error'=>'Sql Error']);
							}
						
						}
						
						catch(\Illuminate\Database\QueryException $ex)
						{ 		
							return response()->json(['status'=>'failed','error'=>'Sql Error']);
						}
				
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'Customer Does not exist']);
					}
				
						
							
				}

			else 
				{
					return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
				}
		  
		}   
	
	public function CustomerSignin (Request $request)
    { 
		if(isset($request['email']) && !empty($request['email']) AND isset($request['password']) && !empty($request['password'])) 
			{
				$email=$request['email'];
				$Password=$request['password'];
				$new_pass =md5($Password);
				$type = "parent";
				
				try 
				{ 
                    $users = DB::select('select * from customer where email = ? AND password = ? ', [$email, $new_pass]);
					if($users)
					{
					    
					    foreach ($users as $key)
						{
							$cusphone       =  $key->phone;
							$cusemail       =  $key->email;
							$childtype ="child";
							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
        					if($userschild)
        					{
        					   $key->children = $userschild;
        					}
        					else
        					{
        				    	$key->children = null;
        					}
						}
					    return response()->json(['status'=>'success','data'=>$users]);
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'Wrong Email or Password']);
					}
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			}
		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }
    
    public function CustomerPwdChange (Request $request)
	{ 
        //return "Here";
		if(isset($request['customer_id']) && !empty($request['customer_id']) AND isset($request['old_password']) && !empty($request['old_password']) AND isset($request['new_password']) && !empty($request['new_password'])) 
			{
				
				$customer_id=$request['customer_id'];
				$New_Password=$request['new_password'];
				$New_Password1=md5($New_Password);
				$Old_Password=$request['old_password'];
				$Old_Password1 =md5($Old_Password);
						   
				$users = DB::select('select * from customer where customer_id = ? AND password = ? ', [$customer_id , $Old_Password1]);
				if($users)
				{
				    
					$user_new = DB::update('update customer SET password = ?  where customer_id = ?', [$New_Password1,$customer_id]);
					if ( $user_new)
					{
						return response()->json(['status'=>'success']);
					}
					else 
					{
						return response()->json(['status'=>'failed','error'=>'Sql Error1']);
					}
					
							
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Old password does not match!']);
				}	
					  
				
			
			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
	  
	}
		
	public function CustomerPhoneEdit (Request $request)
	{ 
		if(isset($request['customer_id']) && !empty($request['customer_id']) AND isset($request['phone']) && !empty($request['phone']) ) 
		{
			
			$customer_id=$request['customer_id'];
			$phone=$request['phone'];
					   
			$users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
			if($users)
			{
			    foreach ($users as $key)
				{
				    $cusemail     =  $key->email;
				}
			    
				$user_new = DB::update('update customer SET phone = ?  where email = ?', [$phone,$cusemail]);
				if ( $user_new)
				{
					return response()->json(['status'=>'success']);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Sql Error1']);
				}
			}
			else
			{
				return response()->json(['status'=>'failed','error'=>'Customer not exist']);
			}	
				  
			
		
		}
		else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
		}
	}
		
	public function EditCustomerProfile2 (Request $request)
    { 
	    if(isset($request['dob']) && !empty($request['dob']) 
		AND isset($request['fname']) && !empty($request['fname'])
		AND isset($request['lname']) && !empty($request['lname'])
		AND isset($request['phone']) && !empty($request['phone'])
		AND isset($request['email']) && !empty($request['email']))
		{
		    $deal_id = $request['deal_id'];
            $dob =$request['dob'];
            $fname =$request['fname'];
            $lname = $request['lname'];
            $phone = $request['phone'];
            $email = $request['email'];
            $child_email = $request['child_email'];
            $password_w=$request['password'];
            $children=$request['children'];
            $password =md5($password_w);
            $gender = $request['gender'];
            $age = $request['age'];
            $add1 = $request['add1'];
            $add2 = $request['add2'];
            $country = $request['country'];
            $state = $request['state'];
            $city = $request['city'];
            $zipcode = $request['zipcode'];
            $type = $request['type'];
            $customer_id = $request['customer_id'];
            $license_no = $request['license_no'];
            $license_exp_date = $request['license_exp_date'];
            $room_no = $request['room_no'];
            $insurance_cmp = $request['insurance_cmp'];
            $insurance_no = $request['insurance_no'];
            $pic_type = $request['pic_type'];
            $signup_timestamp = $request['signup_timestamp'];
			   
			   
		    function addItems($phone11,$option_details11,$deal_id)
			{
				$type = "child";
				//echo "hre";
			
				$data = json_decode($option_details11);
				
				
				foreach ($data as $key)
				{
					$fname11      =  $key->fname;
					//echo "ye lo".$fname11;
					$lname11      =  $key->lname;
					$dob11      =  $key->dob;
					$gender11      =  $key->gender;
					$email11      =  $key->email;
					$customer_id      =  $key->customer_id;
					$age45      =  $key->age;
					$license_no11 = $key->license_no;
		            $license_exp_date11 = $key->license_exp_date;
		            $phone33 = $key->phone;
		            $state33 = $key->state;
		            $insurance_cmp33 = $key->insurance_cmp;
		            $insurance_no33 = $key->insurance_no;
		            $child_email33 = $key->child_email;
		            
		            //echo $fname11." ".$lname11." ".$dob11." ".$gender11." ".$email11." ".$customer_id." ".$age45." ".$license_no11." ".$license_exp_date11." ".$phone33." ".$state33." ".$insurance_cmp33." ".$insurance_no33." ".$child_email33;
		            
		            if( $phone33 != 'nil')
		            {
		                $phone11 = $phone33;
		            }
					
				    if ($customer_id == "nil")
				    {
				        $customer_id= mt_rand(100000, 999999);
						try 
						{ 
						    $inserteed = DB::insert('insert into customer (customer_id,dob,fname,lname,phone,email,gender,type,age,license_no,license_exp_date,state,insurance_cmp,insurance_no,child_email) 
    					    values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$customer_id,$dob11,$fname11,$lname11,$phone11,$email11,$gender11,$type,$age45,$license_no11,$license_exp_date11,$state33,$insurance_cmp33,$insurance_no33,$child_email33]);
    					
							if($inserteed)
							{
							    if( $deal_id == "nil")
							    {
							        $ff=1;
							    }
							    else
							    {
    								$inserteed2 = DB::insert('insert into Deal_Customer (deal_id,dob,fname,lname,phone,email,gender,type,age,license_no,license_exp_date,state,insurance_cmp,insurance_no,child_email) 
        					        values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$deal_id,$dob11,$fname11,$lname11,$phone11,$email11,$gender11,$type,$age45,$license_no11,$license_exp_date11,$state33,$insurance_cmp33,$insurance_no33,$child_email33]);
    							
        							if($inserteed2)
        							{
        							    $ff=1;
        							}
        							else
        							{
        							    $ff=0;
        							}
							    }
							}
							else
							{
							    $ff=0;
							}
						} 
						catch(\Illuminate\Database\QueryException $ex)
						{ 		
							$ff = 0;
						}
				    }
				    else 
				    {
			        	try 
						{ 
						    $inserteed = DB::update('update customer SET insurance_cmp = ?, insurance_no = ?, child_email = ?, state = ? , license_no = ? , license_exp_date = ? , age = ? , phone = ? , dob = ? , fname = ? ,lname = ? ,gender = ?  where customer_id= ?', [$insurance_cmp33,$insurance_no33,$child_email33,$state33,$license_no11,$license_exp_date11,$age45,$phone11,$dob11,$fname11,$lname11,$gender11,$customer_id]);
							if($inserteed)
							{
							    if( $deal_id == "nil")
							    {
							        $ff=1;
							    }
							    else
							    {
    								$inserteed2 = DB::insert('insert into Deal_Customer (deal_id,dob,fname,lname,phone,email,gender,type,age,license_no,license_exp_date,state,insurance_cmp,insurance_no,child_email) 
        					        values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$deal_id,$dob11,$fname11,$lname11,$phone11,$email11,$gender11,$type,$age45,$license_no11,$license_exp_date11,$state33,$insurance_cmp33,$insurance_no33,$child_email33]);
    							
        							if($inserteed2)
        							{
        							    $ff=1;
        							}
        							else
        							{
        							    $ff=0;
        							}
							    }
							}
							else 
							{
								$ff = 0;
							}		
						} 
						catch(\Illuminate\Database\QueryException $ex)
						{ 		
							$ff = 0;
						}
				    }
				}
				
				return $ff;
			}
			 
			$users = DB::select('select * from customer where email = ?', [$email]);
			if($users)
			{
				try 
				{ 
			        if(isset($request['photo']) && !empty($request['photo']))
    			    {
    			        $count = mt_rand(100000, 999999);
    			        if ($pic_type == "b64")
        				{
        				    $b64 =$request['photo'];
                           
                            $bin = base64_decode($b64);
                           
                            $im = imageCreateFromString($bin);
                          
                            if (!$im) 
                            {
                              die('Base64 value is not a valid image');
                            }
                            
                    		$destinationPath='public/pictures';
                    		$extention = "png";
                    		$fileName=round(microtime(true)).$count.".".$extention;
                    		
                			$photo=$fileName;
                			$destination = "pictures/";
                			$target_file = $destination. $photo;
                	        $img_file="public/pictures/".$fileName;
                            imagepng($im, $img_file, 0);
                            //return $target_file;
        				}
        				else 
        				{
        				    
        				    $request->file('photo');
                			$destinationPath='public/pictures';
                			$file=$request->photo;
                			$extention=$request->photo->extension();
                			//$extention=$file->getClientOriginalExtention();
                			$fileName=round(microtime(true)).$count.".".$extention;
                			$file->move($destinationPath,$fileName);
                			$photo=$fileName;
                			$destination = "pictures/";
                			$target_file = $destination. $photo;
        				}
    			   }
    			    else 
    			    {
    			        $target_file = null;
    			    }
        			   
        			if(isset($request['customer_img']) && !empty($request['customer_img']))
    			    {
    			        $count = mt_rand(100000, 999999);
    			        
    			        $request->file('customer_img');
            			$destinationPath='public/pictures';
            			$file=$request->customer_img;
            			$extention=$request->customer_img->extension();
            			//$extention=$file->getClientOriginalExtention();
            			$fileName=round(microtime(true)).$count.".".$extention;
            			$file->move($destinationPath,$fileName);
            			$customer_img=$fileName;
            			$destination = "pictures/";
            			$target_file2 = $destination. $customer_img;
    		        }
    			    else 
    			    {
    			        $target_file2 = null;
    			    }
    			    
    			    if(isset($request['driving_license_img']) && !empty($request['driving_license_img']))
    			    {
    			        $count = mt_rand(100000, 999999);
    			        
    			        $request->file('driving_license_img');
            			$destinationPath='public/pictures';
            			$file=$request->driving_license_img;
            			$extention=$request->driving_license_img->extension();
            			//$extention=$file->getClientOriginalExtention();
            			$fileName=round(microtime(true)).$count.".".$extention;
            			$file->move($destinationPath,$fileName);
            			$driving_license_img=$fileName;
            			$destination = "pictures/";
            			$target_file3 = $destination. $driving_license_img;
    		        }
    			    else 
    			    {
    			        $target_file3 = null;
    			    }
    			    
    			    
				    $user_new = DB::update('update customer SET customer_img = ?, driving_license_img = ?, insurance_cmp = ?, insurance_no = ?,  room_no=?, license_no=?, license_exp_date=?, signature= ? , dob = ? , fname = ? ,lname = ? ,phone = ? ,gender = ? ,age = ? , add1 = ? ,add2 = ?, country = ? ,state = ?, city = ? ,zipcode = ?   where customer_id= ?', [$target_file2,$target_file3,$insurance_cmp,$insurance_no,$room_no,$license_no,$license_exp_date,$target_file,$dob,$fname,$lname,$phone,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$customer_id]);
		            if($user_new)
                    {
                        if( $deal_id == "nil")
                        {
                            if(isset($request['children']) && !empty($request['children']))
                            {
                                if(addItems($phone,$children,$deal_id)==1)
    							{
    						        $users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
                					if($users)
                					{
                					    foreach ($users as $key)
                						{
                							$cusemail   = $key->email;
                							$childtype  = "child";
                							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
                        					if($userschild)
                        					{
                        					   $key->children = $userschild;
                        					}
                        					else
                        					{
                        				    	$key->children =null  ;
                        					}
                						}
                					    return response()->json(['status'=>'success','data'=>$users]);
                					}
                					else
                					{
                						return response()->json(['status'=>'failed','error'=>'Wrong Email']);
                					}
                    					
    								//return response()->json(['status'=>'success']);  
    							}
    							else 
    							{
    								return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
    							}
                            }
                            else 
                            {
                                $users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
                    			if($users)
            					{
            					    foreach ($users as $key)
            						{
            						    $cusemail   =  $key->email;
            							$childtype  = "child";
            							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
                    					if($userschild)
                    					{
                    					   $key->children = $userschild;
                    					}
                    					else
                    					{
                    				        $key->children=null;
                    					}
            						}
            					    return response()->json(['status'=>'success','data'=>$users]);
            					}
            					else
            					{
            						return response()->json(['status'=>'failed','error'=>'Wrong Email']);
            					}
                           }
                        }
                        else
                        {
                            $inserteed2 = DB::insert('insert into Deal_Customer (signup_timestamp,deal_id,dob,fname,lname,phone,signature,email,child_email,password,gender,age,add1,add2,country,state,city,zipcode,type,license_no,license_exp_date,room_no,insurance_cmp,insurance_no,customer_img,driving_license_img) 
            			    values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$signup_timestamp,$deal_id,$dob,$fname,$lname,$phone,$target_file,$email,$child_email,$password,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$type,$license_no,$license_exp_date,$room_no,$insurance_cmp,$insurance_no,$target_file2,$target_file3]);
                            
                            if($inserteed2)
                            {
                               if(isset($request['children']) && !empty($request['children']))
                               {
                                    if(addItems($phone,$children,$deal_id)==1)
        							{
        						        $users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
                    					if($users)
                    					{
                    					    foreach ($users as $key)
                    						{
                    							$cusemail   = $key->email;
                    							$childtype  = "child";
                    							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
                            					if($userschild)
                            					{
                            					   $key->children = $userschild;
                            					}
                            					else
                            					{
                            				    	$key->children =null  ;
                            					}
                    						}
                    					    return response()->json(['status'=>'success','data'=>$users]);
                    					}
                    					else
                    					{
                    						return response()->json(['status'=>'failed','error'=>'Wrong Email']);
                    					}
                        					
        								//return response()->json(['status'=>'success']);  
        							}
        							else 
        							{
        								return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
        							}
                               }
                               else 
                               {
                                    $users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
                        			if($users)
                					{
                					    foreach ($users as $key)
                						{
                						    $cusemail   =  $key->email;
                							$childtype  = "child";
                							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
                        					if($userschild)
                        					{
                        					   $key->children = $userschild;
                        					}
                        					else
                        					{
                        				        $key->children=null;
                        					}
                						}
                					    return response()->json(['status'=>'success','data'=>$users]);
                					}
                					else
                					{
                						return response()->json(['status'=>'failed','error'=>'Wrong Email']);
                					}
                               }
                            }
                            else
                            {
         				    	return response()->json(['status'=>'failed','error'=>'Sql Error']);
         					}
                        }
                    }
                    else 
 					{
 					    return response()->json(['status'=>'failed','error'=>'Sql Error123']);
 					}  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					$ff = 0;
				}	
			}
			else 
			{
			    return response()->json(['status'=>'failed','error'=>'Email not Exists']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
	
	public function AddBalance (Request $request)
    { 
	    if(isset($request['opening_date']) && !empty($request['opening_date']) 
		AND isset($request['opening_balance']) && !empty($request['opening_balance'])
		AND isset($request['opening_employee']) && !empty($request['opening_employee']) AND isset($request['register_id']) && !empty($request['register_id']))
		{
    	    
	       $opening_date =$request['opening_date'];
	       $opening_balance =$request['opening_balance'];
	       $opening_employee = $request['opening_employee'];
	       $closing_employee = $request['closing_employee'];
	       $register_id = $request['register_id'];
	       $location_id = $request['location_id'];
	       $bm_id = mt_rand(1000, 9999);
    	       
    	       
    	      
			try 
			{ 
			    $inserteed = DB::insert('insert into balance_managing (bm_id,opening_date,opening_balance,opening_employee,register_id,location_id) 
				values (?,?,?,?,?,?)',[$bm_id,$opening_date,$opening_balance,$opening_employee,$register_id,$location_id]);
				
				
	            if($inserteed)
                {
                    return response()->json(['status'=>'success','bm_id'=>$bm_id]);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Try Again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function CloseBalance (Request $request)
    { 
	    if(isset($request['bm_id']) && !empty($request['bm_id']) 
		AND isset($request['closing_date']) && !empty($request['closing_date'])
		AND isset($request['closing_balance']) && !empty($request['closing_balance']))
		{
    	    
            $bm_id =$request['bm_id'];
            $closing_date =$request['closing_date'];
            $closing_balance = $request['closing_balance'];
            $closing_employee = $request['closing_employee'];
            
            try 
			{ 
				$inserteed = DB::update('update balance_managing SET  closing_employee = ? , closing_date = ? , closing_balance = ?  where bm_id= ?', [$closing_employee, $closing_date,$closing_balance,$bm_id]);
	            if($inserteed)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error12']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Try Again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function GetClosingBalance (Request $request)
	{ 
        if(isset($request['opening_date']) && !empty($request['opening_date']) AND isset($request['closing_date']) && !empty($request['closing_date']) )
        {
	        try
	        {
	            $opening_date =$request['opening_date'];
	            $closing_date =$request['closing_date'];
	            $bm_id =$request['bm_id'];
	            $order_total_new =0;
	            $justopened = 0;
	       
	            $data2 = DB::select("select * from balance_managing where bm_id = '$bm_id'");	   
		        if($data2)
		        {
		       	    foreach($data2 as $u2)
		       	    {
					    $opening_balance = $u2->opening_balance;
					    $register_id = $u2->register_id;
					    $justopened = 1;
		       	    }
		        }
		        else
		        {
			        $opening_balance = 0;
		        }
		   
    	        $data = DB::select("select * from KOS_cashier where register_id = '$register_id' AND timestamp >= '$opening_date' AND timestamp <= '$closing_date' ");	   
    		    if($data)
    		    {
    		       	foreach($data as $u)
    		       	{
    					$order_total = $u->amount_pay;
    					
    					$order_total_new = $order_total_new + $order_total;
    		       	}
    		       	
    		       	$closing = $order_total_new + $opening_balance;
    			    return response()->json(['status'=>'success','opening_balance'=>$opening_balance,'closing_balance'=>$closing]);
    		    }
    		    else
    		    {
    		        if( $justopened == 1 )
    		        {
    		            return response()->json(['status'=>'success','opening_balance'=>$opening_balance,'closing_balance'=>$opening_balance]);
    		        }
    		        else
    		        {
    			        return response()->json(['status'=>'failed','error'=>'Update again.']);
    		        }
    		    }
    	    }
    	    catch(\Illuminate\Database\QueryException $ex)
    	    { 		
                return response()->json(['status'=>'failed','error'=>'SQL Error.']);
    	    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function VerifyCustomerNew (Request $request)
    { 
	
	    if(isset($request['verify_date']) && !empty($request['verify_date']) AND isset($request['verify_employee']) && !empty($request['verify_employee']) 
		AND isset($request['verify_time']) && !empty($request['verify_time']) AND isset($request['customer_id']) && !empty($request['customer_id'])) 
		{
		    $order_id=$request['order_id'];
			$verify_date=$request['verify_date'];
			$verify_employee=$request['verify_employee'];
			$verify_time=$request['verify_time'];
			//$customer_email=$request['customer_email'];
			$customer_id=$request['customer_id'];
			$verification = 1;
			$verification_status = "verified";
			
			
			//$arr=explode(",",$customer_id);
			//foreach ($arr as $in)
			//{
			    try 
				{ 
					$user_new = DB::update('update customer SET verify_date= ?, verify_employee= ? , verify_time=?  where customer_id = ?', [$verify_date, $verify_employee,$verify_time,$customer_id]);
					if ( $user_new)
					{
					    $user_new2 = DB::update('update KOS_Orders SET verification_status=?  where order_id = ?', [$verification_status,$order_id]);
    					if ( $user_new2)
    					{
    					    return response()->json(['status'=>'success']);	
    					}
    					else 
    					{
    						return response()->json(['status'=>'failed','error'=>'Sql Error1']);
    					}
					}
					else 
					{
						return response()->json(['status'=>'failed','error'=>'Sql Error2']);
					}
				}
				
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error3']);
				}
			//}
			//return response()->json(['status'=>'success']);
		}
	    else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
		}
	}
	
	
	public function UpdateCustomerDeal (Request $request)
    { 
	
	    if(isset($request['order_id']) && !empty($request['order_id']) AND isset($request['customer_id']) && !empty($request['customer_id']) ) 
		{
		    $order_id=$request['order_id'];
			$customer_id=$request['customer_id'];
			
			//echo $order_id." ".$customer_id;
			
			    try 
				{ 
					$user_new = DB::update('update KOS_Orders SET customer_id= ? where order_id = ?', [$customer_id, $order_id ]);
					if ( $user_new)
					{
					     return response()->json(['status'=>'success']);	
					}
					else 
					{
						return response()->json(['status'=>'failed','error'=>'Sql Error']);
					}
				}
				
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			//}
			//return response()->json(['status'=>'success']);
		}
	    else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
		}
	}
	
	public function AddTransaction (Request $request)
    { 
        
	 if(isset($request['transactions_details']) && !empty($request['transactions_details']) )
		{
		    $transactions=$request['transactions_details'];
		    
	        function addItems($transactions11)
			{
				$data = json_decode($transactions11);
				
				foreach ($data as $key)
				{
					$transaction_id =  $key->transaction_id;
					$location_id    = $key->location_id;
					$register_id    = $key->register_id;
					$amount         =  $key->amount;
					$cash_id        =  0;
					$deal_id        =  $key->deal_id;
					
					if($transaction_id == 0)
					{
					    $transaction_id = mt_rand (0,999999999);
					}
			
					try 
    				{ 
    					$inserteed = DB::insert('insert into cashier_transactions (transaction_id,location_id,register_id,amount,cash_id,deal_id) 
    					values (?,?,?,?,?,?)',[$transaction_id,$location_id,$register_id,$amount,$cash_id,$deal_id]);
    					
    		            if($inserteed)
                        {
                        	$ff = 1;
                        }
                        else 
     					{
     					    	$ff = 0;
     					}  
    				} 
    				catch(\Illuminate\Database\QueryException $ex)
    				{ 		
    						$ff = 0;
    				}
				}
				return $ff;
			}
			
			if(addItems($transactions)==1)
			{
			    return response()->json(['status'=>'success']);  
			}
			else 
			{
				return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ViewTransaction (Request $request)
	{ 
        $phone = $request['phone'];
        $myArray = [];
        
        try
        {
            if($phone)
            {
                $data2 = DB::select("select * from KOS_cashier ORDER BY created_at DESC ");	   
    	        if($data2)
    	        {
    	            foreach ($data2 as $key1)
    				{
    	                $deal_id =  $key1->deal_id;
    	               
    	                $data21 = DB::select("select * from KOS_Orders where order_id = '$deal_id' AND user_phone='$phone'");	   
        		        if($data21)
        		        {
        	                foreach ($data21 as $key12)
            				{
            	                $customer_id =  $key12->customer_id;
            	                $deal_id      =  $key12->order_id;
            	                $type = "parent";
				
				                $data221 = DB::select('select * from Deal_Customer where deal_id = ? AND type= ? ', [$deal_id,$type]);	   
                		        if($data221)
                		        {
                		             foreach ($data221 as $key212)
                    				{
                    	                $fname =  $key212->fname;
                    	                $lname =  $key212->lname;
                    	                $phone =  $key212->phone;
                    	                $key12->fname =$fname ;
                    	                $key12->lname =$lname ;
                    	                $key12->phone =$phone ;
                    				}
                    		    }
                    		    else 
                    		    {
                                    $key12->fname =null ;
                        	        $key12->lname =null ;
                        	        $key12->phone =null ;
                    		    }
            				}
    				
    				        $key1->phone =$phone ;
        		            $key1->booking_details =$data21 ;
        		            
        		            $usimage = DB::select('select * from inspection_pictures where deal_id = ? AND side_name !="signature" ', [$deal_id]);
        					if($usimage)
        					{
        				        $key1->Inspection_images = $usimage;
        					}
        					
        					array_push($myArray,$key1);
            		    }
    				}
    				
    	       	    return response()->json(['status'=>'success','data'=>$myArray]);
    		    }
    		    else
    		    {
    		        return response()->json(['status'=>'failed','error'=>'No Data Found']);
    		    }
            }
            else
            {
                $data2 = DB::select("select * from KOS_cashier ORDER BY created_at DESC ");	   
    	        if($data2)
    	        {
    	            foreach ($data2 as $key1)
    				{
    	                $deal_id =  $key1->deal_id;
    	               
    	                $data21 = DB::select("select * from KOS_Orders where order_id = '$deal_id'");	   
        		        if($data21)
        		        {
        	                foreach ($data21 as $key12)
            				{
            	                $customer_id =  $key12->customer_id;
            	                $deal_id      =  $key12->order_id;
            	                $type = "parent";
				
				                $data221 = DB::select('select * from Deal_Customer where deal_id = ? AND type= ? ', [$deal_id,$type]);	
                		        if($data221)
                		        {
                		             foreach ($data221 as $key212)
                    				{
                    	                $fname =  $key212->fname;
                    	                $lname =  $key212->lname;
                    	                $phone =  $key212->phone;
                    	                $key12->fname =$fname ;
                    	                $key12->lname =$lname ;
                    	                $key12->phone =$phone ;
                    				}
                    		    }
                    		    else 
                    		    {
                                    $key12->fname =null ;
                        	        $key12->lname =null ;
                        	        $key12->phone =null ;
                    		    }
            				}
    				
    				        $key1->phone =$phone ;
        		            $key1->booking_details =$data21 ;
            		    }
            		    
            		    $usimage = DB::select('select * from inspection_pictures where deal_id = ? AND side_name !="signature" ', [$deal_id]);
    					if($usimage)
    					{
    				        $key1->Inspection_images = $usimage;
    					}
    				}
    	       	   return response()->json(['status'=>'success','data'=>$data2]);
    		    }
    		    else
    		    {
    		        return response()->json(['status'=>'failed','error'=>'No Data Found']);
    		    }
            }
        }
	    catch(\Illuminate\Database\QueryException $ex)
	    { 		
            return response()->json(['status'=>'failed','error'=>'SQL Error.']);
	    }
    	
    }
    
    public function CouponsDiscount(Request $request)
    {
        if(isset($request['code']) && !empty($request['code'])) 
    	{
    	    $code = $request['code'];
    	    
    	    $users_p = DB::select('select * from coupons where code= ?', [$code]);
            if($users_p)
    		{
    		    return response()->json(['status'=>'success','data'=>$users_p]); 
    		}
    		else
    		{
    		    return response()->json(['status'=>'failed','error'=>'No discount Exists.']);
    		}
    	}
    	else 
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function VerifyTransId (Request $request)
    { 
        if(isset($request['transaction_id']) && !empty($request['transaction_id'])) 
    	{
    	    $transaction_id = $request['transaction_id'];
    	    $location_id = $request['location_id'];
    	    $register_id = $request['register_id'];
    	    
    	    $users_p = DB::select('select * from cashier_transactions where transaction_id= ? AND location_id= ? AND register_id= ?', [$transaction_id,$location_id,$register_id]);
            if($users_p)
    		{
    		    return response()->json(['status'=>'failed','error'=>'Already Exist']);
    		}
    		else
    		{
    		    return response()->json(['status'=>'success']); 
    		}
    	}
    	else 
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function RefundBooking (Request $request)
    { 
	    if(isset($request['cash_id']) && !empty($request['cash_id']) 
		    AND isset($request['refund_amount']) && !empty($request['refund_amount']) 
		    AND isset($request['refund_paymentmethod']) && !empty($request['refund_paymentmethod'])
		    AND isset($request['refund_timestamp']) && !empty($request['refund_timestamp']))
		{
            $cash_id =$request['cash_id'];
            $refund_amount =$request['refund_amount'];
            $refund_paymentmethod = $request['refund_paymentmethod'];
            $refund_timestamp = $request['refund_timestamp'];
            $refund_reason = $request['refund_reason'];
            
            
            if(isset($request['photo']) && !empty($request['photo']))
		    {
	            $count = mt_rand(100000, 999999);
			    $request->file('photo');
    			$destinationPath='public/pictures';
    			$file=$request->photo;
    			$extention=$request->photo->extension();
    			//$extention=$file->getClientOriginalExtention();
    			$fileName=round(microtime(true)).$count.".".$extention;
    			$file->move($destinationPath,$fileName);
    			$photo=$fileName;
    			$destination = "pictures/";
    			$target_file = $destination. $photo;
	        }
		    else 
		    {
		        $target_file = null;
		    }
            
            
		    try 
			{ 
		        $inserted  = DB::update("update KOS_cashier SET refund_signature='$target_file', refund_reason='$refund_reason', refund_amount='$refund_amount', refund_paymentmethod='$refund_paymentmethod', refund_timestamp='$refund_timestamp'  where cash_id='$cash_id'");
	            if($inserted)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				} 
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
}
