<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\http\Request;
use Illuminate\http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Input;
use Hash;


use DB;


class LocationController extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;


    

    public function AddLocation (Request $request)
    { 
		if(isset($request['Shortcode']) && !empty($request['Shortcode']) AND isset($request['Description']) && !empty($request['Description']) AND isset($request['AddressLine1']) && !empty($request['AddressLine1'])
		AND isset($request['AddressLine2']) && !empty($request['AddressLine2']) AND isset($request['City']) && !empty($request['City']) 
		AND isset($request['CountryID']) && !empty($request['CountryID']) AND isset($request['RegionID']) && !empty($request['RegionID']) 
		AND isset($request['Postcode']) && !empty($request['Postcode']) AND isset($request['AccessNotes']) && !empty($request['AccessNotes']) 			) 
			{
				$Shortcode=$request['Shortcode'];
				$Description=$request['Description'];
				$AddressLine1=$request['AddressLine1'];
				
				$AddressLine2=$request['AddressLine2'];
				$City=$request['City'];
				$CountryID=$request['CountryID'];
				$RegionID=$request['RegionID'];
				$Postcode=$request['Postcode'];
				$AccessNotes=$request['AccessNotes'];
				
				try 
				{ 
					$inserteed = DB::insert('insert into Location (Shortcode,Description,AddressLine1,AddressLine2,City,CountryID,RegionID,Postcode,AccessNotes) values (?,?,?,?,?,?,?,?,?)',[$Shortcode,$Description,$AddressLine1,$AddressLine2,$City,$CountryID,$RegionID,$Postcode,$AccessNotes]);											  
					return response()->json(['status'=>'success']);   
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Email Already Exist']);
				}


			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }
	
	
	
	
	public function LocationEdit (Request $request)
    { 
		if(isset($request['LocationID']) && !empty($request['LocationID']) AND isset($request['Shortcode']) && !empty($request['Shortcode']) AND isset($request['Description']) && !empty($request['Description']) AND isset($request['AddressLine1']) && !empty($request['AddressLine1'])
		AND isset($request['AddressLine2']) && !empty($request['AddressLine2']) AND isset($request['City']) && !empty($request['City']) 
		AND isset($request['CountryID']) && !empty($request['CountryID']) AND isset($request['RegionID']) && !empty($request['RegionID']) 
		AND isset($request['Postcode']) && !empty($request['Postcode']) AND isset($request['AccessNotes']) && !empty($request['AccessNotes']) 			) 
			{
				$LocationID=$request['LocationID'];
				$Shortcode=$request['Shortcode'];
				$Description=$request['Description'];
				$AddressLine1=$request['AddressLine1'];
				
				$AddressLine2=$request['AddressLine2'];
				$City=$request['City'];
				$CountryID=$request['CountryID'];
				$RegionID=$request['RegionID'];
				$Postcode=$request['Postcode'];
				$AccessNotes=$request['AccessNotes'];

				$users = DB::select('select * from Location where LocationID = ?', [$LocationID]);
				if($users)
				{
					try 
					{ 
						$user_new = DB::update('update Location SET Shortcode = ? , Description = ? , AddressLine1 = ?, AddressLine2 = ? , City= ? , CountryID= ? ,RegionID=?, Postcode=?,AccessNotes=?   where LocationID = ?', [$Shortcode,$Description,$AddressLine1,$AddressLine2, $City , $CountryID ,$RegionID,$Postcode,$AccessNotes,$LocationID]);
						if ( $user_new)                             
						{
							return response()->json(['status'=>'success']);
						}
						else 
						{
							return response()->json(['status'=>'failed','error'=>'Sql Error']);
						}
					
					}
					
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						return response()->json(['status'=>'failed','error'=>'Sql Error']);
					}
					
									  
					//return response()->json(['status'=>'success','data'=>$users ]);
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong Location Id']);
				}	
					  
				
			
			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }

public function LocationView (Request $request)
    {

		if(isset($request['LocationID']) && !empty($request['LocationID']))
		{
//echo "yahaa";
			$LocationID=$request['LocationID'];
			
			$users = DB::select('select * from Location where LocationID = ?', [$LocationID]);

				if($users)
				{
					return response()->json(['status'=>'success','data'=>$users]);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'No Information Found']);
				}
			
		}
		else 
		{
			
			$users = DB::select('select * from Location');

			
				if($users)
				{
					return response()->json(['status'=>'success','data'=>$users]);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'No Information Found']);
				}
			
		}
        
    }
	
	
	public function LocationDelete(Request $request)
    {

		if(isset($request['LocationID']) && !empty($request['LocationID']))
		{
//echo "yahaa";
			$LocationID=$request['LocationID'];
			
			$users = DB::select('select * from Location where LocationID = ?', [$LocationID]);
				if($users)
				{
					try 
					{ 
						$flag =1;
						$user_new = DB::delete('DELETE FROM Location where LocationID = ?', [$LocationID]);
						if ( $user_new)
						{
							return response()->json(['status'=>'success']);
						}
						else 
						{
							return response()->json(['status'=>'failed','error'=>'Sql Error']);
						}
					
					}
					
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						return response()->json(['status'=>'failed','error'=>'Sql Error']);
					}
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Wrong Location Id']);
				}
			
		}
		else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			
		}
        
    }

}

