<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Add Backup Email</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
    if (!localStorage.login_var)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>

<body>
    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Add Backup Email</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="backup_email.php">Backup Email</a>
                        </li>
                        <li class="active">
                            <strong>Add Backup Email</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="add_backup_email_form">
                                    <div class="form-group">
                                        <label>Backup Email</label>
                                        <input type="email" id="backup_email" name="backup_email" placeholder="Enter Backup Email" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Email For App</label>
                                        <select id="email_type" class="form-control" required>
                                            <option value="TimeClock">TimeClock</option>
                                            <option value="BigApp">BigApp</option>
                                            <option value="GarageApp">GarageApp</option>
                                        </select>
                                    </div>
                                    <div>
                                        <button style="background-color: #003399;border-color: #224ea6;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added Vehicle Type -->
                                        <button id="swal_btn" type="button" style="display:none"></button>
                                        <!-- Vehicle Type not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none"></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            include 'footer.php';
            ?>
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <script>
    $(document).ready(function()
    {
        $("#side16").addClass("activeSM");
        $("#side16 a").css("color","#224ea6");

        $("#add_backup_email_form").validate({
            rules: 
            {
                backup_email: {
                   required: true,
                   email    : true,
                },
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );

                var backup_email = $('#backup_email').val();
                var email_type   = $('#email_type').val();

                var formData = new FormData();
                formData.append("email_id", backup_email);
                formData.append("email_type", email_type);
                                    
                $.ajax
                ({
                    type:'POST',
                    url:"/Panama/timeclock/apis/api/AddBackupEmail",
                    data: formData,
                    contentType: false,
                    cache: false,
                    processData:false,
                    success: function(data)
                    {                        
                        if( data.status == "success" )
                        {
                            l.ladda('stop');
                            swal_btn.click();
                        }
                        else if( data.status == "failed" )
                        {
                            l.ladda('stop');
                            swal_btn2.click();
                        }
                    },
                    error: function(data) 
                    {
                        alert("error");
                    }           

                });                
                return false; // extra insurance preventing the default form action
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Added Successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
                closeOnConfirm: false
            }, function () {
                window.location.assign("backup_email.php");
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: "Backup Email not Added.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
    });
</script>

</body>
</html>
