<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Add Category</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>

<body>
    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Add Category</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="categories.php">Categories</a>
                        </li>
                        <li class="active">
                            <strong>Add Category</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="add_category_form">
                                    <div class="form-group">
                                        <label>Category Name</label>
                                        <input type="text" id="name" name="name" placeholder="Enter Category Name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Category Symbol</label>
                                        <input type="text" id="symbol" name="symbol" placeholder="Enter Category Symbol" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Choose Category Color</label>
                                        <div class="row">
                                            <div class="col-xs-6 col-sm-4">               
                                                <input type="color" id="color" name="color" value="#ff0000" class="form-control" required>
                                            </div>
                                        </div>
                                    </div>                                      
                                    <div>
                                        <button style="background-color: #003399;border-color: #224ea6;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added Category -->
                                        <button id="swal_btn" type="button" style="display:none">
                                        <!-- Category not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            include 'footer.php';
            ?>
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <script>
    var errmsg;
    $(document).ready(function()
    {
        $("#side14").addClass("activeSM");
        $("#side14 a").css("color","#224ea6");
        
       $("#add_category_form").validate({
            rules: 
            {
                name: {
                   required: true
                },
                symbol: {
                   required: true,
                },
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );
                var swal_btn = document.getElementById("swal_btn");

                var name = $('#name').val();
                var symbol = $('#symbol').val();
                var color = $('#color').val();

                var formData = new FormData();
                formData.append("catname", name);
                formData.append("cat_symbol", symbol);
                formData.append("cat_color", color);
                    
                $.ajax
                ({
                    type:'POST',
                    url:"kos_apis/bkc_addcat.php",
                    data: formData,
                    contentType: false,
                    cache: false,
                    processData:false,
                    success: function(data)
                    {
                        var dat = jQuery.parseJSON(data);
                        if( dat.status == "success" )
                        {
                            l.ladda('stop');
                            swal_btn.click();
                        }
                        else if( dat.status == "failed" )
                        {
                            errmsg = dat.error;
                            l.ladda('stop');
                            swal_btn2.click();
                        }
                    },
                    error: function(data) 
                    {
                        alert("error");
                    }           
                });          
                return false; // extra insurance preventing the default form action
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Added Successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
                closeOnConfirm: false
            }, function () {
                window.location.assign("categories.php");
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: errmsg,
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
    });

</script>

</body>
</html>
