<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Add Employee</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
    if (!localStorage.login_var)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>

<body>

    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Add Employee</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="employees.php">Employees</a>
                        </li>
                        <li class="active">
                            <strong>Add Employee</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="add_employee_form">
                                    <div class="form-group">
                                        <label>First Name<span style="color:red">*</span></label>
                                        <input type="text" id="fname" name="fname" placeholder="Enter first name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Last Name<span style="color:red">*</span></label>
                                        <input type="text" id="lname" name="lname" placeholder="Enter last name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Username<span style="color:red">*</span></label>
                                        <input type="text" id="uname" name="uname" placeholder="Enter Username" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Choose 4-Digit Pin Code<span style="color:red">*</span></label>
                                        <input type="text" id="pincode" name="pincode" placeholder="Enter Pincode" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Rate per Hours ($)</label>
                                        <input type="number" id="rate_per_hour" name="rate_per_hour" placeholder="Enter Rate per Hour for an Employee" class="form-control">
                                    </div>
                                    <div class="form-group">
                					    <label for="special_employee">Special Employee:<span style="color:red">*</span></label>
                					    <div class="row">			
                					       <div class="col-xs-6 col-sm-6 col-md-6">
                						        <p id="NO_special_employee" class="btn btn-success" onclick="specialEmployee(this.id)" style="background-color: #224ea6 ; border-color: #224ea6 ; color: #fff">NO</p>
                					        </div>
                			                <div class="col-xs-6 col-sm-6 col-md-6" style="margin-bottom: 10px">
                						        <p id="YES_special_employee" class="btn btn-success" onclick="specialEmployee(this.id)" style="background-color: #fff; border-color: #224ea6 ; color: #224ea6">YES</p>
                					        </div>
                				        </div>
                					</div>
                                    <div class="form-group">
                                        <label>Email</label>
                                        <input type="email" id="email" name="email" placeholder="Enter email" class="form-control">
                                    </div>
                                    <div class="form-group">
                                        <label>Password</label>
                                        <input type="password" id="password" name="password" autocomplete="new-password" placeholder="Enter Password" class="form-control">
                                        <div class="input-group-append">
                                            <input type="checkbox">
                                            <small>Show Password</small>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label>Phone</label>
                                                <input type="text" id="number" name="number" placeholder="Enter phone #" class="form-control">
                                            </div>
                                            <div class="col-sm-6">
                                                <label>Carrier</label>
                                                <select class="form-control" id="carrier" name="carrier">
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>Email For SMS</label>
                                        <input type="email" id="s_email" name="s_email" placeholder="Enter email for sms" class="form-control" disabled="">
                                    </div>
                                    <div class="form-group">
                                        <label>Position<span style="color:red">*</span></label>
                                        <div id="positions_list">
                                            <!-- Dynamically Adding Positions-->
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>Role<span style="color:red">*</span></label>
                                        <select class="form-control" id="role" name="role" required="">
                                            <!--<option value="select" selected>Select Employee Role</option>-->
                                            <option value="Employee">Employee</option>
                                            <option value="Driver">Driver</option>
                                            <option value="Mechanic">Mechanic</option>
                                            <option value="Manager">Manager</option>
                                            <option value="Secretary">Secretary</option>
                                            <option value="Admin">Admin</option>
                                        </select>
                                    </div>  
                                    <div class="form-group">
                                        <label>Locations<span style="color:red">*</span></label>
                                        <div id="locations_list">
                                            <!-- Dynamically Adding Locations-->
                                        </div>
                                    </div>
                                    <div class="form-group">
                					    <label for="over_time">Over Time:<span style="color:red">*</span></label>
                					    <div class="row">			
                					       <div class="col-xs-6 col-sm-6 col-md-6">
                						        <p id="NO_overtime" class="btn btn-success" onclick="overTimeEmployee(this.id)" style="background-color: #fff; border-color: #224ea6 ; color: #224ea6">NO</p>
                					        </div>
                			                <div class="col-xs-6 col-sm-6 col-md-6" style="margin-bottom: 10px">
                						        <p id="YES_overtime" class="btn btn-success" onclick="overTimeEmployee(this.id)" style="background-color: #224ea6 ; border-color: #224ea6 ; color: #fff">YES</p>
                					        </div>
                				        </div>
                					</div>
                					<div class="form-group">
                					    <label for="automatic_deduction"><input id="automatic_deduction_lunch_check" value="" type="checkbox" name="automatic_deduction_lunch_check" /> Automatic Deduction for Lunch Break:</label>
                                        <div>
                                            Give to employee
                                            <input type="number" id="lunch_break_min" name="lunch_break_min" placeholder="Enter Break Time" class="form-control">
                                            min lunch Break, every
                                            <input type="number" id="lunch_break_hours" name="lunch_break_hours" placeholder="Enter Working Hours" class="form-control">
                                            hours in a day.
                                        </div>
                					</div>
                					<div class="form-group">
                					    <label for="automatic_deduction"><input id="automatic_deduction_break_check" value="" type="checkbox" name="automatic_deduction_break_check" /> Automatic Deduction for Break:</label>
                                        <div>
                                            Give to employee
                                            <input type="number" id="break_min" name="break_min" placeholder="Enter Break Time" class="form-control">
                                            min  Break, every
                                            <input type="number" id="break_hours" name="break_hours" placeholder="Enter Working Hours" class="form-control">
                                            hours in a day.
                                        </div>
                					</div>
                					<div class="form-group">
                					    <label for="complete_lunch_break"><input id="complete_lunch_break_check" value="" type="checkbox" name="complete_lunch_break_check" /> Complete Lunch Break:</label>
                                        <div>
                                            Employee have to Complete 
                                            <input type="number" id="complete_lunch_break" name="complete_lunch_break" placeholder="Enter Lunch Break Time" class="form-control">
                                            min  Lunch Break, Before he can Clock in.
                                        </div>
                					</div>
                					<div class="form-group">
                					    <label for="complete_break"><input id="complete_break_check" value="" type="checkbox" name="complete_break_check" /> Complete Break:</label>
                                        <div>
                                            Employee have to Complete 
                                            <input type="number" id="complete_break" name="complete_break" placeholder="Enter Break Time" class="form-control">
                                            min  Break, Before he can Clock in.
                                        </div>
                					</div>
                                    <div>
                                        <button style="background-color: #003399;border-color: #224ea6;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added Employee -->
                                        <button id="swal_btn" type="button" style="display:none"></button>
                                        <!-- Employee not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none"></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <?php
            include 'footer.php';
            ?>

        </div>
    </div>

    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
    
    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>
    
    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>
    
    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>
     <script src="js/plugins/validate/additional-methods.min.js"></script>
    
    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>
    
    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>
    
    <script>
        var errmsg;
        var deduction_lunch_break = 0;
        var deduction_break = 0;
        var complete_lunch_break = 0;
        var complete_break = 0;
        
        $(document).ready(function()
        {
            $("#side3").addClass("activeSM");
            $("#side3 a").css("color","#224ea6");
    
            viewCarrier();
            viewPositions();
            viewLocations();
            
            $('input:checkbox[name=automatic_deduction_lunch_check]').click(function()
            {
                if($(this).prop("checked") == true)
                {
                    deduction_lunch_break = 1;
                }
                else if($(this).prop("checked") == false)
                {
                    deduction_lunch_break = 0;
                }
            });
            
            $('input:checkbox[name=automatic_deduction_break_check]').click(function()
            {
                if($(this).prop("checked") == true)
                {
                    deduction_break = 1;
                }
                else if($(this).prop("checked") == false)
                {
                    deduction_break = 0;
                }
            });
            
            $('input:checkbox[name=complete_lunch_break_check]').click(function()
            {
                if($(this).prop("checked") == true)
                {
                    complete_lunch_break = 1;
                }
                else if($(this).prop("checked") == false)
                {
                    complete_lunch_break = 0;
                }
            });
            
            $('input:checkbox[name=complete_break_check]').click(function()
            {
                if($(this).prop("checked") == true)
                {
                    complete_break = 1;
                }
                else if($(this).prop("checked") == false)
                {
                    complete_break = 0;
                }
            });
    
            $("#add_employee_form").validate({
                rules: 
                {
                    fname: {
                       required: true
                    },
                    lname: {
                        required: true,
                    },
                    rate_per_hour: {
                        //required: true,
                        number: true
                    },
                    pincode: {
                        number: true,
                        minlength: 4,
                        maxlength:4,
                    },            
                    uname: {
                        required: true,
                        nowhitespace: true,
                        minlength: 3
                    },
                    /*password: {
                        required: true,
                    },   
                    number: {
                        required: true,
                        number: true
                    },
                    email: {
                        required: true,
                        email: true
                    },
                    s_email: {
                        required: true,
                        email: true
                    },*/  
                    role: {
                        required: true,
                    },
                },
                messages: 
                {
                    uname: {
                        nowhitespace: "Please remove all spaces.",
                        minlength: "Min length should be 4 characters",
                    },
                },
                submitHandler: function(form) 
                {
                    var l = $( '.ladda-button-demo' ).ladda();
                    l.ladda( 'start' );
    
                    var fname = $('#fname').val();
                    var lname = $('#lname').val();
                    var perhour_pay = $('#rate_per_hour').val();
                    if( perhour_pay )
	                {
	                    perhour_pay = perhour_pay;
	                }
	                else
	                {
	                    perhour_pay = "1";
	                }
	                
                    var pincode = $('#pincode').val();
                    var special_employee = $('#NO_special_employee').css("background-color");
	                if( special_employee == "rgb(34, 78, 166)")
	                {
	                    special_employee = "NO";
	                }
	                else
	                {
	                    special_employee = "YES";
	                }
                    var uname = $('#uname').val();
                    var password = $('#password').val();
                    var number = $('#number').val();
                    var carrier = $('#carrier').val();
                    var email = $('#email').val();
                    var s_email = number+"@"+carrier;
                    $('#s_email').val(s_email);
                    
                    var count = 0
                    var position;
                    $("input:checkbox[name=myCheckbox]:checked").each(function()
                    {
                        if( count == 0 )
                        {
                            position = $(this).val();
                            count++;
                        }
                        else
                        {
                            position = position + ", " + $(this).val();
                        }
                    });
                    var role = $('#role').val();
                    var countLocation = 0
                    var location;
                    $("input:checkbox[name=myCheckboxLocation]:checked").each(function()
                    {
                        if( countLocation == 0 )
                        {
                            location = $(this).val();
                            countLocation++;
                        }
                        else
                        {
                            location = location + ", " + $(this).val();
                        }
                    });
                    var over_time = $('#NO_overtime').css("background-color");
	                if( over_time == "rgb(34, 78, 166)")
	                {
	                    over_time = "NO";
	                }
	                else
	                {
	                    over_time = "YES";
	                }
	                
	                var temp1 = $('#lunch_break_min').val();
	                var temp2 = $('#lunch_break_hours').val();
	                var temp3 = $('#break_min').val();
	                var temp4 = $('#break_hours').val();
	                
	                var automatic_deduction_lunch_break;
	                var automatic_deduction_break;
	                
	                if( temp1 && temp2 )
	                {
    	                automatic_deduction_lunch_break = temp1 + "," + temp2;
    	                deduction_lunch_break = 0;
	                }
	                else
	                {
	                    if($('#automatic_deduction_lunch_check').prop("checked") == true)
                        {
                            deduction_lunch_break = 1;
                        }
                        else
                        {
	                        automatic_deduction_lunch_break = "0,0";
                        }
	                }
	                
	                if( temp3 && temp4 )
	                {
    	                automatic_deduction_break = temp3 + "," + temp4;
    	                deduction_break = 0;
	                }
	                else
	                {
	                    if($('#automatic_deduction_break_check').prop("checked") == true)
                        {
                            deduction_break = 1;
                        }
                        else
                        {
	                        automatic_deduction_break = "0,0";
                        }
	                }
	                
	                var temp5 = $('#complete_lunch_break').val();
	                var temp6 = $('#complete_break').val();
	                
	                if(temp5)
	                {
	                    complete_lunch_break = 0;
	                }
	                else
	                {
	                    if($('#complete_lunch_break_check').prop("checked") == true)
                        {
                            complete_lunch_break = 1;
                        }
                        else
                        {
	                        temp5 = "0";
                        }
	                }
	                
	                if(temp6)
	                {
	                    complete_break = 0;
	                }
	                else
	                {
	                    if($('#complete_break_check').prop("checked") == true)
                        {
                            complete_break = 1;
                        }
                        else
                        {
	                        temp6 = "0";
                        }
	                }
	                
	                var checkingRole = 1;
                   
                    if( role == "Admin")
                    {
                        if( password )
                        {
                            checkingRole = 1;
                        }
                        else
                        {
                            checkingRole = 0;
                        }
                    }
                    
                    if( checkingRole == 1 && count > 0 && countLocation > 0 &&
                        deduction_lunch_break == 0 && deduction_break == 0 && 
                        complete_lunch_break == 0 && complete_break == 0)
                    {
                        var formData = new FormData();
                        formData.append("emp_fname", fname);
                        formData.append("emp_lname", lname);
                        formData.append("perhour_pay", perhour_pay);
                        formData.append("emp_pincode", pincode);
                        formData.append("special_employee", special_employee);
                        formData.append("emp_username", uname);
                        formData.append("emp_pass", password);
                        formData.append("emp_phone", number);
                        formData.append("phone_carrier", carrier);
                        formData.append("emp_email", email);
                        formData.append("emp_emailSMS", s_email);
                        formData.append("position", position);
                        formData.append("emp_role", role);
                        formData.append("assign_location", location);
                        formData.append("overtime", over_time);
                        formData.append("automatic_deduction_lunch_break", automatic_deduction_lunch_break);
                        formData.append("automatic_deduction_break", automatic_deduction_break);
                        formData.append("complete_lunch", temp5);
                        formData.append("complete_break", temp6);
        
                        $.ajax
                        ({
                            type:'POST',
                            url:"kos_apis/add_employee.php",
                            data: formData,
                            contentType: false,
                            cache: false,
                            processData:false,
                            success: function(data)
                            {                        
                                var dat = jQuery.parseJSON(data);
                                if( dat.status == "success" )
                                {
                                    l.ladda('stop');
                                    swal_btn.click();
                                }
                                else if( dat.status == "failed" )
                                {
                                    errmsg = dat.error;
                                    l.ladda('stop');
                                    swal_btn2.click();
                                }
                            },
                            error: function(data) 
                            {
                                alert("error");
                                l.ladda('stop');
                            }           
                        });   
                    }
                    else
                    {
                        if( checkingRole == 0 )
                        {
                            alert("You must enter Password for ADMIN.");
                            l.ladda('stop');
                        }
                        else if( count == 0 )
                        {
                            alert("You must select Position for an Employee.");
                            l.ladda('stop');
                        }
                        else if( countLocation == 0 )
                        {
                            alert("You must assign a Location to an Employee.");
                            l.ladda('stop');
                        }
                        else if( deduction_lunch_break == 1 )
                        {
                            alert("You must enter Automatic Deduction for Lunch Break Time.");
                            l.ladda('stop');
                        }
                        else if( deduction_break == 1 )
                        {
                            alert("You must enter Automatic Deduction for Break Time.");
                            l.ladda('stop');
                        }
                        else if( complete_lunch_break == 1 )
                        {
                            alert("You must enter Complete Lunch Break Time.");
                            l.ladda('stop');
                        }
                        else if( complete_break == 1 )
                        {
                            alert("You must enter Complete Break Time.");
                            l.ladda('stop');
                        }
                    }
                    return false; // extra insurance preventing the default form action
                }
            });
    
            $('input[type="checkbox"]').click(function()
            {
                if($('input[type="checkbox"]').is(':checked') == true)
                {
                    $('#password').attr('type', 'text');
                }
                else
                {
                    $('#password').attr('type', 'password');
                }
            });
    
            $('#swal_btn').click(function(){
                swal({
                    title: "Added Successfully!",
                    text: "",
                    type: "success",
                    confirmButtonColor: "#003399",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("employees.php");
                });
            });
    
            $('#swal_btn2').click(function(){
                swal({
                    title: "Operation Unsuccessfull!",
                    text: errmsg,
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });
        
        function viewCarrier()
        {
            var $list = $("#carrier");
            $list.empty();
            $.ajax({
                url: "kos_apis/view_phonecarrier.php",
                type: "GET",
                success: function(data)
                {   
                    var dat = jQuery.parseJSON(data);
                    if ( dat.status == "success")
                    {
                        //var vehicle_type = '<option value="select" selected>Select type of scooter</option>';
                        //$list.append(vehicle_type);
                        $.each(dat.Data, function(index,obj) 
                        {
                            if ( obj.active == "0")
                            {
                                //Do Nothing
                            }
                            else
                            {
                                $list.append('<option value="'+obj.carrier_gateway+'">'+obj.carrier_name+'</option>');
                            }
                        });
                    }
                    else
                    {
                        alert("Add Carrier");
                    }
                },
                error: function(data)
                {
                }           
            });        
        }
        
        function viewPositions()
        {
            var $list = $("#positions_list");
            $list.empty();
            
            $.ajax({
                url: "/Panama/timeclock/apis/api/ViewAllPositions",
                type: "GET",
                success: function(data)
                {   
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {
                            if ( obj.active == "0")
                            {
                                //Do Nothing
                            }
                            else
                            {
                                $list.append('<p><input id="'+obj.pos_id+'" value="'+obj.position+'" type="checkbox" name="myCheckbox" /> '+obj.position+'</p>');
                            }
                        });
                    }
                    else
                    {
                        alert("Add Positions");
                    }
                },
                error: function(data)
                {
                }           
            });        
        }
        
        function viewLocations()
        {
            var $list = $("#locations_list");
            $list.empty();
            
            $.ajax({
                url: "kos_apis/view_all_location.php",
                type: "GET",
                success: function(result)
                {   
                    var data = jQuery.parseJSON(result);
                    
                    if ( data.status == "success")
                    {
                        $.each(data.Data, function(index,obj) 
                        {
                            if ( obj.location_active == "0")
                            {
                                //Do Nothing
                            }
                            else
                            {
                                $list.append('<p><input id="'+obj.location_id+'" value="'+obj.location_name+'" type="checkbox" name="myCheckboxLocation" /> '+obj.location_name+'</p>');
                            }
                        });
                    }
                    else
                    {
                        alert("Add Location");
                    }
                },
                error: function(data)
                {
                }           
            });        
        }
        
        function specialEmployee(id)
        {
            if( id == "YES_special_employee")
            {
                $('#YES_special_employee').css({
                    "background-color": "#224ea6",
                    "color": "#fff"
                });
                
                $('#NO_special_employee').css({
                    "background-color": "#fff",
                    "color": "#224ea6"
                });
            }
            else if( id == "NO_special_employee")
            {
                $('#NO_special_employee').css({
                    "background-color": "#224ea6",
                    "color": "#fff"
                });
                
                $('#YES_special_employee').css({
                    "background-color": "#fff",
                    "color": "#224ea6"
                });
            }
        }
        
        function overTimeEmployee(id)
        {
            if( id == "YES_overtime")
            {
                $('#YES_overtime').css({
                    "background-color": "#224ea6",
                    "color": "#fff"
                });
                
                $('#NO_overtime').css({
                    "background-color": "#fff",
                    "color": "#224ea6"
                });
            }
            else if( id == "NO_overtime")
            {
                $('#NO_overtime').css({
                    "background-color": "#224ea6",
                    "color": "#fff"
                });
                
                $('#YES_overtime').css({
                    "background-color": "#fff",
                    "color": "#224ea6"
                });
            }
        }
    
    </script>
</body>
</html>
