<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Add Vehicle</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">
    
    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>

<body>

    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Add Vehicle</strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="vehicles.php">Vehicles</a>
                        </li>
                        <li class="active">
                            <strong>Add Vehicle</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="add_vehicle_form">
                                    <div class="form-group">
                                        <label>Scooter#</label>
                                        <input type="number" id="scooter_number" name="scooter_number" placeholder="Enter scooter #" class="form-control" >
                                    </div>
                                    <!--<div class="form-group">
                                        <label>Tag#</label>
                                        <input type="text" id="tag_number" name="tag_number" placeholder="Enter tag #" class="form-control" >
                                    </div>
                                    <div class="form-group">
                                        <label>Vin#</label>
                                        <input type="text" id="vin_number" name="vin_number" placeholder="Enter vin #" class="form-control" >
                                    </div>
                                    <div class="form-group">
                                        <label>Police#</label>
                                        <input type="text" id="police_number" name="police_number" placeholder="Enter police #" class="form-control" >
                                    </div>
                                    <div class="form-group">
                                        <label>Medallion#</label>
                                        <input type="text" id="medallion_number" name="medallion_number" placeholder="Enter medallion #" class="form-control" >
                                    </div>
                                    <div class="form-group">
                                        <label>Make</label>
                                        <input type="text" id="make" name="make" placeholder="Enter Make" class="form-control" >
                                    </div>
                                    <div class="form-group">
                                        <label>Model</label>
                                        <input type="text" id="model" name="model" placeholder="Enter model" class="form-control" >
                                    </div>  
                                    <div class="form-group">
                                        <label>Year</label>
                                        <input type="text" id="year" name="year" placeholder="Enter year" class="form-control" >
                                    </div> 
                                    <div class="form-group">
                                        <label>Size(cc)</label>
                                        <input type="text" id="size" name="size" placeholder="Enter size" class="form-control" >
                                    </div> 
                                    <div class="form-group">
                                        <label>Cost</label>
                                        <input type="number" id="cost" name="cost" placeholder="Enter cost" class="form-control" >
                                    </div> 
                                    <div class="form-group">
                                        <label>Min for Sale</label>
                                        <input type="number" id="min_for_sale" name="min_for_sale" placeholder="Enter model" class="form-control" >
                                    </div> 
                                    <div class="form-group">
                                        <label>Min for Rent</label>
                                        <input type="number" id="min_for_rent" name="min_for_rent" placeholder="Enter model" class="form-control" >
                                    </div> 
                                    <div class="form-group">
                                        <label>Mileage</label>
                                        <input type="text" id="mileage" name="mileage" placeholder="Enter model" class="form-control" >
                                    </div>  
                                    <div class="form-group">
                                        <label>Sold</label>
                                        <input type="text" id="sold" name="sold" placeholder="Enter model" class="form-control" >
                                    </div> 
                                    <div class="form-group">
                                        <label>Scooter Info</label>
                                        <input type="text" id="Vehicle_info" name="Vehicle_info" placeholder="Enter model" class="form-control" >
                                    </div>-->
                                    <div class="form-group">
                                        <label>Type of scooter</label>
                                        <select class="form-control" id="type_of_scooter" name="type_of_scooter">
                                            <!-- Adding Scooter Types Dynamically -->
                                        </select>
                                    </div>
                                    <div>
                                        <button style="background-color: #003399;border-color: #224ea6;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                            <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added Vehicle -->
                                        <button id="swal_btn" type="button" style="display:none">
                                        <!-- Vehicle not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
                include 'footer.php';
            ?>
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <script>
    var errmsg;
    
    $(document).ready(function()
    {
        $("#side4").addClass("activeSM");
        $("#side4 a").css("color","#224ea6");

        viewVehicleType();

        $("#add_vehicle_form").validate({
            rules: 
            {
                scooter_number: {
                   required: true,
                   number: true
                },
                /*tag_number: {
                   required: true,
                   number: true
                },
                vin_number: {
                   required: true,
                   number: true
                },
                police_number: {
                   required: true,
                   number: true
                },
                medallion_number: {
                   required: true,
                   number: true
                },
                make: {
                   required: true,
                },             
                model: {
                   required: true,
                },
                year: {
                   required: true,
                },
                size: {
                   required: true,
                },
                cost: {
                   required: true,
                   number: true
                },
                min_for_sale: {
                   required: true,
                   number: true
                },
                min_for_rent: {
                   required: true,
                   number: true
                },
                mileage: {
                   required: true,
                },
                sold: {
                   required: true,
                },
                Vehicle_info: {
                   required: true,
                },
                type_of_scooter: {
                   required: true,
                }*/
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );
                
                var scooter_number = $('#scooter_number').val();
                var tag_number = $('#tag_number').val();
                var vin_number = $('#vin_number').val();
                var police_number = $('#police_number').val();
                var medallion_number = $('#medallion_number').val();
                var make = $('#make').val();
                var model = $('#model').val();
                var year = $('#year').val();
                var size = $('#size').val();
                var cost = $('#cost').val();
                var min_for_sale = $('#min_for_sale').val();
                var min_for_rent = $('#min_for_rent').val();
                var mileage = $('#mileage').val();
                var sold = $('#sold').val();
                var Vehicle_info = $('#Vehicle_info').val();
                var type_of_scooter = $('#type_of_scooter').val();

                var formData = new FormData();
                formData.append("vehicleNo", scooter_number);
                formData.append("vehicle_tagNo", "tag_number");
                formData.append("vehicle_vinNo", "vin_number");                
                formData.append("vehicle_policeNo", "police_number");
                formData.append("vehicle_medallionNo", "medallion_number");
                formData.append("vehicle_make", "make");
                formData.append("vehicle_model", "model");
                formData.append("vehicle_year", "year");
                formData.append("vehicle_size", "size");
                formData.append("vehicle_cost", "cost");
                formData.append("vehicle_minforsale", "min_for_sale");
                formData.append("vehicle_minforrent", "min_for_rent");
                formData.append("vehicle_mileage", "mileage");
                formData.append("vehicle_sold", "sold");
                formData.append("vehicle_info", "Vehicle_info");
                formData.append("vehicle_type", type_of_scooter);
                
                
                $.ajax
                   ({
                        type:'POST',
                        url:"kos_apis/add_vehicle.php",
                        data: formData,
                        contentType: false,
                        cache: false,
                        processData:false,
                        success: function(data)
                        {                           
                            var dat = jQuery.parseJSON(data);
                            if( dat.status == "success" )
                            {
                                l.ladda( 'stop' );
                                swal_btn.click();
                            }
                            else if( dat.status == "failed" )
                            {
                                l.ladda('stop');
                                errmsg = dat.error;
                                swal_btn2.click();
                            }
                        },
                        error: function(data) 
                        {
                            alert("error");
                        }           

                    });                
                return false; // extra insurance preventing the default form action 
            }
       });

        $('#swal_btn').click(function(){
            swal({
                title: "Added Successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
                closeOnConfirm: false
            }, function () {
                window.location.assign("vehicles.php");
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                title: "Operation Unsuccessfull!",
                text: errmsg,
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
    });
    
    function viewVehicleType()
    {
        var $list = $("#type_of_scooter");
        $list.empty();
        $.ajax({
            url: "kos_apis/view_vehicle_types.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    $.each(dat.types, function(index,obj) 
                    {
                        if ( obj.active == "0")
                        {
                            //Do Nothing
                        }
                        else
                        {
                            vehicle_type = '<option value="'+obj.type_name+'">'+obj.type_name+'</option>';
                            $list.append(vehicle_type);
                        }
                    });
                }
                else
                {
                    $list.append('<option value="select" selected>Select type of scooter</option>');
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    </script>
</body>
</html>
