<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Age Setup</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>

<body>

    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Age Setup</strong></h2>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <div class="form-group">
                                    <label>Age Setup Limit</label>
                                    <input type="number" id="age" name="age" placeholder="Age Setup Limit" class="form-control" disabled="">
                                </div>                         
                                <div>
                                    <a href="update_age_setup.php">
                                        <button style="background-color: #003399;border-color: #224ea6;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Edit Age Limit</span><span class="ladda-spinner"></span>
                                        </button>
                                    </a>
                                    <!-- Successfully Updated Age -->
                                    <button id="swal_btn" type="button" style="display:none"></button>
                                    <!-- Age not Updated -->
                                    <button id="swal_btn2" type="button" style="display:none"></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>

            <?php
            include 'footer.php';
            ?>

        </div>
    </div>

<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- FooTable -->
<script src="js/plugins/footable/footable.all.min.js"></script>

<!-- Page-Level Scripts -->
<script>

    $(document).ready(function() 
    {
        $("#side9").addClass("activeSM");
        $("#side9 a").css("color","#224ea6");

        viewAgeSetup();
        //Empty List
        $('#swal_btn').click(function(){
            swal({
                 title: "List is Empty!",
                text: "Please add Age Setup.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
                closeOnConfirm: false
            }, function () {
                window.location.assign("add_age_setup.php");
            });
        });

        //Delete Row
        $('#swal_btn2').click(function(){
            swal({
                title: "Age Setup Deleted!",
                text: "",
                type: "success",
                confirmButtonColor: "#DD6B55",
            });
        });
    });

    function viewAgeSetup()
    {
        var $list = $("#age_setup_list");
        $list.empty();
        $.ajax({
            url: "kos_apis/view_age.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    $('#age').val(dat.age);
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }
</script>
</body>
</html>
