<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | See All Deals</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
        .tab-group
        {
           position: relative;
           vertical-align: middle;
           zoom: 1; /* Fix for IE7 */
           *display: inline; /* Fix for IE7 */
        }
        .tab-group > li
        {
            background-color: #eeeeee;
            border-radius: 4px;
            position: relative;
            float: left;
        }
        .nav > li.active 
        {
            border-left: 4px solid #566b8a;
            background: #566b8a;
        }
        .tab-group > li.active > a, 
        .tab-group > li.active > a:hover, 
        .tab-group > li.active > a:focus
        {
            background-color: #566b8a;
            color: #fff;
        }
        .tab-group > li > a 
        {
            color: #333;
            border-radius: 0;
            text-align: center;
        }
        .tab-group > li > a:hover 
        {
            border-radius: 4px;
        }
        
        .tab-group li + li 
        {
            margin-left: -1px;
        }
        
        .tab-group > li:not(:first-child):not(:last-child),
        .tab-group > li:not(:first-child):not(:last-child) > a:hover 
        {
          border-radius: 0;
        }
        .tab-group > li:first-child,
        .tab-group > li:first-child > a:hover 
        {
            margin-left: 0;
        }
        .tab-group > li:first-child:not(:last-child),
        .tab-group > li:first-child:not(:last-child) > a:hover 
        {
          border-top-right-radius: 0;
          border-bottom-right-radius: 0;
        }
        .tab-group > li:last-child:not(:first-child),
        .tab-group > li:last-child:not(:first-child) > a:hover 
        {
          border-top-left-radius: 0;
          border-bottom-left-radius: 0;
        }
    </style>
    <script>
        if (!localStorage.login_var)
        {
            window.stop();
            window.location.replace("index.php");
        }
    </script>
</head>
<body>
    <div id="wrapper">
        
        <?php
            include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                    include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>See All Deals</strong></h2>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">    
                    <div class="col-md-6 col-sm-8 col-xs-12">
                        <div class="input-group">
                            <div class="input-group-btn search-panel">
                                <button style="background-color: #566b8a;color: white;" type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                                    <span id="search_concept">Filter by</span> <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu" role="menu">
                                  <li><a href="#Phone Number">Phone Number</a></li>
                                  <!--<li><a href="#Date&Time">Date and Time</a></li>-->
                                  <!--<li><a href="#Locker Number">Locker Number</a></li>-->
                                  <li class="divider"></li>
                                  <li><a href="#All">All</a></li>
                                </ul>
                            </div>
                            <input type="hidden" name="search_param" value="all" id="search_param">         
                            <input type="text" class="form-control" id="search_box" name="search_box" placeholder="Search term...">
                            <span class="input-group-btn">
                                <button onclick="searchFilter()" class="btn btn-default" type="button"><span class="glyphicon glyphicon-search"></span></button>
                            </span>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>SNo</th>
                                            <th>Name</th>
                                            <th>Age</th></th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="deals_list">
                                       <!-- Dynamically appending Employees List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
                include 'footer.php';
            ?>
            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none"></button>

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete Employee</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the Employee?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deleteEmployee()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- FooTable -->
    <script src="js/plugins/footable/footable.all.min.js"></script>

    <!-- Page-Level Scripts -->
    <script>
        var delete_employee;

        $(document).ready(function() 
        {
            $("#side22").addClass("activeSM");
            $("#side22 a").css("color","#224ea6");

            viewDeals();

            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "Please add Deals.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("add_deals.php");
                });
            });

            //Delete Row
            $('#swal_btn2').click(function(){
                swal({
                    title: "Deal Deleted!",
                    text: "",
                    type: "success",
                    confirmButtonColor: "#DD6B55",
                });
            });

            //Active Row
            $('#swal_btn3').click(function(){
                swal({
                     title: "Activated/Deactivated",
                    text: "Deal Activated/Deactivated Successfully.",
                    type: "success",
                    confirmButtonColor: "#003399",
                });
            });
        });

        function viewDeals()
        {
            var $list = $("#deals_list");
            $list.empty();
            $.ajax({
                url: "BigAppLar/apis/api/CustomerSearch",
                type: "GET",
                data: { user_phone : 'All' },
                success: function(data)
                {   
                    var count = 1;
                    
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {
                            // if( obj.emp_active == '0')
                            // {
                            //     var status = '<span id="'+obj.emp_username+'" onclick ="statusChange(this.id);" class="label label-danger">Inactive</span>';
                            // }
                            // else
                            // {
                            //     var status = '<span id="'+obj.emp_username+'" onclick ="statusChange(this.id);" class="label label-primary">Active</span>';
                            // }
                            $.each(obj.customer_details, function(index2,obj2) 
                            {
                                var temp = obj2.age.split(',');
                                var age  = temp[0];//temp.split(',');
                                $list.append('<tr>'+
                                                '<td><strong>'+count+'</strong></td>'+
                                                '<td>'+obj2.fname+' '+obj2.lname+'</td>'+
                                                '<td>'+age+'</td>'+
                                                '<td>'+status+'</td>'+
                                                '<td>'+
                                                    '<div class="btn-group">'+
                                                        '<button id="'+obj.emp_username+'" onclick ="saveEmployee(this.id);" class="btn-white btn btn-xs">Edit</button>'+
                                                        //'<button id="'+obj.emp_username+'" onclick ="deleteEmployeeModal(this.id);" class="btn-white btn btn-xs">Delete</button>'+
                                                    '</div>'+
                                                '</td>'+
                                            '</tr>');
                            });
                            count++;
                        });
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }

        function deleteEmployeeModal(id)
        {
            $('#deleteModal').modal('show');
            delete_employee = id;
        }


        function deleteEmployee()
        {
            $('#deleteModal').modal('hide');

            var emp_id = delete_employee;
            $.ajax({            
                url: "kos_apis/delete_employee.php",
                type: "get",
                data: {"emp_username": emp_id},
                success: function(result)
                {
                    var data = jQuery.parseJSON(result);
                    if(data.status == "success")
                    {
                        swal_btn2.click();
                        viewDeals();
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });
        }

        function saveEmployee(id)
        {
            var emp_id = id;
            localStorage.setItem("emp_id",emp_id);
            window.location.href = "update_employee.php";
            
        }

        function statusChange(id)
        {
            var emp_id = id;
            $.ajax({            
                url: "kos_apis/active_employee.php",
                type: "get",
                data: {"emp_username": emp_id},
                success: function(result)
                {
                    var data = jQuery.parseJSON(result);
                    if(data.status == "success")
                    {
                        swal_btn3.click();
                        viewDeals();
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });        
        }
    </script>
</body>
</html>
