<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Backup Email</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
    if (!localStorage.login_var)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>

<body>

    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Backup Email</strong></h2>
                    <a href="add_backup_email.php">
                        <button type="button" class="btn btn-default btn-sm">
                            <span class="glyphicon glyphicon-plus"></span> Add Backup Email
                        </button>
                    </a>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>
                                            <th>S.No</th>                                            
                                            <th>Backup Email</th>
                                            <th>Type</th>
                                            <th>Status</th>
                                            <!--<th>Action</th>-->
                                        </tr>
                                    </thead>
                                    <tbody id="backup_email_list">
                                       <!-- Dynamically appending Locations List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none"></button>

            <?php
            include 'footer.php';
            ?>

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete Backup Email</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the Backup Email?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deleteBackupEmail()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->

    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
    
    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>
    
    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>
    
    <!-- FooTable -->
    <script src="js/plugins/footable/footable.all.min.js"></script>
    
    <!-- Page-Level Scripts -->
    <script>
        var delete_backup_email;
    
        $(document).ready(function() 
        {
            $("#side16").addClass("activeSM");
            $("#side16 a").css("color","#224ea6");
    
            viewBackupEmailList();
            
            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "Please add Backup Email.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("add_backup_email.php");
                });
            });
    
            //Delete Row
            $('#swal_btn2').click(function(){
                swal({
                    title: "Backup Email Deleted!",
                    text: "",
                    type: "success",
                    confirmButtonColor: "#DD6B55",
                });
            });
    
            //Active Row
            $('#swal_btn3').click(function(){
                swal({
                    title: "Activated/Deactivated",
                    text: "Backup Email Activated/Deactivated Successfully.",
                    type: "success",
                    confirmButtonColor: "#003399",
                });
            });
        });
    
        function viewBackupEmailList()
        {
            var $list = $("#backup_email_list");
            $list.empty();
            
            $.ajax({
                url: "/Panama/timeclock/apis/api/ViewBackupEmail",
                type: "GET",
                success: function(data)
                {   
                    var count = 1;
                    
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {
                            if( obj.active == '0')
                            {
                                var status = '<span id="'+obj.be_id+'" style="cursor:pointer" onclick ="statusChange(this.id);" class="label label-danger">Inactive</span>';
                            }
                            else
                            {
                                var status = '<span id="'+obj.be_id+'" style="cursor:pointer" onclick ="statusChange(this.id);" class="label label-primary">Active</span>';
                            }
                            $list.append('<tr>'+
                                            '<td><strong>'+count+'</strong></td>'+
                                            '<td>'+obj.email_id+'</td>'+
                                            '<td>'+obj.type+'</td>'+
                                            '<td>'+status+'</td>'+
                                            '<td>'+
                                                '<div class="btn-group">'+
                                                    //'<button id="'+obj.be_id+'" onclick ="deleteBackupEmailModal(this.id);" class="btn-white btn btn-xs">Delete</button>'+
                                                '</div>'+
                                            '</td>'+
                                        '</tr>');
                            count++;
                        });
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }
    
        function deleteBackupEmailModal(id)
        {
            $('#deleteModal').modal('show');
            delete_backup_email = id;
        }
    
        function deleteBackupEmail()
        {
            $('#deleteModal').modal('hide');
            
            var backup_email_id = delete_backup_email;
            
            $.ajax({            
                url: "/Panama/timeclock/apis/api/DeleteBackupEmail",
                type: "get",
                data: {"be_id": backup_email_id},
                success: function(data)
                {
                    if(data.status == "success")
                    {
                        swal_btn2.click();
                        viewBackupEmailList();
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });
        }
    
        function statusChange(id)
        {
            var backup_email_id = id;
            
            $.ajax({            
                url: "/Panama/timeclock/apis/api/ActiveBackupEmail",
                type: "get",
                data: {"be_id": backup_email_id},
                success: function(data)
                {
                    if(data.status == "success")
                    {
                        swal_btn3.click();
                        viewBackupEmailList();
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });        
        }
    </script>
</body>
</html>
