<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | See All Deals</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
        .tab-group
        {
           position: relative;
           vertical-align: middle;
           zoom: 1; /* Fix for IE7 */
           *display: inline; /* Fix for IE7 */
        }
        .tab-group > li
        {
            background-color: #eeeeee;
            border-radius: 4px;
            position: relative;
            float: left;
        }
        .nav > li.active 
        {
            border-left: 4px solid #566b8a;
            background: #566b8a;
        }
        .tab-group > li.active > a, 
        .tab-group > li.active > a:hover, 
        .tab-group > li.active > a:focus
        {
            background-color: #566b8a;
            color: #fff;
        }
        .tab-group > li > a 
        {
            color: #333;
            border-radius: 0;
            text-align: center;
        }
        .tab-group > li > a:hover 
        {
            border-radius: 4px;
        }
        
        .tab-group li + li 
        {
            margin-left: -1px;
        }
        
        .tab-group > li:not(:first-child):not(:last-child),
        .tab-group > li:not(:first-child):not(:last-child) > a:hover 
        {
          border-radius: 0;
        }
        .tab-group > li:first-child,
        .tab-group > li:first-child > a:hover 
        {
            margin-left: 0;
        }
        .tab-group > li:first-child:not(:last-child),
        .tab-group > li:first-child:not(:last-child) > a:hover 
        {
          border-top-right-radius: 0;
          border-bottom-right-radius: 0;
        }
        .tab-group > li:last-child:not(:first-child),
        .tab-group > li:last-child:not(:first-child) > a:hover 
        {
          border-top-left-radius: 0;
          border-bottom-left-radius: 0;
        }
    </style>
  
</head>
<body>
    <div id="wrapper">
        
        <?php
            include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                    include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>See All Deals</strong></h2>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
              
                
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>SNo</th>
                                            <th>Nick Name</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="deals_list">
                                       <!-- Dynamically appending Employees List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
                include 'footer.php';
            ?>
            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none"></button>

        </div>
    </div>

    
 


    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- FooTable -->
    <script src="js/plugins/footable/footable.all.min.js"></script>

    <!-- Page-Level Scripts -->
    <script>
        var baseUrl= "/Panama/BigApp/kos_apis/";
        var customer_details;

        $(document).ready(function() 
        {
            $("#side22").addClass("activeSM");
            $("#side22 a").css("color","#224ea6");

            viewDeals();

            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "Please add Deals.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                });
            });

          
            //Active Row
            $('#swal_btn3').click(function(){
                swal({
                     title: "Activated/Deactivated",
                    text: "Deal Activated/Deactivated Successfully.",
                    type: "success",
                    confirmButtonColor: "#003399",
                });
            });
        });

        function viewDeals()
        {
            var $list = $("#deals_list");
            $list.empty();
            
            var count = 1;
             var customer_timestamp;
            
             
            var data = jQuery.parseJSON(localStorage.deals_details);
            $.each(data.order_details, function(index,obj) 
            {
                 customer_timestamp = obj.timestamp;
                 
                        var differnceTime = timeExp(customer_timestamp);

                        if( differnceTime > 4 )
                        {
                          
                           
                        }
                        else
                        {
                 
                            $list.append('<tr>'+
                                        
                                '<td><strong>'+count+'</strong></td>'+
                                '<td>'+obj.nick_name+'</td>'+
                                
                                '<td>'+
                                    '<div class="btn-group">'+
                                        '<button id="'+obj.OTP_user+'_'+obj.user_phone+'" onclick ="chooseDeal(this.id);" class="btn-white btn btn-xs">Choose Deal</button>'+
                                    '</div>'+
                                '</td>'+
                            '</tr>');
                            
                            
                count++;
                       
                        }
                       
                        });
        }
        
        function chooseDeal(id)
        {
            var temp = id.split('_');
            var user_otp = temp[0];
            var user_phone = temp[1];
            
            $.ajax
            ({
                url: baseUrl + "view_order_customer.php",
                type:'GET',                        
                data: { "user_phone" : user_phone , "otp" : user_otp },                    
                success: function(data)
                {
                    var dat = jQuery.parseJSON(data);
                    if( dat.status == "success" )
                    {
                        var customer_timestamp;

                        $.each(dat.order_details, function(index,obj) 
                        {
                            customer_timestamp = obj.timestamp;
                        });

                        var differnceTime = timeExp(customer_timestamp);

                        if( differnceTime > 4 )
                        {
                            alert("Deal is expired");
                        }
                        else
                        {
                            localStorage.setItem("customer_login_deal","login");
                            localStorage.setItem("deal_details",data);
                            window.location.assign("deal_details.php");
                        }
                    }
                    else if( dat.status == "failed" )
                    {
                        alert("Deal is expired");
                    }
                },
                error: function(data) 
                {
                    alert("error");
                    l.ladda('stop');
                }           

            });        
        }
       
        function timeExp(timestamp)
        {
            timestamp = dateTime(timestamp);
            var saveTime = new Date(timestamp + 'Z');
            saveTime.toLocaleDateString();
        
            var currentTime= new Date();
            currentTime+'z';
            result= Math.floor((Math.abs(currentTime-saveTime))/(1000*60*60));
            
            return result;
        }
        
        function dateTime(date)
        {
            var temp = date.split(" ");
            var timestamp;
        
            if( temp[2].toLowerCase() == "am" )
            {
                timestamp = temp[0] + " " + temp[1];
            }
            else
            {
                var time = temp[1].split(":");
                var hours = parseInt(time[0]) + 12;
                timestamp = temp[0] + " " + hours + ":" + time[1];
            }  
        
            return timestamp;
        }
      

        

    </script>
</body>
</html>
