<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Fees</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>

<body>

    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>FEES</strong></h2>
                    <a href="add_fees.php">
                        <button type="button" class="btn btn-default btn-sm">
                            <span class="glyphicon glyphicon-plus"></span> Add Fees
                        </button>
                    </a>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>
                                            <th>SNo</th>                                            
                                            <th>Type</th>
                                            <th>Charges</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="fees_list">
                                       <!-- Dynamically appending Locations List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none"></button>
            <?php
                include 'footer.php';
            ?>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete Fees</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the Fees for <font id="fee_type_name"></font>?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deleteFees()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->



<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- FooTable -->
<script src="js/plugins/footable/footable.all.min.js"></script>

<!-- Page-Level Scripts -->
<script>
    var delete_fees_id;

    $(document).ready(function() 
    {
        $("#side30").addClass("activeSM");
        $("#side30 a").css("color","#224ea6");

        viewFees();
        //Empty List
        $('#swal_btn').click(function(){
            swal({
                 title: "List is Empty!",
                text: "Please add Fees.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
                closeOnConfirm: false
            }, function () {
                window.location.assign("add_fees.php");
            });
        });

        //Delete Row
        $('#swal_btn2').click(function(){
            swal({
                title: "Fees Type Deleted!",
                text: "",
                type: "success",
                confirmButtonColor: "#DD6B55",
            });
        });

        //Active Row
        $('#swal_btn3').click(function(){
            swal({
                 title: "Activated/Deactivated",
                text: "Fees type Activated/Deactivated Successfully.",
                type: "success",
                confirmButtonColor: "#003399",
            });
        });
    });

    function viewFees()
    {
        var $list = $("#fees_list");
        $list.empty();
        $.ajax({
            url: "/Panama/BigApp/BigAppLar/apis/api/ViewFees",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                if ( data.status == "success")
                {
                    $.each(data.data, function(index,obj) 
                    {
                        if( obj.active == '0')
                        {
                            var status = '<span id="'+obj.id+'" onclick ="statusChange(this.id);" class="label label-danger">Inactive</span>';
                        }
                        else
                        {
                            var status = '<span id="'+obj.id+'" onclick ="statusChange(this.id);" class="label label-primary">Active</span>';
                        }
                        $list.append('<tr>'+
                                        '<td><strong>'+count+'</strong></td>'+
                                        '<td>'+obj.type+'</td>'+
                                        '<td>'+obj.charges+'</td>'+
                                        '<td>'+status+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+obj.id+'" onclick ="saveVehicleType(this.id);" class="btn-white btn btn-xs">Edit</button>'+
                                                '<button id="'+obj.id+'_'+obj.type+'" onclick ="deleteFeesModal(this.id);" class="btn-white btn btn-xs">Delete</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>');
                        count++;
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function deleteFeesModal(id)
    {
        var temp = id.split("_");
        $('#fee_type_name').html(temp[1]);
        
        $('#deleteModal').modal('show');
        delete_fees_id = temp[0];
    }

    function deleteFees()
    {
        $('#deleteModal').modal('hide');
        
        var fees_id = delete_fees_id;
        $.ajax({            
            url: "/Panama/BigApp/BigAppLar/apis/api/DeleteFees",
            type: "get",
            data: {"id": fees_id},
            success: function(data)
            {
                if(data.status == "success")
                {
                    swal_btn2.click();
                    viewFees();
                }
                else if (data.status == "failed")
                {
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });
    }

    function saveVehicleType(id)
    {
        var fees_type_id = id;
        localStorage.setItem("fees_type_id",fees_type_id);
        window.location.href = "update_fees.php";
    }

    function statusChange(id)
    {
        var fees_id = id;
        $.ajax({            
            url: "/Panama/BigApp/BigAppLar/apis/api/ActiveFees",
            type: "get",
            data: {"id": fees_id},
            success: function(data)
            {
                if(data.status == "success")
                {
                    swal_btn3.click();
                    viewFees();
                }
                else if (data.status == "failed")
                {
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });        
    }
</script>
</body>
</html>