<!DOCTYPE html>
<html>
<head>
    <title>King Of Scooters | Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    
    <style>
    body {font-family: Arial, Helvetica, sans-serif;}
    
    .imgcontainer {
        text-align: center;
        margin: 24px 0 12px 0;
    }
    
    img.avatar {
        width: 40%;
        border-radius: 50%;
    }
    
    .container {
        padding: 16px;
    }
    </style>
    
    <script>
        if (localStorage.login_var)
        {
            window.stop();
            window.location.replace("employees.php");
        }
    </script>
</head>
<body>
      <div class="imgcontainer">
        <img src="img/logo.png" width="150">
      </div>
    
      <div class="container">
        <div class="row">
            <div class="col-sm-3"></div>
            <div class="col-sm-6">
                <form id="loginForm">
                    <div class="form-group">
                        <label>Username</label>
                        <input type="text" id="uname" name="uname" placeholder="Username" class="form-control" required>
                    </div> 
                    <div class="form-group">
                        <label>Password</label>
                        <input type="password" id="psw" name="psw" placeholder="Password" class="form-control" required>
                    </div> 
                    <div>
                        <button style="background-color: #003399;border-color: #224ea6;color: white; width: 100%; height: 40px" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                <span class="ladda-label" style="font-size:20px">Submit</span><span class="ladda-spinner"></span>
                        </button>
                    </div>
                </form>
            </div>
            <div class="col-sm-3"></div>
        </div>
      </div>

    <!-- Successfully Added Vehicle Type -->
    <button id="swal_btn" type="button" style="display:none"></button>
    <!-- Vehicle Type not  Added -->
    <button id="swal_btn2" type="button" style="display:none"></button>
    
    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    
    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>
    
    <script type="text/javascript">
        var errmsg;
        
        $(document).ready(function (e) 
        {
            $("#loginForm").validate({
                rules: 
                {
                    uname: {
                       required: true,
                    },
                    psw: {
                       required: true,
                    },
                },
                messages: 
                {
                },
                submitHandler: function(form) 
                {
                    var l = $( '.ladda-button-demo' ).ladda();
                    l.ladda( 'start' );
    
                    var Username = $('#uname').val();
                    var Password = $('#psw').val();
    
                    var formData = new FormData();
                    formData.append("emp_username", Username);
                    formData.append("emp_pass", Password);
                                        
                    $.ajax
                    ({
                        type:'POST',
                        url:"kos_apis/login_admin.php",
                        data: formData,
                        contentType: false,
                        cache: false,
                        processData:false,
                        success: function(data)
                        {                        
                            var dat = jQuery.parseJSON(data);
                            if( dat.status == "success" )
                            {
                                l.ladda('stop');
                                localStorage.login_var = "user&pass";
                                window.location.replace("employees.php");
                            }
                            else if( dat.status == "failed" )
                            {
                                l.ladda('stop');
                                errmsg = dat.error;
                                swal_btn2.click();
                            }
                        },
                        error: function(data) 
                        {
                            alert("error");
                        }           
    
                    });                
                    return false; // extra insurance preventing the default form action
                }
            });
    
            $('#swal_btn2').click(function(){
                swal({
                    title: "Operation Unsuccessfull!",
                    text: errmsg,
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });
    </script>
</body>
</html>