<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Locations</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
    if (!localStorage.login_var)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>

<body>

    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Locations</strong></h2>
                    <a href="add_location.php">
                        <button type="button" class="btn btn-default btn-sm">
                            <span class="glyphicon glyphicon-plus"></span> Add Location
                        </button>
                    </a>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>
                                            <th>SNo</th>                                            
                                            <th>Location Name</th>
                                            <th>Location Address</th>
                                            <th>Location Type</th>
                                            <th>Location Id</th>
                                            <th>Location Password</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="location_list">
                                       <!-- Dynamically appending Locations List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">

            <?php
            include 'footer.php';
            ?>

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete Location</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the Location?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deleteLocation()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->



<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- FooTable -->
<script src="js/plugins/footable/footable.all.min.js"></script>

<!-- Page-Level Scripts -->
<script>
    var delete_location;

    $(document).ready(function() 
    {
        $("#side2").addClass("activeSM");
        $("#side2 a").css("color","#224ea6");

        viewLocations();
        //Empty List
        $('#swal_btn').click(function(){
            swal({
                 title: "List is Empty!",
                text: "Please add Locations.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
                closeOnConfirm: false
            }, function () {
                window.location.assign("add_location.php");
            });
        });

        //Delete Row
        $('#swal_btn2').click(function(){
            swal({
                title: "Location Deleted!",
                text: "",
                type: "success",
                confirmButtonColor: "#DD6B55",
            });
        });

        //Active Row
        $('#swal_btn3').click(function(){
            swal({
                 title: "Activated/Deactivated",
                text: "Location Activated/Deactivated Successfully.",
                type: "success",
                confirmButtonColor: "#003399",
            });
        });

        $(document).on('click','input[type="checkbox"]',function()
        {
            if($('#'+this.id).is(':checked') == true)
            {
                $('#password_'+this.id).attr('type', 'text');
            }
            else
            {
                $('#password_'+this.id).attr('type', 'password');
            }
        });
    });

    function viewLocations()
    {
        var $list = $("#location_list");
        $list.empty();
        $.ajax({
            url: "kos_apis/view_all_location.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    $.each(dat.Data, function(index,obj) 
                    {
                        if( obj.location_active == '0')
                        {
                            var status = '<span id="'+obj.location_id+'" onclick ="statusChange(this.id);" class="label label-danger">Inactive</span>';
                        }
                        else
                        {
                            var status = '<span id="'+obj.location_id+'" onclick ="statusChange(this.id);" class="label label-primary">Active</span>';
                        }
                        $list.append('<tr>'+
                                        '<td><strong>'+count+'</strong></td>'+
                                        '<td>'+obj.location_name+'</td>'+
                                        '<td>'+obj.address+'</td>'+
                                        '<td>'+obj.location_type+'</td>'+
                                        '<td>'+obj.location_id+'</td>'+
                                        '<td>'+
                                            '<input type="password" id="password_'+obj.location_id+'" value="'+obj.location_pass+'" disabled>'+
                                            '<div class="input-group-append">'+
                                                '<input type="checkbox" id="'+obj.location_id+'" >'+
                                                '<small> Show Password</small>'+
                                            '</div>'+
                                        '</td>'+
                                        '<td>'+status+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+obj.location_id+'" onclick ="saveLocation(this.id);" class="btn-white btn btn-xs">Edit</button>'+
                                                //'<button id="'+obj.location_id+'" onclick ="deleteLocationModal(this.id);" class="btn-white btn btn-xs">Delete</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>');
                        count++;
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function deleteLocationModal(id)
    {
        $('#deleteModal').modal('show');
        delete_location = id;
    }

    function deleteLocation()
    {
        $('#deleteModal').modal('hide');
        
        var location_id = delete_location;
        $.ajax({            
            url: "kos_apis/delete_location.php",
            type: "get",
            data: {"location_id": location_id},
            success: function(result)
            {
                var data = jQuery.parseJSON(result);
                if(data.status == "success")
                {
                    swal_btn2.click();
                    viewLocations();
                }
                else if (data.status == "failed")
                {
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });
    }

    function saveLocation(id)
    {
        var location_id = id;
        localStorage.setItem("location_id",location_id);
        window.location.href = "update_location.php";
        
    }

    function statusChange(id)
    {
        var location_id = id;
        $.ajax({            
            url: "kos_apis/active_location.php",
            type: "get",
            data: {"location_id": location_id},
            success: function(result)
            {
                var data = jQuery.parseJSON(result);
                if(data.status == "success")
                {
                    swal_btn3.click();
                    viewLocations();
                }
                else if (data.status == "failed")
                {
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });        
    }
</script>
</body>
</html>
