<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Parents Text</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>
<body>
    <div id="wrapper">
        <?php
            include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                    include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Parents Text</strong></h2>
                    <a href="add_parents_text.php">
                        <button type="button" class="btn btn-default btn-sm">
                            <span class="glyphicon glyphicon-plus"></span> Add Parents Text
                        </button>
                    </a>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>SNo</th>
                                            <th>Subject</th>
                                            <th>Heading</th>
                                            <th>Description</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="parents_Text_list">
                                        <!-- Dynamically appending parents_Text_list List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none"></button>

            <?php
                include 'footer.php';
            ?>

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete Parents Text</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the Parents Text?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deleteParentsText()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->


<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- FooTable -->
<script src="js/plugins/footable/footable.all.min.js"></script>

<!-- Page-Level Scripts -->
 <script>
    var delete_parents_text_id;

    $(document).ready(function() 
    {
        $("#side10").addClass("activeSM");
        $("#side10 a").css("color","#224ea6");

        viewParentsText();
        //Empty List
        $('#swal_btn').click(function(){
            swal({
                 title: "List is Empty!",
                text: "Please add Parents text.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
                closeOnConfirm: false
            }, function () {
                window.location.assign("add_parents_text.php");
            });
        });

        //Delete Row
        $('#swal_btn2').click(function(){
            swal({
                title: "Parents text Deleted!",
                text: "",
                type: "success",
                confirmButtonColor: "#DD6B55",
            });
        });

        //Active Row
        $('#swal_btn3').click(function(){
            swal({
                 title: "Activated/Deactivated",
                text: "Parents Text Activated/Deactivated Successfully.",
                type: "success",
                confirmButtonColor: "#003399",
            });
        });
    });

    function viewParentsText()
    {
        var $list = $("#parents_Text_list");
        $list.empty();
        $.ajax({
            url: "kos_apis/view_parental_text.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    $.each(dat.data, function(index,obj) 
                    {
                        if( obj.active_st == '0')
                        {
                            var status = '<span id="'+obj.p_id+'" onclick ="statusChange(this.id);" class="label label-danger">Inactive</span>';
                        }
                        else
                        {
                            var status = '<span id="'+obj.p_id+'" onclick ="statusChange(this.id);" class="label label-primary">Active</span>';
                        }
                        $list.append('<tr>'+
                                        '<td><strong>'+count+'</strong></td>'+
                                        '<td>'+obj.subject+'</td>'+
                                        '<td>'+obj.heading+'</td>'+
                                        '<td>'+obj.description+'</td>'+
                                        '<td>'+status+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+obj.p_id+'" onclick ="saveParentsText(this.id);" class="btn-white btn btn-xs">Edit</button>'+
                                                //'<button id="'+obj.p_id+'" onclick ="deleteParentsTextModal(this.id);" class="btn-white btn btn-xs">Delete</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>');
                        count++;
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function deleteParentsTextModal(id)
    {
        $('#deleteModal').modal('show');
        delete_parents_text_id = id;
    }

    function deleteParentsText()
    {
        $('#deleteModal').modal('hide');

        var p_id = delete_parents_text_id;
        $.ajax({            
            url: "kos_apis/delete_parental.php",
            type: "get",
            data: {"p_id": delete_parents_text_id},
            success: function(result)
            {
                var data = jQuery.parseJSON(result);
                if(data.status == "success")
                {
                    swal_btn2.click();
                    viewParentsText();
                }
                else if (data.status == "failed")
                {
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });
    }

    function saveParentsText(id)
    {
        var parents_text_id = id;
        localStorage.setItem("parents_text_id",parents_text_id);
        window.location.href = "update_parents_text.php";
        
    }

    function statusChange(id)
    {
        var parents_text_id = id;
        $.ajax({            
            url: "kos_apis/active_parental_text.php",
            type: "get",
            data: {"p_id": parents_text_id},
            success: function(result)
            {
                var data = jQuery.parseJSON(result);
                if(data.status == "success")
                {
                    swal_btn3.click();
                    viewParentsText();
                }
                else if (data.status == "failed")
                {
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });        
    }
</script>
</body>
</html>
