<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title> King Of Scooters | Register Locations</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
        if (!localStorage.login_var)
        {
            window.stop();
            window.location.replace("index.php");
        }
    </script>
</head>

<body>

    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>All Locations</strong></h2>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>
                                            <th>SNo</th>                                            
                                            <th>Location Name</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="location_list">
                                       <!-- Dynamically appending Locations List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">

            <?php
            include 'footer.php';
            ?>

        </div>
    </div>

    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
    
    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>
    
    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>
    
    <!-- FooTable -->
    <script src="js/plugins/footable/footable.all.min.js"></script>
    
    <!-- Page-Level Scripts -->
    <script>
        var delete_location;
        var objLocations;
    
        $(document).ready(function() 
        {
            $("#side20").addClass("activeSM");
            $("#side20 a").css("color","#224ea6");
    
            viewLocations();
    
            //Delete Row
            $('#swal_btn2').click(function(){
                swal({
                    title: "Location Deleted!",
                    text: "",
                    type: "success",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });
    
        function viewLocations()
        {
            var $list = $("#location_list");
            $list.empty();
            
            $.ajax({
                url: "kos_apis/view_all_location.php",
                type: "GET",
                success: function(result)
                {   
                    var count = 1;
                    var data = jQuery.parseJSON(result);
                    
                    if ( data.status == "success")
                    {
                        $.each(data.Data, function(index,obj) 
                        {
                            $list.append('<tr>'+
                                            '<td><strong>'+count+'</strong></td>'+
                                            '<td>'+obj.location_name+'</td>'+
                                            '<td>'+
                                                '<div class="btn-group">'+
                                                    '<button id="'+obj.location_id+'_'+obj.location_name+'" onclick ="viewRegisters(this.id);" class="btn-white btn btn-xs">View Registers</button>'+
                                                    '<button id="'+obj.location_id+'_'+obj.location_name+'" onclick ="viewBatch(this.id);" class="btn-white btn btn-xs">View Current Batch</button>'+
                                                '</div>'+
                                            '</td>'+
                                        '</tr>');
                            count++;
                        });
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }
    
        function viewRegisters(id)
        {
            var temp = id.split('_');
            var location_id = temp[0];
            var location_name = temp[1];
            
            localStorage.setItem("location_id",location_id);
            localStorage.setItem("location_name",location_name);
            window.location.href = "view_registers.php";
        }
        
        function viewBatch(id)
        {
            var temp = id.split('_');
            var location_id = temp[0];
            var location_name = temp[1];
            
            localStorage.setItem("location_id",location_id);
            localStorage.setItem("location_name",location_name);
            window.location.href = "view_batch.php";
        }
    </script>
</body>
</html>