<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Security Deposit Refund</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
        .loader 
        {
            border: 16px solid #3498db;
            border-radius: 50%;
            border-top: 16px solid #f3f3f3;
            width: 120px;
            height: 120px;
            -webkit-animation: spin 2s linear infinite; /* Safari */
            animation: spin 2s linear infinite;
        }
        
        /* Safari */
        @-webkit-keyframes spin 
        {
            0% { -webkit-transform: rotate(0deg); }
            100% { -webkit-transform: rotate(360deg); }
        }
        
        @keyframes spin 
        {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>

<body>
        <div id="page-wrapper" class="gray-bg">

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Transaction Refund</Strong></h2>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row" id="loader_div">
                    <center>
                        <div class="loader"></div>
                    </center>
                </div>
                <div class="row" id="other_div" style="display:none">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="add_damage_form" style="font-size: 24px">
                                    <div class="form-group">
                                        <label>Location Name</label>
                                        <p id="location_name"></p>
                                    </div>  
                                    <div class="form-group">
                                        <label>Location Phone#</label>
                                        <a id="attr_loc_phone">
                                            <p id="location_phone"></p>
                                        </a>
                                    </div>  
                                    <div class="form-group">
                                        <label>Emp. Name</label>
                                        <p id="emp_name"></p>
                                    </div>  
                                    <div class="form-group">
                                        <label>Emp. Phone#</label>
                                        <a id="attr_emp_phone">
                                            <p id="emp_phone"></p>
                                        </a>
                                    </div>  
                                    <div class="form-group">
                                        <button style="font-size: 24px" type="button" class="btn btn-sm btn-warning m-t-n-xs" data-toggle="modal" data-target="#myModal">Deal Info</button>
                                    </div>
                                    <div class="form-group">
                                        <label>OTP</label>
                                        <input style="font-size: 24px" type="number" id="otp_code" name="otp_code" class="form-control" required disabled>
                                    </div> 
                                    <div class="form-group">
                                        <label>Damage Charge</label>
                                        <input style="font-size: 24px" type="number" id="damage_charge" name="damage_charge" placeholder="Enter damage charge" class="form-control" required>
                                    </div> 
                                    <div>
                                        <button style="background-color: #003399;border-color: #224ea6;color: white;font-size:24px" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added Category -->
                                        <button id="swal_btn" type="button" style="display:none"></button>
                                        <!-- Category not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none"></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row" id="expired_div" style="display:none">
                    <center>
                        <h1><strong>The link has been expired.</strong></h1>
                    </center>
                </div>
            </div>
            
            <?php
                include 'footer.php';
            ?>
        </div>
        
    <!-- Modal -->
    <div id="myModal" class="modal fade" role="dialog">
        <div class="modal-dialog">
        
        <!-- Modal content-->
        <div class="modal-content" style="font-size: 24px">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 style="font-size: 24px" class="modal-title">Deal Details</h4>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label>Customer Name</label>
                    <p id="customer_name"></p>
                </div>  
                <div class="form-group">
                    <label>Last Name</label>
                    <p id="last_name"></p>
                </div> 
                <div class="form-group">
                    <label>Rental Date </label>
                    <p id="rental_date"></p>
                </div>  
                <div class="form-group">
                    <label>Rental Time</label>
                    <p id="rental_time"></p>
                </div>  
                <div class="form-group">
                    <label>Vehicle Type</label>
                    <p id="vehicle_type"></p>
                </div>  
                <div class="form-group">
                    <label>Term</label>
                    <p id="term"></p>
                </div>  
                <div class="form-group">
                    <label>Price($)</label>
                    <p id="price"></p>
                </div>  
                <div class="form-group">
                    <label>Add Hours</label>
                    <p id="add_hours"></p>
                </div>  
                <div class="form-group">
                    <label>Expected Return Date</label>
                    <p id="expected_return_date"></p>
                </div>  
                <div class="form-group">
                    <label>Expected Return Time</label>
                    <p id="expected_return_time"></p>
                </div>  
                <div class="form-group">
                    <label>Actual Return Date</label>
                    <p id="actual_return_date"></p>
                </div>  
                <div class="form-group">
                    <label>Actual Return Time</label>
                    <p id="actual_return_time"></p>
                </div> 
                <div style="color:red">
                    <div class="form-group">
                        <label>Deposit Type</label>
                        <p id="cash_deposit" color="red"></p>
                    </div>  
                    <div class="form-group">
                        <label>Amount($)</label>
                        <p id="amount"></p>
                    </div>  
                    <div class="form-group">
                        <label>Order#</label>
                        <p id="order_number"></p>
                    </div>  
                    <div class="form-group">
                        <label>Late</label>
                        <p id="late"></p>
                    </div>  
                    <div class="form-group">
                        <label>Damage</label>
                        <p id="damage"></p>
                    </div>  
                </div>
                <div class="form-group">
                    <label>Pictures RENT OUT</label>
                    <div class="row" id="picture_rentout">
                        <!-- Appending Dynamically -->
                    </div>
                </div>  
                <div class="form-group">
                    <label>Pictures RETURN</label>
                    <div class="row" id="picture_return">
                        <!-- Appending Dynamically -->
                    </div>
                </div>  
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
        
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <script>
    var errmsg;
    var order_id,phonenumber,location_name,location_phone,employee_name,employee_phone,emp_username,otp_code,transaction_refund_status;
    
    $(document).ready(function()
    {
        var url   = window.location.href;
        var temp  = url.split('?');
        
        var temp2 = temp[1].split('&');
        
        $.each(temp2, function(index,value) 
        {
            var valTemp = value.split('=');
            if(index == 0)
            {
                phonenumber = valTemp[1];
            }
            else if(index == 1)
            {
                location_name = valTemp[1];
            }
            else if(index == 2)
            {
                location_phone = valTemp[1];
            }
            else if(index == 3)
            {
                employee_name = valTemp[1];
            }
            else if(index == 4)
            {
                employee_phone = valTemp[1];
            }
            else if(index == 5)
            {
                emp_username = valTemp[1];
            }
            else if(index == 6)
            {
                otp_code = valTemp[1];
            }
            else if(index == 7)
            {
                order_id = valTemp[1];
            }
        });
        
        getTransactionInfo(order_id);
        
        
        $("#side14").addClass("activeSM");
        $("#side14 a").css("color","#224ea6");
        
       $("#add_damage_form").validate({
            rules: 
            {
                damage_charge: {
                   required: true,
                   number  : true
                },
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );

                var damage_charge = $('#damage_charge').val();
                    
                $.ajax
                ({
                    type:'GET',
                    url:"/Panama/BigApp/kos_apis/SendOtpEmployee.php",
                    data: { order_id: order_id , emp_username : emp_username , damage_charge : damage_charge , status : "transaction_refund_status" },
                    success: function(data)
                    {
                        var dat = jQuery.parseJSON(data);
                        if( dat.status == "success" )
                        {
                            l.ladda('stop');
                            swal_btn.click();
                        }
                        else if( dat.status == "failed" )
                        {
                            errmsg = dat.error;
                            l.ladda('stop');
                            swal_btn2.click();
                        }
                    },
                    error: function(data) 
                    {
                        alert("error");
                    }           
                });          
                return false; // extra insurance preventing the default form action
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Added Successfully!",
                text: "Damage Amount Added Successfully",
                type: "success",
                confirmButtonColor: "#003399",
                closeOnConfirm: false
            }, function () {
                window.location.reload();
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: errmsg,
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
    });
    
    function getTransactionInfo(order_id)
    {
         var l = $( '.ladda-button-demo' ).ladda();
                // l.ladda( 'start' );
        $.ajax
        ({
            type:'GET',
            url:"/Panama/BigApp/BigAppLar/apis/api/ViewTransactionOrderId",
            data: { order_id : order_id},
            success: function(data)
            {
                if( data.status == "success" )
                {
                    $.each(data.data, function(index12,obj12) 
                    {
                        $('#location_name').html(location_name);
                        $("#attr_loc_phone").attr("href", "tel:"+location_phone);
                        $('#location_phone').html(location_phone);
                        $('#otp_code').val(otp_code);
                        $('#emp_name').html(employee_name);
                        $("#attr_emp_phone").attr("href", "tel:"+employee_phone);
                        $('#emp_phone').html(employee_phone);
                        
                        $.each(obj12.booking_details, function(index,obj) 
                        {
                            transaction_refund_status = obj.transaction_refund_status;
                            $('#first_name').html(obj.fname);
                            $('#last_name').html(obj.lname);
                            var tempCheckout = obj.checkout_time.split(" ");
                            $('#rental_date').html(tempCheckout[0]);
                            $('#rental_time').html(tempCheckout[1]+tempCheckout[2]);
                            $('#vehicle_type').html(obj.vehicle_type);
                            $('#term').html(obj.term);
                            $('#price').html(obj.price);
                            $('#add_hours').html(obj.new_term);
                            var tempReturn = obj.new_return_time.split(" ");
                            $('#expected_return_date').html(tempReturn[0]);
                            $('#expected_return_time').html(tempReturn[1]+tempReturn[2]);
                            var tempCheckin = obj.checkin_time.split(" ");
                            $('#actual_return_date').html(tempCheckin[0]);
                            $('#actual_return_time').html(tempCheckin[1]+tempCheckin[2]);
                            $('#cash_deposit').html(obj.deposit_type);
                            $('#amount').html(obj.deposit_amount);
                            order_id = obj.order_id;
                            $('#order_number').html(obj.order_id);
                            $('#late').html("");
                            if(obj.return_ok == "Damage")
                            {
                                $('#damage').html("YES");
                            }
                            else
                            {
                                $('#damage').html("NO");
                            }
                        });
                        
                        $.each(obj12.Inspection_images, function(index2,obj2) 
                        {
                            if(obj2.situation == "before")
                            {
                                $('#picture_rentout').append('<div class="col-xs-12 col-sm-6">'+
                                                                '<img width="200" src="https://kingwaiver.com/Panama/BigApp/kos_apis/'+obj2.image+'"/>'+
                                                            '</div>');
                            }
                            else
                            {
                                $('#picture_return').append('<div class="col-xs-12 col-sm-6">'+
                                                                '<img width="200" src="https://kingwaiver.com/Panama/BigApp/kos_apis/'+obj2.image+'"/>'+
                                                            '</div>');
                            }
                        });
                    });
                    
                    if(transaction_refund_status == 0)
                    {
                        $('#other_div').css('display','block');
                        $('#loader_div').css('display','none');
                        $('#expired_div').css('display','none');
                    }
                    else
                    {
                        $('#other_div').css('display','none');
                        $('#loader_div').css('display','none');
                        $('#expired_div').css('display','block');
                    }
                }
                else if( data.status == "failed" )
                {
                    errmsg = data.error;
                    $('#loader_div').css('display','none');
                    swal_btn2.click();
                    l.ladda('stop');
                    
                }
            },
            error: function(data) 
            {
                alert("error");
            }           
        });    
    }

</script>

</body>
</html>
