<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | SMS Master</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
    if (!localStorage.login_var)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>

<body>

    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>SMS Master</strong></h2>
                    <a href="add_sms_master.php">
                        <button type="button" class="btn btn-default btn-sm">
                            <span class="glyphicon glyphicon-plus"></span> Add SMS Master
                        </button>
                    </a>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>
                                            <th>SNo</th>                                            
                                            <th>SMS Master</th>
                                            <th>Employee Username</th>
                                            <th>Employee Role</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="sms_master_list">
                                       <!-- Dynamically appending Carriers List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">

            <?php
                include 'footer.php';
            ?>

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete SMS Master</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the SMS Master?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deleteSmsMaster()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->



<!-- Mainly scripts -->
<script src="js/jquery-3.1.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

<!-- Custom and plugin javascript -->
<script src="js/inspinia.js"></script>
<script src="js/plugins/pace/pace.min.js"></script>

<!-- Sweet alert -->
<script src="js/plugins/sweetalert/sweetalert.min.js"></script>

<!-- FooTable -->
<script src="js/plugins/footable/footable.all.min.js"></script>

<!-- Page-Level Scripts -->
<script>
    var delete_sms_master_id;
    var sms_emp_role;

    $(document).ready(function() 
    {
        $("#side12").addClass("activeSM");
        $("#side12 a").css("color","#224ea6");

        viewEmployees();
        //Empty List
        $('#swal_btn').click(function(){
            swal({
                 title: "List is Empty!",
                text: "Please add SMS Master.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
                closeOnConfirm: false
            }, function () {
                window.location.assign("add_sms_master.php");
            });
        });

        //Delete Row
        $('#swal_btn2').click(function(){
            swal({
                title: "SMS Master Deleted!",
                text: "",
                type: "success",
                confirmButtonColor: "#DD6B55",
            });
        });

        //Active Row
        $('#swal_btn3').click(function(){
            swal({
                 title: "Activated/Deactivated",
                text: "SMS Master Activated/Deactivated Successfully.",
                type: "success",
                confirmButtonColor: "#003399",
            });
        });
    });

    function viewEmployees()
    {
        $.ajax({
            url: "kos_apis/view_all_employee.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);

                if ( dat.status == "success")
                {
                    sms_emp_role = dat;
                    viewSmsMaster();
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function viewSmsMaster()
    {
        var $list = $("#sms_master_list");
        $list.empty();
        $.ajax({
            url: "kos_apis/view_mastercode.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    $.each(dat.Data, function(index,obj) 
                    {
                        $.each(sms_emp_role.Data, function(index1,obj1) 
                        {
                            if( obj.employee_name == obj1.emp_username)
                            {
                                if( obj.active == '0')
                                {
                                    var status = '<span id="'+obj.codeid+'" onclick ="statusChange(this.id);" class="label label-danger">Inactive</span>';
                                }
                                else
                                {
                                    var status = '<span id="'+obj.codeid+'" onclick ="statusChange(this.id);" class="label label-primary">Active</span>';
                                }
                                $list.append('<tr>'+
                                                '<td><strong>'+count+'</strong></td>'+
                                                '<td>'+obj.master_code+'</td>'+
                                                '<td>'+obj.employee_name+'</td>'+
                                                '<td>'+obj1.emp_role+'</td>'+
                                                '<td>'+status+'</td>'+
                                                '<td>'+
                                                    '<div class="btn-group">'+
                                                        '<button id="'+obj.codeid+'" onclick ="saveSmsMaster(this.id);" class="btn-white btn btn-xs">Edit</button>'+
                                                        //'<button id="'+obj.codeid+'" onclick ="deleteSmsModal(this.id);" class="btn-white btn btn-xs">Delete</button>'+
                                                    '</div>'+
                                                '</td>'+
                                            '</tr>');
                                count++;
                            }
                        });
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function deleteSmsModal(id)
    {
        $('#deleteModal').modal('show');
        delete_sms_master_id = id;
    }

    function deleteSmsMaster()
    {
        $('#deleteModal').modal('hide');
        
        var _sms_master_id = delete_sms_master_id;
        $.ajax({            
            url: "kos_apis/delete_mastercode.php",
            type: "get",
            data: {"codeid": _sms_master_id},
            success: function(result)
            {
                var data = jQuery.parseJSON(result);
                if(data.status == "success")
                {
                    swal_btn2.click();
                    viewSmsMaster();
                }
                else if (data.status == "failed")
                {
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });
    }

    function saveSmsMaster(id)
    {
        var sms_master_id = id;
        localStorage.setItem("sms_master_id",sms_master_id);
        window.location.href = "update_sms_master.php"; 
    }

    function statusChange(id)
    {
        var carrier_id = id;
        $.ajax({            
            url: "kos_apis/active_mastercode.php",
            type: "get",
            data: {"codeid": carrier_id},
            success: function(result)
            {
                var data = jQuery.parseJSON(result);
                if(data.status == "success")
                {
                    swal_btn3.click();
                    viewSmsMaster();
                }
                else if (data.status == "failed")
                {
                    alert("failed");
                }
            },
            error: function(data) 
            {
            }           
        });        
    }
</script>
</body>
</html>
