<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Edit Accessory</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>

<body>
    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Edit Accessory</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="accessories.php">Accessories</a>
                        </li>
                        <li class="active">
                            <strong>Edit Accessory</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="update_accessory_form">
                                    <div class="form-group">
                                        <label>Name</label>
                                        <input type="text" id="name" name="name" placeholder="Enter name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Quantity</label>
                                        <input type="number" id="quantity" name="quantity" placeholder="Enter quantity" class="form-control" required>
                                    </div>
                                     <div class="form-group">
                                        <label>Price</label>
                                        <input type="number" id="price" name="price" placeholder="Enter price" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Type of scooter</label>
                                        <select class="form-control" id="added_to_vehicle" name="added_to_vehicle">
                                        </select>
                                    </div>                                      
                                    <div>
                                        <button style="background-color: #003399;border-color: #224ea6;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Updated Accessory -->
                                        <button id="swal_btn" type="button" style="display:none">
                                        <!-- Accessory not Updated -->
                                        <button id="swal_btn2" type="button" style="display:none">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            include 'footer.php';
            ?>
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <script>
    $(document).ready(function()
    {
        $("#side5").addClass("activeSM");
        $("#side5 a").css("color","#224ea6");
        
        viewVehicleType();
        viewAccessory();

        $("#update_accessory_form").validate({
            rules: 
            {
                name: {
                   required: true
                },
                quantity: {
                   required: true,
                   number: true
                },
                price: {
                   required: true,
                   number: true
                },
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );

                var name = $('#name').val();
                var added_to_vehicle = $('#added_to_vehicle').val();
                var quantity = $('#quantity').val();
                var price = $('#price').val();
                var acc_id = localStorage.acc_id;

                var formData = new FormData();
                formData.append("acc_id", acc_id);
                formData.append("acc_name", name);
                formData.append("vehicle_type", added_to_vehicle);
                formData.append("acc_pieces", quantity);
                formData.append("acc_price", price);   
                $.ajax
                ({
                    type:'POST',
                    url:"kos_apis/edit_accessory.php",
                    data: formData,
                    contentType: false,
                    cache: false,
                    processData:false,
                    success: function(data)
                    {
                        var dat = jQuery.parseJSON(data);
                        if( dat.status == "success" )
                        {
                            l.ladda('stop');
                            swal_btn.click();
                        }
                        else if( dat.status == "failed" )
                        {
                            l.ladda('stop');
                            swal_btn2.click();
                        }
                    },
                    error: function(data) 
                    {
                        alert("error");
                    }           

                });                
                return false; // extra insurance preventing the default form action
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Updated Successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
                closeOnConfirm: false
            }, function () {
                window.location.assign("accessories.php");
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: "Accessory not Updated.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
    });

    function viewVehicleType()
    {
        var $list = $("#added_to_vehicle");
        $list.empty();
        $.ajax({
            url: "kos_apis/view_vehicle_types.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    var vehicle_type = '<option value="select" selected>Select type of scooter</option>';
                    $list.append(vehicle_type);
                    $.each(dat.types, function(index,obj) 
                    {
                        if ( obj.active == "0")
                        {
                            //Do Nothing
                        }
                        else
                        {
                            vehicle_type = '<option value="'+obj.type_name+'">'+obj.type_name+'</option>';
                            $list.append(vehicle_type);
                        }
                    });
                }
                else
                {
                    $list.append('<option value="select" selected>Select type of scooter</option>');
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function viewAccessory()
    {
        var acc_id = localStorage.acc_id;

        $.ajax({
            url: "kos_apis/view_accessory.php",
            type: "GET",
            data: {"acc_id": acc_id},
            success: function(data)
            {   
                var dat = jQuery.parseJSON(data);
                if(dat.status == "success")
                {
                    $.each(dat.Data, function(i,Employees)
                    {
                        $('#name').val(Employees.acc_name);
                        $('#added_to_vehicle').val(Employees.vehicle_type);
                        $('#quantity').val(Employees.acc_pieces);
                        $('#price').val(Employees.acc_price); 
                    });            
                }
            },     
        });
    }
</script>

</body>
</html>
