<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Edit Calendar Min Price</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">
    
    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>
<body>
    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Edit Calendar Min Price</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="calendar_min_price_list.php">Calendar Min Price List</a>
                        </li>
                        <li class="active">
                            <strong>Edit Calendar Min Price</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form  id="update_calendar_min_price_form">
                                    <div class="form-group">
                                        <label>Type of scooter</label>
                                        <select class="form-control" id="vehicle_type" name="vehicle_type">
                                        </select>
                                    </div> 
                                    <div class="form-group">
                                        <label>Choose Date Range</label>
                                        <div class="row">                                            
                                            <div class="col-xs-6">
                                                <label style="font-weight: normal;">From Date</label>
                                                <input type="date" id="from_date" name="from_date" class="form-control" required>
                                            </div>
                                            <div class="col-xs-6">
                                                <label style="font-weight: normal;">To Date</label>
                                                <input type="date" id="to_date" name="to_date" class="form-control" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label>Fixed Hours Price</label>
                                        <div class="row">
                                            <div class="col-xs-4">
                                                <input type="number" min="0" max="24" id="fixed_price_start_1" name="fixed_price_start_1" placeholder="Starting Hour" class="form-control" required>
                                            </div>
                                            <div class="col-xs-4">
                                                <input type="number" min="0" max="24" id="fixed_price_end_1" name="fixed_price_end_1" placeholder="Ending Hour" class="form-control" required>
                                            </div>
                                            <div class="col-xs-4">
                                                <input type="number" min="0" id="fixed_price_1" name="fixed_price_1" placeholder="Enter Price" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="row" style="margin-top: 5px">
                                           <div class="col-xs-4">
                                                <input type="number" min="0" max="24" id="fixed_price_start_2" name="fixed_price_start_2" placeholder="Starting Hour" class="form-control" required>
                                            </div>
                                            <div class="col-xs-4">
                                                <input type="number" min="0" max="24" id="fixed_price_end_2" name="fixed_price_end_2" placeholder="Ending Hour" class="form-control" required>
                                            </div>
                                            <div class="col-xs-4">
                                                <input type="number" min="0" id="fixed_price_2" name="fixed_price_2" placeholder="Enter Price" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="row" style="margin-top: 5px">
                                            <div class="col-xs-4">
                                                <input type="number" min="0" max="24" id="fixed_price_start_3" name="fixed_price_start_3" placeholder="Starting Hour" class="form-control" required>
                                            </div>
                                            <div class="col-xs-4">
                                                <input type="number" min="0" max="24" id="fixed_price_end_3" name="fixed_price_end_3" placeholder="Ending Hour" class="form-control" required>
                                            </div>
                                            <div class="col-xs-4">
                                                <input type="number" min="0" id="fixed_price_3" name="fixed_price_3" placeholder="Enter Price" class="form-control" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label>Over Night Pricing (24hrs Format)</label>
                                        <div class="row">
                                            <div class="col-xs-4">
                                                <input type="number" min="0" max="24" id="over_night_start_1" name="over_night_start_1" placeholder="Starting Hour" class="form-control" required>
                                            </div>
                                            <div class="col-xs-4">
                                                <input type="text" value="to  9/10/11" class="form-control" disabled="">
                                            </div>
                                            <div class="col-xs-4">
                                                <input type="number" min="0" id="over_night_price_1" name="over_night_price_1" placeholder="Enter Price" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="row" style="margin-top: 5px">
                                           <div class="col-xs-4">
                                                <input type="number" min="0" max="24" id="over_night_start_2" name="over_night_start_2" placeholder="Starting Hour" class="form-control" required>
                                            </div>
                                            <div class="col-xs-4">
                                                <input type="text" value="to  9/10/11" class="form-control" disabled="">
                                            </div>
                                            <div class="col-xs-4">
                                                <input type="number" min="0" id="over_night_price_2" name="over_night_price_2" placeholder="Enter Price" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="row" style="margin-top: 5px">
                                            <div class="col-xs-4">
                                                <input type="number" min="0" max="24" id="over_night_start_3" name="over_night_start_3" placeholder="Starting Hour" class="form-control" required>
                                            </div>
                                            <div class="col-xs-4">
                                                <input type="text" value="to  9/10/11" class="form-control" disabled="">  
                                            </div>
                                            <div class="col-xs-4">
                                                <input type="number" min="0" id="over_night_price_3" name="over_night_price_3" placeholder="Enter Price" class="form-control" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label>Fixed Days Price</label>
                                        <div class="row">
                                            <div class="col-sm-4 col-xs-5">
                                                <input type="text" value="1 Days"  class="form-control" disabled="">
                                            </div>
                                            <div class="col-sm-3 col-xs-3">
                                                <input type="text" value="=" class="form-control" disabled="">
                                            </div>
                                            <div class="col-sm-5 col-xs-4">
                                                <input type="number" min="0" id="day_1" name="day_1" placeholder="Enter Price" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="row" style="margin-top: 5px">
                                            <div class="col-sm-4 col-xs-5">
                                                <input type="text" value="2 Days" class="form-control" disabled="">
                                            </div>
                                            <div class="col-sm-3 col-xs-3">
                                                <input type="text" value="=" class="form-control" disabled="">
                                            </div>
                                            <div class="col-sm-5 col-xs-4">
                                                <input type="number" min="0" id="day_2" name="day_2" placeholder="Enter Price" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="row" style="margin-top: 5px">
                                            <div class="col-sm-4 col-xs-5">
                                                <input type="text" value="3 Days" class="form-control" disabled="">
                                            </div>
                                            <div class="col-sm-3 col-xs-3">
                                                <input type="text" value="=" class="form-control" disabled="">
                                            </div>
                                            <div class="col-sm-5 col-xs-4">
                                                <input type="number" min="0" id="day_3" name="day_3" placeholder="Enter Price" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="row" style="margin-top: 5px">
                                            <div class="col-sm-4 col-xs-5">
                                                <input type="text" value="4 Days" class="form-control" disabled="">
                                            </div>
                                            <div class="col-sm-3 col-xs-3">
                                                <input type="text" value="=" class="form-control" disabled="">
                                            </div>
                                            <div class="col-sm-5 col-xs-4">
                                                <input type="number" min="0" id="day_4" name="day_4" placeholder="Enter Price" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="row" style="margin-top: 5px">
                                            <div class="col-sm-4 col-xs-5">
                                                <input type="text" value="5 Days" class="form-control" disabled="">
                                            </div>
                                            <div class="col-sm-3 col-xs-3">
                                                <input type="text" value="=" class="form-control" disabled="">
                                            </div>
                                            <div class="col-sm-5 col-xs-4">
                                                <input type="number" min="0" id="day_5" name="day_5" placeholder="Enter Price" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="row" style="margin-top: 5px">
                                            <div class="col-sm-4 col-xs-5">
                                                <input type="text" value="6 Days" class="form-control" disabled="">
                                            </div>
                                            <div class="col-sm-3 col-xs-3">
                                                <input type="text" value="=" class="form-control" disabled="">
                                            </div>
                                            <div class="col-sm-5 col-xs-4">
                                                <input type="number" min="0" id="day_6" name="day_6" placeholder="Enter Price" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="row" style="margin-top: 5px">
                                            <div class="col-sm-4 col-xs-5">
                                                <input type="text" value="7 Day" class="form-control" disabled="">
                                            </div>
                                            <div class="col-sm-3 col-xs-3">
                                                <input type="text" value="=" class="form-control" disabled="">
                                            </div>
                                            <div class="col-sm-5 col-xs-4">
                                                <input type="number" min="0" id="day_7" name="day_7" placeholder="Enter Price" class="form-control" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label>Choose a Location</label>
                                        <div id="location_list" name="location_list">
                                        </div>
                                    </div> 
                                    <div>
                                        <button style="background-color: #003399;border-color: #224ea6;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added Calendar Min Price -->
                                        <button id="swal_btn" type="button" style="display:none"></button>
                                        <!-- Calendar Min Price not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none"></button>
                                        <!-- Start Date greater than End Date -->
                                        <button id="swal_btn3" type="button" style="display:none"></button>
                                        <!-- Start Hour greater than End Hour -->
                                        <button id="swal_btn4" type="button" style="display:none"></button>
                                        <!-- Choose Location -->
                                        <button id="swal_btn5" type="button" style="display:none"></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            include 'footer.php';
            ?>
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <script>
    var errmsg;
    $(document).ready(function()
    {
        $("#side6").addClass("activeSM");
        $("#side6 a").css("color","#224ea6");
        
        viewVehicleType();
        viewLocations();
        viewCalendarMinPriceList();

       $("#update_calendar_min_price_form").validate({
            rules: 
            {
                vehicle_type: {
                   required: true
                },
                from_date: {
                   required: true
                },
                to_date: {
                   required: true
                },
                fixed_price_start_1: {
                   required: true
                },
                fixed_price_end_1: {
                   required: true
                },
                fixed_price_1: {
                   required: true,
                   number: true
                },
                fixed_price_start_2: {
                   required: true
                },
                fixed_price_end_2: {
                   required: true
                },
                fixed_price_2: {
                   required: true,
                   number: true
                },             
                fixed_price_start_3: {
                   required: true
                },
                fixed_price_end_3: {
                   required: true
                },
                fixed_price_3: {
                   required: true,
                   number: true
                },                          
                over_night_start_1: {
                   required: true,
                   number: true
                },
                over_night_price_1: {
                   required: true,
                   number: true
                },
                over_night_start_2: {
                   required: true,
                   number: true
                },
                over_night_price_2: {
                   required: true,
                   number: true
                },
                over_night_start_3: {
                   required: true,
                   number: true
                },
                over_night_price_3: {
                   required: true,
                   number: true
                },
                day_1: {
                    required: true
                },
                day_2: {
                    required: true
                },
                day_3: {
                    required: true
                },
                day_4: {
                    required: true
                },
                day_5: {
                    required: true
                },
                day_6: {
                    required: true
                },
                day_7: {
                    required: true
                },
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var start_date = $('#from_date').val();
                var end_date = $('#to_date').val();

                var checkStartDate = new Date(start_date).getTime();
                var checkEndDate = new Date(end_date).getTime();

                var temp_fixed_price_start_1 = $('#fixed_price_start_1').val();
                var fixed_price_start_1 = parseInt(temp_fixed_price_start_1);
                var temp_fixed_price_end_1 = $('#fixed_price_end_1').val();
                var fixed_price_end_1 = parseInt(temp_fixed_price_end_1);
                var fixed_price_1 = $("#fixed_price_1").val();

                var temp_fixed_price_start_2 = $('#fixed_price_start_2').val();
                var fixed_price_start_2 = parseInt(temp_fixed_price_start_2);
                var temp_fixed_price_end_2 = $('#fixed_price_end_2').val();
                var fixed_price_end_2 = parseInt(temp_fixed_price_end_2);
                var fixed_price_2 = $("#fixed_price_2").val();

                var temp_fixed_price_start_3 = $('#fixed_price_start_3').val();
                var fixed_price_start_3 = parseInt(temp_fixed_price_start_3);
                var temp_fixed_price_end_3 = $('#fixed_price_end_3').val();
                var fixed_price_end_3 = parseInt(temp_fixed_price_end_3);
                var fixed_price_3 = $("#fixed_price_3").val();

                var tempFixedPrice = 1;

                if ( fixed_price_start_1 >= fixed_price_end_1)
                {
                    tempFixedPrice = 0;
                }
                if ( fixed_price_start_2 >= fixed_price_end_2)
                {
                    tempFixedPrice = 0;
                }
                if ( fixed_price_start_3 >= fixed_price_end_3)
                {
                    tempFixedPrice = 0;
                }

                var locationString = ""; 
                var tempLocationVar = 0;
                var inputElements = document.getElementsByClassName('locationCheckbox');
                for(var i=0; inputElements[i]; ++i)
                {
                    if(inputElements[i].checked)
                    {
                        locationString = locationString + inputElements[i].value + ",";    
                        tempLocationVar++;                    
                    }
                }
                locationString = locationString.substring(0, locationString.length - 1);

                if (checkStartDate <= checkEndDate)
                {
                    if ( tempFixedPrice == 1 )
                    {
                        if( tempLocationVar > 0)
                        {
                            var l = $( '.ladda-button-demo' ).ladda();
                            l.ladda( 'start' );

                            var fixedHourString = fixed_price_start_1+"-"+fixed_price_end_1+":"+fixed_price_1+","+fixed_price_start_2+"-"+fixed_price_end_2+":"+fixed_price_2+","+fixed_price_start_3+"-"+fixed_price_end_3+":"+fixed_price_3;
                            

                            var vehicle_type = $('#vehicle_type').val();
                            var from_date = $('#from_date').val();
                            var to_date = $('#to_date').val();
                            var from_hour = $('#from_hour').val();
                            var day_1 = $('#day_1').val();
                            var day_2 = $('#day_2').val();
                            var day_3 = $('#day_3').val();
                            var day_4 = $('#day_4').val();
                            var day_5 = $('#day_5').val();
                            var day_6 = $('#day_6').val();
                            var day_7 = $('#day_7').val();
                            var over_night_start_1 = $('#over_night_start_1').val();
                            var over_night_start_2 = $('#over_night_start_2').val();
                            var over_night_start_3 = $('#over_night_start_3').val();
                            var over_night_price_1 = $('#over_night_price_1').val();
                            var over_night_price_2 = $('#over_night_price_2').val();
                            var over_night_price_3 = $('#over_night_price_3').val();

                            var overNightString = over_night_start_1+":"+over_night_price_1+","+over_night_start_2+":"+over_night_price_2+","+over_night_start_3+":"+over_night_price_3;

                            var fixedDaysString = "1:"+day_1+","+"2:"+day_2+","+"3:"+day_3+","+"4:"+day_4+","+"5:"+day_5+","+"6:"+day_6+","+"7:"+day_7;

                            var cp_id= localStorage.cp_id;

                            var formData = new FormData();
                            formData.append("cp_id", cp_id);
                            formData.append("vehicle_type", vehicle_type);
                            formData.append("from_date", from_date);
                            formData.append("to_date", to_date);
                            formData.append("fixed_hours", fixedHourString);
                            formData.append("over_night", overNightString);
                            formData.append("fixed_days", fixedDaysString);
                            formData.append("location", locationString);
                                
                            $.ajax
                            ({
                                type:'POST',
                                url:"kos_apis/edit_cal_min_price.php",
                                data: formData,
                                contentType: false,
                                cache: false,
                                processData:false,
                                success: function(data)
                                {
                                    var dat = jQuery.parseJSON(data);
                                    if( dat.status == "success" )
                                    {
                                        l.ladda('stop');
                                        swal_btn.click();
                                    }
                                    else if( dat.status == "failed" )
                                    {
                                        errmsg = dat.error;
                                        l.ladda('stop');
                                        swal_btn2.click();
                                    }
                                },
                                error: function(data) 
                                {
                                    alert("error");
                                }           
                            });
                        }
                        else
                        {
                            swal_btn5.click();
                        }
                    }
                    else
                    {
                        swal_btn4.click();
                    }
                }
                else
                {
                    swal_btn3.click();
                }

                return false; // extra insurance preventing the default form action
            }
        });

       $('#swal_btn').click(function(){
            swal({
                title: "Updated Successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
                closeOnConfirm: false
            }, function () {
                window.location.assign("calendar_min_price_list.php");
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                title: "Operation Unsuccessfull!",
                text: errmsg,
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
        $('#swal_btn3').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: "Start Date should be less than End Date.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });

        $('#swal_btn4').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: "Start Hour should be less than End Hour.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
        $('#swal_btn5').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: "Please choose at least one Location.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
    });

    function viewVehicleType()
    {
        var $list = $("#vehicle_type");
        $list.empty();
        $.ajax({
            url: "kos_apis/view_vehicle_types.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    var vehicle_type = '<option value="select" selected>Select type of scooter</option>';
                    $list.append(vehicle_type);
                    $.each(dat.types, function(index,obj) 
                    {
                        if ( obj.active == "0")
                        {
                            //Do Nothing
                        }
                        else
                        {
                            vehicle_type = '<option value="'+obj.type_name+'">'+obj.type_name+'</option>';
                            $list.append(vehicle_type);
                        }
                    });
                }
                else
                {
                    $list.append('<option value="select" selected>Select type of scooter</option>');
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function viewLocations()
    {
        var $list = $("#location_list");
        $list.empty();
        $.ajax({
            url: "kos_apis/view_all_location.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);
                if ( dat.status == "success")
                {
                    var location;
                    $.each(dat.Data, function(index,obj) 
                    {
                        if ( obj.location_active == "0")
                        {
                            //Do Nothing
                        }
                        else
                        {
                            location = '<input type="checkbox" class="locationCheckbox" id="'+obj.location_id+'" value="'+obj.location_id+'"> '+obj.location_name+'<br>';
                            $list.append(location);
                        }
                    });
                }
                else
                {
                    alert("Add Location");
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function viewCalendarMinPriceList()
    {
        var cp_id= localStorage.cp_id;

        $.ajax({
            url: "kos_apis/view_cal_price.php",
            type: "GET",
            data: {"cp_id": cp_id},
            success: function(data)
            {   
                var dat = jQuery.parseJSON(data);
                if(dat.status == "success")
                {
                    $.each(dat.Data, function(i,Employees)
                    {
                        $('#vehicle_type').val(Employees.vehicle_type);
                        $('#from_date').val(Employees.from_date);
                        $('#to_date').val(Employees.to_date);

                        //Extracting Fixed Hours
                        var tempFixedHours1 = Employees.fixed_hours;
                        var tempFixedHours2 = tempFixedHours1.split(',');

                        var tempFixedHours3  = tempFixedHours2[0].split(':');
                        var tempFixedHours4  = tempFixedHours3[0].split('-');
                        $('#fixed_price_start_1').val(tempFixedHours4[0]);
                        $('#fixed_price_end_1').val(tempFixedHours4[1]);
                        $('#fixed_price_1').val(tempFixedHours3[1]);

                        var tempFixedHours31 = tempFixedHours2[1].split(':');
                        var tempFixedHours41  = tempFixedHours31[0].split('-');
                        $('#fixed_price_start_2').val(tempFixedHours41[0]);
                        $('#fixed_price_end_2').val(tempFixedHours41[1]);
                        $('#fixed_price_2').val(tempFixedHours31[1]);

                        var tempFixedHours32 = tempFixedHours2[2].split(':');
                        var tempFixedHours42  = tempFixedHours32[0].split('-');
                        $('#fixed_price_start_3').val(tempFixedHours42[0]);
                        $('#fixed_price_end_3').val(tempFixedHours42[1]);
                        $('#fixed_price_3').val(tempFixedHours32[1]);


                        //Extracting Overnight
                        var tempOverNight1 = Employees.over_night;
                        var tempOverNight2 = tempOverNight1.split(',');

                        var tempOverNight3  = tempOverNight2[0].split(':');
                        $('#over_night_start_1').val(tempOverNight3[0]);
                        $('#over_night_price_1').val(tempOverNight3[1]);

                        var tempOverNight31 = tempOverNight2[1].split(':');
                        $('#over_night_start_2').val(tempOverNight31[0]);
                        $('#over_night_price_2').val(tempOverNight31[1]);

                        var tempOverNight32 = tempOverNight2[2].split(':');
                        $('#over_night_start_3').val(tempOverNight32[0]);
                        $('#over_night_price_3').val(tempOverNight32[1]);

                        //Extracting Fixed Days
                        var tempFixedDays1 = Employees.fixed_days;
                        var tempFixedDays2 = tempFixedDays1.split(',');

                        var tempFixedDays3  = tempFixedDays2[0].split(':');
                        $('#day_1').val(tempFixedDays3[1]);
                        var tempFixedDays31 = tempFixedDays2[1].split(':');
                        $('#day_2').val(tempFixedDays31[1]);
                        var tempFixedDays32 = tempFixedDays2[2].split(':');
                        $('#day_3').val(tempFixedDays32[1]);
                        var tempFixedDays33 = tempFixedDays2[3].split(':');
                        $('#day_4').val(tempFixedDays33[1]);
                        var tempFixedDays34 = tempFixedDays2[4].split(':');
                        $('#day_5').val(tempFixedDays34[1]);
                        var tempFixedDays35 = tempFixedDays2[5].split(':');
                        $('#day_6').val(tempFixedDays35[1]);
                        var tempFixedDays36 = tempFixedDays2[6].split(':');
                        $('#day_7').val(tempFixedDays36[1]);

                        //Extracting Locations
                        var tempLocation1 = Employees.location;
                        var tempLocation2 = tempLocation1.split(',');

                        for ( i = 0 ; i < tempLocation2.length ; i++)
                        {
                            $('#'+tempLocation2[i]).prop('checked', true);
                        }
                    });            
                }
            },     
        });
    }

    </script>
</body>
</html>
