<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Edit SMS Master</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <!-- Ladda style -->
    <link href="css/ladda-themeless.min.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
    if (!localStorage.login_var)
    {
        window.stop();
        window.location.replace("index.php");
    }
    </script>
</head>

<body>
    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Edit SMS Master</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="sms_master.php">SMS Master</a>
                        </li>
                        <li class="active">
                            <strong>Edit SMS Master</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="update_sms_master_form">
                                    <div class="form-group">
                                        <label>Enter SMS Master</label>
                                        <input type="text" id="sms_master" name="sms_master" placeholder="Enter SMS Master" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Choose Admin/Manager</label>
                                        <select class="form-control" id="master_employee" name="master_employee" required="">
                                        </select>
                                    </div>                                    
                                    <div>
                                        <button style="background-color: #003399;border-color: #224ea6;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added SMS Master -->
                                        <button id="swal_btn" type="button" style="display:none">
                                        <!-- SMS Master not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            include 'footer.php';
            ?>
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <script>
    $(document).ready(function()
    {
        $("#side12").addClass("activeSM");
        $("#side12 a").css("color","#224ea6");

        viewEmployees();
        viewSmsMasterDetails();

        $("#update_sms_master_form").validate({
            rules: 
            {
                sms_master: {
                    required: true,
                    minlength: 4,
                    maxlength: 4
                },
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );

                var master_code = $('#sms_master').val();
                var employee_name = $('#master_employee').val();

                var sms_master_id = localStorage.sms_master_id;

                var formData = new FormData();
                formData.append("codeid", sms_master_id);
                formData.append("master_code", master_code);
                formData.append("employee_name", employee_name);
                                    
                $.ajax
                ({
                    type:'POST',
                    url:"kos_apis/edit_mastercode.php",
                    data: formData,
                    contentType: false,
                    cache: false,
                    processData:false,
                    success: function(data)
                    {                        
                        var dat = jQuery.parseJSON(data);
                        if( dat.status == "success" )
                        {
                            l.ladda('stop');
                            swal_btn.click();
                        }
                        else if( data.status == "failed" )
                        {
                            l.ladda('stop');
                            swal_btn2.click();
                        }
                    },
                    error: function(data) 
                    {
                        alert("error");
                    }           

                });                
                return false; // extra insurance preventing the default form action
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Updated Successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
                closeOnConfirm: false
            }, function () {
                window.location.assign("sms_master.php");
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: "SMS Master not Updated.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
    });

    function viewEmployees()
    {
        var $list = $("#master_employee");
        $list.empty();
        $.ajax({
            url: "kos_apis/view_all_employee.php",
            type: "GET",
            success: function(data)
            {   
                var count = 1;
                var dat = jQuery.parseJSON(data);

                if ( dat.status == "success")
                {
                    //var vehicle_type = '<option value="select" selected>Select type of scooter</option>';
                    //$list.append(vehicle_type);
                    $.each(dat.Data, function(index,obj) 
                    {
                        if ( obj.emp_active == "0")
                        {
                            //Do Nothing
                        }
                        else
                        {
                            if(obj.emp_role == "Admin" || obj.emp_role == "Manager")
                            {
                                $list.append('<option value="'+obj.emp_username+'">'+obj.emp_username+'</option>');
                            }
                        }
                    });
                }
                else
                {
                    alert("Add Employee");
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function viewSmsMasterDetails()
    {
        var sms_master_id = localStorage.sms_master_id;

        $.ajax({
            url: "kos_apis/view_mastercode.php",
            type: "GET",
            data: {"codeid": sms_master_id},
            success: function(data)
            {   
                var dat = jQuery.parseJSON(data);
                if(dat.status == "success")
                {
                    $.each(dat.Data, function(i,Employees)
                    {
                        $('#sms_master').val(Employees.master_code);
                        $('#master_employee').val(Employees.employee_name);                        
                    });            
                }
            },     
        });
    }
</script>
</body>
</html>
