<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title> Kinf Of Scooters | Batch#</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- FooTable -->
    <link href="css/plugins/footable/footable.core.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/sweetalert.css " rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
    <script>
        if (!localStorage.login_var)
        {
            window.stop();
            window.location.replace("index.php");
        }
    </script>
</head>

<body>

    <div id="wrapper">
        <?php
        include 'navbar_static_side.php';
        ?>

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php
                include 'navbar_static_top.php';
                ?>
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Batch#</strong></h2>
                    <ol class="breadcrumb" style="margin-top:10px">
                        <li>
                            <a href="register.php">View All Locations</a>
                        </li>
                        <li class="active">
                            <strong>Batch#</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>                                           
                                            <th>Location Name</th>
                                            <th>Current Batch</th>
                                            <th>Created Date & Time</th>
                                        </tr>
                                    </thead>
                                    <tbody id="batch_list">
                                       <!-- Dynamically appending Locations List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">

            <?php
                include 'footer.php';
            ?>

        </div>
    </div>

    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
    
    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>
    
    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>
    
    <!-- FooTable -->
    <script src="js/plugins/footable/footable.all.min.js"></script>
    
    <!-- Page-Level Scripts -->
    <script>
    
        $(document).ready(function() 
        {
            $("#side20").addClass("activeSM");
            $("#side20 a").css("color","#224ea6");
    
            viewBatch();
            
            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "There is no Batch Started for this Location..",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("register.php");
                });
            });
        });
    
        function viewBatch()
        {
            var $list = $("#batch_list");
            $list.empty();
            
            $.ajax({
                url : "BigAppLar/apis/api/GetBatchNumber",
                type: "GET",
                data: { "location" : localStorage.location_id },
                success: function(data)
                {   
                    if ( data.status == "success")
                    {
                        $.each( data.data, function(index,obj) 
                        {
                            $list.append('<tr>'+
                                            '<td>'+localStorage.location_name+'</td>'+
                                            '<td>'+obj.name+'</td>'+
                                            '<td>'+obj.created_at+'</td>'+
                                        '</tr>');
                        });
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }
    </script>
</body>
</html>