<!DOCTYPE html>
<html>
<head>
    <title>Dry Clean Locker | Add an Item </title>

    <link href="<?php echo e(asset ('css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('font-awesome/css/font-awesome.css')); ?>" rel="stylesheet">

    <!-- FooTable -->
    <link href="<?php echo e(asset ('css/plugins/footable/footable.core.css')); ?>" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="<?php echo e(asset ('css/sweetalert.css')); ?>" rel="stylesheet">

    <!-- Ladda style -->
    <link href="<?php echo e(asset ('css/ladda-themeless.min.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset ('css/animate.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('css/style.css')); ?>" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>

<body>
    <div id="wrapper">
        <?php echo $__env->make('navbar_static_side', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php echo $__env->make('navbar_static_top', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Add an Item</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="<?php echo e(url('view_item')); ?>">Items</a>
                        </li>
                        <li class="active">
                            <strong>Add an Item</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="add_item_form">
                                    <div class="form-group">
                                        <label>Upload Picture</label>
                                        <input type="file" id="photo" name="photo" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Category List</label>
                                        <select class="form-control" id="category_list" name="category_list" required="">
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Item Name</label>
                                        <input type="text" id="item_name" name="item_name" placeholder="Enter Item name" class="form-control" required>
                                    </div>                                   
                                    <div class="form-group">
                                        <label>Description</label>
                                        <input type="text" id="description" name="description" placeholder="Enter Description" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Price</label>
                                        <input type="number" id="price" name="price" placeholder="Enter Price" onkeypress="return event.charCode == 46 || event.charCode >= 48 && event.charCode <= 57" class="form-control" required>
                                    </div>
                                     
                                    <div>
                                        <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Added Item -->
                                        <button id="swal_btn" type="button" style="display:none"></button>
                                        <!-- Item not  Added -->
                                        <button id="swal_btn2" type="button" style="display:none"></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <script>
    $(document).ready(function()
    {
        $("#side5").addClass("activeSM");
        $("#side5 a").css("color","#224ea6");

        viewCategories();
        
       $("#add_item_form").validate({
            rules: 
            {
                photo: {
                    required: true
                },
                category_list: {
                    required: true
                },
                item_name: {
                    required: true
                },
                description: {
                    required: true,
                },
                price: {
                    required: true
                },
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );
                var swal_btn = document.getElementById("swal_btn");

                var photo= document.getElementById('photo').files[0];
                var category_list = $('#category_list').val();
                var item_name = $('#item_name').val();
                var description = $('#description').val();
                var price = $('#price').val();

                if( category_list == "select" )
                {
                    alert('Please select any Category');
                    l.ladda('stop');
                }
                else
                {
                    var formData = new FormData();
                    formData.append("photo", photo);
                    formData.append("CategoryID", category_list);
                    formData.append("Name", item_name);
                    formData.append("Description", description);
                    formData.append("Price", price);
                                        
                    $.ajax
                    ({
                        type:'POST',
                        url:"/DCL/api/AddItem",
                        data: formData,
                        contentType: false,
                        cache: false,
                        processData:false,
                        success: function(data)
                        {
                            if( data.status == "success" )
                            {
                                l.ladda('stop');
                                swal_btn.click();
                            }
                            else if( data.status == "failed" )
                            {
                                l.ladda('stop');
                                swal_btn2.click();
                            }
                        },
                        error: function(data) 
                        {
                            alert("error");
                        }           
                    }); 
                }               
                return false; // extra insurance preventing the default form action
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Item added successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
                closeOnConfirm: false
            }, function () {
                window.location.assign("<?php echo e(url('view_item')); ?>");
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: "Item not added.",
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
    });

    function viewCategories()
    {
        var $list = $("#category_list");
        $list.empty();
        $.ajax({
            url: "/DCL/api/CategoryView",
            type: "POST",
            success: function(data)
            {   
                if ( data.status == "success")
                {
                    $list.append('<option value="select">Choose a Category</option>');
                    $.each(data.data, function(index,obj) 
                    {
                        $list.append('<option value="'+obj.CategoryID+'">'+obj.Name+'</option>');
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }
</script>

</body>
</html>
