<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\http\Request;
use Illuminate\http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Input;
use Hash;


use DB;


class LocationController extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;


    

    public function AddLocation (Request $request)
    { 
		if(isset($request['Shortcode']) && !empty($request['Shortcode']) AND isset($request['Description']) && !empty($request['Description']) AND isset($request['AddressLine1']) && !empty($request['AddressLine1'])
		AND isset($request['AddressLine2']) && !empty($request['AddressLine2']) AND isset($request['City']) && !empty($request['City']) 
		AND isset($request['CountryID']) && !empty($request['CountryID'])  
		AND isset($request['Postcode']) && !empty($request['Postcode']) AND isset($request['AccessNotes']) && !empty($request['AccessNotes']) 			) 
			{
				$Shortcode=$request['Shortcode'];
				$Description=$request['Description'];
				$AddressLine1=$request['AddressLine1'];
				
				$AddressLine2=$request['AddressLine2'];
				$City=$request['City'];
				$CountryID=$request['CountryID'];
				$RegionID=$request['RegionID'];
				$Postcode=$request['Postcode'];
				$AccessNotes=$request['AccessNotes'];
				
				try 
				{ 
					$inserteed = DB::insert('insert into Location (Shortcode,Description,AddressLine1,AddressLine2,City,CountryID,RegionID,Postcode,AccessNotes) values (?,?,?,?,?,?,?,?,?)',[$Shortcode,$Description,$AddressLine1,$AddressLine2,$City,$CountryID,$RegionID,$Postcode,$AccessNotes]);											  
					return response()->json(['status'=>'success']);   
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Location Already Exist']);
				}


			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }
	
	
	
	
	public function LocationEdit (Request $request)
    { 
		if(isset($request['LocationID']) && !empty($request['LocationID']) AND isset($request['Shortcode']) && !empty($request['Shortcode']) AND isset($request['Description']) && !empty($request['Description']) AND isset($request['AddressLine1']) && !empty($request['AddressLine1'])
		AND isset($request['AddressLine2']) && !empty($request['AddressLine2']) AND isset($request['City']) && !empty($request['City']) 
		AND isset($request['CountryID']) && !empty($request['CountryID'])  
		AND isset($request['Postcode']) && !empty($request['Postcode']) AND isset($request['AccessNotes']) && !empty($request['AccessNotes']) 			) 
			{
				$LocationID=$request['LocationID'];
				$Shortcode=$request['Shortcode'];
				$Description=$request['Description'];
				$AddressLine1=$request['AddressLine1'];
				
				$AddressLine2=$request['AddressLine2'];
				$City=$request['City'];
				$CountryID=$request['CountryID'];
				$RegionID=$request['RegionID'];
				$Postcode=$request['Postcode'];
				$AccessNotes=$request['AccessNotes'];

				$users = DB::select('select * from Location where LocationID = ?', [$LocationID]);
				if($users)
				{
					try 
					{ 
						$user_new = DB::update('update Location SET Shortcode = ? , Description = ? , AddressLine1 = ?, AddressLine2 = ? , City= ? , CountryID= ? ,RegionID=?, Postcode=?,AccessNotes=?   where LocationID = ?', [$Shortcode,$Description,$AddressLine1,$AddressLine2, $City , $CountryID ,$RegionID,$Postcode,$AccessNotes,$LocationID]);
						if ( $user_new)                             
						{
							return response()->json(['status'=>'success']);
						}
						else 
						{
							return response()->json(['status'=>'failed','error'=>'Sql Error']);
						}
					
					}
					
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						return response()->json(['status'=>'failed','error'=>'Sql Error']);
					}
					
									  
					//return response()->json(['status'=>'success','data'=>$users ]);
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong Location Id']);
				}	
					  
				
			
			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }

public function LocationView (Request $request)
    {

		if(isset($request['LocationID']) && !empty($request['LocationID']))
		{
//echo "yahaa";
			$LocationID=$request['LocationID'];
			$flag =0;
			$users = DB::select('select * from Location where LocationID = ? AND  DeletedFlag= ?', [$LocationID,$flag]);

				if($users)
				{
					return response()->json(['status'=>'success','data'=>$users]);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'No Information Found']);
				}
			
		}
		else 
		{
			$flag =0;
			$users = DB::select('select * from Location where DeletedFlag= ?', [$flag]);

			
				if($users)
				{
					return response()->json(['status'=>'success','data'=>$users]);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'No Information Found']);
				}
			
		}
        
    }
	
	
	public function LocationDelete(Request $request)
    {

		if(isset($request['LocationID']) && !empty($request['LocationID']))
		{
//echo "yahaa";
			$LocationID=$request['LocationID'];
			
			$users = DB::select('select * from Location where LocationID = ?', [$LocationID]);
				if($users)
				{
					try 
					{ 
						$flag =1;
						$DeletedFlag =1;
			                        $user_new = DB::update('update Location SET DeletedFlag= ?   where LocationID = ?', [$DeletedFlag,$LocationID]);
						if ( $user_new)
						{
							return response()->json(['status'=>'success']);
						}
						else 
						{
							return response()->json(['status'=>'failed','error'=>'Sql Error']);
						}
					
					}
					
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						return response()->json(['status'=>'failed','error'=>'Sql Error']);
					}
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Wrong Location Id']);
				}
			
		}
		else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			
		}
        
    }



public function LocationLockers (Request $request)
    {

			$flag =0;
			$locs = DB::select('select * from Location where DeletedFlag= ?', [$flag]);
				if($locs)
				{
					foreach ($locs as $loc) 
					{
					$Loc_id = $loc->LocationID;
                                        $Lock_status="E";
						$lockers = DB::select('select * from Locker where LocationID = ? AND  DeletedFlag= ?', [$Loc_id,$flag]);
						if($lockers)
						{
							foreach ($lockers as $locker) 
							{
							  $Lock_st = $locker->LockerStatus;
                                                          if( $Lock_st == "C")
                                                           $Lock_status = $Lock_st;
						
							}

							
						}
						else 
						{
							$Lock_st = "No Locker";
						}
						
						$loc->lockerStatus = $Lock_status;
				
					}
	                             return response()->json(['status'=>'success','data'=>$locs]);					
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'No Information Found']);
				}
			
		
        
    }

}

