<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Maktabti | Order Details </title>

    <link href="<?php echo e(asset ('css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('font-awesome/css/font-awesome.css')); ?>" rel="stylesheet">

    <!-- FooTable -->
    <link href="<?php echo e(asset ('css/plugins/footable/footable.core.css')); ?>" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="<?php echo e(asset ('css/sweetalert.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset ('css/animate.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('css/style.css')); ?>" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>
<body>
    <div id="wrapper">

        <!-- Side Navbar -->
        <?php echo $__env->make('navbar_static_side', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 

        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <!-- Top Navbar -->
                <?php echo $__env->make('navbar_static_top', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Order Details</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="<?php echo e(url('view_orders')); ?>">Orders</a>
                        </li>
                        <li class="active">
                            <strong>Order Details</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce" style="padding-bottom: 0px">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Item List</th>
                                            <th>Quantity</th>
                                            <th>Unit Price</th>
                                            <th>Total Price</th>
                                        </tr>
                                    </thead>
                                    <tbody id="order_details_list">
                                       <!-- Dynamically appending order_details_list -->
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

           

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>

            <!-- Footer -->
            <?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        </div>
    </div>

    
    <!-- Modal Close -->


    <!-- Mainly scripts -->
    <script src="<?php echo e(asset ('js/jquery-3.1.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/metisMenu/jquery.metisMenu.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/slimscroll/jquery.slimscroll.min.js')); ?>"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo e(asset ('js/inspinia.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/pace/pace.min.js')); ?>"></script>

    <!-- Sweet alert -->
    <script src="<?php echo e(asset ('js/plugins/sweetalert/sweetalert.min.js')); ?>"></script>

    <!-- FooTable -->
    <script src="<?php echo e(asset ('js/plugins/footable/footable.all.min.js')); ?>"></script>

    <!-- Page-Level Scripts -->
    <script>
        $(document).ready(function() 
        {
            $("#side1").addClass("activeSM");
            $("#side1 a").css("color","#224ea6");

            viewOrderDetails();

            //Empty List
            $('#swal_btn').click(function(){
                swal({
                     title: "List is Empty!",
                    text: "No Detail Found",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("<?php echo e(url('view_orders')); ?>");
                });
            });
        });

        function viewOrderDetails()
        {
            var order_details_id = localStorage.order_details_id;
            var $list = $("#order_details_list");
            $list.empty();
            $.ajax({
                url: "/DCL/api/ViewOrder",
                type: "POST",
                data: {"OrderID" : order_details_id },
                success: function(data)
                {   
                    var count = 1;
                    var netTotal=0;
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {               
                            //Checking whether Customer Notes exist or not            
                            if(obj.Notes)
                            {
                                var lowerNotes = obj.Notes;
                                var upperNotes = lowerNotes.charAt(0).toUpperCase() + lowerNotes.substr(1);
                                $('#customer_note').html(upperNotes);
                            }
                            else
                            {
                                $('#customer_note').html("Customer has not entered any Notes.");
                            }

                            //Checking whether Cleaner Notes exist or not  
                            if(obj.cleaner_note)
                            {
                                $('#cleaner_note_div').css('display','block');
                                $('#cleaner_note_paragraph').html(obj.cleaner_note);
                                $('#customer_note_button').css('display','none');
                                $('#cleaner_note').val(obj.cleaner_note);
                            }

                            //If status is not collected Admin can not Add notes.
                            if( obj.OrderStatus != "Collected")
                            {
                                $('#customer_note_button').css('display','none');
                                $('#customer_note_button_edit').css('display','none');
                            }

                            $.each(obj.items, function(index1,obj1) 
                            {
                                netTotal = netTotal + parseFloat(obj1.ItemTotalCost);

                                var unit_price = obj1.ItemTotalCost / obj1.Quantity;

                                var price_fixed = parseFloat(obj1.ItemTotalCost);
                                var new_price_fixed = price_fixed.toFixed(2);


                                $list.append('<tr>'+
                                                '<td><strong>'+count+'</strong></td>'+
                                                '<td>'+obj1.ItemName+'</td>'+
                                                '<td>'+obj1.Quantity+'</td>'+
                                                '<td>€'+unit_price.toFixed(2)+'</td>'+
                                                '<td>€'+new_price_fixed+'</td>'+
                                            '</tr>');
                                count++;
                            });
                        });
                        if( count == 1)
                        {
                            swal_btn.click();
                        }
                        else
                        {
                            $list.append('<tr>'+
                                                '<td></td>'+
                                                '<td></td>'+
                                                '<td></td>'+
                                                '<td><strong>Net Total:</strong></td>'+
                                                '<td><strong>€'+netTotal.toFixed(2)+'</strong></td>'+
                                            '</tr>');
                        }
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }

        function addCleanerNote()
        {
            var order_details_id = localStorage.order_details_id;
            var cleaner_note_value = $('#cleaner_note').val();

            if( cleaner_note_value )
            {
                $.ajax({            
                    url: "/DCL/api/CleanerNote",
                    type: "POST",
                    data: { "OrderID": order_details_id , "cleaner_note" : cleaner_note_value },
                    success: function(data)
                    {
                        if( data.status == "success" )
                        {
                            $('#cleaner_note_modal').modal('hide');
                            viewOrderDetails();
                        }
                        else if ( data.status == "failed" )
                        {
                            alert("failed");
                        }
                    },
                    error: function(data) 
                    {
                    }           
                });
            }
            else
            {
                alert("Cleaner note is empty. Please enter some text to Add Note.");
            }
        }
    </script>
</body>
</html>
