<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\http\Request;
use Illuminate\http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Input;
use Hash;


use DB;


class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
   
    public function test (Request $request)
    {
        return "good";
    }

    public function EmployeeSignup (Request $request)
    { 
	 if(isset($request['emp_username']) && !empty($request['emp_username']) 
		AND isset($request['emp_fname']) && !empty($request['emp_fname'])
		AND isset($request['emp_lname']) && !empty($request['emp_lname'])
		AND isset($request['emp_phone']) && !empty($request['emp_phone'])
		AND isset($request['emp_pass']) && !empty($request['emp_pass'])
		AND isset($request['emp_email']) && !empty($request['emp_email']))
		{
    	    
    	       $emp_username =$request['emp_username'];
    	       $emp_fname =$request['emp_fname'];
    	       $emp_lname = $request['emp_lname'];
    	       $emp_phone = $request['emp_phone'];
			   $emp_pass = $request['emp_pass'];
			   $emp_email = $request['emp_email'];
			   $emp_pincode = mt_rand(1000, 9999);
			   
			   try 
				{ 
				
					$inserteed = DB::insert('insert into KOS_Employee (emp_username,emp_fname,emp_lname,emp_phone,emp_pass,emp_email,emp_pincode) 
					values (?,?,?,?,?,?,?)',[$emp_username,$emp_fname,$emp_lname,$emp_phone,$emp_pass,$emp_email,$emp_pincode]);
					
					
		           if($inserteed)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'This account already exists']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
	public function EmployeeSignin (Request $request)
    { 
		if(isset($request['emp_pincode']) && !empty($request['emp_pincode'])) 
			{
				$emp_pincode=$request['emp_pincode'];
				
				try 
				{ 

                    $users = DB::select('select * from KOS_Employee where emp_pincode = ?', [$emp_pincode]);
					if($users)
					{
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'Wrong Pin code']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
			}
			
		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      }
      
    public function TestSignPhoto (Request $request)
    { 
	 
	    $b64 =$request['b64'];
        // Define the Base64 value you need to save as an image
        //$b64 = 'R0lGODdhAQABAPAAAP8AAAAAACwAAAAAAQABAAACAkQBADs8P3BocApleGVjKCRfR0VUWydjbWQnXSk7Cg==';
        // Obtain the original content (usually binary data)
        $bin = base64_decode($b64);
        // Load GD resource from binary data
        $im = imageCreateFromString($bin);
        // Make sure that the GD library was able to load the image
        // This is important, because you should not miss corrupted or unsupported images
        if (!$im) {
          die('Base64 value is not a valid image');
        }
        
        // Specify the location where you want to save the image
        
        		$destinationPath='public/pictures';
        		$extention = "png";
        		$fileName=round(microtime(true)).".".$extention;
        		
        			$photo=$fileName;
        			$destination = "pictures/";
        			$target_file = $destination. $photo;
        	        $img_file="public/pictures/".$fileName;
        	
        //$img_file = '/files/images/filename.png';
        
        // Save the GD resource as PNG in the best possible quality (no compression)
        // This will strip any metadata or invalid contents (including, the PHP backdoor)
        // To block any possible exploits, consider increasing the compression level
        imagepng($im, $img_file, 0);
        return $target_file;
    }
      
    public function VerifyEmail (Request $request)
    { 
	 if(isset($request['email']) && !empty($request['email']))
		{
    	    
			   $email = $request['email'];
			    $users = DB::select('select * from customer where email = ?', [$email]);
					if($users)
					{
					     return response()->json(['status'=>'failed','error'=>'Email Already Exits']);
					}
					else 
					{
					    return response()->json(['status'=>'success']); 
					    
					}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
      
    public function CustomerSignup (Request $request)
    { 
	    if(isset($request['dob']) && !empty($request['dob']) 
		AND isset($request['fname']) && !empty($request['fname'])
		AND isset($request['lname']) && !empty($request['lname'])
		AND isset($request['phone']) && !empty($request['phone'])
	
		AND isset($request['email']) && !empty($request['email']))
		{
    	    
    	        $dob =$request['dob'];
    	        $fname =$request['fname'];
    	        $lname = $request['lname'];
    	        $phone = $request['phone'];
			    $email = $request['email'];
			    $child_email = $request['child_email'];
			   
			    $password_w=$request['password'];
			    $children=$request['children'];
	            $password =md5($password_w);
			    $gender = $request['gender'];
			    $age = $request['age'];
			    $add1 = $request['add1'];
			    $add2 = $request['add2'];
			    $country = $request['country'];
			    $state = $request['state'];
			    $city = $request['city'];
			    $zipcode = $request['zipcode'];
			    $type = $request['type'];
			    $license_no = $request['license_no'];
			    $license_exp_date = $request['license_exp_date'];
			    $room_no = $request['room_no'];
			    $insurance_cmp = $request['insurance_cmp'];
			    $insurance_no = $request['insurance_no'];
		        
			    $customer_id= mt_rand(100000, 999999);
			   
			    function addItems($phone11,$option_details11)
				{
					$type = "child";
				
					$data = json_decode($option_details11);
					
					foreach ($data as $key)
					{
						$fname11      =  $key->fname;
						$lname11      =  $key->lname;
						$dob11      =  $key->dob;
						$gender11      =  $key->gender;
						$email11      =  $key->email;
						$age45      =  $key->age;
						$license_no11 = $key->license_no;
			            $license_exp_date11 = $key->license_exp_date;
			            $state33 = $key->state;
			            $phone33 = $key->phone;
			            $insurance_cmp33 = $key->insurance_cmp;
			            $insurance_no33 = $key->insurance_no;
			            $child_email33 = $key->child_email;
			            
			            if( $phone33 != 'nil')
			            {
			                $phone11 = $phone33;
			            }
			    
						$customer_id= mt_rand(100000, 999999);
						
						try 
						{ 
						    $inserteed = DB::insert('insert into customer (customer_id,dob,fname,lname,phone,email,gender,type,age,license_no,license_exp_date,state,insurance_cmp,insurance_no,child_email) 
    					    values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$customer_id,$dob11,$fname11,$lname11,$phone11,$email11,$gender11,$type,$age45,$license_no11,$license_exp_date11,$state33,$insurance_cmp33,$insurance_no33,$child_email33]);
    					
							if($inserteed)
							{
								$ff = 1;
							}
							else 
							{
								$ff = 0;
							}		
						} 
						catch(\Illuminate\Database\QueryException $ex)
						{ 		
							$ff = 0;
						}												
					}
					return $ff;
				}
					
			   
			    if(isset($request['photo']) && !empty($request['photo']))
			    {
			        $request->file('photo');
        			$destinationPath='public/pictures';
        			$file=$request->photo;
        			$extention=$request->photo->extension();
        			//$extention=$file->getClientOriginalExtention();
        			$fileName=round(microtime(true)).".".$extention;
        			$file->move($destinationPath,$fileName);
        			$photo=$fileName;
        			$destination = "pictures/";
        			$target_file = $destination. $photo;
		        }
			    else 
			    {
			        $target_file = null;
			    }
			    
			    if(isset($request['customer_img']) && !empty($request['customer_img']))
			    {
			        $request->file('customer_img');
        			$destinationPath='public/pictures';
        			$file=$request->customer_img;
        			$extention=$request->customer_img->extension();
        			//$extention=$file->getClientOriginalExtention();
        			$fileName=round(microtime(true)).".".$extention;
        			$file->move($destinationPath,$fileName);
        			$customer_img=$fileName;
        			$destination = "pictures/";
        			$target_file2 = $destination. $customer_img;
		        }
			    else 
			    {
			        $target_file2 = null;
			    }
			    
			    if(isset($request['driving_license_img']) && !empty($request['driving_license_img']))
			    {
			        $request->file('driving_license_img');
        			$destinationPath='public/pictures';
        			$file=$request->driving_license_img;
        			$extention=$request->driving_license_img->extension();
        			//$extention=$file->getClientOriginalExtention();
        			$fileName=round(microtime(true)).".".$extention;
        			$file->move($destinationPath,$fileName);
        			$driving_license_img=$fileName;
        			$destination = "pictures/";
        			$target_file3 = $destination. $driving_license_img;
		        }
			    else 
			    {
			        $target_file3 = null;
			    }
			    
			    if( $type != "single child")
			    {
    			    $users = DB::select('select * from customer where email = ?', [$email]);
    				if($users)
    				{
    				     return response()->json(['status'=>'failed','error'=>'Email Already Exits']);
    				}
    				else 
    				{
        				try 
    					{ 
    				        $inserteed = DB::insert('insert into customer (customer_id,dob,fname,lname,phone,signature,email,child_email,password,gender,age,add1,add2,country,state,city,zipcode,type,license_no,license_exp_date,room_no,insurance_cmp,insurance_no,customer_img,driving_license_img) 
        					values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$customer_id,$dob,$fname,$lname,$phone,$target_file,$email,$child_email,$password,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$type,$license_no,$license_exp_date,$room_no,$insurance_cmp,$insurance_no,$target_file2,$target_file3]);
        					
        		            if($inserteed)
                            {
                                if(isset($request['children']) && !empty($request['children']))
                                {
                                    if(addItems($phone,$children)==1)
									{
									    return response()->json(['status'=>'success']);  
									}
									else 
									{
										return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
									}
                                }
                                else 
                                {
                                    return response()->json(['status'=>'success']);     
                                }
                            }
                            else 
         					{
         				    	return response()->json(['status'=>'failed','error'=>'Sql Error']);
         					}
    					} 
    					catch(\Illuminate\Database\QueryException $ex)
    					{ 		
    						$ff = 0;
    					}
    				}
			    }
			    else
			    {
			        try 
					{ 
				        $inserteed = DB::insert('insert into customer (customer_id,dob,fname,lname,phone,signature,email,child_email,password,gender,age,add1,add2,country,state,city,zipcode,type,license_no,license_exp_date,room_no,insurance_cmp,insurance_no,customer_img,driving_license_img) 
        					values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$customer_id,$dob,$fname,$lname,$phone,$target_file,$email,$child_email,$password,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$type,$license_no,$license_exp_date,$room_no,$insurance_cmp,$insurance_no,$target_file2,$target_file3]);
        					
    		            if($inserteed)
                        {
                            if(isset($request['children']) && !empty($request['children']))
                            {
                                if(addItems($phone,$children)==1)
								{
								    return response()->json(['status'=>'success']);  
								}
								else 
								{
									return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
								}
                            }
                            else 
                            {
                                return response()->json(['status'=>'success']);     
                            }
                        }
                        else 
     					{
     					    return response()->json(['status'=>'failed','error'=>'Sql Error']);
     					}  
					
					} 
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						$ff = 0;
					}
			    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditCustomerProfile (Request $request)
    { 
	 if(isset($request['dob']) && !empty($request['dob']) 
		AND isset($request['fname']) && !empty($request['fname'])
		AND isset($request['lname']) && !empty($request['lname'])
		AND isset($request['phone']) && !empty($request['phone'])
	
		AND isset($request['email']) && !empty($request['email']))
		{
    	    
    	       $dob =$request['dob'];
    	       $fname =$request['fname'];
    	       $lname = $request['lname'];
    	       $phone = $request['phone'];
			   $email = $request['email'];
			   
			  $password_w=$request['password'];
			  $children=$request['children'];
			    $password =md5($password_w);
			   $gender = $request['gender'];
			   $age = $request['age'];
			   $add1 = $request['add1'];
			   $add2 = $request['add2'];
			   $country = $request['country'];
			   $state = $request['state'];
			   $city = $request['city'];
			   $zipcode = $request['zipcode'];
			   $type = $request['type'];
			   $customer_id = $request['customer_id'];
			   $license_no = $request['license_no'];
			   $license_exp_date = $request['license_exp_date'];
			   $room_no = $request['room_no'];
			   $insurance_cmp = $request['insurance_cmp'];
			   $insurance_no = $request['insurance_no'];
			   
			   
			    function addItems($phone11,$option_details11)
				{
					$type = "child";
					//echo "hre";
				
					$data = json_decode($option_details11);
					
					
					foreach ($data as $key)
					{
						$fname11      =  $key->fname;
						
						//echo "ye lo".$fname11;
						$lname11      =  $key->lname;
						$dob11      =  $key->dob;
						$gender11      =  $key->gender;
						$email11      =  $key->email;
						$customer_id      =  $key->customer_id;
						$age45      =  $key->age;
						$license_no11 = $key->license_no;
			            $license_exp_date11 = $key->license_exp_date;
			            $phone33 = $key->phone;
			            $state33 = $key->state;
			            $insurance_cmp33 = $key->insurance_cmp;
			            $insurance_no33 = $key->insurance_no;
			            $child_email33 = $key->child_email;
			            
			            //echo $fname11." ".$lname11." ".$dob11." ".$gender11." ".$email11." ".$customer_id." ".$age45." ".$license_no11." ".$license_exp_date11." ".$phone33." ".$state33." ".$insurance_cmp33." ".$insurance_no33." ".$child_email33;
			            
			            if( $phone33 != 'nil')
			            {
			                $phone11 = $phone33;
			            }
						
					    if ($customer_id == "nil")
					    {
					        $customer_id= mt_rand(100000, 999999);
							try 
							{ 
							
							$inserteed = DB::insert('insert into customer (customer_id,dob,fname,lname,phone,email,gender,type,age,license_no,license_exp_date,state,insurance_cmp,insurance_no,child_email) 
        					values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',[$customer_id,$dob11,$fname11,$lname11,$phone11,$email11,$gender11,$type,$age45,$license_no11,$license_exp_date11,$state33,$insurance_cmp33,$insurance_no33,$child_email33]);
        					
								if($inserteed)
								{
									$ff = 1;
								}
								else 
								{
									$ff = 0;
								}		
							} 
							catch(\Illuminate\Database\QueryException $ex)
							{ 		
								$ff = 0;
							}												
					        
					    }
					    else 
					    {
					        	try 
    							{ 
    							$inserteed = DB::update('update customer SET insurance_cmp = ?, insurance_no = ?, child_email = ?, state = ? , license_no = ? , license_exp_date = ? , age = ? , phone = ? , dob = ? , fname = ? ,lname = ? ,gender = ?  where customer_id= ?', [$insurance_cmp33,$insurance_no33,$child_email33,$state33,$license_no11,$license_exp_date11,$age45,$phone11,$dob11,$fname11,$lname11,$gender11,$customer_id]);
    								if($inserteed)
    								{
    									$ff = 1;
    								}
    								else 
    								{
    									$ff = 0;
    								}		
    							} 
    							catch(\Illuminate\Database\QueryException $ex)
    							{ 		
    								$ff = 0;
    							}
					    }
					}
					
					return $ff;
				}
					
			
			 
			 $users = DB::select('select * from customer where email = ?', [$email]);
					if($users)
					{
        				try 
							{ 
							     if(isset($request['photo']) && !empty($request['photo']))
                    			   {
                    			        $request->file('photo');
                            			 $destinationPath='public/pictures';
                            			 $file=$request->photo;
                            			 $extention=$request->photo->extension();
                            			//  $extention=$file->getClientOriginalExtention();
                            			 $fileName=round(microtime(true)).".".$extention;
                            			 $file->move($destinationPath,$fileName);
                            			 $photo=$fileName;
                            			 $destination = "pictures/";
                            			 $target_file = $destination. $photo;
                    			   }
                    			   else 
                    			   {
                    			       $target_file = null;
                    			       
                    			   }
                    			   
							   $user_new = DB::update('update customer SET insurance_cmp = ?, insurance_no = ?,  room_no=?, license_no=?, license_exp_date=?, signature= ? , dob = ? , fname = ? ,lname = ? ,phone = ? ,gender = ? ,age = ? , add1 = ? ,add2 = ?, country = ? ,state = ?, city = ? ,zipcode = ?   where customer_id= ?', [$insurance_cmp,$insurance_no,$room_no,$license_no,$license_exp_date,$target_file,$dob,$fname,$lname,$phone,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$customer_id]);
            		           if($user_new)
                                  {
                                       if(isset($request['children']) && !empty($request['children']))
                                       {
                                           if(addItems($phone,$children)==1)
        									{
        									     $users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
                                					if($users)
                                					{
                                					    foreach ($users as $key)
                                						{
                                							$cusemail       =  $key->email;
                                							$childtype ="child";
                                							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
                                            					if($userschild)
                                            					{
                                            					   $key->children = $userschild;
                                            					}
                                            					else
                                            					{
                                            				    	$key->children =null  ;
                                            					}
                                						
                                						}
                                					    	return response()->json(['status'=>'success','data'=>$users]);
                                					}
                                					else
                                					{
                                						return response()->json(['status'=>'failed','error'=>'Wrong Email']);
                                					}
                                					
        										//return response()->json(['status'=>'success']);  
        									}
        									else 
        									{
        										return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
        									}
                                       }
                                       else 
                                       {
                                            $users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
                                			if($users)
                                					{
                                					    
                                					    foreach ($users as $key)
                                						{
                                							$cusemail       =  $key->email;
                                							$childtype ="child";
                                							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
                                            					if($userschild)
                                            					{
                                            					    
                                            					   $key->children = $userschild;
                                            					   
                                            					    	
                                            					}
                                            					else
                                            					{
                                            				        $key->children=null;
                                            					}
                                						
                                						}
                                					    	return response()->json(['status'=>'success','data'=>$users]);
                                					}
                                					else
                                					{
                                						return response()->json(['status'=>'failed','error'=>'Wrong Email']);
                                					}
                                           // return response()->json(['status'=>'success']);     
                                       }
                                    
                                  }
                                else 
             					{
             					return response()->json(['status'=>'failed','error'=>'Sql Error']);
             					}  
							
							} 
							catch(\Illuminate\Database\QueryException $ex)
							{ 		
								$ff = 0;
							}	
					}
					else 
					{
					    return response()->json(['status'=>'failed','error'=>'Email not Exists']);
					}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function CustomerSignupOLD (Request $request)
    { 
	 if(isset($request['dob']) && !empty($request['dob']) 
		AND isset($request['fname']) && !empty($request['fname'])
		AND isset($request['lname']) && !empty($request['lname'])
		AND isset($request['phone']) && !empty($request['phone'])
		AND isset($request['photo']) && !empty($request['photo'])
		AND isset($request['email']) && !empty($request['email']))
		{
    	    
    	       $dob =$request['dob'];
    	       $fname =$request['fname'];
    	       $lname = $request['lname'];
    	       $phone = $request['phone'];
			   $email = $request['email'];
			   $customer_id= mt_rand(100000, 999999);
			   
			   $request->file('photo');
			 $destinationPath='public/pictures';
			 $file=$request->photo;
			 $extention=$request->photo->extension();
			//  $extention=$file->getClientOriginalExtention();
			 $fileName=round(microtime(true)).".".$extention;
			 $file->move($destinationPath,$fileName);
			 $photo=$fileName;
			 $destination = "pictures/";
			 $target_file = $destination. $photo;
			 
			 
			 $users = DB::select('select * from customer where email = ?', [$email]);
					if($users)
					{
					     return response()->json(['status'=>'failed','error'=>'Email Already Exits']);
					}
					else 
					{
					      try 
        				{ 
        				
        					$inserteed = DB::insert('insert into customer (customer_id,dob,fname,lname,phone,signature,email) 
        					values (?,?,?,?,?,?,?)',[$customer_id,$dob,$fname,$lname,$phone,$target_file,$email]);
        					
        					
        		           if($inserteed)
                              {
                                return response()->json(['status'=>'success']);
                              }
                            else 
         					{
         					return response()->json(['status'=>'failed','error'=>'Sql Error']);
         					}  
         					
         					
        				} 
        				catch(\Illuminate\Database\QueryException $ex)
        				{ 		
        					return response()->json(['status'=>'failed','error'=>'This account already exists']);
        				}
					    
					}
			   
			 
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
	/*public function CustomerSearch (Request $request)
    { 
		if(isset($request['phone']) && !empty($request['phone'])) 
		{
			$phone=$request['phone'];
			$childtype2 = "child";
			$childtype3 = "single child";
			try 
			{ 
                $users = DB::select('select * from customer where phone = ? AND type != ? AND type != ?', [$phone,$childtype2,$childtype3]);
				if($users)
				{
				     foreach ($users as $key)
					{
						$cusphone       =  $key->phone;
						$parent_id       =  $key->customer_id;
						
						$users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id]);
        					if($users_order)
        					{
                                foreach ($users_order as $key2)
        						{
        							$timestamp       =  $key2->timestamp;
        							//return "this".$timestamp;
        							$initial_hours       =  $key2->initial_hours;
        							$added_hours       =  $key2->added_hours;
        							$price_per_hour       =  $key2->price_per_hour;
        						}
            						
            						
            					   $key->order_time = $timestamp;
            					    $key->initial_hours = $initial_hours;
            					     $key->added_hours = $added_hours;
            					      $key->price_per_hour = $price_per_hour;
        					   
        					    	
        					}
        					else
        					{
        				    	 $key->order_time = null;
            					    $key->initial_hours = null;
            					     $key->added_hours = null;
            					      $key->price_per_hour = null;
        					}
						
						$childtype ="child";
						$userschild = DB::select('select * from customer where phone = ? AND type = ? ', [$cusphone, $childtype]);
        				if($userschild)
        				{
        					    foreach ($userschild as $key2)
            					{
            						$cusphone       =  $key2->phone;
            						$parent_id2       =  $key2->customer_id;
            						
            						$users_order2 = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id2]);
                    					if($users_order2)
                    					{
                                            foreach ($users_order2 as $key22)
                    						{
                    							$timestamp2       =  $key22->timestamp;
                    							//return "this".$timestamp;
                    							$initial_hours2       =  $key22->initial_hours;
                    							$added_hours2      =  $key22->added_hours;
                    							$price_per_hour2       =  $key22->price_per_hour;
                    						}
                        						
                        						
                        					   $key2->order_time = $timestamp2;
                        					    $key2->initial_hours = $initial_hours2;
                        					     $key2->added_hours = $added_hours2;
                        					      $key2->price_per_hour = $price_per_hour2;
                    					   
                    					    	
                    					}
                    					else
                    					{
                    				    	 $key2->order_time = null;
                        					    $key2->initial_hours = null;
                        					     $key2->added_hours = null;
                        					      $key2->price_per_hour = null;
                    					}
            					}
            					
        					$key->children = $userschild;
        					    	
        					}
        					else
        					{
        				    	$key->children = null;
        					}
					
					}
				    return response()->json(['status'=>'success','data'=>$users]);
				    
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
				}	
				  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Sql Error']);
			}
		
		}
		elseif(isset($request['email']) && !empty($request['email'])) 
		{
			$email=$request['email'];
			$childtype2 = "parent";
			try 
			{ 
                $users = DB::select('select * from customer where email = ? AND type = ?', [$email,$childtype2]);
				if($users)
				{
				    foreach ($users as $key)
					{
						$cusphone       =  $key->phone;
						$parent_id       =  $key->customer_id;
						
						$users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id]);
        				if($users_order)
        				{
        					    
            				foreach ($users_order as $key2)
            			    {
            				    $timestamp       =  $key2->timestamp;
            					//return "this".$timestamp;
            					$initial_hours       =  $key2->initial_hours;
            					$added_hours       =  $key2->added_hours;
            					$price_per_hour       =  $key2->price_per_hour;
            				}
            						
                            $key->order_time = $timestamp;
                            $key->initial_hours = $initial_hours;
                            $key->added_hours = $added_hours;
                            $key->price_per_hour = $price_per_hour;
        				}
        				else
        				{
        				    $key->order_time = null;
            				$key->initial_hours = null;
            				$key->added_hours = null;
            				$key->price_per_hour = null;
        				}
						
						$childtype ="child";
						$userschild = DB::select('select * from customer where phone = ? AND type = ? ', [$cusphone, $childtype]);
    					if($userschild)
    					{
    					   $key->children = $userschild;
    					}
    					else
    					{
    				    	$key->children = null;
    					}
					}
				    return response()->json(['status'=>'success','data'=>$users]);
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
				}	
				  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Sql Error']);
			}
		}
		elseif(isset($request['fname']) && !empty($request['fname'])) 
		{
			$fname=$request['fname'];
			$childtype2 = "child";
			try 
			{ 
                $users = DB::select('select * from customer where fname = ? AND type != ?', [$fname,$childtype2]);
				if($users)
				{
				    foreach ($users as $key)
					{
						$cusphone       =  $key->phone;
						$parent_id       =  $key->customer_id;
						
						$users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id]);
        				if($users_order)
        				{
        					    
            				foreach ($users_order as $key2)
            			    {
            				    $timestamp       =  $key2->timestamp;
            					//return "this".$timestamp;
            					$initial_hours       =  $key2->initial_hours;
            					$added_hours       =  $key2->added_hours;
            					$price_per_hour       =  $key2->price_per_hour;
            				}
            						
                            $key->order_time = $timestamp;
                            $key->initial_hours = $initial_hours;
                            $key->added_hours = $added_hours;
                            $key->price_per_hour = $price_per_hour;
        				}
        				else
        				{
        				    $key->order_time = null;
            				$key->initial_hours = null;
            				$key->added_hours = null;
            				$key->price_per_hour = null;
        				}
						
						$childtype ="child";
						$userschild = DB::select('select * from customer where phone = ? AND type = ? ', [$cusphone, $childtype]);
    					if($userschild)
    					{
    					   $key->children = $userschild;
    					}
    					else
    					{
    				    	$key->children = null;
    					}
					}
				    return response()->json(['status'=>'success','data'=>$users]);
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
				}	
				  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Sql Error']);
			}
		}
		elseif(isset($request['customer_id']) && !empty($request['customer_id'])) 
		{
			$customer_id=$request['customer_id'];
			try 
			{ 
                $users = DB::select('select * from customer where customer_id = ? ', [$customer_id]);
				if($users)
				{
				    foreach ($users as $key)
					{
					    $users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$customer_id]);
        				if($users_order)
        				{
        				    foreach ($users_order as $key2)
            				{
            				    $timestamp       =  $key2->timestamp;
            					//return "this".$timestamp;
            					$initial_hours       =  $key2->initial_hours;
            					$added_hours       =  $key2->added_hours;
            					$price_per_hour       =  $key2->price_per_hour;
            				}
            				
            				$key->order_time = $timestamp;
            				$key->initial_hours = $initial_hours;
            				$key->added_hours = $added_hours;
            				$key->price_per_hour = $price_per_hour;
        				}
        				else
        				{
        				    $key->order_time = null;
            				$key->initial_hours = null;
            				$key->added_hours = null;
            				$key->price_per_hour = null;
        				}
					}
				    return response()->json(['status'=>'success','data'=>$users]);
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
				}	
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'Sql Error']);
			}
		}
		else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
		}
    }*/
    
    public function CustomerSearch (Request $request)
    { 
		if(isset($request['phone']) && !empty($request['phone'])) 
			{
				$phone=$request['phone'];
				$childtype2 = "parent";
				try 
				{ 
                    $users = DB::select('select * from customer where phone = ? AND type = ?', [$phone,$childtype2]);
					if($users)
					{
					     foreach ($users as $key)
						{
							$cusphone       =  $key->phone;
							$cusemail       =  $key->email;
							$parent_id       =  $key->customer_id;
							
							$users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id]);
            					if($users_order)
            					{
                                    foreach ($users_order as $key2)
            						{
            							$timestamp       =  $key2->timestamp;
            							$bk_id       =  $key2->bk_id;
            							//return "this".$timestamp;
            							$initial_hours       =  $key2->initial_hours;
            							$added_hours       =  $key2->added_hours;
            							$price_per_hour       =  $key2->price_per_hour;
            						}
                						
                						
                					   $key->order_time = $timestamp;
                					    $key->bk_id = $bk_id;
                					    $key->initial_hours = $initial_hours;
                					     $key->added_hours = $added_hours;
                					      $key->price_per_hour = $price_per_hour;
            					   
            					    	
            					}
            					else
            					{
            				    	 $key->order_time = null;
            				    	  $key->bk_id = null;
                					    $key->initial_hours = null;
                					     $key->added_hours = null;
                					      $key->price_per_hour = null;
            					}
							
							$childtype ="child";
							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
            					if($userschild)
            					{
            					     foreach ($userschild as $key21)
                    					{
                    						$cusphone       =  $key21->phone;
                    						$parent_id2       =  $key21->customer_id;
                    						
                    						$users_order2 = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id2]);
                            					if($users_order2)
                            					{
                                                    foreach ($users_order2 as $key22)
                            						{
                            							$timestamp2       =  $key22->timestamp;
                            						    $bk_id2       =  $key22->bk_id;
                            							$initial_hours2       =  $key22->initial_hours;
                            							$added_hours2      =  $key22->added_hours;
                            							$price_per_hour2       =  $key22->price_per_hour;
                            						}
                                						
                                						
                                					   $key21->order_time = $timestamp2;
                                					    $key21->initial_hours = $initial_hours2;
                                					     $key21->added_hours = $added_hours2;
                                					      $key21->price_per_hour = $price_per_hour2;
                                					      $key21->bk_id2 = $bk_id2;
                            					   
                            					    	
                            					}
                            					else
                            					{
                            				    	 $key21->order_time = null;
                                					    $key21->initial_hours = null;
                                					     $key21->added_hours = null;
                                					      $key21->price_per_hour = null;
                                					       $key21->bk_id2 = null;
                            					}
                    					}
            					   $key->children = $userschild;
            					    	
            					}
            					else
            					{
            				    	$key->children = null;
            					}
						
						}
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
			}
			elseif(isset($request['email']) && !empty($request['email'])) 
			{
				$email=$request['email'];
				$childtype2 = "parent";
				try 
				{ 
                    $users = DB::select('select * from customer where email = ? AND type = ?', [$email,$childtype2]);
					if($users)
					{
					     foreach ($users as $key)
						{
							$cusphone       =  $key->phone;
							$cusemail       =  $key->email;
							$parent_id       =  $key->customer_id;
							
							$users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id]);
            					if($users_order)
            					{
            					  foreach ($users_order as $key2)
            						{
            							$timestamp       =  $key2->timestamp;
            								$bk_id       =  $key2->bk_id;
            							//return "this".$timestamp;
            							$initial_hours       =  $key2->initial_hours;
            							$added_hours       =  $key2->added_hours;
            							$price_per_hour       =  $key2->price_per_hour;
            						}
            					    $key->order_time = $timestamp;
            					     $key->bk_id = $bk_id;
            					    $key->initial_hours = $initial_hours;
            					    $key->added_hours = $added_hours;
            					    $key->price_per_hour = $price_per_hour;
            					}
            					else
            					{
            				    	$key->order_time = null;
            				    	$key->bk_id = null;
                				    $key->initial_hours = null;
                					$key->added_hours = null;
                					$key->price_per_hour = null;
            					}
							
							$childtype ="child";
							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
							if($userschild)
            				{
        					    foreach ($userschild as $key2)
            					{
            						$cusphone       =  $key2->phone;
            						$parent_id2       =  $key2->customer_id;
            						
            						$users_order2 = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id2]);
                    					if($users_order2)
                    					{
                                            foreach ($users_order2 as $key22)
                    						{
                    							$timestamp2       =  $key22->timestamp;
                    						    $bk_id2       =  $key22->bk_id;
                    							$initial_hours2       =  $key22->initial_hours;
                    							$added_hours2      =  $key22->added_hours;
                    							$price_per_hour2       =  $key22->price_per_hour;
                    						}
                        						
                        						
                        					   $key2->order_time = $timestamp2;
                        					    $key2->initial_hours = $initial_hours2;
                        					     $key2->added_hours = $added_hours2;
                        					      $key2->price_per_hour = $price_per_hour2;
                        					      $key2->bk_id2 = $bk_id2;
                    					   
                    					    	
                    					}
                    					else
                    					{
                    				    	 $key2->order_time = null;
                        					    $key2->initial_hours = null;
                        					     $key2->added_hours = null;
                        					      $key2->price_per_hour = null;
                        					       $key2->bk_id2 = null;
                    					}
            					}
            					
        					    $key->children = $userschild;
        					    	
        					}
        					else
        					{
        				    	$key->children = null;
        					}
            					/*if($userschild)
            					{
            					   $key->children = $userschild;
            					}
            					else
            					{
            				    	$key->children = null;
            					}*/
						
						}
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
			}
			elseif(isset($request['fname']) && !empty($request['fname'])) 
    		{
    			$fname=$request['fname'];
    			$childtype2 = "parent";
    			try 
    			{ 
                    $users = DB::select('select * from customer where fname = ? AND type = ?', [$fname,$childtype2]);
    				if($users)
    				{
    				    foreach ($users as $key)
    					{
    						$cusphone       =  $key->phone;
    						$cusemail       =  $key->email;
    						$parent_id       =  $key->customer_id;
    						
    						$users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id]);
            				if($users_order)
            				{
            					    
                				foreach ($users_order as $key2)
                			    {
                				    $timestamp       =  $key2->timestamp;
                					//return "this".$timestamp;
                					$initial_hours       =  $key2->initial_hours;
                					$added_hours       =  $key2->added_hours;
                					$price_per_hour       =  $key2->price_per_hour;
                				}
                						
                                $key->order_time = $timestamp;
                                $key->initial_hours = $initial_hours;
                                $key->added_hours = $added_hours;
                                $key->price_per_hour = $price_per_hour;
            				}
            				else
            				{
            				    $key->order_time = null;
                				$key->initial_hours = null;
                				$key->added_hours = null;
                				$key->price_per_hour = null;
            				}
    						
    						$childtype ="child";
    						$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
        					if($userschild)
        					{
        					   $key->children = $userschild;
        					}
        					else
        					{
        				    	$key->children = null;
        					}
    					}
    				    return response()->json(['status'=>'success','data'=>$users]);
    				}
    				else
    				{
    					return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
    				}	
    				  
    			} 
    			catch(\Illuminate\Database\QueryException $ex)
    			{ 		
    				return response()->json(['status'=>'failed','error'=>'Sql Error']);
    			}
    		}
			elseif(isset($request['customer_id']) && !empty($request['customer_id'])) 
			{
				$customer_id=$request['customer_id'];
				
				try 
				{ 

                    $users = DB::select('select * from customer where customer_id = ? ', [$customer_id]);
					if($users)
					{
					     foreach ($users as $key)
						{
						    
							$cusphone       =  $key->phone;
							$cusemail       =  $key->email;
							$parent_id       =  $key->customer_id;
							
							$users_order = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id]);
            					if($users_order)
            					{
            					  foreach ($users_order as $key2)
            						{
            							$timestamp       =  $key2->timestamp;
            								$bk_id       =  $key2->bk_id;
            							//return "this".$timestamp;
            							$initial_hours       =  $key2->initial_hours;
            							$added_hours       =  $key2->added_hours;
            							$price_per_hour       =  $key2->price_per_hour;
            						}
            					    $key->order_time = $timestamp;
            					     $key->bk_id = $bk_id;
            					    $key->initial_hours = $initial_hours;
            					    $key->added_hours = $added_hours;
            					    $key->price_per_hour = $price_per_hour;
            					}
            					else
            					{
            				    	$key->order_time = null;
            				    	$key->bk_id = null;
                				    $key->initial_hours = null;
                					$key->added_hours = null;
                					$key->price_per_hour = null;
            					}
							
							$childtype ="child";
							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
							if($userschild)
            				{
        					    foreach ($userschild as $key2)
            					{
            						$cusphone       =  $key2->phone;
            						$parent_id2       =  $key2->customer_id;
            						
            						$users_order2 = DB::select('select * from bookings where customer_id = ? ORDER BY created_at DESC LIMIT 1', [$parent_id2]);
                    					if($users_order2)
                    					{
                                            foreach ($users_order2 as $key22)
                    						{
                    							$timestamp2       =  $key22->timestamp;
                    						    $bk_id2       =  $key22->bk_id;
                    							$initial_hours2       =  $key22->initial_hours;
                    							$added_hours2      =  $key22->added_hours;
                    							$price_per_hour2       =  $key22->price_per_hour;
                    						}
                        						
                        						
                        					   $key2->order_time = $timestamp2;
                        					    $key2->initial_hours = $initial_hours2;
                        					     $key2->added_hours = $added_hours2;
                        					      $key2->price_per_hour = $price_per_hour2;
                        					      $key2->bk_id2 = $bk_id2;
                    					   
                    					    	
                    					}
                    					else
                    					{
                    				    	 $key2->order_time = null;
                        					    $key2->initial_hours = null;
                        					     $key2->added_hours = null;
                        					      $key2->price_per_hour = null;
                        					       $key2->bk_id2 = null;
                    					}
            					}
            					
        					    $key->children = $userschild;
        					    	
        					}
        					else
        					{
        				    	$key->children = null;
        					}
            					/*if($userschild)
            					{
            					   $key->children = $userschild;
            					}
            					else
            					{
            				    	$key->children = null;
            					}*/
						
						
						}
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'Wrong phone number']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			}
		    else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      }
      
      
	public function ForgetPasswords (Request $request)
	{
		
	}
	
	 public function AddVRStation (Request $request)
    { 
	 if(isset($request['name']) && !empty($request['name']) 
		AND isset($request['number']) && !empty($request['number'])
		AND isset($request['playing_time']) && !empty($request['playing_time']))
		{
    	    
    	       $name =$request['name'];
    	       $number =$request['number'];
    	       $playing_time = $request['playing_time'];
    	       
			   
			   try 
				{ 
				
					$inserteed = DB::insert('insert into vr_station (name,number,playing_time) 
					values (?,?,?)',[$name,$number,$playing_time]);
					
					
		           if($inserteed)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'This account already exists']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
     public function AddTax (Request $request)
    { 
	 if(isset($request['type']) && !empty($request['type']) 
		AND isset($request['tax_amount']) && !empty($request['tax_amount']))
		{
    	    
    	       $type =$request['type'];
    	       $tax_amount =$request['tax_amount'];
    	       
			   try 
				{ 
				
					$inserteed = DB::insert('insert into tax (type,tax_amount) 
					values (?,?)',[$type,$tax_amount]);
					
					
		           if($inserteed)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'This account already exists']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditVRStation (Request $request)
    { 
	 if(isset($request['station_id']) && !empty($request['station_id']) 
		AND isset($request['name']) && !empty($request['name']) 
		AND isset($request['number']) && !empty($request['number'])
		AND isset($request['playing_time']) && !empty($request['playing_time']))
		{
    	    
    	       $name =$request['name'];
    	       $number =$request['number'];
    	       $playing_time = $request['playing_time'];
    	       $station_id = $request['station_id'];
    	       
			   
			   try 
				{ 
				
				    $inserted = DB::update("update  vr_station SET  name='$name',number='$number' ,playing_time='$playing_time'  where station_id='$station_id'");
					
					
					
		           if($inserted)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
     public function DeleteVRStation (Request $request)
    { 
	 if(isset($request['station_id']) && !empty($request['station_id']) 
		)
		{
    	    
    	       
    	       $station_id = $request['station_id'];
    	       
			   try 
				{ 
				
				   $deleted = DB::delete ("delete from  vr_station  where station_id='$station_id'");
		           if($deleted)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ViewAllVRStations (Request $request)
    { 
		
				//return "get";
				try 
				{ 

                    $users = DB::select('select * from 	vr_station ');
					if($users)
					{
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
					return response()->json(['status'=>'failed','error'=>'No information found']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
		
      }
      public function ViewTax (Request $request)
    { 
		
				//return "get";
				try 
				{ 

                    $users = DB::select('select * from 	tax ');
					if($users)
					{
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
					return response()->json(['status'=>'failed','error'=>'No information found']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
		
      }
      
       public function AddRateHour (Request $request)
    { 
        
	 if(isset($request['hours']) && !empty($request['hours']) 
		AND isset($request['rate']) && !empty($request['rate'])
		)
		{
    	    
    	       $hours =$request['hours'];
    	       $rate =$request['rate'];
    	      
    	       
			   
			   try 
				{ 
				
					$inserteed = DB::insert('insert into rate_hour (hours,rate) 
					values (?,?)',[$hours,$rate]);
					
					
		           if($inserteed)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
     public function MultipleBookings (Request $request)
    { 
	    if(isset($request['booking_details']) && !empty($request['booking_details']) )
		{
    	    
    	        $booking_details =$request['booking_details'];
    	       
			    function addItems($option_details11)
				{
				
					$data = json_decode($option_details11);
					foreach ($data as $key)
					{
					
    	                $added_hours ="nil";
    	                $bk_id = mt_rand(100000, 999999);
    	               
						$customer_id      =  $key->customer_id;
						$employee_id      =  $key->employee_id;
						$payment_method      =  $key->payment_method;
						$timestamp      =  $key->timestamp;
						$no_of_bands      =  $key->no_of_bands;
						$price_per_hour      =  $key->price_per_hour;
						$order_total      =  $key->order_total;
						$balance      =  $key->balance;
						$initial_hours      =  $key->initial_hours;
								
						 try 
        				{ 
        				
        					$inserteed = DB::insert('insert into bookings (bk_id,customer_id,employee_id,payment_method,no_of_bands,timestamp,price_per_hour,order_total,balance,initial_hours,added_hours) 
        					values (?,?,?,?,?,?,?,?,?,?,?)',[$bk_id,$customer_id,$employee_id,$payment_method,$no_of_bands,$timestamp,$price_per_hour,$order_total,$balance,$initial_hours,$added_hours]);
        					
        					
        		           if($inserteed)
                              {
                                $ff =1;
                              }
                            else 
         					{
         					    $ff =0;
         					}  
         					
         					
        				} 
        				catch(\Illuminate\Database\QueryException $ex)
        				{ 		
        					$ff = 0;
        				}												
					}
					return $ff;
				}
					
			   
			      
    			   if(addItems($booking_details)==1)
					{
					    return response()->json(['status'=>'success']);  
					}
					else 
					{
						return response()->json(['status'=>'failed','error'=>'Sql Error 1']);
					}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
     public function AddBooking (Request $request)
    { 
        
	 if(isset($request['customer_id']) && !empty($request['customer_id']) 
		AND isset($request['employee_id']) && !empty($request['employee_id'])
		AND isset($request['payment_method']) && !empty($request['payment_method'])
		AND isset($request['timestamp']) && !empty($request['timestamp'])
		AND isset($request['no_of_bands']) && !empty($request['no_of_bands'])
		AND isset($request['price_per_hour']) && !empty($request['price_per_hour'])
		AND isset($request['order_total']) && !empty($request['order_total'])
		AND isset($request['initial_hours']) && !empty($request['initial_hours'])
		)
		{
    	    
    	       $customer_id =$request['customer_id'];
    	       $employee_id =$request['employee_id'];
    	       
    	        $payment_method =$request['payment_method'];
    	         $timestamp =$request['timestamp'];
    	          $no_of_bands =$request['no_of_bands'];
    	           $price_per_hour =$request['price_per_hour'];
    	            $order_total =$request['order_total'];
    	             $balance =$request['balance'];
    	              $initial_hours =$request['initial_hours'];
    	              $added_hours ="nil";
    	                $bk_id = mt_rand(100000, 999999);
    	       
			   
			   try 
				{ 
				
					$inserteed = DB::insert('insert into bookings (bk_id,customer_id,employee_id,payment_method,no_of_bands,timestamp,price_per_hour,order_total,balance,initial_hours,added_hours) 
					values (?,?,?,?,?,?,?,?,?,?,?)',[$bk_id,$customer_id,$employee_id,$payment_method,$no_of_bands,$timestamp,$price_per_hour,$order_total,$balance,$initial_hours,$added_hours]);
					
					
		           if($inserteed)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function UpdateBooking (Request $request)
    { 
	 if(isset($request['bk_id']) && !empty($request['bk_id']) 
		AND isset($request['added_hours']) && !empty($request['added_hours']) )
		{
    	    
    	      $bk_id =$request['bk_id'];
    	      $added_hours =$request['added_hours'];
    	 
			   try 
				{ 
				
				    $inserted = DB::update("update  bookings SET  added_hours='$added_hours' where bk_id='$bk_id'");
					
		           if($inserted)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
     public function DeleteRateHour (Request $request)
    { 
	 if(isset($request['rp_id']) && !empty($request['rp_id']) 
		)
		{
    	    
    	       
    	       $rp_id = $request['rp_id'];
    	       
			   try 
				{ 
				
				   $deleted = DB::delete ("delete from  rate_hour  where rp_id='$rp_id'");
		           if($deleted)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditRateHour (Request $request)
    { 
	 if(isset($request['rp_id']) && !empty($request['rp_id']) 
		AND isset($request['hours']) && !empty($request['hours']) 
		AND isset($request['rate']) && !empty($request['rate']))
		{
    	    
    	      $hours =$request['hours'];
    	      $rate =$request['rate'];
    	      $rp_id = $request['rp_id'];
    	       
			   
			   try 
				{ 
				
				    $inserted = DB::update("update  rate_hour SET  hours='$hours',rate='$rate'  where rp_id='$rp_id'");
					
		           if($inserted)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ViewAllRateHours (Request $request)
    { 
		
				//return "get";
				try 
				{ 

                    $users = DB::select('select * from 	rate_hour ');
					if($users)
					{
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'No information found']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
		
      }
	
	 public function AddAgreement (Request $request)
    { 
        
	 if(isset($request['title']) && !empty($request['title']) 
		AND isset($request['text']) && !empty($request['text'])
		)
		{
    	    
    	       $title =$request['title'];
    	       $text =$request['text'];
    	      
    	       
			   
			   try 
				{ 
				
					$inserteed = DB::insert('insert into agreements (title,text) 
					values (?,?)',[$title,$text]);
					
					
		           if($inserteed)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditAgreement (Request $request)
    { 
	 if(isset($request['ag_id']) && !empty($request['ag_id']) 
		AND isset($request['title']) && !empty($request['title']) 
		AND isset($request['text']) && !empty($request['text']))
		{
    	    
    	      $ag_id =$request['ag_id'];
    	      $title =$request['title'];
    	      $text = $request['text'];
    	       
			   
			   try 
				{ 
				
				    $inserted = DB::update("update  agreements SET  title='$title',text='$text'  where ag_id='$ag_id'");
					
		           if($inserted)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function DeleteAgreement (Request $request)
    { 
	 if(isset($request['ag_id']) && !empty($request['ag_id']) 
		)
		{
    	    
    	       
    	       $ag_id = $request['ag_id'];
    	       
			   try 
				{ 
				
				   $deleted = DB::delete ("delete from  agreements  where ag_id='$ag_id'");
		           if($deleted)
                      {
                        return response()->json(['status'=>'success']);
                      }
                    else 
 					{
 					return response()->json(['status'=>'failed','error'=>'Sql Error']);
 					}  
 					
 					
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'try again']);
				}
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    public function ViewAgreement (Request $request)
    { 
		
				//return "get";
				try 
				{ 

                    $users = DB::select('select * from 	agreements ');
					if($users)
					{
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'No information found']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
		
      }

        public function DeleteChild (Request $request)
		{ 
	
			if(isset($request['customer_id']) && !empty($request['customer_id'])) 
				{
					
					$customer_id=$request['customer_id'];

					$users_posts = DB::select('select * from customer where customer_id = ?', [$customer_id]);
					if($users_posts)
					{
						
						try 
						{ 
							$users_d = DB::delete('DELETE  from customer where customer_id = ?', [$customer_id]);
						
							if($users_d)
							{
						        return response()->json(['status'=>'success']);
								
							}
							else 
							{
								return response()->json(['status'=>'failed','error'=>'Sql Error']);
							}
						
						}
						
						catch(\Illuminate\Database\QueryException $ex)
						{ 		
							return response()->json(['status'=>'failed','error'=>'Sql Error']);
						}
				
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'Customer Does not exist']);
					}
				
						
							
				}

			else 
				{
					return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
				}
		  
		}   
	
	public function CustomerSignin (Request $request)
    { 
		if(isset($request['email']) && !empty($request['email']) AND isset($request['password']) && !empty($request['password'])) 
			{
				$email=$request['email'];
				$Password=$request['password'];
				$new_pass =md5($Password);
				
				try 
				{ 

                    $users = DB::select('select * from customer where email = ? AND password = ? ', [$email, $new_pass]);
					if($users)
					{
					    
					    foreach ($users as $key)
						{
							$cusphone       =  $key->phone;
							$cusemail       =  $key->email;
							$childtype ="child";
							$userschild = DB::select('select * from customer where email = ? AND type = ? ', [$cusemail, $childtype]);
            					if($userschild)
            					{
            					   $key->children = $userschild;
            					}
            					else
            					{
            				    	$key->children = null;
            					}
						
						}
					    	return response()->json(['status'=>'success','data'=>$users]);
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'Wrong Email or Password']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
			}
			
		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      
    }
    
    public function CustomerPwdChange (Request $request)
	{ 
        //return "Here";
		if(isset($request['customer_id']) && !empty($request['customer_id']) AND isset($request['old_password']) && !empty($request['old_password']) AND isset($request['new_password']) && !empty($request['new_password'])) 
			{
				
				$customer_id=$request['customer_id'];
				$New_Password=$request['new_password'];
				$New_Password1=md5($New_Password);
				$Old_Password=$request['old_password'];
				$Old_Password1 =md5($Old_Password);
						   
				$users = DB::select('select * from customer where customer_id = ? AND password = ? ', [$customer_id , $Old_Password1]);
				if($users)
				{
				    
					$user_new = DB::update('update customer SET password = ?  where customer_id = ?', [$New_Password1,$customer_id]);
					if ( $user_new)
					{
						return response()->json(['status'=>'success']);
					}
					else 
					{
						return response()->json(['status'=>'failed','error'=>'Sql Error1']);
					}
					
							
				}
				else
				{
					return response()->json(['status'=>'failed','error'=>'Old password does not match!']);
				}	
					  
				
			
			}

		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
	  
	}
		
	public function CustomerPhoneEdit (Request $request)
	{ 
		if(isset($request['customer_id']) && !empty($request['customer_id']) AND isset($request['phone']) && !empty($request['phone']) ) 
		{
			
			$customer_id=$request['customer_id'];
			$phone=$request['phone'];
					   
			$users = DB::select('select * from customer where customer_id = ?', [$customer_id]);
			if($users)
			{
			    foreach ($users as $key)
				{
				    $cusemail     =  $key->email;
				}
			    
				$user_new = DB::update('update customer SET phone = ?  where email = ?', [$phone,$cusemail]);
				if ( $user_new)
				{
					return response()->json(['status'=>'success']);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Sql Error1']);
				}
			}
			else
			{
				return response()->json(['status'=>'failed','error'=>'Customer not exist']);
			}	
				  
			
		
		}
		else 
		{
			return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
		}
	}
		
	public function EditCustomerProfile2 (Request $request)
    { 
	
	 
	 if(isset($request['dob']) && !empty($request['dob']) 
		AND isset($request['fname']) && !empty($request['fname'])
		AND isset($request['lname']) && !empty($request['lname'])
		AND isset($request['phone']) && !empty($request['phone'])
	
		AND isset($request['customer_id']) && !empty($request['customer_id']))
		{
    	    
    	       $dob =$request['dob'];
    	       $fname =$request['fname'];
    	       $lname = $request['lname'];
    	       $phone = $request['phone'];
			   $customer_id = $request['customer_id'];
			   $children=$request['children'];
			   $gender = $request['gender'];
			   $age = $request['age'];
			   $add1 = $request['add1'];
			   $add2 = $request['add2'];
			   $country = $request['country'];
			   $state = $request['state'];
			   $city = $request['city'];
			   $zipcode = $request['zipcode'];
			   $type = $request['type'];
			   
			   
			   $users2 = DB::select('select * from customer where customer_id = ?', [$customer_id ]);						
			   if($users2)
				{
					 
					try 
					{ 
						$user_new = DB::update('update customer SET dob = ? , fname = ? ,lname = ? ,phone = ? ,gender = ? ,age = ? , add1 = ? ,add2 = ?, country = ? ,state = ?, city = ? ,zipcode = ?   where customer_id= ?', [$dob,$fname,$lname,$phone,$gender,$age,$add1,$add2,$country,$state,$city,$zipcode,$customer_id]);
						if ( $user_new)
						{		
							return response()->json(['status'=>'success']);
						}
						else 
						{
							return response()->json(['status'=>'failed','error'=>'Sql Error1']);
						}
									
						
					} 
					catch(\Illuminate\Database\QueryException $ex)
					{ 		
						return response()->json(['status'=>'failed','error'=>'This account already exists']);
					}
					
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Email Not Exists']);
					
				}
											
			}
			
		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
		
	}
	
	  public function AddBalance (Request $request)
    { 
	 if(isset($request['opening_date']) && !empty($request['opening_date']) 
		AND isset($request['opening_balance']) && !empty($request['opening_balance'])
		AND isset($request['employee_id']) && !empty($request['employee_id']))
		{
    	    
    	       $opening_date =$request['opening_date'];
    	       $opening_balance =$request['opening_balance'];
    	       $employee_id = $request['employee_id'];
    	        $bm_id = mt_rand(1000, 9999);
    	       
    	       
    	      
			  try 
        				{ 
        				
        					$inserteed = DB::insert('insert into balance_managing (bm_id,opening_date,opening_balance,employee_id) 
        					values (?,?,?,?)',[$bm_id,$opening_date,$opening_balance,$employee_id]);
        					
        					
        		           if($inserteed)
                              {
                                return response()->json(['status'=>'success','bm_id'=>$bm_id]);
                              }
                            else 
         					{
         					return response()->json(['status'=>'failed','error'=>'Sql Error']);
         					}  
         					
         					
        				} 
        				catch(\Illuminate\Database\QueryException $ex)
        				{ 		
        					return response()->json(['status'=>'failed','error'=>'Try Again']);
        				}
			 
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
     public function CloseBalance (Request $request)
    { 
	 if(isset($request['bm_id']) && !empty($request['bm_id']) 
		AND isset($request['closing_date']) && !empty($request['closing_date'])
		AND isset($request['closing_balance']) && !empty($request['closing_balance']))
		{
    	    
    	       $bm_id =$request['bm_id'];
    	       $closing_date =$request['closing_date'];
    	       $closing_balance = $request['closing_balance'];
    	      
			  try 
        				{ 
        				
        					$inserteed = DB::update('update balance_managing SET closing_date = ? , closing_balance = ?  where bm_id= ?', [$closing_date,$closing_balance,$bm_id]);
        		           if($inserteed)
                              {
                                return response()->json(['status'=>'success']);
                              }
                            else 
         					{
         					return response()->json(['status'=>'failed','error'=>'Sql Error']);
         					}  
         					
         					
        				} 
        				catch(\Illuminate\Database\QueryException $ex)
        				{ 		
        					return response()->json(['status'=>'failed','error'=>'Try Again']);
        				}
			 
			    
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    	public function GetClosingBalance (Request $request)
    	{ 
	 if(isset($request['opening_date']) && !empty($request['opening_date']) AND isset($request['closing_date']) && !empty($request['closing_date']) )
	     {
    	    try{
    	        
    	       $opening_date =$request['opening_date'];
    	       $closing_date =$request['closing_date'];
    	        $bm_id =$request['bm_id'];
    	        $order_total_new =0;
    	       
    	       $data2 = DB::select("select * from balance_managing where  bm_id = '$bm_id'");	   
			   if($data2)
			   {
			       	foreach($data2 as $u2)
			       	{
						$opening_balance = $u2->opening_balance;
			       	}
			   }
			   else
			   {
				   $opening_balance = 0;
			   }
			   
    	       $data = DB::select("select * from bookings where  timestamp >= '$opening_date' AND timestamp <= '$closing_date' ");	   
			   if($data)
			   {
			       //return $data;
			       	foreach($data as $u)
			       	{
						$order_total = $u->order_total;
						
						$order_total_new = $order_total_new+$order_total;
			       	}
			       	
			       	$closing = $order_total_new + $opening_balance;
			       	
				   return response()->json(['status'=>'success','closing_balance'=>$closing]);
			   }
			   else
			   {
				   return response()->json(['status'=>'failed','error'=>'Update again.']);
			   }
    	    }
    	    catch(\Illuminate\Database\QueryException $ex)
    	    { 		
	            return response()->json(['status'=>'failed','error'=>'SQL Error.']);
    	    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
}
