<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Maktabti| Books</title>

    <link href="<?php echo e(asset ('css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('font-awesome/css/font-awesome.css')); ?>" rel="stylesheet">

    <!-- FooTable -->
    <link href="<?php echo e(asset ('css/plugins/footable/footable.core.css')); ?>" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="<?php echo e(asset ('css/sweetalert.css')); ?>" rel="stylesheet">

    <!-- Ladda style -->
    <link href="<?php echo e(asset ('css/ladda-themeless.min.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset ('css/animate.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset ('css/style.css')); ?>" rel="stylesheet">
    
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
        .container 
        {
          margin-top: 15px;
        }
        .tab-group
        {
           position: relative;
           vertical-align: middle;
           zoom: 1; /* Fix for IE7 */
           *display: inline; /* Fix for IE7 */
        }
        
        .tab-group > li
        {
            background-color: #eeeeee;
            border-radius: 4px;
            position: relative;
            float: left;
        }
        .nav > li.active 
        {
            border-left: 4px solid #566b8a;
            background: #566b8a;
        }
        .tab-group > li.active > a, 
        .tab-group > li.active > a:hover, 
        .tab-group > li.active > a:focus
        {
            background-color: #566b8a;
            color: #fff;
        }
        .tab-group > li > a 
        {
            color: #333;
            border-radius: 0;
            text-align: center;
        }
        .tab-group > li > a:hover 
        {
            border-radius: 4px;
        }
        
        .tab-group li + li 
        {
            margin-left: -1px;
        }
        
        .tab-group > li:not(:first-child):not(:last-child),
        .tab-group > li:not(:first-child):not(:last-child) > a:hover 
        {
          border-radius: 0;
        }
        .tab-group > li:first-child,
        .tab-group > li:first-child > a:hover 
        {
            margin-left: 0;
        }
        .tab-group > li:first-child:not(:last-child),
        .tab-group > li:first-child:not(:last-child) > a:hover 
        {
          border-top-right-radius: 0;
          border-bottom-right-radius: 0;
        }
        .tab-group > li:last-child:not(:first-child),
        .tab-group > li:last-child:not(:first-child) > a:hover 
        {
          border-top-left-radius: 0;
          border-bottom-left-radius: 0;
        }
    </style>


<script>
    if (!localStorage.Session)
    {
        window.stop();
        window.location.replace("login");
    }
    </script>

</head>
<body>
    <div id="wrapper">

        <!-- Side Navbar -->
        <?php echo $__env->make('navbar_static_side', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 

        <div id="page-wrapper" class="gray-bg">
          <div class="row border-bottom">
              <!-- Top Navbar -->
              <?php echo $__env->make('navbar_static_top', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 
          </div>
          <div class="row wrapper border-bottom white-bg page-heading">
              <div class="col-lg-10">
                  <h2><strong>Books</strong></h2>
                  <a href="<?php echo e(url('add_style')); ?>">
                      <button type="button" class="btn btn-default btn-sm">
                          <span class="glyphicon glyphicon-plus"></span> Add a Book
                      </button>
                  </a>
              </div>
              <div class="col-lg-2">

              </div>
          </div>

        <div class="wrapper wrapper-content animated fadeInRight ecommerce">

              

                <div class="row" id="styles_list">
                	
                </div>
            </div> 

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>
             <!-- Assign -->
            <button id="swal_btn3" type="button" style="display:none"></button>

            <!-- Footer -->
            <?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        </div>
    </div>

    <!-- Modal View Palette Details -->
    <div class="modal fade" id="palettePicDetailsModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Palette Details</h4>
                </div>
                <div class="modal-body">  
                	<div class="form-group">
                       <img id="palette_image_detail" src="" width="50">
                    </div>              
					<div class="form-group">
                   		<label>Category</label>									
						<p id="category_name_detail"></p>
                    </div>
                   
                    <div class="form-group">
                        <label>Description</label>
                        <p id="description_detail"></p>
                    </div>                           
                    <div>
                        <button style="background-color: #566b8a;color: white;" onclick="showAssign()" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                             <span class="ladda-label">Assign to a Customer</span><span class="ladda-spinner"></span>
                        </button>
                    </div>

                    <div id="assignToCustomer" style="display: none">
	                    <div class="form-group">
	                   		<label>Customer List</label>									
							<select class="form-control" id="customer_name" name="customer_name" required="">
								<!-- Appending all customers Dynamically -->
							</select>
	                    </div>
	                    <button type="button" class="btn btn-default" onclick="assigning()" style="background-color: green; color: white" >Assign</button>
	                    <button type="button" class="btn btn-default" onclick="hideAssign()" style="background-color: darkorange; color: white">Hide</button>
	                </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->

    <!-- Modal Delete Palette -->
    <div class="modal fade" id="palettePicDeleteModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete Palette</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the Palette?</p>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white" onclick="deletePalette()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->

    <!-- Modal Edit Palette -->
    <div class="modal fade" id="palettePicEditModal" role="dialog">
        <div class="modal-dialog">
          <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Edit Palette</h4>
                </div>
                <div class="modal-body">  
                	<div class="form-group">
                       <img id="palette_image" src="" width="50">
                    </div>              
                    <form id="edit_palette_form">
						<div class="form-group">
                       		<label>Category List</label>									
							<select class="form-control" id="category_name" name="category_name" required="">
								<option value="fabric_patterns">Fabric Patterns</option>
								<option value="necklines">Necklines</option>
								<option value="shirts">Shirts</option>
								<option value="jackets">Jackets</option>
								<option value="dresses">Dresses</option>
								<option value="skirts">Skirts</option>
								<option value="handbags">Handbags</option>
								<option value="jewelry">Jewelry</option>
							</select>
                        </div>
						
                        <div class="form-group">
                            <label>Upload Picture</label>
                            <input type="file" id="photo" name="photo" class="form-control">
                        </div>
                       
                        <div class="form-group">
                            <label>Description</label>
                            <textarea rows="5" id="description" name="description" placeholder="Enter Description" class="form-control" required></textarea>
                        </div>                           
                        <div>
                            <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                 <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                            </button>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->



    <!-- Mainly scripts -->
    <script src="<?php echo e(asset ('js/jquery-3.1.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/metisMenu/jquery.metisMenu.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/slimscroll/jquery.slimscroll.min.js')); ?>"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo e(asset ('js/inspinia.js')); ?>"></script>
    <script src="<?php echo e(asset ('js/plugins/pace/pace.min.js')); ?>"></script>

    <!-- Sweet alert -->
    <script src="<?php echo e(asset ('js/plugins/sweetalert/sweetalert.min.js')); ?>"></script>

    <!-- FooTable -->
    <script src="<?php echo e(asset ('js/plugins/footable/footable.all.min.js')); ?>"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <!-- Page-Level Scripts -->
    <script>   
        var palette_delete_id;
        var palette_edit_id;
        var palette_details_assign;

        $(document).ready(function() 
        {
            $("#side3").addClass("activeSM");
            $("#side3 a").css("color","#224ea6");

            viewStyles();

            $(".TAB").click(function()
            {
                var status = this.id;

                if( status == "All" )
                {
                  $('.show_all_tab').css("display","block");
                }
                else
                {
                  $('.show_all_tab').css("display","none");
                  $('.'+status).css("display","block");
                }
            });

            $("#edit_palette_form").validate({
	            rules: 
	            {
	                category_name: {
	                    required: true,
	                },
	                description: {
	                    required: true,
	                }
	            },
	            messages: 
	            {
	            },
	            submitHandler: function(form) 
	            {
	                var l = $( '.ladda-button-demo' ).ladda();
	                l.ladda( 'start' );
	                var swal_btn = document.getElementById("swal_btn");
					var photo= document.getElementById('photo').files[0];
	                var category_name = $('#category_name').val();
	                var description = $('#description').val();
	       


	                var formData = new FormData();
	                formData.append("style_id", palette_edit_id);
	                if(photo)
	                {
	                	formData.append("photo", photo);
	                }
	                formData.append("category_name", category_name);
	                formData.append("description", description);
	                
	                    
	                $.ajax
	                ({
	                    type:'POST',
	                    url:"/joon/api/EditStyle",
	                    data: formData,
	                    contentType: false,
	                    cache: false,
	                    processData:false,
	                    success: function(data)
	                    {
	                        if( data.status == "success")
	                        {
	                        	$('#palettePicEditModal').modal('hide');
	                            l.ladda('stop');
	                            viewStyles();
	                            swal_btn.click();
	                        }
	                        else if( data.status == "failed" )
	                        {
	                        	l.ladda('stop');
	                            alert("NOT EDITED! Data Is same");
	                        }
	                    },
	                    error: function(data) 
	                    {
	                        alert("error");
	                    }           

	                });                
	                return false; // extra insurance preventing the default form action
	            }
	        });



            //Empty List
            $('#swal_btn').click(function(){
                swal({
                    title: "Palette Edited",
                    text: "",
                    type: "success",
                    confirmButtonColor: "green",
                });
            });

            //Delete Row
            $('#swal_btn2').click(function(){
                swal({
                    title: "Style Deleted!",
                    text: "",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });

            //Delete Row
            $('#swal_btn3').click(function(){
                swal({
                    title: "Palette Assigned to a Customer!",
                    text: "",
                    type: "success",
                    confirmButtonColor: "green",
                });
            });

        });

        function viewStyles()
        {
            var $list = $("#styles_list");
            $list.empty();
            $.ajax({
                url: "http://tecjaunt.com/Maktabti/api/ItemView",
                type: "POST",
               // data: { "category_name" : "All" },
                success: function(data)
                {   
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {                                            
                            $list.append('<div id="'+obj.book_id+'" class="col-md-3 col-sm-4 col-xs-6 show_all_tab '+obj.category_name+'" style="padding: 10px 10px 0px 10px;">'+
                            				'<label style="position: fixed;margin-left:5px;margin-top: 2px;">'+
                            					'<i class="fa fa-pencil" id="'+obj.book_id+'-'+obj.cover_photo+'-'+obj.category_name+'-'+obj.description+'" onclick ="PalettePicEditModal(this.id);"style="font-size:20px;color:black;margin-right:5px"></i>'+
                            					'<i class="fa fa-adn" id="'+obj.book_id+'-'+obj.cover_photo+'-'+obj.category_name+'-'+obj.description+'" onclick ="PalettePicDetailsModal(this.id);" style="font-size:20px;color:blue;margin-right:5px"></i>'+
                            					'<i class="fa fa-trash" id="'+obj.book_id+'" onclick ="PalettePicDeleteModal(this.id);" style="font-size:20px;color:red"></i>'+
                            				'</label>'+
					                     	'<img src="http://tecjaunt.com/Maktabti/public/'+obj.cover_photo+'" style="width:100%; height:323px">'+
					                    '</div>');
                        });
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }

        function PalettePicDetailsModal(id)
        {
            palette_details_assign = id.split('-');
            var palette_details_id  = palette_details_assign[0];
            $('#palette_image_detail').attr('src','/joon/public/'+palette_details_assign[1]);
            $('#category_name_detail').html(palette_details_assign[2]);
            $('#description_detail').html(palette_details_assign[3]); 


            var $list = $("#customer_name");
            $list.empty();
            //Calling Api to get list of all customers
            $.ajax({            
                url: "/joon/api/CustomerViewAll",
                type: "POST",
                success: function(data)
                {
                    if(data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {                                            
                            $list.append('<option value="'+obj.email+'">'+obj.name+'</option>');
                        });
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                    $('#palettePicDetailsModal').modal('show');
                },
                error: function(data) 
                {
                }           
            });
        }

        function showAssign()
        {
        	$('#assignToCustomer').css('display','block');
        }


        function hideAssign()
        {
        	$('#assignToCustomer').css('display','none');
        }

        function assigning()
        {
        	var email = $('#customer_name').val();
        	//Calling Api to get list of all customers
            $.ajax({            
                url: "/joon/api/AddStyleCus",
                type: "POST",
                data: { "customer_email" : email ,  "style_id" : palette_details_assign[0] ,  "category_name" : palette_details_assign[2] },
                success: function(data)
                {
                    if(data.status == "success")
                    {
                    	swal_btn3.click();
                    	$('#palettePicDetailsModal').modal('hide');
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });
        }

        function PalettePicDeleteModal(id)
        {
            $('#palettePicDeleteModal').modal('show');
            palette_delete_id = id;
        }


        function deletePalette()
        {
            $('#palettePicDeleteModal').modal('hide');

            $.ajax({            
                url: "/joon/api/DelStyle",
                type: "POST",
                data: {"style_id": palette_delete_id},
                success: function(data)
                {
                    if(data.status == "success")
                    {
                        swal_btn2.click();
                        viewStyles();
                    }
                    else if (data.status == "failed")
                    {
                        alert("failed");
                    }
                },
                error: function(data) 
                {
                }           
            });
        }

        function PalettePicEditModal(id)
        {
            $('#palettePicEditModal').modal('show');
            var palette_details = id.split('-');
            palette_edit_id = palette_details[0];
            $('#palette_image').attr('src','/joon/public/'+palette_details[1]);
            $('#category_name').val(palette_details[2]);
            $('#description').val(palette_details[3]); 
        }

    </script>
</body>
</html>
