<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Employee Web | Day Details</title>

    @include("partials.headerLinks")

    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
        
        .detailsBtn
        {
            background-color: #224ea6;
            color: white;
            border-color: #224ea6;
        }
        .btn-success 
        {
            width: 100%;
            margin: 20px 0px;
            color: #fff;
            background-color: green;
            border-color: green;
        }
        .btn-success:hover
        {
            color: #fff;
            background-color: green;
            border-color: green;
        }
        .btn-success:focus
        {
            color: #fff;
            background-color: green;
            border-color: green;
        }
        .btn-danger 
        {
            width: 100%;
            color: #fff;
            background-color: #d9534f;
            border-color: #d43f3a;
        }
    </style>
    <script>
    if (!localStorage.login_timeclock_emp)
    {
        window.stop();
        window.location.replace("login");
    }
    </script>
</head>

<body>

    <div id="wrapper">
        @include("partials.emp_sidebar")


        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                @include("partials.emp_topbar")

            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="row" style="font-size:24px;margin:20px 0px 0px 40px;">
                    <font>Day Details : </font> <font id="selectedDay" style="font-weight:800;color:#224ea6"></font><br>
                    <font>Name : </font> <font id="employee_name" style="font-weight:800;color:#224ea6"></font><br>
                    <font>Location : </font> <font id="employee_location" style="font-weight:800;color:#224ea6"></font><br>
                    <font>Position : </font> <font id="employee_position" style="font-weight:800;color:#224ea6"></font><br>
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>
                                            <th>Type</th>                                            
                                            <th>Date</th>
                                            <th>Time</th>
                                        </tr>
                                    </thead>
                                    <tbody id="payroll_list">
                                       <!-- Dynamically appending Locations List -->
                                    </tbody>
                                </table>
                                
                                <div class="row" style="font-size:24px;margin-left: 5px;">
                                    <font style="font-weight:800">Total Time for Today : </font> <font id="total_hours"></font><br>
                                    <font style="font-weight:800">Rate per Hour : $</font> <font id="emp_rate"></font><br>
                                    <font style="font-weight:800">Total Payroll for Today : </font> <font id="total_pay"></font><br>
                                    <font style="font-weight:800">Confirmed By : </font> <font id="confirm_by"></font><br>
                                    <font style="font-weight:800">Confirmed Date : </font> <font id="confirm_date"></font><br>
                                    <font style="font-weight:800">Confirmed Time : </font> <font id="confirm_time"></font><br>
                                    <font style="font-weight:800">Advance: </font> <font id="total_advance"></font><br>
                                    
                                    <a href="weekly_report.php">
                                        <button class="btn-success">Approve</button>
                                    </a>
                                    <a href="wrong_details.php">
                                        <button class="btn-danger">Not Approve</button>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">
        </div>
    </div>

    @include("partials.scriptLinks")

    
    <!-- Page-Level Scripts -->
    <script>
        var date1;
        var date2;
        var advance_total;
    
        $(document).ready(function() 
        {
            var temp = localStorage.choosenDay;
            date1 = temp + " 00:00";
            date2 = temp + " 23:59";
            
            $('#emp_name').html(localStorage.Employee_Name);
            $('#selectedDay').html(localStorage.choosenDay);
            
            $("#side2").addClass("activeSM");
            $("#side2 a").css("color","#224ea6");
    
            
            viewPayrollList();
            calculateAdvance();
            
            //Empty List
            $('#swal_btn').click(function(){
                swal({
                    title: "No Data",
                    text: "Employee has no Working hours During the Selected Week.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("employee_selection");
                });
            });
            
            $('#swal_btn2').click(function(){
                swal({
                    title: "No Details",
                    text: "Employee has no Working hours During the Selected Day.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });
    
        function viewPayrollList()
        {
            var $list = $("#payroll_list");
            $list.empty();
            
            $.ajax({
                url: "http://127.0.0.1:9000/api/ViewOnClockWebEmployees",
                type: "GET",
                data: { "location" : "All" , "date1" : date1 , "date2" : date2 , "employee_id" : localStorage.emp_username },
                success: function(data)
                {   
                    var perHourPay;
                    var TotalHours = 0;
                    
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {
                            $('#employee_location').html(obj.location);
                            $('#employee_position').html(obj.position);
                            
                            var tempObj = convertTime(obj.time);
                            
                            $list.append('<tr style="color:green">'+
                                            '<td ><strong>Clock In</strong></td>'+
                                            '<td>'+obj.date+'</td>'+
                                            '<td>'+tempObj+'</td>'+
                                        '</tr>');
                            
                            $.each(obj.employee_details, function(index2,obj2)
                            {
                                $('#employee_name').html(obj2.emp_fname + " " + obj2.emp_lname);
                                perHourPay = parseFloat(obj2.perhour_pay);
                            });
                            
                            if( obj.breaks )
                            {
                                $.each(obj.breaks, function(index3,obj3)
                                {
                                    var tempObj3   = convertTime(obj3.time);
                                    var tempAction = capitalizeFirstLetter(obj3.action);
                                    
                                    $list.append('<tr style="color:red">'+
                                                    '<td ><strong>'+tempAction+'</strong></td>'+
                                                    '<td>'+obj3.date+'</td>'+
                                                    '<td>'+tempObj3+'</td>'+
                                                '</tr>');
                                                
                                    if(obj3.back_to_work_date)
                                    {
                                        var tempObjBTW = convertTime(obj3.back_to_work_time);
                                        
                                        $list.append('<tr style="color:green">'+
                                                        '<td ><strong>Back to Work</strong></td>'+
                                                        '<td>'+obj3.back_to_work_date+'</td>'+
                                                        '<td>'+tempObjBTW+'</td>'+
                                                    '</tr>');
                                    }
                                });
                            }
                            
                            $.each(obj.clockouts, function(index4,obj4)
                            {
                                var tempObj4 = convertTime(obj4.time);
                                $list.append('<tr style="color:red">'+
                                                '<td ><strong>Clock Out</strong></td>'+
                                                '<td>'+obj4.date+'</td>'+
                                                '<td>'+tempObj4+'</td>'+
                                            '</tr>');
                            });
                            
                            $list.append('<tr>'+
                                                '<td ></td>'+
                                                '<td></td>'+
                                                '<td></td>'+
                                            '</tr>');
                            
                            TotalHours = TotalHours + parseFloat(obj.working_hours);
                            
                            var confirm_temp = obj.confirm_timestamp.split(" ");
                            var tempObjConfirm = convertTime(confirm_temp[1]);
                            
                            $('#confirm_by').html(obj.confirm_employee_fullname);
                            $('#confirm_date').html(confirm_temp[0]);
                            $('#confirm_time').html(tempObjConfirm);
                        });
                        
                        var tempHours = secondsToHms(TotalHours);
                        
                        TotalHours  = (TotalHours / 3600).toFixed(2);
                        
                        var total_pay   = (TotalHours * perHourPay).toFixed(2);
                        $('#total_hours').html(tempHours);
                        $('#emp_rate').html(perHourPay);
                        $('#total_pay').html('$' + total_pay);
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }
    
        function convertTime(time)
        {
            var temp = time.split(':');
            var hours = temp[0];
            
            if( hours < 12)
            {
                hours = hours + ":" + temp[1] + " AM";
            }
            else if( hours == 12)
            {
                hours = hours + ":" + temp[1] + " PM";
            }
            else if( hours > 12)
            {
                hours = hours - 12 ;
                if( hours < 10 )
                {
                    hours = "0" + hours + ":" + temp[1] + " PM";
                }
                else
                {
                    hours = hours + ":" + temp[1] + " PM";
                }
            }
            return hours;
        }
        
        function secondsToHms(d) 
        {
            d = Number(d);
            var h = Math.floor(d / 3600);
            var m = Math.floor(d % 3600 / 60);
            //var s = Math.floor(d % 3600 % 60);
        
            var hDisplay = h > 0 ? h + (h == 1 ? " Hour " : " Hours ") : "";
            var mDisplay = m > 0 ? m + (m == 1 ? " Minute " : " Minutes ") : "";
            //var sDisplay = s > 0 ? s + (s == 1 ? " second" : " seconds") : "";
            return hDisplay + mDisplay;// + sDisplay; 
        }
        
        function calculateAdvance()
        {
            $.ajax({
                url: "http://127.0.0.1:9000/api/AdvanceLoanTotal",
                type: "GET",
                data: { "date1" : localStorage.choosenDay , "date2" : localStorage.choosenDay , "employee_id" : localStorage.emp_username },
                success: function(data)
                {   
                    if ( data.status == "success")
                    {
                        advance_total = data.emp_advance.toFixed(2);
                        $('#total_advance').html('$' + advance_total);
                    }
                    else if ( data.status == "failed")
                    {
                        advance_total = 0;
                        advance_total = advance_total.toFixed(2);
                        $('#total_advance').html('$' + advance_total);
                    }
                },
                error: function(data)
                {
                }           
            });        
        }
        
        function capitalizeFirstLetter(string) 
        {
            return string.charAt(0).toUpperCase() + string.slice(1);
        }
    </script>
</body>
</html>