<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Employee Web | Weekly Report</title>
    @include('partials.headerLinks')

    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
        
        .detailsBtn
        {
            background-color: #224ea6;
            color: white;
            border-color: #224ea6;
        }
    </style>
    <script>
    if (!localStorage.login_timeclock_emp)
    {
        window.stop();
        window.location.replace("/login");
    }
    </script>
</head>

<body>

    <div id="wrapper">
        @include('partials.emp_sidebar')


        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
    @include('partials.emp_topbar')
                
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Payroll Details for a week</strong></h2>
                    <h2 style="color:#224ea6;font-weight:bolder" id="selectedWeek"></h2>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <div class="row">
                                    <center>
                                        <div class="col-xs-6">
                                            <h2 style="font-weight:800">Total Hours</h2>
                                            <h2 id="total_hours" style="font-weight:800;color:#224ea6"></h2>
                                        </div>
                                        <div class="col-xs-6">
                                            <h2 style="font-weight:800">Amount to Pay</h2>
                                            <h2 id="total_pay" style="font-weight:800;color:#224ea6"></h2>
                                        </div>
                                        <!--<div class="col-xs-4">
                                            <h2 style="font-weight:800">Advance Details</h2>
                                            <h2 id="total_advance" style="font-weight:800;color:#224ea6"></h2>
                                        </div>-->
                                    </center>
                                </div>
                                
                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>
                                            <th>Day</th>                                            
                                            <th>Date</th>
                                            <th>Total Hours</th>
                                            <th>Amount to Pay</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="payroll_list">
                                       <!-- Dynamically appending Locations List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none">
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none">

        </div>
    </div>

    @include('partials.scriptLinks')

    
    <!-- Page-Level Scripts -->
    <script>
        var date1;
        var date2;
        var Mdate = Tdate = Wdate = Thdate = Fdate = Sdate = Sudate = 0;
        var advanceTotal = 0.00;
        
        $(document).ready(function() 
        {
            var temp = localStorage.selectedweek.split('-');
            date1 = temp[0] + " 00:00";
            date2 = temp[1] + " 23:59";
            
            $('#emp_name').html(localStorage.Employee_Name);
            $('#selectedWeek').html(localStorage.selectedweek);
            
            $("#side2").addClass("activeSM");
            $("#side2 a").css("color","#224ea6");
            
            Mdate  = temp[0];
            Sudate = temp[1]; 
            Tdate  = calculateWeekDates(1);
            Wdate  = calculateWeekDates(2);
            Thdate = calculateWeekDates(3);
            Fdate  = calculateWeekDates(4);
            Sdate  = calculateWeekDates(5);
            //alert(Tdate);
            viewPayrollList();
            
            //Empty List
            $('#swal_btn').click(function()
            {
                swal({
                    title: "No Data",
                    text:  "Employee has no Working hours During the Selected Week.",
                    type:  "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function () {
                    window.location.assign("selection_employees");
                });
            });
            
            $('#swal_btn2').click(function(){
                swal({
                    title: "No Details",
                    text: "Employee has no Working hours During the Selected Day.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });
    
        function viewPayrollList()
        {
            var $list = $("#payroll_list");
            $list.empty();
            
            $.ajax({
                url: "http://127.0.0.1:9000/api/ViewOnClockWebEmployees",
                type: "GET",
                data: { "location" : "All" , "date1" : date1 , "date2" : date2 , "employee_id" : localStorage.emp_username },
                success: function(data)
                {   
                    var perHourPay;
                    var M = T = W = Th = F = S = Su = 0;
                    var Mhours = Thours = Whours = Thhours = Fhours = Shours = Suhours = 0;
                    var weekday = new Array(7);
                    weekday[0] = "Sunday";
                    weekday[1] = "Monday";
                    weekday[2] = "Tuesday";
                    weekday[3] = "Wednesday";
                    weekday[4] = "Thursday";
                    weekday[5] = "Friday";
                    weekday[6] = "Saturday";
                    
                    if ( data.status == "success")
                    {
                        $.each(data.data, function(index,obj) 
                        {
                            $.each(obj.employee_details, function(index2,obj2)
                            {
                                perHourPay = parseFloat(obj2.perhour_pay);
                            });
                            
                            $.each(obj.advance_details, function(index21,obj21)
                            {
                                if( obj21.advance_type == "loan" )
                                {
                                    advanceTotal = advanceTotal + parseFloat( obj21.amount );   
                                }
                            });
                            
                            var d = new Date(obj.clock_out);
                            var DayofWeek = weekday[d.getDay()];
                            
                            if( DayofWeek == "Monday" )
                            {
                                M = 1 ;
                                Mhours = Mhours + parseFloat(obj.working_hours);
                            }
                            else if( DayofWeek == "Tuesday")
                            {
                                T = 1 ;
                                Thours = Thours + parseFloat(obj.working_hours);
                            }
                            else if( DayofWeek == "Wednesday")
                            {
                                W = 1 ;
                                Whours = Whours + parseFloat(obj.working_hours);
                            }
                            else if( DayofWeek == "Thursday")
                            {
                                Th = 1 ;
                                Thhours = Thhours + parseFloat(obj.working_hours);
                            }
                            else if( DayofWeek == "Friday")
                            {
                                F = 1 ;
                                Fhours = Fhours + parseFloat(obj.working_hours);
                            }
                            else if( DayofWeek == "Saturday")
                            {
                                S = 1 ;
                                Shours = Shours + parseFloat(obj.working_hours);
                            }
                            else if( DayofWeek == "Sunday")
                            {
                                Su = 1 ;
                                Suhours = Suhours + parseFloat(obj.working_hours);
                            }
                        });
                        
                        Mhours  = (Mhours / 3600).toFixed(2);
                        Thours  = (Thours / 3600).toFixed(2);
                        Whours  = (Whours / 3600).toFixed(2);
                        Thhours  = (Thhours / 3600).toFixed(2);
                        Fhours  = (Fhours / 3600).toFixed(2);
                        Shours  = (Shours / 3600).toFixed(2);
                        Suhours  = (Suhours / 3600).toFixed(2);
                        
                        var total_hours = parseFloat(Mhours) + parseFloat(Thours) + parseFloat(Whours) + parseFloat(Thhours) + parseFloat(Fhours) + parseFloat(Shours) + parseFloat(Suhours);
                        var total_pay   = (total_hours * perHourPay).toFixed(2);
                        
                        $('#total_hours').html(total_hours.toFixed(2));
                        $('#total_pay').html('$' + total_pay);
                        //$('#total_advance').html('$' + advanceTotal);
                        
                        $list.append('<tr>'+
                                        '<td><strong>Monday</strong></td>'+
                                        '<td>'+Mdate+'</td>'+
                                        '<td>'+Mhours+'</td>'+
                                        '<td>$'+(Mhours * perHourPay).toFixed(2)+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+Mdate+'_'+M+'" onclick ="viewDetails(this.id);" class="detailsBtn btn-white btn btn-xs">View Details</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>'+
                                    '<tr>'+
                                        '<td><strong>Tuesday</strong></td>'+
                                        '<td>'+Tdate+'</td>'+
                                        '<td>'+Thours+'</td>'+
                                        '<td>$'+(Thours * perHourPay).toFixed(2)+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+Tdate+'_'+T+'" onclick ="viewDetails(this.id);" class="detailsBtn btn-white btn btn-xs">View Details</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>'+
                                    '<tr>'+
                                        '<td><strong>Wednesday</strong></td>'+
                                        '<td>'+Wdate+'</td>'+
                                        '<td>'+Whours+'</td>'+
                                        '<td>$'+(Whours * perHourPay).toFixed(2)+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+Wdate+'_'+W+'" onclick ="viewDetails(this.id);" class="detailsBtn btn-white btn btn-xs">View Details</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>'+
                                    '<tr>'+
                                        '<td><strong>Thursday</strong></td>'+
                                        '<td>'+Thdate+'</td>'+
                                        '<td>'+Thhours+'</td>'+
                                        '<td>$'+(Thhours * perHourPay).toFixed(2)+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+Thdate+'_'+Th+'" onclick ="viewDetails(this.id);" class="detailsBtn btn-white btn btn-xs">View Details</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>'+
                                    '<tr>'+
                                        '<td><strong>Friday</strong></td>'+
                                        '<td>'+Fdate+'</td>'+
                                        '<td>'+Fhours+'</td>'+
                                        '<td>$'+(Fhours * perHourPay).toFixed(2)+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+Fdate+'_'+F+'" onclick ="viewDetails(this.id);" class="detailsBtn btn-white btn btn-xs">View Details</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>'+
                                    '<tr>'+
                                        '<td><strong>Saturday</strong></td>'+
                                        '<td>'+Sdate+'</td>'+
                                        '<td>'+Shours+'</td>'+
                                        '<td>$'+(Shours * perHourPay).toFixed(2)+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+Sdate+'_'+S+'" onclick ="viewDetails(this.id);" class="detailsBtn btn-white btn btn-xs">View Details</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>'+
                                    '<tr>'+
                                        '<td><strong>Sunday</strong></td>'+
                                        '<td>'+Sudate+'</td>'+
                                        '<td>'+Suhours+'</td>'+
                                        '<td>$'+(Suhours * perHourPay).toFixed(2)+'</td>'+
                                        '<td>'+
                                            '<div class="btn-group">'+
                                                '<button id="'+Sudate+'_'+Su+'" onclick ="viewDetails(this.id);" class="detailsBtn btn-white btn btn-xs">View Details</button>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>');
                    }
                    else
                    {
                        swal_btn.click();
                    }
                },
                error: function(data)
                {
                }           
            });        
        }
        
        function calculateWeekDates(date)
        {
            var targetDate = new Date(date1);
            targetDate.setDate(targetDate.getDate() + date);
            
            // So you can see the date we have created
            var dd = targetDate.getDate();
            var mm = targetDate.getMonth() + 1; // 0 is January, so we must add 1
            var yyyy = targetDate.getFullYear();
            
            if(dd<10) 
            {
                dd='0'+dd;
            } 
            
            if(mm<10) 
            {
                mm='0'+mm;
            } 
            
            var dateString = mm + "/" + dd + "/" + yyyy;
            
            // So you can see the output
            return dateString;
        }
    
        function viewDetails(day)
        {
            var temp = day.split('_');
            var choosenDay = temp[0];
            if( temp[1] == 0 )
            {
                swal_btn2.click();
            }
            else
            {
                localStorage.setItem("choosenDay",choosenDay);
                window.location.href = "details.php";
            }
        }
    </script>
</body>
</html>
