<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\Controller;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::group(['prefix' => 'manage-admin'], function () {
    //get routes
    Route::get('/onclock-employees',function(){
        return view('admin.who-is-on-clock');
    })->name('onclock');
    Route::get('/list/location',function(){
        return view('admin.show-location-list');
    })->name('location-clock');
    Route::get('/employee-clockin',function(){
        return view('admin.clockin-employee');
    })->name('clockin-employee');
    Route::get('/todays-clockin',function(){
        return view('admin.todays-clock');
    })->name('todays-clockin');
    Route::get('/employees',function(){
        return view('admin.employees-list');
    })->name('employee-listing');
    Route::get('/add-employee',[AdminController::class,'ViewAddEmployee'])->name('add-employee');
    Route::get('/update-employee',[AdminController::class,'ViewUpdateEmployee'])->name('update-employee');
    Route::get('/clockout-employees',[AdminController::class,'ViewClockOutEmployees'])->name('clockout-employees');
    Route::get('/clockout-details',[AdminController::class,'ViewClockOutEmployeesDetails'])->name('clock-details');
    Route::get('/advance-search',[AdminController::class,'ViewAdvanceSearch'])->name('advance-search');
    Route::get('/advance-details',[AdminController::class,'ViewAdvanceDetails'])->name('advance-details');
    Route::get('/active-employee',[AdminController::class,'ActiveEmployee'])->name('active-employee');
    Route::get('/payroll_detail',[AdminController::class,'ViewPayrollDetail'])->name('payroll_detail');
    Route::get('/emp_payroll_detail',[AdminController::class,'ViewEmpPayrollDetail'])->name('emp_payroll_detail');
    Route::get('/phone_carrier',[AdminController::class,'view_phonecarrier']);
    Route::get('/payroll_report',[AdminController::class,'ViewPayrollReport'])->name('payroll_report');
    Route::get('/view_all_employess',[AdminController::class,"getAllEmployees"])->name('allempolyees');
    Route::get('/view_all_locations',[AdminController::class,"getAllLocations"])->name('alllocations');
    Route::get('/view_all_locations_inactive',[AdminController::class,"getAllLocationsInActive"])->name('all_locations_inactive');
    Route::get('/view_all_locations_active',[AdminController::class,"getAllLocationsActive"])->name('allocationsactive');
    Route::get('/clockin_employees_location/{id}',[AdminController::class,"ClockInEmployeesOnLocation"])->name('clockin_employees_location');
    Route::get('/confirm_employee_hours',[AdminController::class,"ViewConfirmEmpHour"])->name('view_confirm_employee');
    Route::get('/confirm_employee_hours_listing',[AdminController::class,"ViewConfirmEmpHourListing"])->name('confirm_employee_list');
    Route::get('/confirm_employee',[AdminController::class,"ConfirmEmpolyee"])->name('confirm_employee');
    Route::get('/add_note',[AdminController::class,"AddNote"])->name('add_note');
    Route::get('/40-hours',[AdminController::class,"View40Hours"])->name('40_hours');
    Route::get('/advance',[AdminController::class,"ViewAdavance"])->name('adavance');
    Route::get('/40-hours_details',[AdminController::class,"View40HoursdDetails"])->name('40_hours_details');
    Route::get('/send_payrol',[AdminController::class, "ViewSendPayroll"])->name('send-payroll');
    Route::get('/send_payrol_emp',[AdminController::class, "ViewSendPayrollEmp"])->name('send-payroll-emp');
    Route::get('/send_payrol_details',[AdminController::class, "ViewSendPayrollDetails"])->name('send-payroll-details');
    //post routes
    Route::post('/add_employee1',[AdminController::class,'addEmployee']);
});
Route::get('/', function () {
    return view('auth.login');
})->name('login');
Route::group(['prefix' => 'manage-employee'], function () {
    Route::get('/login',[EmployeeController::class,'ViewEmployeeLogin']);
    Route::get('/selection_employees',[EmployeeController::class,'ViewEmployeeSelection'])->name('selection_employees');
    Route::get('/weekly_report',[EmployeeController::class,'ViewWeeklyReport'])->name('weekly_report');
    Route::get('/paycheck_history',[EmployeeController::class,'ViewPayCheckHistry'])->name('paycheck_history');
    Route::get('/detials',[EmployeeController::class,'ViewDetials'])->name('detials');
    // paycheck_history
});