<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Employee</title>

    @include('partials.headerLinks')
    <style type="text/css">
        .activeSM {
            background-color: white !important;
            /* #38283c !important;*/
        }
    </style>
    <script>
        const loginUrl = "{{ route('login') }}";

        if (!localStorage.login_timeclock_admin) {
            window.stop();
            window.location.replace(loginUrl);
        }
    </script>
</head>

<body>
    <div id="wrapper">
        @include('partials.navbar')
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                @include('partials.top-bar')
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><strong>Employees</strong></h2>
                    <a href="{{ route('add-employee') }}">
                        <button type="button" class="btn btn-default btn-sm">
                            <span class="glyphicon glyphicon-plus"></span> Add Employee
                        </button>
                    </a>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>SNo</th>
                                            <th>First Name</th>
                                            <th>Last Name</th>
                                            <th>Per Hour Pay ($)</th>
                                            <th>Pin Code</th>
                                            <th>Username</th>
                                            <th>Phone#</th>
                                            <th>Email</th>
                                            <th>Email for SMS</th>
                                            <th>Positions</th>
                                            <th>Assigned Locations</th>
                                            <th>Role</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="employee_list">
                                        <!-- Dynamically appending Employees List -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none"></button>

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete Employee</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the Employee?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white"
                        onclick="deleteEmployee()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white"
                        data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->



    @include('partials.scriptLinks')
    <script>
        const AllEmployeeUrl = "{{ route('allempolyees') }}";
        const AddEmployeeUrl = "{{ route('add-employee') }}";
        const UpdateEmployeeUrl = "{{ route('update-employee') }}";
        
        var delete_employee;

        $(document).ready(function() {
            $("#side2").addClass("activeSM");
            $("#side2 a").css("color", "#224ea6");

            viewEmployees();

            //Empty List
            $('#swal_btn').click(function() {
                swal({
                    title: "List is Empty!",
                    text: "Please add Employees.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function() {
                    window.location.assign(AddEmployeeUrl);
                });
            });

            //Delete Row
            $('#swal_btn2').click(function() {
                swal({
                    title: "Employee Deleted!",
                    text: "",
                    type: "success",
                    confirmButtonColor: "#DD6B55",
                });
            });

            //Active Row
            $('#swal_btn3').click(function() {
                swal({
                    title: "Activated/Deactivated",
                    text: "Employee Activated/Deactivated Successfully.",
                    type: "success",
                    confirmButtonColor: "#003399",
                });
            });
        });

        function viewEmployees() {
            var $list = $("#employee_list");
            $list.empty();
            $.ajax({
                url: AllEmployeeUrl,
                type: "GET",
                success: function(data) {
                    console.log(data, "data")
                    var count = 1;
                    // var dat = jQuery.parseJSON(data);
                    if (data.status == "success") {
                        $.each(data.Data, function(index, obj) {
                            if (obj.emp_active == '0') {
                                var status = '<span id="' + obj.emp_username +
                                    '" onclick ="statusChange(this.id);" class="label label-danger">Inactive</span>';
                            } else {
                                var status = '<span id="' + obj.emp_username +
                                    '" onclick ="statusChange(this.id);" class="label label-primary">Active</span>';
                            }
                            $list.append('<tr>' +
                                '<td><strong>' + count + '</strong></td>' +
                                '<td>' + obj.emp_fname + '</td>' +
                                '<td>' + obj.emp_lname + '</td>' +
                                '<td>' + obj.perhour_pay + '</td>' +
                                '<td>' + obj.emp_pincode + '</td>' +
                                '<td>' + obj.emp_username + '</td>' +
                                '<td>' + obj.emp_phone + '</td>' +
                                '<td>' + obj.emp_email + '</td>' +
                                '<td>' + obj.emp_emailSMS + '</td>' +
                                '<td>' + obj.position + '</td>' +
                                '<td>' + obj.assign_location + '</td>' +
                                '<td>' + obj.emp_role + '</td>' +
                                '<td>' + status + '</td>' +
                                '<td>' +
                                '<div class="btn-group">' +
                                '<button id="' + obj.emp_username +
                                '" onclick ="saveEmployee(this.id);" class="btn-white btn btn-xs">Edit</button>' +
                                //'<button id="'+obj.emp_username+'" onclick ="deleteEmployeeModal(this.id);" class="btn-white btn btn-xs">Delete</button>'+
                                '</div>' +
                                '</td>' +
                                '</tr>');
                            count++;
                        });
                    } else {
                        swal_btn.click();
                    }
                },
                error: function(data) {}
            });
        }

        function deleteEmployeeModal(id) {
            $('#deleteModal').modal('show');
            delete_employee = id;
        }


        function deleteEmployee() {
            $('#deleteModal').modal('hide');

            var emp_id = delete_employee;
            $.ajax({
                url: "/timePhpApi/BigApp/kos_apis/delete_employee.php",
                type: "get",
                data: {
                    "emp_username": emp_id
                },
                success: function(result) {
                    var data = jQuery.parseJSON(result);
                    if (data.status == "success") {
                        swal_btn2.click();
                        viewEmployees();
                    } else if (data.status == "failed") {
                        alert("failed");
                    }
                },
                error: function(data) {}
            });
        }

        function saveEmployee(id) {
            var emp_id = id;
            localStorage.setItem("emp_id", emp_id);
            window.location.href = UpdateEmployeeUrl;

        }

        function statusChange(id) {
            var emp_id = id;
            console.log(emp_id, 'emp_id')
            $.ajax({
                url: `http://127.0.0.1:9000/manage-admin/active-employee`,
                type: "get",
                data: {
                    "emp_username": emp_id
                },
                success: function(result) {
                    // var data = jQuery.parseJSON(result);
                    console.log(result, "result")
                    if (result.status == "success") {
                        swal_btn3.click();
                        viewEmployees();
                    } else if (result.status == "failed") {
                        alert("failed");
                    }
                },
                error: function(data) {}
            });
        }
    </script>
</body>

</html>
