<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Admin Panel | Add Employee</title>
    
    <link href="
    https://cdn.jsdelivr.net/npm/sweetalert2@11.7.31/dist/sweetalert2.min.css
    " rel="stylesheet">
    <?php echo $__env->make('partials.headerLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style type="text/css">
        .activeSM {
            background-color: white !important;
            /* #38283c !important;*/
        }

        .default {
            background-color: #224ea6;
            border-color: #224ea6;
            color: white;
            width: 100%;
            height: 40px;
            border-style: solid;
            font-size: 20px;
            margin-bottom: 20px;
        }

        div:where(.swal2-container) {
            display: grid;
            position: fixed;
            z-index: 10000 !important;
            inset: 0;
            box-sizing: border-box;
        }
    </style>
    <script>
        const loginUrl = "<?php echo e(route('login')); ?>";

        if (!localStorage.login_timeclock_admin) {
            window.stop();
            window.location.replace(loginUrl);
        }
    </script>
</head>

<body>

    <div id="wrapper w-100 bg-primary">
        <?php echo $__env->make('partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php echo $__env->make('partials.top-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Employee Details</Strong></h2>
                </div>
                <div class="col-lg-12">
                    <h5 id="location_name">

                    </h5>
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-10">
                            <div class="row locationContainer" style="padding-right:20px">

                                <div class="col-sm-6">

                                </div>
                                <div class="col-sm-6">
                                </div>
                                <div class="col-sm-12">
                                    <table class="table table-striped" style="background: #fff;" id="table2">
                                        <thead>
                                            <tr>
                                                <th colspan="5">Name</th>
                                                
                                                <th colspan="5">Position</th>
                                                <th colspan="5">In</th>
                                                <th colspan="5">Out</th>
                                                
                                                <th colspan="5"> Note</th>
                                                <th colspan="5"> Confirm by </th>
                                                <th colspan="5"> Confirm status </th>
                                            </tr>
                                        </thead>
                                        <tbody id="employee_list">
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="6">
                                                    <ul class="pagination pull-right">
                                                    </ul>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                

            </div>

            <?php echo $__env->make('partials.scriptLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;
            <script src="
                                                                                    https://cdn.jsdelivr.net/npm/sweetalert2@11.7.31/dist/sweetalert2.all.min.js
                                                                                    "></script>
            <script>
                const ViewLocationUrl = "<?php echo e(route('allocationsactive')); ?>";
                const ViewEmployeesOnClock = "<?php echo e(route('ViewOnClockEmployees')); ?>";
                const confirmEmployeeUrl = "<?php echo e(route('confirm_employee')); ?>";
                const AddNoteUrl = "<?php echo e(route('add_note')); ?>";

                const localStorageName = localStorage.getItem('locationHours');
                const localStorageDate = localStorage.getItem('locationHoursDate');
                let location_name = document.getElementById('location_name');
                // const Employee_Name = localStorage.getItem('Employee_Name');
                location_name.textContent = `Location: ${localStorageName}`;
                let newDate = new Date(localStorageDate).toLocaleString('en-GB', {
                    hour12: false,
                });

                let dateArray = newDate.split(',');
                let RealDate = dateArray[0];
                const getAllLocation = () => {
                    $.ajax({
                        url: ViewLocationUrl,
                        type: "GET",
                        success: function(data) {
                            console.log(data);
                            if (data.status === "success") {
                                data.Data.forEach(element => {
                                    if (element.location_name == localStorageName) {
                                        ListingTable(element.location_name);
                                    }
                                });
                            }

                        },
                        error: function(error) {
                            console.error("Error:", error);
                        }
                    });
                };
                getAllLocation();
                const apiCall = (emp) => {
                    console.log(emp);
                    let dataArr = emp.split('/');
                    const data = {
                        employee_id: dataArr[0],
                        tc_id: dataArr[1],
                        comfirmby: Employee_Name
                    }
                    $.ajax({
                        url: confirmEmployeeUrl,
                        type: "GET",
                        data: data,
                        success: function(data) {
                            if (data.status == "success") {
                                // alert("success")
                                window.location.reload();

                            }
                            // console.log(data);
                        },
                        error: function(error) {
                            console.error("Error:", error);
                            location.reload();
                        }
                    });
                }
                const ListingTable = (name) => {
                    const data = {
                        employee_id: 'All',
                        location: name
                    }
                    $.ajax({
                        url: ViewEmployeesOnClock,
                        type: "GET",
                        data: data,
                        success: function(data) {
                            // console.log(data);
                            if (data.status == 'success') {
                                console.log(data.data, "orDate");
                                data.data.forEach(element => {
                                    console.log("h1");
                                    const dateString1 = element.date;

                                    // JavaScript Date object
                                    const date2 = new Date(
                                        localStorageDate);
                                    date2.setHours(0, 0, 0, 0);
                                    // Parse the first date string and create a JavaScript Date object
                                    const date1Parts = dateString1.split("/");
                                    const year1 = parseInt(date1Parts[2], 10);
                                    const month1 = parseInt(date1Parts[0], 10) -
                                        1; // Months are zero-based in JavaScript
                                    const day1 = parseInt(date1Parts[1], 10);
                                    const date1 = new Date(year1, month1, day1);
                                    date1.setHours(0, 0, 0, 0);
                                    console.log("h2", date1.getTime() === date2.getTime());
                                    console.log("h3", date1, date2);

                                    // Compare the two Date objects
                                    if (date1.getTime() === date2.getTime()) {
                                        console.log("h3");

                                        var parent = $('#employee_list');
                                        var name = element.employee_details[0].emp_fname + " " +
                                            element.employee_details[0].emp_lname;
                                        console.log(parent, "parents");
                                        if (element.employee_details) {
                                            console.log(element.note == null);
                                            if (element.confirm_status == 1) {
                                                parent.append(
                                                    '<tr>' +
                                                    '<td colspan="5">' + name + '</td>' +
                                                    '<td colspan="5">' + element.position + '</td>' +
                                                    '<td colspan="5">' + element.clock_in +
                                                    '</td>' +
                                                    '<td colspan="5">' + element.clock_out + '</td>' +
                                                    '<td colspan="5"><button class="btn btn-sm btn-primary" id="' +
                                                    element.employee_id + '/' + element.tc_id + '/' +
                                                    element.note +
                                                    '"  onclick="NotePopup(this.id);">Note</button></td>' +
                                                    '<td colspan="5">Confirm by ' + element
                                                    .confirm_employee_fullname + '</td>' +
                                                    '<td>' +
                                                    '<button class="btn btn-sm btn-success" id="' +
                                                    element.employee_id + '/' + element.tc_id +
                                                    '" onclick="apiCall(this.id);">Confirmed</button>' +
                                                    '</tr>'
                                                )
                                            } else {
                                                parent.append(
                                                    '<tr>' +
                                                    '<td colspan="5">' + name + '</td>' +
                                                    '<td colspan="5">' + element.position + '</td>' +
                                                    '<td colspan="5">' + element.clock_in +
                                                    '</td>' +
                                                    '<td colspan="5">' + element.clock_out + '</td>' +
                                                    '<td colspan="5"><button class="btn btn-sm btn-primary disabled">Note</button></td>' +
                                                    '<td colspan="5">Not Confirmed</td>' +
                                                    '<td>' +
                                                    '<button class="btn btn-sm btn-primary" id="' +
                                                    element.employee_id + '/' + element.tc_id +
                                                    '" onclick="apiCall(this.id);">Not Confirmed</button>' +
                                                    '</tr>' +
                                                    '</tr>'
                                                )
                                            }

                                        }
                                        // parent.append(
                                        //    
                                        // )
                                    } else {
                                        // var parent = $('#employee_list');

                                        // parent.append(
                                        //     '<tr>' +
                                        //     '<td colspan="5" style="color:red;font-size: 20px;background:#fff;"><strong>No Result Found.</strong></td>' +
                                        //     '</tr>'
                                        // )
                                    }
                                })
                            } else {
                                var parent = $('#employee_list');

                                parent.append(
                                    '<tr>' +
                                    '<td colspan="5" style="color:red;font-size: 20px;background:#fff;"><strong>No Result Found.</strong></td>' +
                                    '</tr>'
                                )
                            }
                        },
                        error: function(error) {
                            console.log(error);
                        }
                    })

                }
                const NotePopup = (note) => {
                    console.log(note, "note");
                    const noteArr = note.split('/');

                    const {
                        // value: ""
                    } = Swal.fire({
                        title: 'Enter your text here',
                        input: 'textarea',
                        // input: 'text',
                        inputLabel: 'Note',
                        inputValue: "",
                        showCancelButton: true,
                        inputValidator: (value) => {

                            if (!value) {
                                return 'You need to write something!'
                            } else {
                                data = {
                                    employee_id: noteArr[0],
                                    tc_id: noteArr[1],
                                    note: value
                                }
                                $.ajax({
                                    url: AddNoteUrl,
                                    type: "GET",
                                    data: data,
                                    success: function(data) {
                                        console.log(data);
                                        if (data.status == "success") {
                                            // alert("success")

                                            window.location.reload();
                                        } else {
                                            console.log("something went wrong")
                                        }
                                    }
                                })
                            }
                        }
                    })
                }
            </script>



</body>

</html>
<?php /**PATH E:\laragon\www\Time-Clock\resources\views/admin/confirmEmployeesListing.blade.php ENDPATH**/ ?>