<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\http\Request;
use Illuminate\http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Input;
use Hash;


use DB;


class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
   
    public function test (Request $request)
    {
        return "good";
    }

  
    public function EmployeeSignin (Request $request)
    { 
		if(isset($request['emp_pincode']) && !empty($request['emp_pincode'])) 
			{
				$emp_pincode=$request['emp_pincode'];
				
				try 
				{ 
                    $users = DB::select('select * from KOS_Employee where emp_pincode = ?', [$emp_pincode]);
					if($users)
					{
					    return response()->json(['status'=>'success','data'=>$users]);
					    
					}
					else
					{
						return response()->json(['status'=>'failed','error'=>'Wrong Pin code']);
					}	
					  
				} 
				catch(\Illuminate\Database\QueryException $ex)
				{ 		
					return response()->json(['status'=>'failed','error'=>'Sql Error']);
				}
			
			}
			
		else 
			{
				return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
			}
      }
    
    public function EditEmployee (Request $request)
    { 
	    if(isset($request['emp_username']) && !empty($request['emp_username']) 
		    AND isset($request['emp_fname']) && !empty($request['emp_fname'])
		    AND isset($request['emp_lname']) && !empty($request['emp_lname'])
		    AND isset($request['emp_pincode']) && !empty($request['emp_pincode']))
		{
	        $emp_username =$request['emp_username'];
	        $emp_fname =$request['emp_fname'];
	        $emp_lname = $request['emp_lname'];
	        $emp_phone = $request['emp_phone'];
		    $emp_pass = $request['emp_pass'];
		    $emp_email = $request['emp_email'];
		    $emp_pincode = $request['emp_pincode'];
		    $emp_role = $request['emp_role'];
		    
		    $users = DB::select('select * from KOS_Employee where emp_username = ?', [$emp_username ]);						
		    if($users)
			{
			    foreach ($users as $key)
				{
				    $emp_pincode_exist = $key->emp_pincode;
				}
				
				if( $emp_pincode_exist != $emp_pincode )
				{
    			    $users2 = DB::select('select * from KOS_Employee where emp_pincode = ?', [$emp_pincode]);
        	        if($users2)
        			{
        			    return response()->json(['status'=>'failed','error'=>'Pincode Already Exits for another Employee.']);
        			}
        			else 
        			{
        				try 
        				{ 
        					$user_new = DB::update('update KOS_Employee SET emp_fname = ? , emp_lname = ? ,emp_phone = ? ,emp_pass = ? ,emp_email = ? ,emp_pincode = ? ,emp_role = ? where emp_username= ?', [$emp_fname,$emp_lname,$emp_phone,$emp_pass,$emp_email,$emp_pincode,$emp_role,$emp_username]);
        					if ( $user_new)
        					{		
        						return response()->json(['status'=>'success']);
        					}
        					else 
        					{
        						return response()->json(['status'=>'failed','error'=>'Sql Error1']);
        					}
        				} 
        				catch(\Illuminate\Database\QueryException $ex)
        				{ 		
        					return response()->json(['status'=>'failed','error'=>'This account already exists']);
        				}
        			}
				}
				else 
    			{
    				try 
    				{ 
    					$user_new = DB::update('update KOS_Employee SET emp_fname = ? , emp_lname = ? ,emp_phone = ? ,emp_pass = ? ,emp_email = ? ,emp_pincode = ? ,emp_role = ? where emp_username= ?', [$emp_fname,$emp_lname,$emp_phone,$emp_pass,$emp_email,$emp_pincode,$emp_role,$emp_username]);
    					if ( $user_new)
    					{		
    						return response()->json(['status'=>'success']);
    					}
    					else 
    					{
    						return response()->json(['status'=>'failed','error'=>'Sql Error1']);
    					}
    				} 
    				catch(\Illuminate\Database\QueryException $ex)
    				{ 		
    					return response()->json(['status'=>'failed','error'=>'This account already exists']);
    				}
    			}
			}
			else 
			{
		        return response()->json(['status'=>'failed','error'=>'Email Not Exists']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ViewAllEmployees (Request $request)
    { 
		try 
		{ 
            $users = DB::select('select * from 	KOS_Employee ');
			if($users)
			{
			    return response()->json(['status'=>'success','data'=>$users]);
			}
			else
			{
				return response()->json(['status'=>'failed','error'=>'No information found']);
			}	
		} 
		catch(\Illuminate\Database\QueryException $ex)
		{ 		
			return response()->json(['status'=>'failed','error'=>'Sql Error']);
		}
    }
    
    public function ViewEmployee (Request $request)
    { 
        if(isset($request['emp_username']) && !empty($request['emp_username']))
		{
		    $emp_username = $request['emp_username'];
		    
		    try 
			{
			    $users = DB::select ('select * from KOS_Employee where emp_username = ?', [$emp_username]);
	            if($users)
                {
                    return response()->json(['status'=>'success','data'=>$users]);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'No information found']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
			    return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function DeleteEmployee (Request $request)
    { 
	    if(isset($request['emp_username']) && !empty($request['emp_username']))
		{
		    $emp_username = $request['emp_username'];
		    try 
			{
			    $deleted = DB::delete ("delete from KOS_Employee  where emp_username='$emp_username'");
	            if($deleted)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
			    return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    //Positions FUNCTIONS
    public function AddPosition (Request $request)
    { 
	    if(isset($request['position']) && !empty($request['position']) )
		{
    	    $position =$request['position'];
    	    
    	       
			try 
			{ 
				$inserteed = DB::insert('insert into KOS_positions (position) values (?)',[$position]);
				
		        if($inserteed)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
			    return response()->json(['status'=>'failed','error'=>'This already exists']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
   
    public function ActivePosition (Request $request)
    { 
	    if(isset($request['pos_id']) && !empty($request['pos_id']))
		{
	        $pos_id =$request['pos_id'];
	       
	       $users = DB::select ('select * from KOS_positions where pos_id = ?', [$pos_id]);
	            if($users)
                {
                    foreach ($users as $key)
					{
						
						$current      =  $key->active;
					
					}
                   
                   if ($current == 1)
                   {
                       $active = 0;
                        try 
            			{ 
            			    $inserted = DB::update("update  KOS_positions SET  active='$active' where pos_id='$pos_id'");
            				
            	            if($inserted)
                            {
                                return response()->json(['status'=>'success','active'=>0]);
                            }
                            else 
             				{
             				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
             				} 
            			} 
            			catch(\Illuminate\Database\QueryException $ex)
            			{ 		
            				return response()->json(['status'=>'failed','error'=>'try again']);
            			}
                   }
                   else 
                   {
                       $active = 1;
                        try 
            			{ 
            			    $inserted = DB::update("update  KOS_positions SET  active='$active' where pos_id='$pos_id'");
            				
            	            if($inserted)
                            {
                                return response()->json(['status'=>'success','active'=>1]);
                            }
                            else 
             				{
             				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
             				} 
            			} 
            			catch(\Illuminate\Database\QueryException $ex)
            			{ 		
            				return response()->json(['status'=>'failed','error'=>'try again']);
            			}
                       
                   }
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'No information found']);
 				} 
		   
		   
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ViewAllPositions (Request $request)
    { 
		//return "get";
		try 
		{ 
            $users = DB::select('select * from 	KOS_positions ');
			if($users)
			{
		        return response()->json(['status'=>'success','data'=>$users]);
			}
			else
			{
			return response()->json(['status'=>'failed','error'=>'No information found']);
			}
		} 
		catch(\Illuminate\Database\QueryException $ex)
		{ 		
			return response()->json(['status'=>'failed','error'=>'Sql Error']);
		}
    }
    
   
    public function DeletePosition (Request $request)
    { 
	    if(isset($request['pos_id']) && !empty($request['pos_id']))
		{
	        $pos_id = $request['pos_id'];
	       
		    try 
			{ 
			    $deleted = DB::delete ("delete from  KOS_positions  where pos_id='$pos_id'");
	            if($deleted)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'id invalid']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    
   
     //Time Clock FUNCTIONS
    public function AddClockinTime (Request $request)
    { 
	    if(isset($request['date']) && !empty($request['date']) 
	    AND isset($request['time']) && !empty($request['time']) AND isset($request['employee_id']) && !empty($request['employee_id']) 
	    AND isset($request['position']) && !empty($request['position']) AND isset($request['location']) && !empty($request['location'])  AND isset($request['clock_in']) && !empty($request['clock_in'])  )
		{
    	    $date =$request['date'];
    	    $time =$request['time'];
    	    $employee_id =$request['employee_id'];
    	    $selfie =$request['selfie'];
    	    $position =$request['position'];
    	    $location =$request['location'];
    	    $clock_in =$request['clock_in'];
    	    
    	    	$request->file('photo');
				 $destinationPath='public/pictures';
				 $file=$request->photo;
				 $extention=$request->photo->extension();
			//  $extention=$file->getClientOriginalExtention();
				 $fileName=round(microtime(true)).".".$extention;
				 $file->move($destinationPath,$fileName);
				 $photo=$fileName;
				 $destination = "pictures/";
				 $target_file = $destination. $photo;
    	    
    	       
			try 
			{ 
				$inserteed = DB::insert('insert into timeclock (date,time,employee_id,selfie,position,location,clock_in) values (?,?,?,?,?,?,?)',[$date,$time,$employee_id,$target_file,$position,$location,$clock_in]);
				
		        if($inserteed)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
			    return response()->json(['status'=>'failed','error'=>'This already exists']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
     public function BreaksClockinTime (Request $request)
    { 
	    if(isset($request['date']) && !empty($request['date']) 
	    AND isset($request['time']) && !empty($request['time']) AND isset($request['employee_id']) && !empty($request['employee_id']) 
	    AND isset($request['position']) && !empty($request['position']) AND isset($request['location']) && !empty($request['location'])  AND isset($request['tc_id']) && !empty($request['tc_id'])  )
		{
    	    $date =$request['date'];
    	    $time =$request['time'];
    	    $employee_id =$request['employee_id'];
    	    $selfie =$request['selfie'];
    	    $position =$request['position'];
    	    $location =$request['location'];
    	    $action =$request['action'];
    	    $start_time =$request['start_time'];
    	     $back_to_work =$request['back_to_work'];
    	   
    	    $tc_id =$request['tc_id'];
    	    
    	    	$request->file('photo');
				 $destinationPath='public/pictures';
				 $file=$request->photo;
				 $extention=$request->photo->extension();
			//  $extention=$file->getClientOriginalExtention();
				 $fileName=round(microtime(true)).".".$extention;
				 $file->move($destinationPath,$fileName);
				 $photo=$fileName;
				 $destination = "pictures/";
				 $target_file = $destination. $photo;
    	    
    	       
			
				$inserteed = DB::insert('insert into timeclock_breaks (tc_id,date,time,employee_id,selfie,position,location,start_time,action) values (?,?,?,?,?,?,?,?,?)',[$tc_id,$date,$time,$employee_id,$target_file,$position,$location,$start_time,$action]);
				
		        if($inserteed)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    //VR Location Functions
    public function AddLocations (Request $request)
    { 
	    if( isset($request['location_name']) && !empty($request['location_name']) AND isset($request['location_active']) && !empty($request['location_active']) 
	    AND isset($request['location_pass']) && !empty($request['location_pass'])
	    AND isset($request['location_type']) && !empty($request['location_type']) AND isset($request['address']) && !empty($request['address']))
		{
    	    $location_name = $request['location_name'];
    	    $location_active   = $request['location_active'];
    	    $location_pass = $request['location_pass'];
    	    $location_type   = $request['location_type'];
    	    $address = $request['address'];
    	   
    	    
			try 
            { 
    			$inserteed = DB::insert('insert into KOS_Locations (location_name,location_active,location_pass,location_type,address) values (?,?,?,?,?)',[$location_name, $location_active,$location_pass,$location_type,$address]);
    			
                if($inserteed)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
     			{
     			    return response()->json(['status'=>'failed','error'=>'Sql Error']);
     			}  
    		} 
    		catch(\Illuminate\Database\QueryException $ex)
    		{ 		
    			return response()->json(['status'=>'failed','error'=>'Try Again']);
    		}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function EditLocations (Request $request)
    { 
	     if( isset($request['location_id']) && !empty($request['location_id']) AND  isset($request['location_name']) && !empty($request['location_name']) AND isset($request['location_active']) && !empty($request['location_active']) 
	    AND isset($request['location_pass']) && !empty($request['location_pass'])
	    AND isset($request['location_type']) && !empty($request['location_type']) AND isset($request['address']) && !empty($request['address']))
		{
    	    $location_id = $request['location_id'];
    	    $location_name = $request['location_name'];
    	    $location_active   = $request['location_active'];
    	    $location_pass = $request['location_pass'];
    	    $location_type   = $request['location_type'];
    	    $address = $request['address'];
			   
			   
			$users2 = DB::select('select * from KOS_Locations where location_id = ?', [$location_id ]);						
			if($users2)
			{
    			try 
    			{ 
    			    $user_new = DB::update('update KOS_Locations SET location_name = ? , location_active =?, location_pass=?, location_type=?, address=?  where location_id= ?', [$location_name,$location_active,$location_pass,$location_type,$address,$location_id]);
    				if ( $user_new)
    				{		
    					return response()->json(['status'=>'success']);
    				}
    				else 
    				{
    					return response()->json(['status'=>'failed','error'=>'Sql Error1']);
    				}
    			} 
    			catch(\Illuminate\Database\QueryException $ex)
    			{ 		
    				return response()->json(['status'=>'failed','error'=>'SQL Error']);
    			}
    		}
    		else 
    		{
    			return response()->json(['status'=>'failed','error'=>'Location Doesnt exists']);
    		}
    	}
    	else 
    	{
    		return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
		
	}
	
	public function GetLocation (Request $request)
	{ 
        try
        {
        
            $data2 = DB::select("select * from KOS_Locations");	   
	        if($data2)
	        {
	       	   
	            return response()->json(['status'=>'success','data'=>$data2]);
		    }
		    else
		    {
		        return response()->json(['status'=>'failed','error'=>'Data Doesnt exists.']);
		    }
        }
	    catch(\Illuminate\Database\QueryException $ex)
	    { 		
            return response()->json(['status'=>'failed','error'=>'SQL Error.']);
	    }
    	
    }
    
    public function DeleteLocation (Request $request)
    { 
	    if(isset($request['location_id']) && !empty($request['location_id']))
		{
		    $location_id = $request['location_id'];
		    
		    try 
			{
			    $deleted = DB::delete ("delete from KOS_Locations where location_id='$location_id'");
			    
	            if($deleted)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
 				{
 				    return response()->json(['status'=>'failed','error'=>'Sql Error']);
 				}  
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
			    return response()->json(['status'=>'failed','error'=>'try again']);
			}
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    //VR BATCH FUNCTIONS
    public function AddBatch (Request $request)
    { 
	    if( isset($request['employee_id']) && !empty($request['employee_id']) AND isset($request['location']) && !empty($request['location']) )
		{
    	    $location = $request['location'];
    	    $employee_id = $request['employee_id'];
    	    
    	    $users2 = DB::select('select * from VR_batch where location = ? ORDER BY created_at DESC LIMIT 1 ', [$location ]);						
			if($users2)
			{
			    foreach($users2 as $u2)
		       	    {
					    $name = $u2->name;
					    $batchnumber =  $name +1;
		       	    }
		       	    
        		  try 
                    { 
            			$inserteed = DB::insert('insert into VR_batch (name,location,employee_id) values (?,?,?)',[$batchnumber, $location,$employee_id]);
            			
                        if($inserteed)
                        {
                            return response()->json(['status'=>'success','batch_no'=>$batchnumber]);
                        }
                        else 
             			{
             			    return response()->json(['status'=>'failed','error'=>'Sql Error']);
             			}  
            		} 
            		catch(\Illuminate\Database\QueryException $ex)
            		{ 		
            			return response()->json(['status'=>'failed','error'=>'Try Again']);
            		}
		        
			}
			else 
			{
			    $batchnumber =1;
			    
			    try 
                    { 
            		$inserteed = DB::insert('insert into VR_batch (name,location,employee_id) values (?,?,?)',[$batchnumber, $location,$employee_id]);
            			
                        if($inserteed)
                        {
                            return response()->json(['status'=>'success','batch_no'=>$batchnumber]);
                        }
                        else 
             			{
             			    return response()->json(['status'=>'failed','error'=>'Sql Error']);
             			}  
            		} 
            		catch(\Illuminate\Database\QueryException $ex)
            		{ 		
            			return response()->json(['status'=>'failed','error'=>'Try Again']);
            		}
			}
			
		
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function GetBatchNumber (Request $request)
	{
	    if( isset($request['location']) && !empty($request['location']) )
        {
	        try
	        {
	            $location = $request['location'];
	            
	            $data2 = DB::select("select * from VR_batch where location = '$location' ORDER BY created_at DESC LIMIT 1 ");	   
		        if($data2)
		        {
		            return response()->json(['status'=>'success','data'=>$data2]);
    		    }
    		    else
    		    {
    		        return response()->json(['status'=>'failed','error'=>'Batch No Doesnt exists.']);
    		    }
	        }
    	    catch(\Illuminate\Database\QueryException $ex)
    	    { 		
                return response()->json(['status'=>'failed','error'=>'SQL Error.']);
    	    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    //VR REGISTER FUNCTIONS
    public function Addregisters (Request $request)
    { 
	    if( isset($request['location']) && !empty($request['location']) AND isset($request['name']) && !empty($request['name']) )
		{
    	    $location = $request['location'];
    	    $name = $request['name'];
    	    $status = "close";
    	   
    	   try 
            { 
    			$inserteed = DB::insert('insert into VR_registers (name,location,status) values (?,?,?)',[$name, $location, $status]);
    			
                if($inserteed)
                {
                    return response()->json(['status'=>'success']);
                }
                else 
     			{
     			    return response()->json(['status'=>'failed','error'=>'Sql Error']);
     			}  
    		} 
    		catch(\Illuminate\Database\QueryException $ex)
    		{ 		
    			return response()->json(['status'=>'failed','error'=>'Try Again']);
    		}
			
		
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function ViewRegisters (Request $request)
	{ 
        if( isset($request['location']) && !empty($request['location']) )
        {
	        try
	        {
	            $location = $request['location'];
	            
	            $data2 = DB::select("select * from VR_registers where location = '$location'");	   
		        if($data2)
		        {
		       	    foreach($data2 as $u2)
		       	    {
					    $register_id = $u2->register_id;
					    $data23 = DB::select("select * from balance_managing where register_id = '$register_id' ORDER BY creataed_at DESC LIMIT 1");	   
            		    if($data23)
            		    {
            		        $u2->balance_details = $data23;
                	    }
                		else
                		{
                		    //Do Nothing
                		}
		       	    }
		            return response()->json(['status'=>'success','data'=>$data2]);
    		    }
    		    else
    		    {
    		        return response()->json(['status'=>'failed','error'=>'No Register exists for this Location.']);
    		    }
	        }
    	    catch(\Illuminate\Database\QueryException $ex)
    	    { 		
                return response()->json(['status'=>'failed','error'=>'SQL Error.']);
    	    }
    	}
    	else
    	{
    	    return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
    }
    
    public function UpdateStatusRegister (Request $request)
    { 
	     if( isset($request['register_id']) && !empty($request['register_id']) AND  isset($request['status']) && !empty($request['status']))
		{
    	    $register_id = $request['register_id'];
    	    $status = $request['status'];
    	   
			try 
			{ 
			    $user_new = DB::update('update VR_registers SET status = ?  where register_id= ?', [$status,$register_id]);
				if ( $user_new)
				{		
					return response()->json(['status'=>'success']);
				}
				else 
				{
					return response()->json(['status'=>'failed','error'=>'Sql Error1']);
				}
			} 
			catch(\Illuminate\Database\QueryException $ex)
			{ 		
				return response()->json(['status'=>'failed','error'=>'SQL Error']);
			}
    		
    	}
    	else 
    	{
    		return response()->json(['status'=>'failed','error'=>'Incomplete Parameters']);
    	}
		
	}
	
	public function ViewPhoneRequirement (Request $request)
	{ 
	    
	    $rt =1;
        $data23 = DB::select("select * from phone_requirement where pr_id = '$rt'");	   
        if($data23)
        {
            return response()->json(['status'=>'success','data'=>$data23]);
	    }
	    else
	    {
	        return response()->json(['status'=>'failed','error'=>'Data Doesnt exists.']);
	    }
    }
    
}
