<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Admin Panel | Advance History Details</title>

    @include('partials.headerLinks')

    <style type="text/css">
        .activeSM {
            background-color: white !important;
            /* #38283c !important;*/
        }

        .detailsBtn {
            background-color: #224ea6;
            color: white;
            border-color: #224ea6;
        }

        .btn-success {
            width: 100%;
            margin: 20px 0px;
            color: #fff;
            background-color: green;
            border-color: green;
        }

        .btn-success:hover {
            color: #fff;
            background-color: green;
            border-color: green;
        }

        .btn-success:focus {
            color: #fff;
            background-color: green;
            border-color: green;
        }

        .btn-danger {
            width: 100%;
            color: #fff;
            background-color: #d9534f;
            border-color: #d43f3a;
        }

        .btn-primary {
            width: 100%;
            color: #fff;
            background-color: #224ea6;
            border-color: #224ea6;
        }

        .btn-primary:hover {
            color: #fff;
            background-color: #224ea6;
            border-color: #224ea6;
        }

        .btn-primary:focus {
            color: #fff;
            background-color: #224ea6;
            border-color: #224ea6;
        }
    </style>
    <script>
        const loginUrl = "{{ route('login') }}";

        if (!localStorage.login_timeclock_admin) {
            window.stop();
            window.location.replace(loginUrl);
        }
    </script>
</head>

<body>

    <div id="wrapper">
        @include('partials.navbar')


        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                @include('partials.top-bar')

            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="row" style="font-size:24px;margin:20px 0px 0px 40px;">
                    <center>
                        <font style="font-weight:800">Advance History Details</font><br>
                        <font id="selectedWeek" style="font-weight:800;color:#224ea6"></font>
                    </center>
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th >Advance</th>
                                            <th>Advance Returned</th>
                                        </tr>
                                    </thead>
                                    <tbody id="advance_list">
                                        <!-- Dynamically Appending Data -->
                                    </tbody>
                                </table>
                            </div>
                            <button onclick="goBack()" class="btn btn-primary">Back</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none"></button>
        </div>
    </div>

    <!-- Mainly scripts -->
    @include('partials.scriptLinks')
    <!--===============================================================================================-->

    <!-- Page-Level Scripts -->
    <script>
        const gobackurl = "{{ route('advance-search') }}";
        $(document).ready(function() {
            $('#emp_name').html(localStorage.Employee_Name);
            $('#selectedWeek').html(localStorage.selectedweek);

           $(document).ready(function() {
            $("#side6").addClass("activeSM");
            $("#side6 a").css("color", "#224ea6");
        });

            printTableRow();

            //Empty List
            $('#swal_btn').click(function() {
                swal({
                    title: "No Data",
                    text: "Employee has no Working hours During the Selected Week.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });

            $('#swal_btn2').click(function() {
                swal({
                    title: "No Details",
                    text: "Employee has no Working hours During the Selected Day.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });

        function printTableRow() {
            var $list = $('#advance_list');
            $list.empty();

            $list.append('<tr>' +
                '<td>' + localStorage.AdvanceEmployee + '</td>' +
                '<td>$' + localStorage.AdvanceLoan + '</td>' +
                '<td>$' + localStorage.AdvanceReturned + '</td>' +
                '</tr>');
        }

        function goBack() {
            window.location.href = gobackurl;
        }
    </script>
</body>

</html>
