<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>King Of Scooters | Weekly Graph Report</title>

    @include('partials.headerLinks')
    <style type="text/css">
        .activeSM {
            background-color: white !important;
            /* #38283c !important;*/
        }

        .borderTd {
            border: 2px #D2D3D8 solid;
        }
        .tableHeading{
            position: relative;
            height: 45px;
            
            background-color: #fff!important;
        }
        .tableChild{
            position: absolute;
            left: 42%;
            font-size: 2rem;
            font-weight: bold;
            padding: 2px 0;
        }
    </style>
    <script>
        const loginUrl = "{{ route('login') }}";

        if (!localStorage.login_timeclock_admin) {
            window.stop();
            window.location.replace(loginUrl);
        }
    </script>
</head>

<body>
    <div id="wrapper">
        @include('partials.navbar')
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                @include('partials.top-bar')
            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2 style="text-align: center;margin-left:95px;"><strong>Weekly Report - Location <span
                                id="loc"></span></strong></h2>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content table-responsive">
                                {{-- <table class="table table-striped">
                                    <thead>
                                        <tr id="day_list">
                                            <td colspan="2" class="borderTd">
                                                Date
                                            </td>
                                        </tr>
                                        <tr id="date_list">
                                            <td colspan="2" class="borderTd">
                                                Day
                                            </td>
                                        </tr>
                                    </thead>
                                    <tbody id="">
                                        
                                    </tbody>
                                    
                                    <tfoot>
                                        <tr>
                                            <td colspan="6">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table> --}}
                                <table id="list" class="table table-striped">
                                    <thead>
                                        <tr id="day_list">
                                            <td colspan="2" class="borderTd">
                                                Date
                                            </td>
                                        </tr>
                                        <tr id="date_list">
                                            <td colspan="2" class="borderTd">
                                                Day
                                            </td>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none"></button>
            <!-- Delete Row -->
            <button id="swal_btn2" type="button" style="display:none"></button>
            <!-- Active/Inactive row -->
            <button id="swal_btn3" type="button" style="display:none"></button>

        </div>
    </div>

    <!-- Modal -->
    {{-- <div class="modal fade" id="deleteModal" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Delete Employee</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the Employee?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white"
                        onclick="deleteEmployee()">Yes</button>
                    <button type="button" class="btn btn-default" style="background-color: #ed5565; color: white"
                        data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div> --}}
    <!-- Modal Close -->



    @include('partials.scriptLinks')
    {{-- <script src="{{ asset('js/jquery-3.1.1.min.js') }}"></script> --}}
    {{-- <script src="{{ asset('js/bootstrap.min.js') }}"></script> --}}
    <script src="{{ asset('js/jquery.metisMenu.js') }}"></script>
    <script src="{{ asset('js/jquery.slimscroll.min.js') }}"></script>
    <script src="{{ asset('js/dates.js') }}"></script>

    <script>
        const nextPageUrl = "{{ route('weekly-report') }}";
        var startDateRange;
        var endDateRange;
        var total_pay;
        var advanceTotal = 0;
        var Total_Hours;
        var Grand_Total_Hours = 0;
        var Grand_Total_Pay = 0;
        var emp_fullname;
        var clockin_date;
        var hours;
        var print;
        var perHourPay;
        var $list;
        var startDayofWeek, lastDayofWeek;
        var normalHours = 0;
        var overTimeHours = 0;
        var totalExtraHours = 0;
        var overtime = "NO";
        var EmployeeUsername;
        var DetailsExists = 0;
        const arr = [];
        const positionArr = [];
        $(document).ready(function() {
            $('#emp_name').html(localStorage.Employee_Name);
            $('#selectedWeek').html(localStorage.selectedweek);
            $('#loc').html(localStorage.Selected_Loc);

            $("#side10").addClass("activeSM");
            $("#side10 a").css("color", "#224ea6");

            assignValues();
            viewDetails();

            //Empty List
            $('#swal_btn').click(function() {
                swal({
                    title: "No Data",
                    text: "Employee has no Working hours During the Selected Week.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                    closeOnConfirm: false
                }, function() {
                    window.location.assign("employee_selection.php");
                });
            });

            $('#swal_btn2').click(function() {
                swal({
                    title: "No Details",
                    text: "Employee has no Working hours During the Selected Day.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                });
            });
        });

        function assignValues() {
            const selectedWeek = localStorage.getItem('Selected_Week');
            if (selectedWeek) {
                const arr = selectedWeek.split('-');
                startDateRange = arr[0];
                endDateRange = arr[1];

            }
            // startDateRange = localStorage.getItem('From_Date');
            // endDateRange = localStorage.getItem('To_Date');

            // $('#selected_location').html(localStorage.Selected_Loc);
            // $('#from_date').html(startDateRange);
            // $('#to_date').html(endDateRange);
        }

        function viewDetails() {
            // $list = $("#payroll_list");
            // $list.empty();
           
            var EmployeesObject = JSON.parse(localStorage.EmployeesObject);
            var Employees = JSON.parse(localStorage.AllEmployees);
            // startDateRange = "09/18/2021";
            // endDateRange = "09/25/2021";
            getFullWeek(startDateRange, endDateRange);
            // console.log(result);
            $.each(EmployeesObject, function(array_index, array_value) {
                clockin_date = array_value.date; // The date you want to check
                // End date of the range

                // console.log(array_value.date, startDateRange, endDateRange)
                // Convert the date strings to Date objects
                var clockinDateObj = new Date(clockin_date);
                var startDateObj = new Date(startDateRange);
                var endDateObj = new Date(endDateRange);

                // Check if clockin_date falls within the range
                if (clockinDateObj >= startDateObj && clockinDateObj <= endDateObj) {
                    if(array_value.clock_out != 0){
                         if (positionArr.length >= 1) {
                        const arrStatus = positionArr.includes(array_value.position);
                        // console.log(arrStatus);
                        if (!arrStatus) {
                            // console.log("inside")
                            positionArr.push(array_value.position);
                        } else {

                        }

                    } else {
                        positionArr.push(array_value.position);
                    }

                    arr.push({
                        position: array_value.position,
                        data: array_value
                    })
                    }
                   
                    // You can perform additional actions here if it's within the range
                } else {
                    // console.log('clockin_date is not within the range');
                    // You can perform other actions here if it's not within the range
                }

                // Rest of your code

                // printList(print);
            });
            if(arr.length < 1){
                swal({
                    title: "No Details",
                    text: "Employees has no Working hours During the Selected Week.",
                    type: "warning",
                    confirmButtonColor: "#DD6B55",
                }, function() {
                    goBack();
                });
            }
            console.log(arr, "arr");
            // console.log(positionArr, "arr");

            // if (DetailsExists == 0) {
            //     $list.append('<tr>' +
            //         '<td colspan="5" style="color:red;font-size: 20px;"><strong>No Result Found.</strong></td>' +
            //         '</tr>');
            // }
            viewDateList();
            showSecondList();

        }
        const result = [];
        const getFullWeek = (start, end) => {
            const startDate = new Date(start);
            const endDate = new Date(end);

            const weekdays = ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"];

            while (startDate <= endDate) {
                const day = startDate.toLocaleDateString('en-US', {
                    weekday: 'long'
                });
                const date = startDate.toLocaleDateString('en-US', {
                    month: '2-digit',
                    day: '2-digit',
                    year: 'numeric'
                });
                const formattedDate = `${day} ${date}`;

                result.push({
                    day: day,
                    date: date
                });

                // Move to the next day
                startDate.setDate(startDate.getDate() + 1);
            }

        }
        const viewDateList = () => {
            let day = $('#day_list');
            result.forEach(element => {
                $('#day_list').append(
                    '<td colspan="2" class="borderTd">' + element.day + '</td>'
                )
                $('#date_list').append(
                    '<td colspan="2" class="borderTd" id="' + element.date + '">' + element.date + '</td>'
                )
            });
        }

        const showSecondList = () => {
    const parent = document.getElementById('list');
    for (let index = 0; index < positionArr.length; index++) {
        const element = positionArr[index];
        const BodyPar = document.createElement("tbody");
        const trPar = document.createElement("tr");
        const tr = document.createElement("h4");
        tr.textContent = element;
        trPar.className ='tableHeading';
        tr.className = 'tableChild';
        BodyPar.id = element;
        // BodyPar.class = "table table-striped";

        parent.appendChild(BodyPar);
        BodyPar.appendChild(trPar);
        trPar.appendChild(tr);
        // Filter arr to get objects with the same position
        const positionData = arr.filter(item => item.position === element);

        positionData.forEach(data => {

            // console.log(data.data.clock_in,data.,"sadia");
            const sliptedArr = data.data.clock_in.split(' ');
            const sliptedArr1 = data.data.clock_out.split(' ');
            const clockinTime =convertTo12HourFormat(sliptedArr[1]);
            const clockOutTime = convertTo12HourFormat(sliptedArr1[1]);
            
            // const time = sliptedArr[1] + "-" + sliptedArr1[1];
            const time = clockinTime + "-" + clockOutTime;
            const trChild = document.createElement('tr');
            document.getElementById(element).appendChild(trChild);
            let name = data.data.employee_details ? data.data.employee_details[0].emp_fname +' '+ data.data.employee_details[0].emp_lname : data.data.employee_id;
            // if(data.data.employee_details){
            //     name = data.data.employee_details[0].emp_fname +' '+ data.data.employee_details[0].emp_lname;
            // }
            const tdName = document.createElement('td');
            tdName.textContent = name;
            tdName.colSpan = 2;
            tdName.className ="borderTd";
            trChild.appendChild(tdName);

            result.forEach(resultElement => {
                const td = document.createElement('td');
                td.id = resultElement.date;
                console.log(data.data.date,resultElement.date);
                console.log(resultElement.date == data.data.date, "dsdsa")
                if(resultElement.date == data.data.date){
                    td.textContent = time;
                }
               
                td.className = "borderTd";
                td.colSpan = 2;
                trChild.appendChild(td);
            });
            
        });
    }
}
function convertTo12HourFormat(time) {
    // Parse the input time string to a Date object
    const date = new Date(`1/1/2023 ${time}`); // Using a dummy date

    // Get the hours and minutes
    const hours = date.getHours();
    const minutes = date.getMinutes();

    // Determine if it's AM or PM
    const amPm = hours >= 12 ? "PM" : "AM";

    // Convert hours to 12-hour format
    const hours12 = hours % 12 || 12; // Handle midnight (0) as 12

    // Format the time as "hh:mm AM/PM"
    const formattedTime = `${hours12}:${minutes.toString().padStart(2, '0')} ${amPm}`;

    return formattedTime;
}

        function goBack() {
            window.location.href = nextPageUrl;
        }
    </script>
</body>

</html>
