<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\Controller;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::group(['prefix' => 'manage-admin'], function () {
    //get routes
    Route::get('/onclock-employees',function(){
        return view('admin.who-is-on-clock');
    })->name('onclock');
    Route::get('/list/location',function(){
        return view('admin.show-location-list');
    })->name('location-clock');
    Route::get('/employee-clockin',function(){
        return view('admin.clockin-employee');
    })->name('clockin-employee');
    Route::get('/todays-clockin',function(){
        return view('admin.todays-clock');
    })->name('todays-clockin');
    Route::get('/employees',function(){
        return view('admin.employees-list');
    })->name('employee-listing');
    Route::get('/add-employee','AdminController@ViewAddEmployee')->name('add-employee');
    Route::get('/update-employee','AdminController@ViewUpdateEmployee')->name('update-employee');
    Route::get('/clockout-employees','AdminController@ViewClockOutEmployees')->name('clockout-employees');
    Route::get('/clockout-details','AdminController@ViewClockOutEmployeesDetails')->name('clock-details');
    Route::get('/advance-search','AdminController@ViewAdvanceSearch')->name('advance-search');
    Route::get('/advance-details','AdminController@ViewAdvanceDetails')->name('advance-details');
    Route::get('/active-employee','AdminController@ActiveEmployee')->name('active-employee');
    Route::get('/payroll_detail','AdminController@ViewPayrollDetail')->name('payroll_detail');
    Route::get('/emp_payroll_detail','AdminController@ViewEmpPayrollDetail')->name('emp_payroll_detail');
    Route::get('/phone_carrier','AdminController@view_phonecarrier')->name("phone_carrier");
    Route::get('/payroll_report','AdminController@ViewPayrollReport')->name('payroll_report');
    Route::get('/view_all_employess',"AdminController@getAllEmployees")->name('allempolyees');
    Route::get('/view_all_locations',"AdminController@getAllLocations")->name('alllocations');
    Route::get('/view_all_locations_inactive',"AdminController@getAllLocationsInActive")->name('all_locations_inactive');
    Route::get('/view_all_locations_active',"AdminController@getAllLocationsActive")->name('allocationsactive');
    Route::get('/clockin_employees_location/{id}',"AdminController@ClockInEmployeesOnLocation")->name('clockin_employees_location');
    Route::get('/confirm_employee_hours',"AdminController@ViewConfirmEmpHour")->name('view_confirm_employee');
    Route::get('/confirm_employee_hours_listing',"AdminController@ViewConfirmEmpHourListing")->name('confirm_employee_list');
    Route::get('/confirm_employee',"AdminController@ConfirmEmpolyee")->name('confirm_employee');
    Route::get('/add_note',"AdminController@AddNote")->name('add_note');
    Route::get('/40-hours',"AdminController@View40Hours")->name('40_hours');
    Route::get('/advance',"AdminController@ViewAdavance")->name('adavance');
    Route::get('/40-hours_details',"AdminController@View40HoursdDetails")->name('40_hours_details');
    Route::get('/send_payrol',"AdminController@ViewSendPayroll")->name('send-payroll');
    Route::get('/send_payrol_emp',"AdminController@ViewSendPayrollEmp")->name('send-payroll-emp');
    Route::get('/send_payrol_details',"AdminController@ViewSendPayrollDetails")->name('send-payroll-details');
      Route::get('/weekly-report',"AdminController@ViewWeeklyReport")->name('weekly-report');
    Route::get('/payroll-report-graph',"AdminController@ViewWeeklyReportFirst")->name('payroll-report-graph');
    Route::get('/weekly-report-graph',"AdminController@ViewWeeklyReportTable")->name('weekly-report-graph');
    //post routes
    
});
Route::post('/add_employee1','AdminController@addEmployee')->name('add_employee1');
Route::get('/', function () {
    // return "YES";
    return view('auth.login');
})->name("login");
Route::group(['prefix' => 'manage-employee'], function () {
    Route::get('/login','EmployeeController@ViewEmployeeLogin');
    Route::get('/selection_employees','EmployeeController@ViewEmployeeSelection')->name('selection_employees');
    Route::get('/weekly_report','EmployeeController@ViewWeeklyReport')->name('weekly_report');
    Route::get('/paycheck_history','EmployeeController@ViewPayCheckHistry')->name('paycheck_history');
    Route::get('/detials','EmployeeController@ViewDetials')->name('detials');
    // paycheck_history
});