<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Timeclock Admin Panel | Shift Details</title>

    <?php echo $__env->make('partials.headerLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <style type="text/css">
        .activeSM {
            background-color: white !important;
            /* #38283c !important;*/
        }

        .detailsBtn {
            background-color: #224ea6;
            color: white;
            border-color: #224ea6;
        }

        .btn-success {
            width: 100%;
            margin: 20px 0px;
            color: #fff;
            background-color: green;
            border-color: green;
        }

        .btn-success:hover {
            color: #fff;
            background-color: green;
            border-color: green;
        }

        .btn-success:focus {
            color: #fff;
            background-color: green;
            border-color: green;
        }

        .btn-danger {
            width: 100%;
            color: #fff;
            background-color: #d9534f;
            border-color: #d43f3a;
        }

        .btn-primary {
            width: 100%;
            color: #fff;
            background-color: #224ea6;
            border-color: #224ea6;
        }

        .btn-primary:hover {
            color: #fff;
            background-color: #224ea6;
            border-color: #224ea6;
        }

        .btn-primary:focus {
            color: #fff;
            background-color: #224ea6;
            border-color: #224ea6;
        }
    </style>
    <script>
        const loginUrl = "<?php echo e(route('login')); ?>";

        if (!localStorage.login_timeclock_admin) {
            window.stop();
            window.location.replace(loginUrl);
        }
    </script>
</head>

<body>

    <div id="wrapper">
        <?php echo $__env->make('partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                <?php echo $__env->make('partials.top-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="row" style="font-size:24px;margin:20px 0px 0px 40px;">
                    <center>
                        <font style="font-weight:800">Daily Shift Details</font><br>
                        <font id="selectedWeek" style="font-weight:800;color:#224ea6"></font>
                    </center>
                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight ecommerce">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div id="payroll_list" class="ibox-content table-responsive">
                                <!-- Dynamically Appending Data -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Empty List -->
            <button id="swal_btn" type="button" style="display:none">
                <!-- Delete Row -->
                <button id="swal_btn2" type="button" style="display:none">
                    <!-- Active/Inactive row -->
                    <button id="swal_btn3" type="button" style="display:none">

        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="clockOutModal" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Clock Employee Out</h4>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to clock out your Employee?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" style="background-color: #1ab394; color: white"
                        onclick="dateTime()">Yes</button>
                    <button type="button" class="btn btn-default"
                        style="background-color: #ed5565; color: white;float: left" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Close -->

    <!-- Mainly scripts -->
    <?php echo $__env->make('partials.scriptLinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="js/spin.min.js"></script>
    <script src="js/ladda.min.js"></script>
    <script src="js/ladda.jquery.min.js"></script>
    <!-- Page-Level Scripts -->
    <script>
        const goBackUrl = "<?php echo e(route('clockout-employees')); ?>";
        const AdvanceLoanTotal = "<?php echo e(route('AdvanceLoanTotal')); ?>";
        const AddClockoutTime = "<?php echo e(route('AddClockoutTime')); ?>";

        var date1;
        var date2;
        var advance_total;
        var EmployeesObject = JSON.parse(localStorage.EmployeesObject);
        var Employee_Tc_Id = localStorage.Employee_Tc_Id;
        var perHourPay;
        var TotalHours = 0;
        var c_employee_id, c_tc_id, c_date, c_time, c_position, c_location;
        var l;

        $(document).ready(function() {
            $('#emp_name').html(localStorage.Employee_Name);
            $('#selectedWeek').html(localStorage.selectedweek);

            $("#side2").addClass("activeSM");
            $("#side2 a").css("color", "#224ea6");
            viewPayrollList();

            //Empty List
            $('#swal_btn').click(function() {
                swal({
                    title: "SUCCESS",
                    text: "Successfully Clock out this Employee!",
                    type: "success",
                    confirmButtonColor: "#224ea6",
                    closeOnConfirm: false
                }, function() {
                    window.location.assign(goBackUrl);
                });
            });
        });
function sorting(a,b){
      return new Date(a.start_time) - new Date(b.start_time);
    }
        function viewPayrollList() {
            var $list = $("#payroll_list");
            $list.empty();

            $.each(EmployeesObject, function(index, obj) {
                if (Employee_Tc_Id == obj.tc_id) {
                    c_employee_id = obj.employee_id;
                    c_tc_id = obj.tc_id;
                    c_position = obj.position;
                    c_location = obj.location;

                    printEmployeeDetails($list, obj);

                    printTable($list, obj, index);

                    var id = "table_" + index;
                    var $list2 = $("#" + id);

                    printClockIn($list2, obj);

                    printBreaks($list2, obj);

                    printClockOut($list2, obj);

                    showRemainingDetails(obj, index);
                    if(obj.confirm_status == 1){
                        console.log(obj.confirm_employee);
                        if(obj.confirm_timestamp !== null){
                            const dateTime = obj.confirm_timestamp.split(' ');
                        $('#confirm_date_'+index).text(dateTime[0]);
                        $('#confirm_time_'+index).text(convertTo12HourFormat(dateTime[1]));
                        }
                        $('#confirm_by_'+index).text(obj.confirm_employee_fullname);
                        if(obj.note != null){
                             $('#confirm_note_'+index).text(obj.note);
                        }
                    }
                }
            });
        }

        function printEmployeeDetails($list, object) {
            var fullName;

            $.each(object.employee_details, function(index, obj) {
                fullName = obj.emp_fname + " " + obj.emp_lname;
            });

            $list.append('<div style="font-size: 15px;font-weight: 800;margin-left: 8px;">' +
                '<font>Name : </font><font style="font-weight:800;color:#224ea6">' + fullName + '</font><br>' +
                '<font>Location : </font> <font style="font-weight:800;color:#224ea6">' + object.location +
                '</font><br>' +
                '<font>Position : </font> <font style="font-weight:800;color:#224ea6">' + object.position +
                '</font><br>' +
                '</div>');
        }

        function printTable($list, object, index) {
            $list.append('<table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">' +
                '<thead>' +
                '<tr>' +
                '<th>Type</th>' +
                '<th>Date</th>' +
                '<th>Time</th>' +
                '</tr>' +
                '</thead>' +
                '<tbody id="table_' + index + '">' +
                '</tbody>' +
                '</table>' +
                '<div class="row" style="font-size:15px;margin-left: 5px;">' +
                '<font style="font-weight:800">Total Time for Today : </font> <font id="total_hours_' + index +
                '"></font><br>' +
                '<font style="font-weight:800">Rate per Hour : $</font> <font id="emp_rate_' + index + '"></font><br>' +
                '<font style="font-weight:800">Total Payroll for Today : </font> <font id="total_pay_' + index +
                '"></font><br>' +
                //'<font style="font-weight:800;color:red">Advance: </font> <font id="total_advance_'+index+'"></font><br>'+
                '<font style="font-weight:800">Confirmed By : </font> <font id="confirm_by_' + index + '"></font><br>' +
                '<font style="font-weight:800">Confirmed Date : </font> <font id="confirm_date_' + index +
                '"></font><br>' +
                '<font style="font-weight:800">Confirmed Time : </font> <font id="confirm_time_' + index +
                '"></font><br>' +
                '<font style="font-weight:800">Confirmed Note : </font> <font id="confirm_note_' + index +
                '"></font><br>' +
                '</div></br>' +
                '<button onclick="clockOutModal()" class="ladda-button ladda-button-demo btn btn-danger" type="submit" data-style="zoom-in">' +
                '<span class="ladda-label">Clock Employee Out</span><span class="ladda-spinner"></span>' +
                '</button></br></br>' +
                '<button onclick="goBack()" class="btn btn-primary">Back</button>');
            //'<hr style="border-top: 2px solid black">');
        }

        function printClockIn($list, object) {
            $list.empty();

            var tempTime = convertTime(object.time);

            $list.append('<tr style="color:green">' +
                '<td ><strong>Clock In</strong></td>' +
                '<td>' + object.date + '</td>' +
                '<td>' + tempTime + '</td>' +
                '</tr>');
        }

        function printBreaks($list, object) {
            
            if (object.breaks) {
                const data = object.breaks.sort(sorting);
                $.each(data, function(index, obj) {
                    var tempTime = convertTime(obj.time);
                    var tempCamelCase = capitalizeFirstLetter(obj.action);

                    $list.append('<tr style="color:red">' +
                        '<td ><strong>' + tempCamelCase + '</strong></td>' +
                        '<td>' + obj.date + '</td>' +
                        '<td>' + tempTime + '</td>' +
                        '</tr>');

                    if (obj.back_to_work_date) {
                        var tempTimeBTW = convertTime(obj.back_to_work_time);

                        $list.append('<tr style="color:green">' +
                            '<td ><strong>Back to Work</strong></td>' +
                            '<td>' + obj.back_to_work_date + '</td>' +
                            '<td>' + tempTimeBTW + '</td>' +
                            '</tr>');
                    }
                });
            }
        }

        function printClockOut($list, object) {
            $.each(object.clockouts, function(index, obj) {
                var tempTime = convertTime(obj.time);
                $list.append('<tr style="color:red">' +
                    '<td ><strong>Clock Out</strong></td>' +
                    '<td>' + obj.date + '</td>' +
                    '<td>' + tempTime + '</td>' +
                    '</tr>');
            });
        }

        function showRemainingDetails(object, index) {
            var hours = calculateHours(object);

            var TotalHours = (parseFloat(hours) / 3600).toFixed(2);

            var displayTime = secondsToHms(hours);

            var total_pay = (parseFloat(TotalHours) * parseFloat(object.payroll_perhr)).toFixed(2);

            $('#total_hours_' + index).html(displayTime);
            $('#emp_rate_' + index).html(object.payroll_perhr);
            $('#total_pay_' + index).html('$' + total_pay);

            calculateAdvance(object, index);
            // showConfirmManagerDetails(object, index);
        }

        function calculateHours(object) {
            console.log(object);
            var hours;

            if (object.clock_out == 0) {
                hours = parseFloat(object.working_hours);
                console.log(hours);
                 
                if (object.breaks) {
                    var tempStartDate;
                    const data = object.breaks.sort(sorting);
                    $.each(data, function(index, obj) {
                        if (obj.back_to_work_date) {
                            tempStartDate = obj.back_to_work_date + " " + obj.back_to_work_time;
                        } else {
                            tempStartDate = obj.back_to_work_date;
                        }
                    });

                    if (tempStartDate) {
                        var startDate = new Date(tempStartDate);
                        var endDate = new Date();
                        var seconds = (endDate.getTime() - startDate.getTime()) / 1000;
                        hours = parseFloat(hours) + parseFloat(seconds);
                    } else {
                        hours = parseFloat(hours);
                    }
                } else {
                    var startDate = new Date(object.clock_in);
                    var endDate = new Date();
                    var seconds = (endDate.getTime() - startDate.getTime()) / 1000;
                    hours = parseFloat(seconds);
                }
            } else {
                hours = parseFloat(object.working_hours);
            }

            return hours;
        }

        function secondsToHms(seconds) {
            seconds = Number(seconds);
            var h = Math.floor(seconds / 3600);
            var m = Math.floor(seconds % 3600 / 60);
            //var s = Math.floor(d % 3600 % 60);

            var hDisplay = h > 0 ? h + (h == 1 ? " Hour " : " Hours ") : "";
            var mDisplay = m > 0 ? m + (m == 1 ? " Minute " : " Minutes ") : "";
            //var sDisplay = s > 0 ? s + (s == 1 ? " second" : " seconds") : "";
            return hDisplay + mDisplay; // + sDisplay; 
        }

        function showConfirmManagerDetails(object, index) {
            if (object.confirm_timestamp) {
                var confirm_temp = object.confirm_timestamp.split(" ");
                var tempTimeConfirm = convertTime(confirm_temp[1]);

                $('#confirm_by_' + index).html(object.confirm_employee_fullname);
                $('#confirm_date_' + index).html(confirm_temp[0]);
                $('#confirm_time_' + index).html(tempTimeConfirm);
                $('#confirm_note_' + index).html(object.note);
            }
        }

        function convertTime(time) {
            var temp = time.split(':');
            var hours = temp[0];

            if (hours < 12) {
                hours = hours + ":" + temp[1] + " AM";
            } else if (hours == 12) {
                hours = hours + ":" + temp[1] + " PM";
            } else if (hours > 12) {
                hours = hours - 12;
                if (hours < 10) {
                    hours = "0" + hours + ":" + temp[1] + " PM";
                } else {
                    hours = hours + ":" + temp[1] + " PM";
                }
            }
            return hours;
        }

        function calculateAdvance(object, index) {

            $.ajax({
                url: AdvanceLoanTotal,
                type: "GET",
                data: {
                    "date1": object.clock_in,
                    "date2": object.clock_in,
                    "employee_id": localStorage.choosenEmployee
                },
                success: function(data) {
                    if (data.status == "success") {
                        advance_total = data.emp_advance.toFixed(2);
                        $('#total_advance_' + index).html('$' + advance_total);
                    } else if (data.status == "failed") {
                        advance_total = 0;
                        advance_total = advance_total.toFixed(2);
                        $('#total_advance_' + index).html('$' + advance_total);
                    }
                },
                error: function(data) {}
            });
        }

        function capitalizeFirstLetter(string) {
            return string.charAt(0).toUpperCase() + string.slice(1);
        }

        function clockOutEmployee() {
            var formData = new FormData();
            formData.append("employee_id", c_employee_id);
            formData.append("tc_id", c_tc_id);
            formData.append("date", c_date);
            formData.append("time", c_time);
            formData.append("position", c_position);
            formData.append("location", c_location);
             var l = $( '.ladda-button-demo' ).ladda();
                    l.ladda( 'start' );
            $.ajax({
                url: AddClockoutTime,
                type: "POST",
                data: formData,
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {
                    if (data.status == "success") {
                        l.ladda('stop');
                        swal_btn.click();
                        //window.location.href = "clockout_employee.php";
                    } else if (data.status == "failed") {
                        l.ladda('stop');
                        alert(data.error);
                    }
                },
                error: function(data) {
                    l.ladda('stop');
                    alert("error");
                }
            });
        }

        function dateTime() {
            $('#clockOutModal').modal('hide');

            l = $('.ladda-button-demo').ladda();
            //l.ladda( 'start' );

            var date = new Date();
            var day = date.getDate();
            var month = date.getMonth() + 1;
            var year = date.getFullYear();
            var hours = date.getHours();
            var mins = date.getMinutes();

            if (hours < 10) {
                hours = "0" + hours;
            }

            if (mins < 10) {
                mins = "0" + mins;
            }

            var time = hours + ":" + mins;

            if (month < 10) {
                month = "0" + month;
            }

            if (day < 10) {
                day = "0" + day;
            }

            date = month + "/" + day + "/" + year;

            c_date = date;
            c_time = time;

            //alert(c_date + " " + c_time );

            clockOutEmployee();
        }
 function convertTo12HourFormat(time) {
    // Parse the input time string to a Date object
    const date = new Date(`1/1/2023 ${time}`); // Using a dummy date

    // Get the hours and minutes
    const hours = date.getHours();
    const minutes = date.getMinutes();

    // Determine if it's AM or PM
    const amPm = hours >= 12 ? "PM" : "AM";

    // Convert hours to 12-hour format
    const hours12 = hours % 12 || 12; // Handle midnight (0) as 12

    // Format the time as "hh:mm AM/PM"
    const formattedTime = `${hours12}:${minutes.toString().padStart(2, '0')} ${amPm}`;

    return formattedTime;
}
        function clockOutModal() {
            $('#clockOutModal').modal('show');
        }

        function goBack() {
            window.location.href = goBackUrl;
        }
    </script>
</body>

</html>
<?php /**PATH /home/adihai1972/public_html/Panama_dup/timeclock/development/Test/resources/views/admin/clockout_details.blade.php ENDPATH**/ ?>