<!DOCTYPE html>
<html>
<head>
    <title>Dry Clean Locker | Edit a Locker </title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link href="{{ asset ('css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset ('font-awesome/css/font-awesome.css') }}" rel="stylesheet">

    <!-- FooTable -->
    <link href="{{ asset ('css/plugins/footable/footable.core.css') }}" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="{{ asset ('css/sweetalert.css') }}" rel="stylesheet">

    <!-- Ladda style -->
    <link href="{{ asset ('css/ladda-themeless.min.css')}}" rel="stylesheet">

    <link href="{{ asset ('css/animate.css') }}" rel="stylesheet">
    <link href="{{ asset ('css/style.css') }}" rel="stylesheet">
    <style type="text/css">
        .activeSM
        {
            background-color: white !important; /* #38283c !important;*/
        }
    </style>
</head>

<body>
    <div id="wrapper">
        @include('navbar_static_side')
        
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom">
                @include('navbar_static_top')
            </div>

            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2><Strong>Edit a Locker</Strong></h2>
                    <ol class="breadcrumb">
                        <li>
                            <a href="{{ url('view_locker')}}">Lockers</a>
                        </li>
                        <li class="active">
                            <strong>Edit a Locker</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>

            <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="ibox ">
                            <div class="ibox-content">
                                <form id="edit_locker_form">
                                     <div class="form-group">
                                        <label>Location List</label>
                                        <select class="form-control" id="location_list" name="location_list" required="">
                                        </select>
                                    </div>                                 
                                    <div class="form-group">
                                        <label>Locker Number</label>
                                        <input type="number" id="locker_no" name="locker_no" onkeypress="return event.charCode >= 48 && event.charCode <= 57" placeholder="Enter locker#" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Notes <small>(optional)</small></label>
                                        <input type="text" id="acc_notes" name="acc_notes" placeholder="Enter a Note" class="form-control">
                                    </div> 
                                     
                                    <div>
                                        <button style="background-color: #566b8a;color: white;" class="ladda-button ladda-button-demo btn btn-sm btn-primary m-t-n-xs" type="submit" data-style="zoom-in">
                                                <span class="ladda-label">Submit</span><span class="ladda-spinner"></span>
                                        </button>
                                        <!-- Successfully Edited Locker -->
                                        <button id="swal_btn" type="button" style="display:none"></button>
                                        <!-- Locker not  Edited -->
                                        <button id="swal_btn2" type="button" style="display:none"></button>
                                    </div>
                                </form>
                                <a href="{{url('view_locker')}}">
                                    <button style="background-color: #5cb85c;color: white;margin-left: 70px;margin-top: -50px;" class="btn btn-sm btn-primary m-t-n-xs" data-style="zoom-in">Cancel</button>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('footer')
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <script src="js/plugins/jquery-ui/jquery-ui.min.js"></script>

    <!-- Sweet alert -->
    <script src="js/plugins/sweetalert/sweetalert.min.js"></script>

    <!-- Jquery Validate -->
    <script src="js/plugins/validate/jquery.validate.min.js"></script>

    <!-- Ladda -->
    <script src="js/plugins/ladda/spin.min.js"></script>
    <script src="js/plugins/ladda/ladda.min.js"></script>
    <script src="js/plugins/ladda/ladda.jquery.min.js"></script>

    <script>
    var errorMessage;
    $(document).ready(function()
    {
        $("#side3").addClass("activeSM");
        $("#side3 a").css("color","#224ea6");

        viewLocations();
        viewLockers();
        
       $("#edit_locker_form").validate({
            rules: 
            {
                location_list: {
                    required: true
                },
                locker_no: {
                    required: true,
                },
            },
            messages: 
            {
            },
            submitHandler: function(form) 
            {
                var l = $( '.ladda-button-demo' ).ladda();
                l.ladda( 'start' );
                var swal_btn = document.getElementById("swal_btn");

                var location_list = $('#location_list').val();
                var locker_no = $('#locker_no').val();
                var acc_notes = $('#acc_notes').val();

                var locker_id = localStorage.locker_id;

                if ( location_list == "select" )
                {
                    alert("Please choose location for Locker.");
                    l.ladda( 'stop' );
                }
                else
                {
                    var formData = new FormData();
                    formData.append("LockerID", locker_id);                    
                    formData.append("LocationID", location_list);
                    formData.append("LockerNumber", locker_no);
                    formData.append("Notes", acc_notes);
                                        
                    $.ajax
                    ({
                        type:'POST',
                        url:"/DCL/api/LockerEdit",
                        data: formData,
                        contentType: false,
                        cache: false,
                        processData:false,
                        success: function(data)
                        {
                            if( data.status == "success" )
                            {
                                l.ladda('stop');
                                swal_btn.click();
                            }
                            else if( data.status == "failed" )
                            {
                                l.ladda('stop');
                                errorMessage = data.error;
                                swal_btn2.click();
                            }
                        },
                        error: function(data) 
                        {
                            alert("error");
                        }           
                    }); 
                }               
                return false; // extra insurance preventing the default form action
            }
        });

        $('#swal_btn').click(function(){
            swal({
                title: "Locker edited successfully!",
                text: "",
                type: "success",
                confirmButtonColor: "#003399",
                closeOnConfirm: false
            }, function () {
                window.location.assign("{{ url('view_locker')}}");
            });
        });

        $('#swal_btn2').click(function(){
            swal({
                 title: "Operation Unsuccessfull!",
                text: errorMessage,
                type: "warning",
                confirmButtonColor: "#DD6B55",
            });
        });
    });

    function viewLocations()
    {
        var $list = $("#location_list");
        $list.empty();
        $.ajax({
            url: "/DCL/api/LocationView",
            type: "POST",
            success: function(data)
            {   
                if ( data.status == "success")
                {
                    $list.append('<option value="select">Choose location for Locker</option>');

                    $.each(data.data, function(index,obj) 
                    {                       
                        $list.append('<option value="'+obj.LocationID+'">'+obj.Shortcode+'</option>');
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }

    function viewLockers()
    {
        var locker_id = localStorage.locker_id;
        $.ajax({
            url: "/DCL/api/LockerView",
            type: "POST",
            data: { "LockerID" : locker_id },
            success: function(data)
            {   
                var count = 1;

                if ( data.status == "success")
                {
                    $.each(data.data, function(index,obj) 
                    {
                        $('#location_list').val(obj.LocationID);
                        $('#locker_no').val(obj.LockerNumber);
                        $('#acc_notes').val(obj.Notes);
                    });
                }
                else
                {
                    swal_btn.click();
                }
            },
            error: function(data)
            {
            }           
        });        
    }
</script>

</body>
</html>
